package ext.draw.sprite {

[Native("Ext.draw.sprite.Tick", require)]
/**
 * A veritical line sprite. The x and y configs set the center of the line with the size
 * value determining the height of the line (the line will be twice the height of 'size'
 * since 'size' is added to above and below 'y' to set the line endpoints).
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'tick',
 *        x: 20,
 *        y: 40,
 *        size: 10,
 *        strokeStyle: '#388FAD',
 *        lineWidth: 2
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Tick.html Original Ext JS documentation of 'Ext.draw.sprite.Tick'
 */
public class TickSprite extends LineSprite {
  /**
   * @inheritDoc
   */
  public function TickSprite(config:TickSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The size of the sprite.
   * Meant to be comparable to the size of a circle sprite with the same radius.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Tick.html#cfg-size Original Ext JS documentation of 'size'
   */
  public native function get size():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set size(value:Number):void;

  [ExtConfig]
  /**
   * The position of the center of the sprite on the x-axis.
   * @default 'number'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Tick.html#cfg-x Original Ext JS documentation of 'x'
   */
  public native function get x():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set x(value:Object):void;

  [ExtConfig]
  /**
   * The position of the center of the sprite on the y-axis.
   * @default 'number'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Tick.html#cfg-y Original Ext JS documentation of 'y'
   */
  public native function get y():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set y(value:Object):void;
}
}