package ext.draw.sprite {

[Native("Ext.draw.sprite.Triangle", require)]
/**
 * A sprite that represents a triangle.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'triangle',
 *        size: 50,
 *        translationX: 100,
 *        translationY: 100,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Triangle.html Original Ext JS documentation of 'Ext.draw.sprite.Triangle'
 */
public class TriangleSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function TriangleSprite(config:TriangleSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The size of the sprite.
   * Meant to be comparable to the size of a circle sprite with the same radius.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Triangle.html#cfg-size Original Ext JS documentation of 'size'
   */
  public native function get size():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set size(value:Number):void;
}
}