package ext.env {
import ext.Version;

[Native("Ext.env.Browser")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Provides information about browser.</p>
 * <p>Should not be manually instantiated unless for unit-testing.
 * Access the global instance stored in →<code>ext.browser</code> instead.</p>
 * @see ext.#browser ext.browser
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html Original Ext JS documentation of 'Ext.env.Browser'
 */
public class Browser extends Object {
  /**
   * The full name of the current browser's engine.
   * Possible values are:
   * <ul>
   * <li>WebKit</li>
   * <li>Gecko</li>
   * <li>Presto</li>
   * <li>Trident</li>
   * <li>Other</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#property-engineName Original Ext JS documentation of 'engineName'
   */
  public native function get engineName():String;

  /**
   * Refer to →<code>ext.Version</code>.
   * @see ext.Version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#property-engineVersion Original Ext JS documentation of 'engineVersion'
   */
  public native function get engineVersion():Version;

  /**
   * <code>true</code> if page is running over SSL.
   * @default Ext.isSecure
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#property-isSecure Original Ext JS documentation of 'isSecure'
   */
  public native function get isSecure():Boolean;

  /**
   * @private
   */
  public native function set isSecure(value:Boolean):void;

  /**
   * The full name of the current browser.
   * Possible values are:
   * <ul>
   * <li>IE</li>
   * <li>Firefox</li>
   * <li>Safari</li>
   * <li>Chrome</li>
   * <li>Opera</li>
   * <li>Other</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#property-name Original Ext JS documentation of 'name'
   */
  public native function get name():String;

  /**
   * Browser User Agent string.
   * @default userAgent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#property-userAgent Original Ext JS documentation of 'userAgent'
   */
  public native function get userAgent():String;

  /**
   * @private
   */
  public native function set userAgent(value:String):void;

  /**
   * Refer to →<code>ext.Version</code>.
   * @see ext.Version
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#property-version Original Ext JS documentation of 'version'
   */
  public native function get version():Version;

  /**
   * A "hybrid" property, can be either accessed as a method call, for example...
   * <pre>
   * if (Ext.browser.is('IE')) {
   *     // ...
   * }
   * </pre>
   * <p>Or as an object with Boolean properties, for example:</p>
   * <pre>
   * if (Ext.browser.is.IE) {
   *     // ...
   * }
   * </pre>
   * <p>Versions can be conveniently checked as well. For example:</p>
   * <pre>
   * if (Ext.browser.is.IE10) {
   *     // Equivalent to (Ext.browser.is.IE &amp;&amp; Ext.browser.version.equals(10))
   * }
   * </pre>
   * <p><b>Note:</b> Only <i>major component</i> (→<code>ext.Version.getMajor()</code>) and
   * <i>simplified</i> (→<code>ext.Version.getShortVersion()</code>) value of the version are available via
   * direct property checking.</p>
   * <p>Supported values are:</p>
   * <ul>
   * <li>IE</li>
   * <li>Firefox</li>
   * <li>Safari</li>
   * <li>Chrome</li>
   * <li>Opera</li>
   * <li>WebKit</li>
   * <li>Gecko</li>
   * <li>Presto</li>
   * <li>Trident</li>
   * <li>WebView</li>
   * <li>Other</li>
   * </ul>
   * @param name The OS name to check.
   * @see ext.Version#getMajor()
   * @see ext.Version#getShortVersion()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.env.Browser.html#method-is Original Ext JS documentation of 'is'
   */
  public native function matches(name:String):Boolean;
}
}