package ext.event {
import ext.Base;
import ext.util.Point;

import js.Event;
import js.HTMLElement;

[Native("Ext.event.Event", require)]
/**
 * Just as →<code>ext.dom.Element</code> wraps around a native DOM node, →<code>ext.event.Event</code> wraps
 * the browser's native event-object normalizing cross-browser differences such as mechanisms
 * to stop event-propagation along with a method to prevent default actions from taking place.
 * <p>Here is a simple example of how you use it:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var container = Ext.create('Ext.Container', {
 *     layout: 'fit',
 *     renderTo: Ext.getBody(),
 *     items: [{
 *         id: 'logger',
 *         html: 'Click somewhere!',
 *         padding: 5
 *     }]
 * });
 *
 * container.getEl().on({
 *     click: function(e, node) {
 *         var string = '';
 *
 *         string += 'You clicked at: { x: ' + e.pageX + ', y: ' + e.pageY + ' } ' +
 *                     '&lt;i&gt;(e.pageX &amp; e.pageY)&lt;/i&gt;';
 *         string += '&lt;hr /&gt;';
 *         string += 'The HTMLElement you clicked has the className of: &lt;strong&gt;' +
 *                     e.target.className + '&lt;/strong&gt; &lt;i&gt;(e.target)&lt;/i&gt;';
 *         string += '&lt;hr /&gt;';
 *         string += 'The HTMLElement which has the listener has a className of: &lt;strong&gt;' +
 *                      e.currentTarget.className + '&lt;/strong&gt; &lt;i&gt;(e.currentTarget)&lt;/i&gt;';
 *
 *         Ext.getCmp('logger').setHtml(string);
 *     }
 * });
 * </pre>
 * <p><b><i>Recognizers</i></b></p>
 * <p>Ext JS includes many default event recognizers to know when a user interacts with
 * the application.</p>
 * <p>For a full list of default recognizers, and more information, please view the
 * →<code>ext.event.gesture.GestureRecognizer</code> documentation.</p>
 * <p>This class also provides a set of constants for use with key events. These are useful
 * for determining if a specific key was pressed, and are available both on instances,
 * and as static properties of the class. The following two statements are equivalent:</p>
 * <pre>
 * if (e.getKey() === Ext.event.Event.TAB) {
 *     // tab key was pressed
 * }
 *
 * if (e.getKey() === e.TAB) {
 *     // tab key was pressed
 * }
 * </pre>
 * @see ext.dom.Element
 * @see ext.event.Event
 * @see ext.event.gesture.GestureRecognizer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html Original Ext JS documentation of 'Ext.event.Event'
 */
public class Event extends Base {
  /**
   * Key constant @type Number
   * @default 65
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-A Original Ext JS documentation of 'A'
   */
  public static native function get A():*;

  /**
   * Key constant @type Number
   * @default 18
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-ALT Original Ext JS documentation of 'ALT'
   */
  public static native function get ALT():*;

  /**
   * Key constant @type Number
   * @default 66
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-B Original Ext JS documentation of 'B'
   */
  public static native function get B():*;

  /**
   * Key constant @type Number
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-BACKSPACE Original Ext JS documentation of 'BACKSPACE'
   */
  public static native function get BACKSPACE():*;

  /**
   * Key constant @type Number
   * @default 67
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-C Original Ext JS documentation of 'C'
   */
  public static native function get C():*;

  /**
   * Key constant @type Number
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-CAPS_LOCK Original Ext JS documentation of 'CAPS_LOCK'
   */
  public static native function get CAPS_LOCK():*;

  /**
   * Key constant @type Number
   * @default 93
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-CONTEXT_MENU Original Ext JS documentation of 'CONTEXT_MENU'
   */
  public static native function get CONTEXT_MENU():*;

  /**
   * Key constant @type Number
   * @default 17
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-CTRL Original Ext JS documentation of 'CTRL'
   */
  public static native function get CTRL():*;

  /**
   * Key constant @type Number
   * @default 68
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-D Original Ext JS documentation of 'D'
   */
  public static native function get D():*;

  /**
   * Key constant @type Number
   * @default 46
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-DELETE Original Ext JS documentation of 'DELETE'
   */
  public static native function get DELETE():*;

  /**
   * Key constant @type Number
   * @default 40
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-DOWN Original Ext JS documentation of 'DOWN'
   */
  public static native function get DOWN():*;

  /**
   * Key constant @type Number
   * @default 69
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-E Original Ext JS documentation of 'E'
   */
  public static native function get E():*;

  /**
   * Key constant @type Number
   * @default 56
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-EIGHT Original Ext JS documentation of 'EIGHT'
   */
  public static native function get EIGHT():*;

  /**
   * Key constant @type Number
   * @default 35
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-END Original Ext JS documentation of 'END'
   */
  public static native function get END():*;

  /**
   * Key constant @type Number
   * @default 13
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-ENTER Original Ext JS documentation of 'ENTER'
   */
  public static native function get ENTER():*;

  /**
   * Key constant @type Number
   * @default 27
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-ESC Original Ext JS documentation of 'ESC'
   */
  public static native function get ESC():*;

  /**
   * Key constant @type Number
   * @default 70
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F Original Ext JS documentation of 'F'
   */
  public static native function get F():*;

  /**
   * Key constant @type Number
   * @default 112
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F1 Original Ext JS documentation of 'F1'
   */
  public static native function get F1():*;

  /**
   * Key constant @type Number
   * @default 121
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F10 Original Ext JS documentation of 'F10'
   */
  public static native function get F10():*;

  /**
   * Key constant @type Number
   * @default 122
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F11 Original Ext JS documentation of 'F11'
   */
  public static native function get F11():*;

  /**
   * Key constant @type Number
   * @default 123
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F12 Original Ext JS documentation of 'F12'
   */
  public static native function get F12():*;

  /**
   * Key constant @type Number
   * @default 113
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F2 Original Ext JS documentation of 'F2'
   */
  public static native function get F2():*;

  /**
   * Key constant @type Number
   * @default 114
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F3 Original Ext JS documentation of 'F3'
   */
  public static native function get F3():*;

  /**
   * Key constant @type Number
   * @default 115
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F4 Original Ext JS documentation of 'F4'
   */
  public static native function get F4():*;

  /**
   * Key constant @type Number
   * @default 116
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F5 Original Ext JS documentation of 'F5'
   */
  public static native function get F5():*;

  /**
   * Key constant @type Number
   * @default 117
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F6 Original Ext JS documentation of 'F6'
   */
  public static native function get F6():*;

  /**
   * Key constant @type Number
   * @default 118
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F7 Original Ext JS documentation of 'F7'
   */
  public static native function get F7():*;

  /**
   * Key constant @type Number
   * @default 119
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F8 Original Ext JS documentation of 'F8'
   */
  public static native function get F8():*;

  /**
   * Key constant @type Number
   * @default 120
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-F9 Original Ext JS documentation of 'F9'
   */
  public static native function get F9():*;

  /**
   * Key constant @type Number
   * @default 53
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-FIVE Original Ext JS documentation of 'FIVE'
   */
  public static native function get FIVE():*;

  /**
   * Key constant @type Number
   * @default 52
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-FOUR Original Ext JS documentation of 'FOUR'
   */
  public static native function get FOUR():*;

  /**
   * Key constant @type Number
   * @default 71
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-G Original Ext JS documentation of 'G'
   */
  public static native function get G():*;

  /**
   * Key constant @type Number
   * @default 72
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-H Original Ext JS documentation of 'H'
   */
  public static native function get H():*;

  /**
   * Key constant @type Number
   * @default 36
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-HOME Original Ext JS documentation of 'HOME'
   */
  public static native function get HOME():*;

  /**
   * Key constant @type Number
   * @default 73
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-I Original Ext JS documentation of 'I'
   */
  public static native function get I():*;

  /**
   * Key constant @type Number
   * @default 45
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-INSERT Original Ext JS documentation of 'INSERT'
   */
  public static native function get INSERT():*;

  /**
   * Key constant @type Number
   * @default 74
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-J Original Ext JS documentation of 'J'
   */
  public static native function get J():*;

  /**
   * Key constant @type Number
   * @default 75
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-K Original Ext JS documentation of 'K'
   */
  public static native function get K():*;

  /**
   * Key constant @type Number
   * @default 76
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-L Original Ext JS documentation of 'L'
   */
  public static native function get L():*;

  /**
   * Key constant @type Number
   * @default 37
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-LEFT Original Ext JS documentation of 'LEFT'
   */
  public static native function get LEFT():*;

  /**
   * Key constant @type Number
   * @default 77
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-M Original Ext JS documentation of 'M'
   */
  public static native function get M():*;

  /**
   * Key constant @type Number
   * @default 91
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-META Original Ext JS documentation of 'META'
   */
  public static native function get META():*;

  /**
   * Key constant @type Number
   * @default 78
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-N Original Ext JS documentation of 'N'
   */
  public static native function get N():*;

  /**
   * Key constant @type Number
   * @default 57
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NINE Original Ext JS documentation of 'NINE'
   */
  public static native function get NINE():*;

  /**
   * Key constant @type Number
   * @default 12
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_CENTER Original Ext JS documentation of 'NUM_CENTER'
   */
  public static native function get NUM_CENTER():*;

  /**
   * Key constant @type Number
   * @default 111
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_DIVISION Original Ext JS documentation of 'NUM_DIVISION'
   */
  public static native function get NUM_DIVISION():*;

  /**
   * Key constant @type Number
   * @default 104
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_EIGHT Original Ext JS documentation of 'NUM_EIGHT'
   */
  public static native function get NUM_EIGHT():*;

  /**
   * Key constant @type Number
   * @default 101
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_FIVE Original Ext JS documentation of 'NUM_FIVE'
   */
  public static native function get NUM_FIVE():*;

  /**
   * Key constant @type Number
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_FOUR Original Ext JS documentation of 'NUM_FOUR'
   */
  public static native function get NUM_FOUR():*;

  /**
   * Key constant @type Number
   * @default 109
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_MINUS Original Ext JS documentation of 'NUM_MINUS'
   */
  public static native function get NUM_MINUS():*;

  /**
   * Key constant @type Number
   * @default 106
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_MULTIPLY Original Ext JS documentation of 'NUM_MULTIPLY'
   */
  public static native function get NUM_MULTIPLY():*;

  /**
   * Key constant @type Number
   * @default 105
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_NINE Original Ext JS documentation of 'NUM_NINE'
   */
  public static native function get NUM_NINE():*;

  /**
   * Key constant @type Number
   * @default 97
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_ONE Original Ext JS documentation of 'NUM_ONE'
   */
  public static native function get NUM_ONE():*;

  /**
   * Key constant @type Number
   * @default 110
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_PERIOD Original Ext JS documentation of 'NUM_PERIOD'
   */
  public static native function get NUM_PERIOD():*;

  /**
   * Key constant @type Number
   * @default 107
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_PLUS Original Ext JS documentation of 'NUM_PLUS'
   */
  public static native function get NUM_PLUS():*;

  /**
   * Key constant @type Number
   * @default 103
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_SEVEN Original Ext JS documentation of 'NUM_SEVEN'
   */
  public static native function get NUM_SEVEN():*;

  /**
   * Key constant @type Number
   * @default 102
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_SIX Original Ext JS documentation of 'NUM_SIX'
   */
  public static native function get NUM_SIX():*;

  /**
   * Key constant @type Number
   * @default 99
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_THREE Original Ext JS documentation of 'NUM_THREE'
   */
  public static native function get NUM_THREE():*;

  /**
   * Key constant @type Number
   * @default 98
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_TWO Original Ext JS documentation of 'NUM_TWO'
   */
  public static native function get NUM_TWO():*;

  /**
   * Key constant @type Number
   * @default 96
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-NUM_ZERO Original Ext JS documentation of 'NUM_ZERO'
   */
  public static native function get NUM_ZERO():*;

  /**
   * Key constant @type Number
   * @default 79
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-O Original Ext JS documentation of 'O'
   */
  public static native function get O():*;

  /**
   * Key constant @type Number
   * @default 49
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-ONE Original Ext JS documentation of 'ONE'
   */
  public static native function get ONE():*;

  /**
   * Key constant @type Number
   * @default 80
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-P Original Ext JS documentation of 'P'
   */
  public static native function get P():*;

  /**
   * Key constant @type Number
   * @default 34
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-PAGE_DOWN Original Ext JS documentation of 'PAGE_DOWN'
   */
  public static native function get PAGE_DOWN():*;

  /**
   * Key constant @type Number
   * @default 33
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-PAGE_UP Original Ext JS documentation of 'PAGE_UP'
   */
  public static native function get PAGE_UP():*;

  /**
   * Key constant @type Number
   * @default 19
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-PAUSE Original Ext JS documentation of 'PAUSE'
   */
  public static native function get PAUSE():*;

  /**
   * Key constant @type Number
   * @default 44
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-PRINT_SCREEN Original Ext JS documentation of 'PRINT_SCREEN'
   */
  public static native function get PRINT_SCREEN():*;

  /**
   * Key constant @type Number
   * @default 81
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-Q Original Ext JS documentation of 'Q'
   */
  public static native function get Q():*;

  /**
   * Key constant @type Number
   * @default 82
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-R Original Ext JS documentation of 'R'
   */
  public static native function get R():*;

  /**
   * Key constant @type Number
   * @default 13
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-RETURN Original Ext JS documentation of 'RETURN'
   */
  public static native function get RETURN():*;

  /**
   * Key constant @type Number
   * @default 39
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-RIGHT Original Ext JS documentation of 'RIGHT'
   */
  public static native function get RIGHT():*;

  /**
   * Key constant @type Number
   * @default 83
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-S Original Ext JS documentation of 'S'
   */
  public static native function get S():*;

  /**
   * Key constant @type Number
   * @default 55
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-SEVEN Original Ext JS documentation of 'SEVEN'
   */
  public static native function get SEVEN():*;

  /**
   * Key constant @type Number
   * @default 16
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-SHIFT Original Ext JS documentation of 'SHIFT'
   */
  public static native function get SHIFT():*;

  /**
   * Key constant @type Number
   * @default 54
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-SIX Original Ext JS documentation of 'SIX'
   */
  public static native function get SIX():*;

  /**
   * Key constant @type Number
   * @default 32
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-SPACE Original Ext JS documentation of 'SPACE'
   */
  public static native function get SPACE():*;

  /**
   * Key constant @type Number
   * @default 84
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-T Original Ext JS documentation of 'T'
   */
  public static native function get T():*;

  /**
   * Key constant @type Number
   * @default 9
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-TAB Original Ext JS documentation of 'TAB'
   */
  public static native function get TAB():*;

  /**
   * Key constant @type Number
   * @default 51
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-THREE Original Ext JS documentation of 'THREE'
   */
  public static native function get THREE():*;

  /**
   * Key constant @type Number
   * @default 50
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-TWO Original Ext JS documentation of 'TWO'
   */
  public static native function get TWO():*;

  /**
   * Key constant @type Number
   * @default 85
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-U Original Ext JS documentation of 'U'
   */
  public static native function get U():*;

  /**
   * Key constant @type Number
   * @default 38
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-UP Original Ext JS documentation of 'UP'
   */
  public static native function get UP():*;

  /**
   * Key constant @type Number
   * @default 86
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-V Original Ext JS documentation of 'V'
   */
  public static native function get V():*;

  /**
   * Key constant @type Number
   * @default 87
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-W Original Ext JS documentation of 'W'
   */
  public static native function get W():*;

  /**
   * The mouse wheel delta scaling factor when the
   * <a href="https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent/deltaMode"><code>deltaMode</code></a>
   * is DOM_DELTA_LINE
   * <p>To change this value:</p>
   * <pre>
   *  Ext.event.Event.prototype.WHEEL_LINE_SIZE = 16;
   * </pre>
   * @default 20
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-WHEEL_LINE_SIZE Original Ext JS documentation of 'WHEEL_LINE_SIZE'
   */
  public static native function get WHEEL_LINE_SIZE():Number;

  /**
   * The mouse wheel delta scaling factor when the
   * <a href="https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent/deltaMode"><code>deltaMode</code></a>
   * is DOM_DELTA_PAGE
   * <p>To change this value:</p>
   * <pre>
   *  Ext.event.Event.prototype.WHEEL_PAGE_SIZE = 400;
   * </pre>
   * @default 600
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-WHEEL_PAGE_SIZE Original Ext JS documentation of 'WHEEL_PAGE_SIZE'
   */
  public static native function get WHEEL_PAGE_SIZE():Number;

  /**
   * The mouse wheel delta scaling factor when the
   * <a href="https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent/deltaMode"><code>deltaMode</code></a>
   * is DOM_DELTA_PIXEL
   * <p>To change this value:</p>
   * <pre>
   *  Ext.event.Event.prototype.WHEEL_PIXEL_SIZE = 3;
   * </pre>
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-WHEEL_PIXEL_SIZE Original Ext JS documentation of 'WHEEL_PIXEL_SIZE'
   */
  public static native function get WHEEL_PIXEL_SIZE():Number;

  /**
   * Key constant @type Number
   * @default 88
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-X Original Ext JS documentation of 'X'
   */
  public static native function get X():*;

  /**
   * Key constant @type Number
   * @default 89
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-Y Original Ext JS documentation of 'Y'
   */
  public static native function get Y():*;

  /**
   * Key constant @type Number
   * @default 90
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-Z Original Ext JS documentation of 'Z'
   */
  public static native function get Z():*;

  /**
   * Key constant @type Number
   * @default 48
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-ZERO Original Ext JS documentation of 'ZERO'
   */
  public static native function get ZERO():*;

  /**
   * Create an Ext IEventObject browser event wrapper from the
   * given browser event.
   * @param browserEvent the browser event to wrap
   */
  public function Event(browserEvent:js.Event) {
  }

  /**
   * True if the alt key was down during the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-altKey Original Ext JS documentation of 'altKey'
   */
  public native function get altKey():Boolean;

  /**
   * @private
   */
  public native function set altKey(value:Boolean):void;

  /**
   * The angle of the rotation.
   * <p><b>This is only available when the event type is <code>rotate</code></b></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-angle Original Ext JS documentation of 'angle'
   */
  public native function get angle():Number;

  /**
   * @private
   */
  public native function set angle(value:Number):void;

  /**
   * The raw browser event which this object wraps.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-browserEvent Original Ext JS documentation of 'browserEvent'
   */
  public native function get browserEvent():js.Event;

  /**
   * @private
   */
  public native function set browserEvent(value:js.Event):void;

  /**
   * Indicates which mouse button caused the event for mouse events, for example
   * <code>mousedown</code>, <code>click</code>, <code>mouseup</code>...
   * <ul>
   * <li><code>0</code> for left button.</li>
   * <li><code>1</code> for middle button.</li>
   * <li><code>2</code> for right button.</li>
   * </ul>
   * <p><i>Note</i>: In IE8 &amp; IE9, the <code>click</code> event does not provide the button.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-button Original Ext JS documentation of 'button'
   */
  public native function get button():Number;

  /**
   * @private
   */
  public native function set button(value:Number):void;

  /**
   * True if the control key was down during the event.
   * In Mac this will also be true when meta key was down.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-ctrlKey Original Ext JS documentation of 'ctrlKey'
   */
  public native function get ctrlKey():Boolean;

  /**
   * @private
   */
  public native function set ctrlKey(value:Boolean):void;

  /**
   * Refers to the element the event handler was attached to, vs the <code>→target</code>, which is
   * the actual element that fired the event. For example, if the event bubbles, the
   * <code>→target</code> element may be a descendant of the <code>→currentTarget</code>, as the event may
   * have been triggered on the <code>→target</code> and then bubbled up to the <code>→currentTarget</code>
   * where it was handled.
   * @see #target
   * @see #currentTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-currentTarget Original Ext JS documentation of 'currentTarget'
   */
  public native function get currentTarget():HTMLElement;

  /**
   * @private
   */
  public native function set currentTarget(value:HTMLElement):void;

  /**
   * Indicates whether or not →<code>preventDefault()</code> was called on the event.
   * @default false
   * @see #preventDefault()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-defaultPrevented Original Ext JS documentation of 'defaultPrevented'
   */
  public native function get defaultPrevented():Boolean;

  /**
   * @private
   */
  public native function set defaultPrevented(value:Boolean):void;

  [Deprecated(replacement="currentTarget", since="5.0.0")]
  /**
   * Same as <code>→currentTarget</code>
   * @see #currentTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-delegatedTarget Original Ext JS documentation of 'delegatedTarget'
   */
  public native function get delegatedTarget():HTMLElement;

  /**
   * @private
   */
  public native function set delegatedTarget(value:HTMLElement):void;

  /**
   * @default deltaX
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-deltaX Original Ext JS documentation of 'deltaX'
   */
  public native function get deltaX():Number;

  /**
   * @private
   */
  public native function set deltaX(value:Number):void;

  /**
   * @default deltaY
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-deltaY Original Ext JS documentation of 'deltaY'
   */
  public native function get deltaY():Number;

  /**
   * @private
   */
  public native function set deltaY(value:Number):void;

  /**
   * The direction of the swipe. Available options are:
   * <ul>
   * <li>up</li>
   * <li>down</li>
   * <li>left</li>
   * <li>right</li>
   * </ul>
   * <p><b>This is only available when the event type is <code>swipe</code></b></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-direction Original Ext JS documentation of 'direction'
   */
  public native function get direction():Number;

  /**
   * @private
   */
  public native function set direction(value:Number):void;

  /**
   * The distance of the event.
   * <p><b>This is only available when the event type is <code>swipe</code> and <code>pinch</code>.</b></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-distance Original Ext JS documentation of 'distance'
   */
  public native function get distance():Number;

  /**
   * @private
   */
  public native function set distance(value:Number):void;

  /**
   * The duration of the swipe.
   * <p><b>This is only available when the event type is <code>swipe</code></b></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-duration Original Ext JS documentation of 'duration'
   */
  public native function get duration():Number;

  /**
   * @private
   */
  public native function set duration(value:Number):void;

  /**
   * The browsers x coordinate of the event.
   * Note: this only works in browsers that support pageX on the native browser event
   * object (pageX is not natively supported in IE9 and earlier). In Ext JS, for a
   * cross browser normalized x-coordinate use →<code>getX()</code>
   * @see #getX()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-pageX Original Ext JS documentation of 'pageX'
   */
  public native function get pageX():Number;

  /**
   * @private
   */
  public native function set pageX(value:Number):void;

  /**
   * The browsers y coordinate of the event.
   * Note: this only works in browsers that support pageY on the native browser event
   * object (pageY is not natively supported in IE9 and earlier). In Ext JS, for a
   * cross browser normalized y-coordinate use →<code>getY()</code>
   * @see #getY()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-pageY Original Ext JS documentation of 'pageY'
   */
  public native function get pageY():Number;

  /**
   * @private
   */
  public native function set pageY(value:Number):void;

  /**
   * The pointer type for this event. May be empty if the event was
   * not triggered by a pointer. Current available types are:
   * <ul>
   * <li><code>mouse</code></li>
   * <li><code>touch</code></li>
   * <li><code>pen</code></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-pointerType Original Ext JS documentation of 'pointerType'
   */
  public native function get pointerType():String;

  /**
   * @private
   */
  public native function set pointerType(value:String):void;

  /**
   * A amount of rotation, since the start of the event.
   * <p><b>This is only available when the event type is <code>rotate</code></b></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-rotation Original Ext JS documentation of 'rotation'
   */
  public native function get rotation():Number;

  /**
   * @private
   */
  public native function set rotation(value:Number):void;

  /**
   * The scape of a pinch event.
   * <p><b>This is only available when the event type is <code>pinch</code></b></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-scale Original Ext JS documentation of 'scale'
   */
  public native function get scale():Number;

  /**
   * @private
   */
  public native function set scale(value:Number):void;

  /**
   * True if the shift key was down during the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-shiftKey Original Ext JS documentation of 'shiftKey'
   */
  public native function get shiftKey():Boolean;

  /**
   * @private
   */
  public native function set shiftKey(value:Boolean):void;

  /**
   * The element that fired this event. For the element whose handlers are currently
   * being processed, i.e. the element that the event handler was attached to, use
   * <code>→currentTarget</code>
   * @see #currentTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#property-target Original Ext JS documentation of 'target'
   */
  public native function get target():HTMLElement;

  /**
   * @private
   */
  public native function set target(value:HTMLElement):void;

  /**
   * The event type (copied from the browser event).
   */
  public native function get type():String;

  /**
   * @private
   */
  public native function set type(value:String):void;

  /**
   * Claims this event as the currently active gesture. Once a gesture is claimed
   * no other gestures will fire events until after the current gesture has completed.
   * For example, if <code>claimGesture()</code> is invoked on a dragstart or drag event, no
   * swipestart or swipe events will be fired until the drag gesture completes, even if
   * the gesture also meets the required duration and distance requirements to be recognized
   * as a swipe.
   * <p>If <code>claimGesture()</code> is invoked on a mouse, touch, or pointer event, it will disable
   * all gesture events until termination of the current gesture is indicated by a
   * mouseup, touchend, or pointerup event.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-claimGesture Original Ext JS documentation of 'claimGesture'
   */
  public native function claimGesture():ext.event.Event;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Clones this event.
   * @return The cloned copy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():ext.event.Event;

  /**
   * Gets the character code for the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getCharCode Original Ext JS documentation of 'getCharCode'
   */
  public native function getCharCode():Number;

  /**
   * If this is an event of →<code>type</code> <code>paste</code>, this returns the clipboard data
   * of the pasesd mime type.
   * @since 6.5.1
   * @param type The mime type of the data to extract from the
   * clipabord.
   * <p>Note that this uses non-standard browaer APIs and may not work reliably on all
   * platforms.</p>
   * @default 'text/plain'
   * @return The clipboard data.
   * @see #type
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getClipboardData Original Ext JS documentation of 'getClipboardData'
   */
  public native function getClipboardData(type:String = 'text/plain'):*;

  /**
   * Returns a normalized keyCode for the event.
   * @return The key code
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getKey Original Ext JS documentation of 'getKey'
   */
  public native function getKey():Number;

  /**
   * Returns the name of the keyCode for the event.
   * @return The key name
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getKeyName Original Ext JS documentation of 'getKeyName'
   */
  public native function getKeyName():String;

  [Deprecated(replacement="getX", since="4.0")]
  /**
   * Gets the x coordinate of the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getPageX Original Ext JS documentation of 'getPageX'
   */
  public native function getPageX():Number;

  [Deprecated(replacement="getY", since="4.0")]
  /**
   * Gets the y coordinate of the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getPageY Original Ext JS documentation of 'getPageY'
   */
  public native function getPageY():Number;

  /**
   * Returns a point object that consists of the object coordinates.
   * @return point
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getPoint Original Ext JS documentation of 'getPoint'
   */
  public native function getPoint():Point;

  /**
   * Gets the related target.
   * @param selector A simple selector to filter the target or look for an
   * ancestor of the target. See →<code>ext.dom.DomQuery</code> for information about simple
   * selectors.
   * @param maxDepth The max depth to search as a number or
   * element (defaults to 10 || document.body).
   * @param returnEl <code>true</code> to return a Ext.Element object instead of DOM
   * node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getRelatedTarget Original Ext JS documentation of 'getRelatedTarget'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function getRelatedTarget(selector:String = null, maxDepth:* = undefined, returnEl:Boolean = false):HTMLElement;

  /**
   * Gets the target for the event.
   * @param selector A simple selector to filter the target or look
   * for an ancestor of the target
   * @param maxDepth (Default 10||document.body) The max depth to
   * search as a number or element (defaults to 10 || document.body)
   * @default 10||document.body
   * @param returnEl <code>true</code> to return a Ext.Element object instead
   * of DOM node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getTarget Original Ext JS documentation of 'getTarget'
   */
  public native function getTarget(selector:String = null, maxDepth:* = 10, returnEl:Boolean = false):HTMLElement;

  /**
   * Returns the time of the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getTime Original Ext JS documentation of 'getTime'
   */
  public native function getTime():Date;

  [Deprecated(replacement="deltaY", since="6.6.0")]
  /**
   * Normalizes mouse wheel y-delta across browsers. To get x-delta information, use
   * →<code>getWheelDeltas()</code> instead.
   * @return The mouse wheel y-delta
   * @see #getWheelDeltas()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getWheelDelta Original Ext JS documentation of 'getWheelDelta'
   */
  public native function getWheelDelta():Number;

  [Deprecated(replacement="deltaX", since="6.7.0")]
  /**
   * Returns the mouse wheel deltas for this event.
   * @return An object with "x" and "y" properties holding the mouse wheel deltas.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getWheelDeltas Original Ext JS documentation of 'getWheelDeltas'
   */
  public native function getWheelDeltas():Object;

  /**
   * Gets the x coordinate of the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getX Original Ext JS documentation of 'getX'
   */
  public native function getX():Number;

  [ArrayElementType("Number")]
  /**
   * Gets the X and Y coordinates of the event.
   * @return The xy values like [x, y]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getXY Original Ext JS documentation of 'getXY'
   */
  public native function getXY():Array;

  /**
   * Gets the y coordinate of the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-getY Original Ext JS documentation of 'getY'
   */
  public native function getY():Number;

  /**
   * Returns true if the control, meta, shift or alt key was pressed during this event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-hasModifier Original Ext JS documentation of 'hasModifier'
   */
  public native function hasModifier():Boolean;

  /**
   * Injects a DOM event using the data in this object and (optionally) a new target.
   * This is a low-level technique and not likely to be used by application code. The
   * currently supported event types are:
   * <p><b>HTMLEvents</b></p>
   * <ul>
   * <li>load</li>
   * <li>unload</li>
   * <li>select</li>
   * <li>change</li>
   * <li>submit</li>
   * <li>reset</li>
   * <li>resize</li>
   * <li>scroll</li>
   * </ul>
   * <p><b>MouseEvents</b></p>
   * <ul>
   * <li>click</li>
   * <li>dblclick</li>
   * <li>mousedown</li>
   * <li>mouseup</li>
   * <li>mouseover</li>
   * <li>mousemove</li>
   * <li>mouseout</li>
   * </ul>
   * <p><b>UIEvents</b></p>
   * <ul>
   * <li>focusin</li>
   * <li>focusout</li>
   * <li>activate</li>
   * <li>focus</li>
   * <li>blur</li>
   * </ul>
   * @param target If specified, the target for the event.
   * This is likely to be used when relaying a DOM event. If not specified, →<code>getTarget()</code>
   * is used to determine the target.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-injectEvent Original Ext JS documentation of 'injectEvent'
   * @see #getTarget()
   */
  public native function injectEvent(target:* = undefined):void;

  /**
   * Checks if the key pressed was a "navigation" key. A navigation key is defined by
   * these keys:
   * <ul>
   * <li>Page Up</li>
   * <li>Page Down</li>
   * <li>End</li>
   * <li>Home</li>
   * <li>Left</li>
   * <li>Up</li>
   * <li>Right</li>
   * <li>Down</li>
   * <li>Return</li>
   * <li>Tab</li>
   * <li>Esc</li>
   * </ul>
   * @param scrollableOnly Only check navigation keys that can cause
   * element scrolling by their default action.
   * @return <code>true</code> if the press is a navigation keypress
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-isNavKeyPress Original Ext JS documentation of 'isNavKeyPress'
   */
  public native function isNavKeyPress(scrollableOnly:Boolean = false):Boolean;

  /**
   * Checks if the key pressed was a "special" key. A special key is defined as one of
   * these keys:
   * <ul>
   * <li>Page Up</li>
   * <li>Page Down</li>
   * <li>End</li>
   * <li>Home</li>
   * <li>Left arrow</li>
   * <li>Up arrow</li>
   * <li>Right arrow</li>
   * <li>Down arrow</li>
   * <li>Return</li>
   * <li>Tab</li>
   * <li>Esc</li>
   * <li>Backspace</li>
   * <li>Delete</li>
   * <li>Shift</li>
   * <li>Ctrl</li>
   * <li>Alt</li>
   * <li>Pause</li>
   * <li>Caps Lock</li>
   * <li>Print Screen</li>
   * <li>Insert</li>
   * </ul>
   * @return <code>true</code> if the key for this event is special
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-isSpecialKey Original Ext JS documentation of 'isSpecialKey'
   */
  public native function isSpecialKey():Boolean;

  /**
   * Returns the <code>→key()</code> property of a keyboard event.
   * @see #key()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-key Original Ext JS documentation of 'key'
   */
  public native function key():String;

  /**
   * Prevents the browsers default handling of the event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-preventDefault Original Ext JS documentation of 'preventDefault'
   */
  public native function preventDefault():void;

  /**
   * Initiates a drag gesture in response to this event.
   * <p>Only available when <code>type</code> is <code>'longpress'</code>. When invoked a dragstart event
   * will be immediately fired at the coordinates of the longpress event. Thereafter
   * drag events will fire in response to movement on the screen without regard
   * to the distance moved.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-startDrag Original Ext JS documentation of 'startDrag'
   */
  public native function startDrag():void;

  /**
   * Stop the event (<code>→preventDefault()</code> and <code>→stopPropagation()</code>).
   * @see #preventDefault()
   * @see #stopPropagation()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-stopEvent Original Ext JS documentation of 'stopEvent'
   */
  public native function stopEvent():Event;

  /**
   * Cancels bubbling of the event.
   * <p><strong>Overridden in Ext.overrides.event.Event.</strong></p>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-stopPropagation Original Ext JS documentation of 'stopPropagation'
   */
  public native function stopPropagation():Event;

  /**
   * Returns true if the target of this event is a child of <code>el</code>. If the allowEl
   * parameter is set to false, it will return false if the target is <code>el</code>.
   * Example usage:
   * <pre>
   * // Handle click on any child of an element
   * Ext.getBody().on('click', function(e){
   *     if(e.within('some-el')){
   *         alert('Clicked on a child of some-el!');
   *     }
   * });
   *
   * // Handle click directly on an element, ignoring clicks on child nodes
   * Ext.getBody().on('click', function(e,t){
   *     if((t.id == 'some-el') &amp;&amp; !e.within(t, true)){
   *         alert('Clicked directly on some-el!');
   *     }
   * });
   * </pre>
   * @param el The id, DOM element or Ext.Element to check
   * @param related <code>true</code> to test if the related target is within el instead
   * of the target
   * @param allowEl <code>true</code> to allow the target to be considered "within" itself.
   * <code>false</code> to only allow child elements.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.Event.html#method-within Original Ext JS documentation of 'within'
   */
  public native function within(el:*, related:Boolean = false, allowEl:Boolean = true):Boolean;
}
}