package ext.event.gesture {

[Native("Ext.event.gesture.DoubleTap", require)]
/**
 * A simple event recognizer which knows when you double tap.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.DoubleTap.html Original Ext JS documentation of 'Ext.event.gesture.DoubleTap'
 */
public class DoubleTap extends SingleTouch {
  /**
   * @param config @inheritDoc
   */
  public function DoubleTap(config:DoubleTap = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The maximum distance a touch can move without canceling recognition
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.DoubleTap.html#cfg-moveDistance Original Ext JS documentation of 'moveDistance'
   * @see #getMoveDistance()
   * @see #setMoveDistance()
   */
  public native function get moveDistance():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set moveDistance(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum distance the second tap can occur from the first tap and still
   * be considered a doubletap
   * @default 24
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.DoubleTap.html#cfg-tapDistance Original Ext JS documentation of 'tapDistance'
   * @see #getTapDistance()
   * @see #setTapDistance()
   */
  public native function get tapDistance():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set tapDistance(value:Number):void;

  /**
   * Returns the value of <code>moveDistance</code>.
   * @see #moveDistance
   */
  public native function getMoveDistance():Number;

  /**
   * Returns the value of <code>tapDistance</code>.
   * @see #tapDistance
   */
  public native function getTapDistance():Number;

  /**
   * Sets the value of <code>moveDistance</code>.
   * @param moveDistance The new value.
   * @see #moveDistance
   */
  public native function setMoveDistance(moveDistance:Number):void;

  /**
   * Sets the value of <code>tapDistance</code>.
   * @param tapDistance The new value.
   * @see #tapDistance
   */
  public native function setTapDistance(tapDistance:Number):void;
}
}