package ext.event.gesture {

[Native("Ext.event.gesture.Drag", require)]
/**
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.Drag.html Original Ext JS documentation of 'Ext.event.gesture.Drag'
 */
public class Drag extends SingleTouch {
  /**
   * @param config @inheritDoc
   */
  public function Drag(config:Drag = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The minimum distance of pixels before a touch event becomes a drag event.
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.Drag.html#cfg-minDistance Original Ext JS documentation of 'minDistance'
   * @see #getMinDistance()
   * @see #setMinDistance()
   */
  public native function get minDistance():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set minDistance(value:Number):void;

  /**
   * Returns the value of <code>minDistance</code>.
   * @see #minDistance
   */
  public native function getMinDistance():Number;

  /**
   * Sets the value of <code>minDistance</code>.
   * @param minDistance The new value.
   * @see #minDistance
   */
  public native function setMinDistance(minDistance:Number):void;
}
}