package ext.event.gesture {
import ext.Base;
import ext.mixin.IIdentifiable;

[Native("Ext.event.gesture.Recognizer", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>A base class for all gesture recognizers.</p>
 * <p>The following gestures are enabled by default in both Ext JS and Sencha Touch:</p>
 * <ul>
 * <li>→<code>ext.event.gesture.Tap</code></li>
 * <li>→<code>ext.event.gesture.DoubleTap</code></li>
 * <li>→<code>ext.event.gesture.LongPress</code></li>
 * <li>→<code>ext.event.gesture.Drag</code></li>
 * <li>→<code>ext.event.gesture.Swipe</code></li>
 * <li>→<code>ext.event.gesture.Pinch</code></li>
 * <li>→<code>ext.event.gesture.Rotate</code></li>
 * <li>→<code>ext.event.gesture.EdgeSwipe</code></li>
 * </ul>
 * @see ext.event.gesture.Tap
 * @see ext.event.gesture.DoubleTap
 * @see ext.event.gesture.LongPress
 * @see ext.event.gesture.Drag
 * @see ext.event.gesture.Swipe
 * @see ext.event.gesture.Pinch
 * @see ext.event.gesture.Rotate
 * @see ext.event.gesture.EdgeSwipe
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.Recognizer.html Original Ext JS documentation of 'Ext.event.gesture.Recognizer'
 */
public class GestureRecognizer extends Base implements IIdentifiable {
  /**
   * @param config @inheritDoc
   */
  public function GestureRecognizer(config:GestureRecognizer = null) {
    super();
  }

  /**
   * The priority of the recognizer. Determines the order in which it recognizes gestures
   * relative to other recognizers. The default recognizers use the following priorities:
   * <ul>
   * <li>Ext.event.gesture.Drag: 100</li>
   * <li>Ext.event.gesture.Tap: 200</li>
   * <li>Ext.event.gesture.DoubleTap: 300</li>
   * <li>Ext.event.gesture.LongPress: 400</li>
   * <li>Ext.event.gesture.EdgeSwipe: 500</li>
   * <li>Ext.event.gesture.Swipe: 600</li>
   * <li>Ext.event.gesture.Pinch: 700</li>
   * <li>Ext.event.gesture.Rotate: 800</li>
   * </ul>
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.Recognizer.html#property-priority Original Ext JS documentation of 'priority'
   */
  public native function get priority():Number;

  /**
   * @private
   */
  public native function set priority(value:Number):void;

  /**
   * @inheritDoc
   */
  public native function getId():String;
}
}