package ext.event.gesture {

[Native("Ext.event.gesture.Tap", require)]
/**
 * A simple event recogniser which knows when you tap.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.Tap.html Original Ext JS documentation of 'Ext.event.gesture.Tap'
 */
public class Tap extends SingleTouch {
  /**
   * @param config @inheritDoc
   */
  public function Tap(config:Tap = null) {
    super();
  }

  [ExtConfig]
  /**
   * The maximimum distance in pixels a touchstart event can travel and still be considered
   * a tap event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.event.gesture.Tap.html#cfg-moveDistance Original Ext JS documentation of 'moveDistance'
   */
  public native function get moveDistance():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set moveDistance(value:Number):void;
}
}