package ext.events {
import ext.Component;
import ext.container.Container;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.Component_container_posEvent")]
public class Component_container_posEvent extends FlExtEvent {
  /**
   * Fires after a Component had been added to a Container.
   * @since 3.4.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#event-added Original Ext JS documentation of 'added'
   * @see ext.Component
   * @eventType onAdded
   */
  public static const ADDED:String = "onAdded";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "container", "pos", "eOpts"];

  public function Component_container_posEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Parent Container
   */
  public native function get container():Container;

  /**
   * position of Component
   */
  public native function get pos():Number;

  public native function get source():Component;
}
}