package ext.events {
import ext.Component;
import ext.container.Container;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.Component_ownerCtEvent")]
public class Component_ownerCtEvent extends FlExtEvent {
  /**
   * Fires when a component is removed from an Ext.container.Container
   * @since 3.4.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#event-removed Original Ext JS documentation of 'removed'
   * @see ext.Component
   * @eventType onRemoved
   */
  public static const REMOVED:String = "onRemoved";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "ownerCt", "eOpts"];

  public function Component_ownerCtEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Container which holds the component
   */
  public native function get ownerCt():Container;

  public native function get source():Component;
}
}