package ext.events {
import ext.Component;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.Component_width_heightEvent")]
public class Component_width_heightEvent extends FlExtEvent {
  /**
   * Fires <i>one time</i> - after the component has been laid out for the first time at its initial
   * size.
   * <p>This event does not fire on components that use →<code>liquidLayout</code>, such as
   * <i>Buttons</i> (→<code>ext.button.Button</code>) and <i>Form Fields</i> (→<code>ext.form.field.BaseField</code>).</p>
   * @see ext.Component#liquidLayout
   * @see ext.button.Button
   * @see ext.form.field.BaseField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Component.html#event-boxready Original Ext JS documentation of 'boxready'
   * @see ext.Component
   * @eventType onBoxReady
   */
  public static const BOX_READY:String = "onBoxReady";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "width", "height", "eOpts"];

  public function Component_width_heightEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The initial height.
   */
  public native function get height():Number;

  public native function get source():Component;

  /**
   * The initial width.
   */
  public native function get width():Number;
}
}