package ext.events {
import ext.Editor;
import ext.dom.Element;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.Editor_boundEl_valueEvent")]
public class Editor_boundEl_valueEvent extends FlExtEvent {
  /**
   * Fires when editing is initiated, but before the value changes. Editing can be canceled
   * by returning <code>false</code> from the handler of this event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#event-beforestartedit Original Ext JS documentation of 'beforestartedit'
   * @see ext.Editor
   * @eventType onBeforeStartEdit
   */
  public static const BEFORE_START_EDIT:String = "onBeforeStartEdit";
  /**
   * Fires when this editor is displayed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.Editor.html#event-startedit Original Ext JS documentation of 'startedit'
   * @see ext.Editor
   * @eventType onStartEdit
   */
  public static const START_EDIT:String = "onStartEdit";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "boundEl", "value", "eOpts"];

  public function Editor_boundEl_valueEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The underlying element bound to this editor
   */
  public native function get boundEl():Element;

  public native function get source():Editor;

  /**
   * The field value being set
   */
  public native function get value():Object;
}
}