package ext.events {
import ext.ElementLoader;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.ElementLoader_optionsEvent")]
public class ElementLoader_optionsEvent extends FlExtEvent {
  /**
   * Fires before a load request is made to the server.
   * Returning false from an event listener can prevent the load
   * from occurring.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#event-beforeload Original Ext JS documentation of 'beforeload'
   * @see ext.ElementLoader
   * @eventType onBeforeLoad
   */
  public static const BEFORE_LOAD:String = "onBeforeLoad";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "options", "eOpts"];

  public function ElementLoader_optionsEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The options passed to the request
   */
  public native function get options():Object;

  public native function get source():ElementLoader;
}
}