package ext.events {
import ext.ElementLoader;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.ElementLoader_response_optionsEvent")]
public class ElementLoader_response_optionsEvent extends FlExtEvent {
  /**
   * Fires after an unsuccessful load.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#event-exception Original Ext JS documentation of 'exception'
   * @see ext.ElementLoader
   * @eventType onException
   */
  public static const EXCEPTION:String = "onException";
  /**
   * Fires after a successful load.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.ElementLoader.html#event-load Original Ext JS documentation of 'load'
   * @see ext.ElementLoader
   * @eventType onLoad
   */
  public static const LOAD:String = "onLoad";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "response", "options", "eOpts"];

  public function ElementLoader_response_optionsEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The options passed to the request
   */
  public native function get options():Object;

  /**
   * The response from the server
   */
  public native function get response():Object;

  public native function get source():ElementLoader;
}
}