package ext.events {
import ext.route.Route;
import ext.route.RouteAction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.GlobalEvents_action_routeEvent")]
public class GlobalEvents_action_routeEvent extends FlExtEvent {
  /**
   * Fires when a route is being exited meaning when a route
   * was executed but no longer matches a token in the current hash.
   * <p>The exit handlers can be prevented from executing by returning <code>false</code> in a listener
   * or executing the →<code>ext.route.RouteAction.stop()</code> method on the action.</p>
   * @see ext.route.RouteAction#stop()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-beforerouteexit Original Ext JS documentation of 'beforerouteexit'
   * @see ext.SGlobalEvents
   * @eventType onBeforeRouteExit
   */
  public static const BEFORE_ROUTE_EXIT:String = "onBeforeRouteExit";
  public static const __PARAMETER_SEQUENCE__:Array = ["action", "route", "eOpts"];

  public function GlobalEvents_action_routeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The action with defined exit actions. Each
   * action will execute with the last token this route was connected with.
   */
  public native function get action():RouteAction;

  public native function get route():Route;
}
}