package ext.events {
import ext.route.RouteAction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.GlobalEvents_action_tokensEvent")]
public class GlobalEvents_action_tokensEvent extends FlExtEvent {
  /**
   * Fires when the hash has changed and before any routes are executed. This allows
   * pre-processing to add additional →<code>ext.route.RouteAction.before()</code> or
   * →<code>ext.route.RouteAction.action()</code> handlers when the
   * →<code>ext.route.RouteAction</code> is run.
   * <p>Route execution can be prevented by returning <code>false</code> in the listener
   * or executing the →<code>ext.route.RouteAction.stop()</code> method on the action.</p>
   * @see ext.route.RouteAction#before()
   * @see ext.route.RouteAction#action()
   * @see ext.route.RouteAction
   * @see ext.route.RouteAction#stop()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-beforeroutes Original Ext JS documentation of 'beforeroutes'
   * @see ext.SGlobalEvents
   * @eventType onBeforeRoutes
   */
  public static const BEFORE_ROUTES:String = "onBeforeRoutes";
  public static const __PARAMETER_SEQUENCE__:Array = ["action", "tokens", "eOpts"];

  public function GlobalEvents_action_tokensEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * An action that will be executed
   * prior to any route execution.
   */
  public native function get action():RouteAction;

  [ArrayElementType("String")]
  /**
   * An array of individual tokens in the hash.
   */
  public native function get tokens():Array;
}
}