package ext.events {
import ext.Component;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.GlobalEvents_componentEvent")]
public class GlobalEvents_componentEvent extends FlExtEvent {
  /**
   * Fires when a Component is added to a Container.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-added Original Ext JS documentation of 'added'
   * @see ext.SGlobalEvents
   * @eventType onAdded
   */
  public static const ADDED:String = "onAdded";
  /**
   * Fires when a Component is collapsed (e.g., a panel).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-collapse Original Ext JS documentation of 'collapse'
   * @see ext.SGlobalEvents
   * @eventType onCollapse
   */
  public static const COLLAPSE:String = "onCollapse";
  /**
   * Fires when a Component is expanded (e.g., a panel).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-expand Original Ext JS documentation of 'expand'
   * @see ext.SGlobalEvents
   * @eventType onExpand
   */
  public static const EXPAND:String = "onExpand";
  /**
   * Fires when a Component is hidden.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-hide Original Ext JS documentation of 'hide'
   * @see ext.SGlobalEvents
   * @eventType onHide
   */
  public static const HIDE:String = "onHide";
  /**
   * Fires when a Component is removed from a Container.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-removed Original Ext JS documentation of 'removed'
   * @see ext.SGlobalEvents
   * @eventType onRemoved
   */
  public static const REMOVED:String = "onRemoved";
  /**
   * Fires when a Component is shown.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-show Original Ext JS documentation of 'show'
   * @see ext.SGlobalEvents
   * @eventType onShow
   */
  public static const SHOW:String = "onShow";
  public static const __PARAMETER_SEQUENCE__:Array = ["component", "eOpts"];

  public function GlobalEvents_componentEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get component():Component;
}
}