package ext.events {
import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.GlobalEvents_contextEvent")]
public class GlobalEvents_contextEvent extends FlExtEvent {
  /**
   * Fires before →<code>ext.mixin.Responsive</code> perform any updates in response to
   * dynamic changes. This is prior to refreshing <code>responsiveFormulas</code>.
   * @since 5.0.1
   * @see ext.mixin.Responsive
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-beforeresponsiveupdate Original Ext JS documentation of 'beforeresponsiveupdate'
   * @see ext.SGlobalEvents
   * @eventType onBeforeResponsiveUpdate
   */
  public static const BEFORE_RESPONSIVE_UPDATE:String = "onBeforeResponsiveUpdate";
  /**
   * Fires when →<code>ext.mixin.Responsive</code> is about to perform updates in response to
   * dynamic changes. At this point all <code>responsiveFormulas</code> have been refreshed.
   * @since 5.0.1
   * @see ext.mixin.Responsive
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-beginresponsiveupdate Original Ext JS documentation of 'beginresponsiveupdate'
   * @see ext.SGlobalEvents
   * @eventType onBeginResponsiveUpdate
   */
  public static const BEGIN_RESPONSIVE_UPDATE:String = "onBeginResponsiveUpdate";
  /**
   * Fires after →<code>ext.mixin.Responsive</code> has performed updates in response to
   * dynamic changes.
   * @since 5.0.1
   * @see ext.mixin.Responsive
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-responsiveupdate Original Ext JS documentation of 'responsiveupdate'
   * @see ext.SGlobalEvents
   * @eventType onResponsiveUpdate
   */
  public static const RESPONSIVE_UPDATE:String = "onResponsiveUpdate";
  public static const __PARAMETER_SEQUENCE__:Array = ["context", "eOpts"];

  public function GlobalEvents_contextEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The context object used by <code>responsiveConfig</code> expressions.
   */
  public native function get context():Object;
}
}