package ext.events {
import ext.route.Route;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.GlobalEvents_routeEvent")]
public class GlobalEvents_routeEvent extends FlExtEvent {
  /**
   * Fires when a route was rejected from either a before action,
   * →<code>ext.GlobalEvents.event:onBeforeRoutes</code> event or →<code>ext.GlobalEvents.event:onBeforeRoute</code> event.
   * @see ext.SGlobalEvents#event:onBeforeRoutes ext.GlobalEvents.event:onBeforeRoutes
   * @see ext.SGlobalEvents#event:onBeforeRoute ext.GlobalEvents.event:onBeforeRoute
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-routereject Original Ext JS documentation of 'routereject'
   * @see ext.SGlobalEvents
   * @eventType onRouteReject
   */
  public static const ROUTE_REJECT:String = "onRouteReject";
  public static const __PARAMETER_SEQUENCE__:Array = ["route", "eOpts"];

  public function GlobalEvents_routeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The route which had it's execution rejected.
   */
  public native function get route():Route;
}
}