package ext.events {
import ext.route.Route;
import ext.route.RouteAction;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.events.GlobalEvents_route_actionEvent")]
public class GlobalEvents_route_actionEvent extends FlExtEvent {
  /**
   * Fires when a route is about to be executed. This allows pre-processing to add additional
   * →<code>ext.route.RouteAction.before()</code> or →<code>ext.route.RouteAction.action()</code> handlers
   * when the →<code>ext.route.RouteAction</code> is run.
   * <p>The route can be prevented from executing by returning <code>false</code> in a listener
   * or executing the →<code>ext.route.RouteAction.stop()</code> method on the action.</p>
   * @see ext.route.RouteAction#before()
   * @see ext.route.RouteAction#action()
   * @see ext.route.RouteAction
   * @see ext.route.RouteAction#stop()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.GlobalEvents.html#event-beforeroute Original Ext JS documentation of 'beforeroute'
   * @see ext.SGlobalEvents
   * @eventType onBeforeRoute
   */
  public static const BEFORE_ROUTE:String = "onBeforeRoute";
  public static const __PARAMETER_SEQUENCE__:Array = ["route", "action", "eOpts"];

  public function GlobalEvents_route_actionEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The action that will be run.
   */
  public native function get action():RouteAction;

  /**
   * The route being executed.
   */
  public native function get route():Route;
}
}