package ext.field {
import ext.Base;

[Native("Ext.field.InputMask", require)]
/**
 * Input masks provide a way for developers to define rules that govern user input. This ensures
 * that data is submitted in an expected format and with the appropriate character set.
 * <p>Frequent uses of input masks include:</p>
 * <ul>
 * <li>Zip or postal codes</li>
 * <li>Times</li>
 * <li>Dates</li>
 * <li>Telephone numbers</li>
 * </ul>
 * <p><b><i>Character Sets</i></b></p>
 * <p>Input mask characters can be defined by representations of the desired set. For instance,
 * if you only want to allow numbers, you can use 0 or 9. Here is the list of default
 * representations:</p>
 * <ul>
 * <li>'&#42;': '[A-Za-z0-9]' // any case letter A-Z, any integer</li>
 * <li>'a': '[a-z]' // any lower case letter a-z</li>
 * <li>'A': '[A-Z]' // any upper case letter A-Z</li>
 * <li>'0': '[0-9]' // any integer</li>
 * <li>'9': '[0-9]' // any integer</li>
 * </ul>
 * <p>So, to create a telephone input mask, you could use:</p>
 * <ul>
 * <li>(000) 000-0000</li>
 * </ul>
 * <p>or</p>
 * <ul>
 * <li>(999) 999-9999</li>
 * </ul>
 * <p><b><i>Telephone input mask</i></b></p>
 * <pre>
 * @example toolkit=modern
 * Ext.create({
 *     fullscreen: true,
 *     xtype: 'formpanel',
 *
 *     items: [{
 *         xtype: 'textfield',
 *         label: 'Phone Number',
 *         placeholder: '(xxx) xxx-xxxx',
 *         inputMask: '(999) 999-9999'
 *     }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.field.InputMask.html Original Ext JS documentation of 'Ext.field.InputMask'
 */
public class InputMaskField extends Base {
  [ExtConfig]
  [Bindable]
  /**
   * <b>This is a required setting</b>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.field.InputMask.html#cfg-pattern Original Ext JS documentation of 'pattern'
   * @see #getPattern()
   * @see #setPattern()
   */
  public native function get pattern():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set pattern(value:String):void;

  /**
   * Returns the value of <code>pattern</code>.
   * @see #pattern
   */
  public native function getPattern():String;

  /**
   * Sets the value of <code>pattern</code>.
   * @param pattern The new value.
   * @see #pattern
   */
  public native function setPattern(pattern:String):void;
}
}