package ext.flash {
import ext.Component;
import ext.dom.Element;

[Native("Ext.flash.Component", require)]
/**
 * @see ext.flash.events.FlashComponentEvent.FAILURE
 * @eventType ext.flash.events.FlashComponentEvent.FAILURE
 */
[Event(name='onFailure', type='ext.flash.events.FlashComponentEvent')]
/**
 * @see ext.flash.events.FlashComponentEvent.SUCCESS
 * @eventType ext.flash.events.FlashComponentEvent.SUCCESS
 */
[Event(name='onSuccess', type='ext.flash.events.FlashComponentEvent')]
/**
 * A simple Component for displaying an Adobe Flash SWF movie. The movie will be sized and can
 * participate in layout like any other Component.
 * <p>This component requires the third-party SWFObject library version 2.2 or above. It is not
 * included within the ExtJS distribution, so you will have to include it into your page manually
 * in order to use this component.
 * The SWFObject library can be downloaded from the <a href="http://code.google.com/p/swfobject">SWFObject project page</a>
 * and then simply import it into the head of your HTML document:</p>
 * <pre>
 * &lt;script type="text/javascript" src="path/to/local/swfobject.js"&gt;&lt;/script&gt;
 * </pre>
 * <p><b><i>Configuration</i></b></p>
 * <p>This component allows several options for configuring how the target Flash movie is embedded.
 * The most important is the required →<code>url</code> which points to the location of the Flash movie
 * to load. Other configurations include:</p>
 * <ul>
 * <li>→<code>backgroundColor</code></li>
 * <li>→<code>wmode</code></li>
 * <li>→<code>flashVars</code></li>
 * <li>→<code>flashParams</code></li>
 * <li>→<code>flashAttributes</code></li>
 * </ul>
 * <p><b><i>Example usage:</i></b></p>
 * <pre>
 * var win = Ext.widget('window', {
 *     title: "It's a tiger!",
 *     layout: 'fit',
 *     width: 300,
 *     height: 300,
 *     x: 20,
 *     y: 20,
 *     resizable: true,
 *     items: {
 *         xtype: 'flash',
 *         url: 'tiger.swf'
 *     }
 * });
 * win.show();
 * </pre>
 * <p><b><i>Express Install</i></b></p>
 * <p>Adobe provides a tool called <a href="http://www.adobe.com/devnet/flashplayer/articles/express_install.html">Express Install</a>
 * that offers users an easy way to upgrade their Flash player. If you wish to make use of this,
 * you should set the static EXPRESS_INSTALL_URL property to the location of your Express Install
 * SWF file:</p>
 * <pre>
 * Ext.flash.Component.EXPRESS_INSTALL_URL = 'path/to/local/expressInstall.swf';
 * </pre>
 * @see #url
 * @see #backgroundColor
 * @see #wmode
 * @see #flashVars
 * @see #flashParams
 * @see #flashAttributes
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html Original Ext JS documentation of 'Ext.flash.Component'
 */
public class FlashComponent extends Component {
  /**
   * The url for installing flash if it doesn't exist. This should be set to a local resource.
   * See <a href="http://get.adobe.com/flashplayer/">http://get.adobe.com/flashplayer/</a> for details.
   * @default 'http://swfobject.googlecode.com/svn/trunk/swfobject/expressInstall.swf'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#static-property-EXPRESS_INSTALL_URL Original Ext JS documentation of 'EXPRESS_INSTALL_URL'
   */
  public static native function get EXPRESS_INSTALL_URL():String;

  /**
   * @param config @inheritDoc
   */
  public function FlashComponent(config:FlashComponent = null) {
    super();
  }

  [ExtConfig]
  /**
   * The background color of the SWF movie.
   * @default "#ffffff"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-backgroundColor Original Ext JS documentation of 'backgroundColor'
   */
  public native function get backgroundColor():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set backgroundColor(value:String):void;

  [ExtConfig]
  /**
   * True to prompt the user to install flash if not installed. Note that this uses
   * Ext.FlashComponent.EXPRESS_INSTALL_URL, which should be set to the local resource.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-expressInstall Original Ext JS documentation of 'expressInstall'
   */
  public native function get expressInstall():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expressInstall(value:Boolean):void;

  [ExtConfig]
  /**
   * A set of key value pairs to be passed to the flash object as attributes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-flashAttributes Original Ext JS documentation of 'flashAttributes'
   */
  public native function get flashAttributes():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set flashAttributes(value:Object):void;

  [ExtConfig]
  /**
   * A set of key value pairs to be passed to the flash object as parameters. Possible parameters
   * can be found here: http://kb2.adobe.com/cps/127/tn_12701.html
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-flashParams Original Ext JS documentation of 'flashParams'
   */
  public native function get flashParams():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set flashParams(value:Object):void;

  [ExtConfig]
  /**
   * A set of key value pairs to be passed to the flash object as flash variables.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-flashVars Original Ext JS documentation of 'flashVars'
   */
  public native function get flashVars():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set flashVars(value:Object):void;

  [ExtConfig]
  /**
   * Indicates the version the flash content was published for.
   * @default "9.0.115"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-flashVersion Original Ext JS documentation of 'flashVersion'
   */
  public native function get flashVersion():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set flashVersion(value:String):void;

  /**
   * A reference to the object or embed element into which the SWF file is loaded. Only
   * populated after the component is rendered and the SWF has been successfully embedded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#property-swf Original Ext JS documentation of 'swf'
   */
  public native function get swf():Element;

  /**
   * @private
   */
  public native function set swf(value:Element):void;

  [ExtConfig]
  /**
   * The height of the embedded SWF movie inside the component.
   * <p>Defaults to "100%" so that the movie matches the height of the component.</p>
   * @default "100%"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-swfHeight Original Ext JS documentation of 'swfHeight'
   */
  public native function get swfHeight():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set swfHeight(value:*):void;

  [ExtConfig]
  /**
   * The width of the embedded SWF movie inside the component.
   * <p>Defaults to "100%" so that the movie matches the width of the component.</p>
   * @default "100%"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-swfWidth Original Ext JS documentation of 'swfWidth'
   */
  public native function get swfWidth():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set swfWidth(value:*):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. The URL of the SWF file to include.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:String):void;

  [ExtConfig]
  /**
   * The wmode of the flash object. This can be used to control layering.
   * Set to 'transparent' to ignore the →<code>backgroundColor</code> and make the background
   * of the Flash movie transparent.
   * @default "opaque"
   * @see #backgroundColor
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#cfg-wmode Original Ext JS documentation of 'wmode'
   */
  public native function get wmode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set wmode(value:String):void;

  /**
   * Retrieves the id of the SWF object/embed element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#method-getSwfId Original Ext JS documentation of 'getSwfId'
   */
  public native function getSwfId():String;
}
}