package ext.flash.events {
import ext.flash.FlashComponent;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.flash.events.FlashComponentEvent")]
public class FlashComponentEvent extends FlExtEvent {
  /**
   * Fired when the Flash movie embedding fails
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#event-failure Original Ext JS documentation of 'failure'
   * @see ext.flash.FlashComponent
   * @eventType onFailure
   */
  public static const FAILURE:String = "onFailure";
  /**
   * Fired when the Flash movie has been successfully embedded
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.flash.Component.html#event-success Original Ext JS documentation of 'success'
   * @see ext.flash.FlashComponent
   * @eventType onSuccess
   */
  public static const SUCCESS:String = "onSuccess";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function FlashComponentEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():FlashComponent;
}
}