package ext.form {
import ext.container.Container;
import ext.data.Model;
import ext.data.reader.DataReader;
import ext.form.field.Field;
import ext.util.MixedCollection;
import ext.util.Observable;

[Native("Ext.form.Basic", require)]
/**
 * @see ext.form.events.BasicForm_actionEvent.ACTION_COMPLETE
 * @eventType ext.form.events.BasicForm_actionEvent.ACTION_COMPLETE
 */
[Event(name='onActionComplete', type='ext.form.events.BasicForm_actionEvent')]
/**
 * @see ext.form.events.BasicForm_actionEvent.ACTION_FAILED
 * @eventType ext.form.events.BasicForm_actionEvent.ACTION_FAILED
 */
[Event(name='onActionFailed', type='ext.form.events.BasicForm_actionEvent')]
/**
 * @see ext.form.events.BasicForm_actionEvent.BEFORE_ACTION
 * @eventType ext.form.events.BasicForm_actionEvent.BEFORE_ACTION
 */
[Event(name='onBeforeAction', type='ext.form.events.BasicForm_actionEvent')]
/**
 * @see ext.form.events.BasicForm_dirtyEvent.DIRTY_CHANGE
 * @eventType ext.form.events.BasicForm_dirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.form.events.BasicForm_dirtyEvent')]
/**
 * @see ext.form.events.BasicForm_validEvent.VALIDITY_CHANGE
 * @eventType ext.form.events.BasicForm_validEvent.VALIDITY_CHANGE
 */
[Event(name='onValidityChange', type='ext.form.events.BasicForm_validEvent')]
/**
 * Provides input field management, validation, submission, and form loading services for the
 * collection of →<code>ext.form.field.Field</code> instances within a
 * →<code>ext.container.Container</code>. It is recommended that you use a →<code>ext.form.FormPanel</code>
 * as the form container, as that has logic to automatically hook up an instance of
 * →<code>ext.form.BasicForm</code> (plus other conveniences related to field configuration.)
 * <p><b><i>Form Actions</i></b></p>
 * <p>The Basic class delegates the handling of form loads and submits to instances of
 * →<code>ext.form.action.Action</code>. See the various Action implementations for specific details
 * of each one's functionality, as well as the documentation for →<code>doAction()</code> which details
 * the configuration options that can be specified in each action call.</p>
 * <p>The default submit Action is →<code>ext.form.action.SubmitAction</code>, which uses an Ajax request
 * to submit the form's values to a configured URL. To enable normal browser submission
 * of an Ext form, use the →<code>standardSubmit</code> config option.</p>
 * <p><b><i>File uploads</i></b></p>
 * <p>File uploads are not performed using normal 'Ajax' techniques; see the description for
 * →<code>hasUpload()</code> for details. If you're using file uploads you should read the method
 * description.</p>
 * <p><b><i>Example usage:</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Basic Form',
 *     renderTo: Ext.getBody(),
 *     bodyPadding: 5,
 *     width: 350,
 *
 *     // Any configuration items here will be automatically passed along to
 *     // the Ext.form.Basic instance when it gets created.
 *
 *     // The form will submit an AJAX request to this URL when submitted
 *     url: 'save-form.php',
 *
 *     items: [{
 *         xtype: 'textfield',
 *         fieldLabel: 'Field',
 *         name: 'theField'
 *     }],
 *
 *     buttons: [{
 *         text: 'Submit',
 *         handler: function() {
 *             // The getForm() method returns the Ext.form.Basic instance:
 *             var form = this.up('form').getForm();
 *             if (form.isValid()) {
 *                 // Submit the Ajax request and handle the response
 *                 form.submit({
 *                     success: function(form, action) {
 *                        Ext.Msg.alert('Success', action.result.message);
 *                     },
 *                     failure: function(form, action) {
 *                         Ext.Msg.alert(
 *                             'Failed',
 *                             action.result ? action.result.message : 'No response'
 *                         );
 *                     }
 *                 });
 *             }
 *         }
 *     }]
 * });
 * </pre>
 * @see ext.form.field.Field
 * @see ext.container.Container
 * @see ext.form.FormPanel
 * @see ext.form.BasicForm
 * @see ext.form.action.Action
 * @see #doAction()
 * @see ext.form.action.SubmitAction
 * @see #standardSubmit
 * @see #hasUpload()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html Original Ext JS documentation of 'Ext.form.Basic'
 */
public class BasicForm extends Observable {
  /**
   * Creates new form.
   * @param owner The component that is the container for the form,
   * usually a →<code>ext.form.FormPanel</code>
   * @param config Configuration options. These are normally specified in the config
   * to the →<code>ext.form.FormPanel</code> constructor, which passes them along to the BasicForm
   * automatically.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see ext.form.FormPanel
   */
  public function BasicForm(owner:Container, config:BasicForm = null) {
    super();
  }

  [ExtConfig]
  /**
   * If specified, load and submit actions will be handled with
   * →<code>ext.form.action.DirectLoadAction</code> and
   * →<code>ext.form.action.DirectSubmitAction</code>. Methods which have been imported by
   * →<code>ext.direct.DirectManager</code> can be specified here to load and submit forms. API methods
   * may also be specified as strings. See →<code>ext.data.proxy.DirectProxy.directFn</code>.
   * Such as the following:
   * <pre>
   * api: {
   *     load: App.ss.MyProfile.load,
   *     submit: App.ss.MyProfile.submit
   * }
   * </pre>
   * <p>Load actions can use →<code>paramOrder</code> or →<code>paramsAsHash</code> to customize how the load
   * method is invoked. Submit actions will always use a standard form submit. The <code>formHandler</code>
   * configuration (see Ext.direct.RemotingProvider#action) must be set on the associated
   * server-side method which has been imported by →<code>ext.direct.DirectManager</code>.</p>
   * @see ext.form.action.DirectLoadAction
   * @see ext.form.action.DirectSubmitAction
   * @see ext.direct.#DirectManager ext.direct.DirectManager
   * @see ext.data.proxy.DirectProxy#directFn
   * @see #paramOrder
   * @see #paramsAsHash
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-api Original Ext JS documentation of 'api'
   */
  public native function get api():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set api(value:Object):void;

  [ExtConfig]
  /**
   * Parameters to pass with all requests. e.g. baseParams: <code>{id: '123', foo: 'bar'}</code>.
   * <p>Parameters are encoded as standard HTTP parameters using →<code>ext.ObjectUtil.toQueryString()</code>.</p>
   * @see ext.SObjectUtil#toQueryString() ext.ObjectUtil.toQueryString()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-baseParams Original Ext JS documentation of 'baseParams'
   */
  public native function get baseParams():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseParams(value:Object):void;

  [ExtConfig]
  /**
   * An Ext.data.reader.Reader (e.g. →<code>ext.data.reader.XmlReader</code>) instance or
   * configuration to be used to read field error messages returned from 'submit' actions.
   * This is optional as there is built-in support for processing JSON responses.
   * <p>The Records which provide messages for the invalid Fields must use the
   * Field name (or id) as the Record ID, and must contain a field called 'msg'
   * which contains the error message.</p>
   * <p>The errorReader does not have to be a full-blown implementation of a
   * Reader. It simply needs to implement a <code>read(xhr)</code> function
   * which returns an Array of Records in an object with the following
   * structure:</p>
   * <pre>
   * {
   *     records: recordArray
   * }
   * </pre>
   * @see ext.data.reader.XmlReader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-errorReader Original Ext JS documentation of 'errorReader'
   */
  public native function get errorReader():DataReader;

  [ExtConfig]
  /**
   * @private
   */
  public native function set errorReader(value:*):void;

  [ExtConfig]
  /**
   * If set to true, the field values are sent as JSON in the request body.
   * All of the field values, plus any additional params configured via →<code>baseParams</code>
   * and/or the <code>options</code> to →<code>submit()</code>, will be included in the values POSTed in the body
   * of the request.
   * @see #baseParams
   * @see #submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-jsonSubmit Original Ext JS documentation of 'jsonSubmit'
   */
  public native function get jsonSubmit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set jsonSubmit(value:Boolean):void;

  [ExtConfig]
  /**
   * Optional metadata to pass with the actions when Ext Direct →<code>api</code> is used.
   * See →<code>ext.direct.DirectManager</code> for more information.
   * @see #api
   * @see ext.direct.#DirectManager ext.direct.DirectManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-metadata Original Ext JS documentation of 'metadata'
   */
  public native function get metadata():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set metadata(value:*):void;

  [ExtConfig]
  /**
   * The request method to use (GET or POST) for form actions if one isn't supplied
   * in the action options.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-method Original Ext JS documentation of 'method'
   */
  public native function get method():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set method(value:String):void;

  /**
   * The container component to which this BasicForm is attached.
   * @default owner
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#property-owner Original Ext JS documentation of 'owner'
   */
  public native function get owner():Container;

  /**
   * @private
   */
  public native function set owner(value:Container):void;

  [ExtConfig]
  /**
   * A list of params to be executed server side. Only used for the →<code>api</code> <code>→load()</code>
   * configuration.
   * <p>Specify the params in the order in which they must be executed on the
   * server-side as either (1) an Array of String values, or (2) a String of params
   * delimited by either whitespace, comma, or pipe. For example,
   * any of the following would be acceptable:</p>
   * <pre>
   * paramOrder: ['param1','param2','param3']
   * paramOrder: 'param1 param2 param3'
   * paramOrder: 'param1,param2,param3'
   * paramOrder: 'param1|param2|param'
   * </pre>
   * @see #api
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-paramOrder Original Ext JS documentation of 'paramOrder'
   */
  public native function get paramOrder():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set paramOrder(value:*):void;

  [ExtConfig]
  /**
   * Only used for the →<code>api</code> <code>→load()</code> configuration. If true, parameters will be sent as a
   * single hash collection of named arguments. Providing a →<code>paramOrder</code> nullifies this
   * configuration.
   * @default false
   * @see #api
   * @see #load()
   * @see #paramOrder
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-paramsAsHash Original Ext JS documentation of 'paramsAsHash'
   */
  public native function get paramsAsHash():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set paramsAsHash(value:Boolean):void;

  [ExtConfig]
  /**
   * An Ext.data.reader.Reader (e.g. →<code>ext.data.reader.XmlReader</code>) instance or
   * configuration to be used to read data when executing 'load' actions. This
   * is optional as there is built-in support for processing JSON responses.
   * @see ext.data.reader.XmlReader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-reader Original Ext JS documentation of 'reader'
   */
  public native function get reader():DataReader;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reader(value:*):void;

  [ExtConfig]
  /**
   * If set to true, a standard HTML form submit is used instead of a XHR (Ajax) style form
   * submission. All of the field values, plus any additional params configured via
   * →<code>baseParams</code> and/or the <code>options</code> to →<code>submit()</code>, will be included in the values
   * submitted in the form.
   * @see #baseParams
   * @see #submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-standardSubmit Original Ext JS documentation of 'standardSubmit'
   */
  public native function get standardSubmit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set standardSubmit(value:Boolean):void;

  [ExtConfig]
  /**
   * Timeout for form actions in seconds.
   * @default 30
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-timeout Original Ext JS documentation of 'timeout'
   */
  public native function get timeout():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  [ExtConfig]
  /**
   * If set to true, →<code>reset()</code>() resets to the last loaded or
   * →<code>ext.form.BasicForm.setValues()</code>() data instead of when the form was first
   * created.
   * @default false
   * @see #reset()
   * @see ext.form.BasicForm#setValues()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-trackResetOnLoad Original Ext JS documentation of 'trackResetOnLoad'
   */
  public native function get trackResetOnLoad():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trackResetOnLoad(value:Boolean):void;

  [ExtConfig]
  /**
   * The URL to use for form actions if one isn't supplied in the
   * →<code>ext.form.BasicForm.doAction()</code> options.
   * @see ext.form.BasicForm#doAction()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:String):void;

  [ExtConfig]
  /**
   * By default wait messages are displayed with Ext.MessageBox.wait. You can target a specific
   * element by passing it or its id or mask the form itself by passing in true.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-waitMsgTarget Original Ext JS documentation of 'waitMsgTarget'
   */
  public native function get waitMsgTarget():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitMsgTarget(value:*):void;

  [ExtConfig]
  /**
   * The default title to show for the waiting message box
   * @default 'Please Wait...'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#cfg-waitTitle Original Ext JS documentation of 'waitTitle'
   */
  public native function get waitTitle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitTitle(value:String):void;

  /**
   * Calls →<code>ext.Ext.applyIf()</code> for all field in this form with the passed object.
   * @param obj The object to be applied
   * @return this
   * @see ext.SExt#applyIf() ext.Ext.applyIf()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-applyIfToFields Original Ext JS documentation of 'applyIfToFields'
   */
  public native function applyIfToFields(obj:Object):BasicForm;

  /**
   * Calls →<code>ext.Ext.apply()</code> for all fields in this form with the passed object.
   * @param obj The object to be applied
   * @return this
   * @see ext.SExt#apply() ext.Ext.apply()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-applyToFields Original Ext JS documentation of 'applyToFields'
   */
  public native function applyToFields(obj:Object):BasicForm;

  /**
   * Check whether the dirty state of the entire form has changed since it was last checked, and
   * if so fire the →<code>event:onDirtyChange</code> event. This is automatically invoked
   * when an individual field's <code>dirty</code> state changes.
   * @see #event:onDirtyChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-checkDirty Original Ext JS documentation of 'checkDirty'
   */
  public native function checkDirty():void;

  /**
   * Check whether the validity of the entire form has changed since it was last checked, and
   * if so fire the →<code>event:onValidityChange</code> event. This is automatically invoked
   * when an individual field's validity changes.
   * @see #event:onValidityChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-checkValidity Original Ext JS documentation of 'checkValidity'
   */
  public native function checkValidity():void;

  /**
   * Clears all invalid field messages in this form.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-clearInvalid Original Ext JS documentation of 'clearInvalid'
   */
  public native function clearInvalid():BasicForm;

  /**
   * Destroys this object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Performs a predefined action (an implementation of →<code>ext.form.action.Action</code>)
   * to perform application-specific processing.
   * @param action The name of the predefined action type,
   * or instance of →<code>ext.form.action.Action</code> to perform.
   * @param options The options to pass to the →<code>ext.form.action.Action</code>
   * that will get created, if the action argument is a String.
   * <p>All of the config options listed below are supported by both the
   * <i>submit</i> (→<code>ext.form.action.SubmitAction</code>) and <i>load</i> (→<code>ext.form.action.LoadAction</code>) actions
   * unless otherwise noted (custom actions could also accept other config options):</p>
   * <ul>
   * <li><code>url:String</code> (optional) —
   * The url for the action (defaults to the form's →<code>url</code>.)
   * </li>
   * <li><code>method:String</code> (optional) —
   * The form method to use (defaults to the form's method, or POST if not defined)
   * </li>
   * <li><code>params</code> (optional) —
   * The params to pass (defaults to the form's baseParams, or none if not defined)
   * <p>Parameters are encoded as standard HTTP parameters using
   * <i>Ext.Object.toQueryString</i> (→<code>ext.Ext.urlEncode()</code>).</p>
   * </li>
   * <li><code>headers:Object</code> (optional) —
   * Request headers to set for the action.
   * </li>
   * <li><code>success:Function</code> (optional) —
   * The callback that will be invoked after a successful response (see top of
   * <i>submit</i> (→<code>ext.form.action.SubmitAction</code>) and <i>load</i> (→<code>ext.form.action.LoadAction</code>)
   * for a description of what constitutes a successful response).
   * <ul>
   * <li><code>form:ext.form.BasicForm</code> (optional) —
   * The form that requested the action.
   * </li>
   * <li><code>action:ext.form.action.Action</code> (optional) —
   * The Action object which performed
   * the operation.
   * The action object contains these properties of interest:
   * <ul>
   * <li>→<code>ext.form.action.Action.response</code></li>
   * <li>→<code>ext.form.action.Action.result</code> - interrogate for custom post-processing</li>
   * <li>→<code>ext.form.action.Action.type</code></li>
   * </ul>
   * </li>
   * </ul>
   * </li>
   * <li><code>failure:Function</code> (optional) —
   * The callback that will be invoked after a failed transaction attempt.
   * <ul>
   * <li><code>form:ext.form.BasicForm</code> (optional) —
   * The form that requested the action.
   * </li>
   * <li><code>action:ext.form.action.Action</code> (optional) —
   * The Action object which performe
   * d the operation.
   * The action object contains these properties of interest:
   * <ul>
   * <li>→<code>ext.form.action.Action.failureType</code></li>
   * <li>→<code>ext.form.action.Action.response</code></li>
   * <li>→<code>ext.form.action.Action.result</code> - interrogate for custom post-processing</li>
   * <li>→<code>ext.form.action.Action.type</code></li>
   * </ul>
   * </li>
   * </ul>
   * </li>
   * <li><code>scope:Object</code> (optional) —
   * The scope in which to call the callback functions (The this reference for the callback
   * functions).
   * </li>
   * <li><code>clientValidation:Boolean</code> (optional) —
   * Submit Action only. Determines whether a Form's fields are validated in a final call to
   * →<code>ext.form.BasicForm.isValid()</code> prior to submission. Set to false to prevent this.
   * If undefined, pre-submission field validation is performed.
   * </li>
   * </ul>
   * @return this
   * @see ext.form.action.Action
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-doAction Original Ext JS documentation of 'doAction'
   * @see ext.form.action.SubmitAction
   * @see ext.form.action.LoadAction
   * @see #url
   * @see ext.SExt#urlEncode() ext.Ext.urlEncode()
   * @see ext.form.action.Action#response
   * @see ext.form.action.Action#result
   * @see ext.form.action.Action#type
   * @see ext.form.action.Action#failureType
   * @see ext.form.BasicForm#isValid()
   */
  public native function doAction(action:*, options:Object = null):BasicForm;

  /**
   * Find a specific →<code>ext.form.field.Field</code> in this form by id or name.
   * @param id The value to search for (specify either a →<code>ext.Component.id</code> or
   * <i>name</i> (→<code>ext.form.field.Field.getName()</code>) or hiddenName).
   * @return The first matching field, or <code>null</code> if none was found.
   * @see ext.form.field.Field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-findField Original Ext JS documentation of 'findField'
   * @see ext.Component#id
   * @see ext.form.field.Field#getName()
   */
  public native function findField(id:String):Field;

  /**
   * Retrieves the fields in the form as a set of key/value pairs, using their
   * →<code>ext.form.field.Field.getModelData()</code> method to collect the values.
   * If multiple fields return values under the same name those values will be combined
   * into an Array. This is similar to →<code>getValues()</code> except that this method collects
   * type-specific data values (e.g. Date objects for date fields) while getValues returns
   * only String values for submission.
   * @param dirtyOnly If true, only fields that are dirty will be included
   * in the result.
   * @default false
   * @see ext.form.field.Field#getModelData()
   * @see #getValues()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-getFieldValues Original Ext JS documentation of 'getFieldValues'
   */
  public native function getFieldValues(dirtyOnly:Boolean = false):Object;

  /**
   * Return all the →<code>ext.form.field.Field</code> components in the owner container.
   * @return Collection of the Field objects
   * @see ext.form.field.Field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-getFields Original Ext JS documentation of 'getFields'
   */
  public native function getFields():MixedCollection;

  /**
   * Returns the last Ext.data.Model instance that was loaded via →<code>loadRecord()</code>
   * @return The record
   * @see #loadRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-getRecord Original Ext JS documentation of 'getRecord'
   */
  public native function getRecord():Model;

  /**
   * Retrieves the fields in the form as a set of key/value pairs, using their
   * →<code>ext.form.field.Field.getSubmitData()</code> method to collect the values.
   * If multiple fields return values under the same name those values will be combined
   * into an Array. This is similar to →<code>ext.form.BasicForm.getFieldValues()</code>
   * except that this method collects only String values for submission, while getFieldValues
   * collects type-specific data values (e.g. Date objects for date fields.)
   * @param asString If true, will return the key/value collection as a single
   * URL-encoded param string.
   * @default false
   * @param dirtyOnly If true, only fields that are dirty will be included
   * in the result.
   * @default false
   * @param includeEmptyText If true, the configured emptyText of empty fields
   * will be used.
   * @default false
   * @param useDataValues If true, the
   * →<code>ext.form.field.Field.getModelData()</code>
   * method is used to retrieve values from fields, otherwise the
   * →<code>ext.form.field.Field.getSubmitData()</code> method is used.
   * @default false
   * @see ext.form.field.Field#getSubmitData()
   * @see ext.form.BasicForm#getFieldValues()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-getValues Original Ext JS documentation of 'getValues'
   * @see ext.form.field.Field#getModelData()
   */
  public native function getValues(asString:Boolean = false, dirtyOnly:Boolean = false, includeEmptyText:Boolean = false, useDataValues:Boolean = false, isSubmitting:Boolean = false):*;

  /**
   * Returns true if the form contains any invalid fields. No fields will be marked as invalid
   * as a result of calling this; to trigger marking of fields use →<code>isValid()</code> instead.
   * @see #isValid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-hasInvalidField Original Ext JS documentation of 'hasInvalidField'
   */
  public native function hasInvalidField():void;

  /**
   * Returns <code>true</code> if the form contains a file upload field. This is used to determine the method
   * for submitting the form: File uploads are not performed using normal 'Ajax' techniques,
   * that is they are <b>not</b> performed using XMLHttpRequests. Instead a hidden <code>&lt;form&gt;</code> element
   * containing all the fields is created temporarily and submitted with its <a href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">target</a>
   * set to refer to a dynamically generated, hidden <code>&lt;iframe&gt;</code> which is inserted
   * into the document but removed after the return data has been gathered.
   * <p>The server response is parsed by the browser to create the document for the IFRAME.
   * If the server is using JSON to send the return object, then the <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a> header
   * should be set to "text/plain" in order to tell the browser to insert the text unchanged
   * into a '&lt;pre>' element in the document body from which it can be retrieved.</p>
   * <p>If the <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a> header is sent as the default, "text/html", then characters
   * which are significant to an HTML parser must be sent as HTML entities, so encode
   * <code>"&lt;"</code> as <code>"&amp;lt;"</code>, <code>"&amp;"</code> as <code>"&amp;amp;"</code> etc.</p>
   * <p>The response text is retrieved from the document, and a fake XMLHttpRequest object is created
   * containing a responseText property in order to conform to the requirements of event handlers
   * and callbacks.</p>
   * <p>Be aware that file upload packets are sent with the content type <a href="http://www.faqs.org/rfcs/rfc2388.html">multipart/form</a>
   * and some server technologies (notably JEE) may require some custom processing in order to
   * retrieve parameter names and parameter values from the packet content.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-hasUpload Original Ext JS documentation of 'hasUpload'
   */
  public native function hasUpload():Boolean;

  /**
   * Returns <code>true</code> if any fields in this form have changed from their original values.
   * <p>Note that if this BasicForm was configured with →<code>ext.form.BasicForm.trackResetOnLoad</code> then the Fields' <i>original values</i> are updated when the values are
   * loaded by →<code>ext.form.BasicForm.setValues()</code> or →<code>loadRecord()</code>. This means
   * that:</p>
   * <ul>
   * <li>→<code>trackResetOnLoad</code>: <code>false</code> -&gt; Will return <code>true</code> after calling this method.</li>
   * <li>→<code>trackResetOnLoad</code>: <code>true</code> -&gt; Will return <code>false</code> after calling this method.</li>
   * </ul>
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see ext.form.BasicForm#setValues()
   * @see #loadRecord()
   * @see #trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-isDirty Original Ext JS documentation of 'isDirty'
   */
  public native function isDirty():Boolean;

  /**
   * Returns true if client-side validation on the form is successful. Any invalid fields will be
   * marked as invalid. If you only want to determine overall form validity without marking
   * anything, use →<code>hasInvalidField()</code> instead.
   * @see #hasInvalidField()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-isValid Original Ext JS documentation of 'isValid'
   */
  public native function isValid():Boolean;

  /**
   * Shortcut to <i>do</i> (→<code>doAction()</code>) a <i>load action</i> (→<code>ext.form.action.LoadAction</code>).
   * @param options The options to pass to the action (see →<code>doAction()</code>
   * for details)
   * @return this
   * @see #doAction()
   * @see ext.form.action.LoadAction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-load Original Ext JS documentation of 'load'
   */
  public native function load(options:Object):BasicForm;

  /**
   * Loads an →<code>ext.data.Model</code> into this form by calling →<code>setValues()</code> with the
   * <i>record data</i> (→<code>ext.data.Model.getData()</code>). The fields in the model are mapped to
   * fields in the form by matching either the →<code>ext.form.field.BaseField.name</code> or
   * →<code>ext.Component.itemId</code>. See also →<code>trackResetOnLoad</code>.
   * @param record The record to load
   * @return this
   * @see ext.data.Model
   * @see #setValues()
   * @see ext.data.Model#getData()
   * @see ext.form.field.BaseField#name
   * @see ext.Component#itemId
   * @see #trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-loadRecord Original Ext JS documentation of 'loadRecord'
   */
  public native function loadRecord(record:Model):BasicForm;

  /**
   * This method allows you to mark one or more fields in a form as invalid along with
   * one or more invalid messages per field.
   * <pre>
   * var formPanel = Ext.create('Ext.form.Panel', {
   *     title: 'Contact Info',
   *     width: 300,
   *     bodyPadding: 10,
   *     renderTo: Ext.getBody(),
   *     items: [{
   *         xtype: 'textfield',
   *         name: 'name',
   *         id: 'nameId',
   *         fieldLabel: 'Name'
   *     }, {
   *         xtype: 'textfield',
   *         name: 'email',
   *         id: 'emailId',
   *         fieldLabel: 'Email Address'
   *     }],
   *     bbar: [{
   *         text: 'Mark both fields invalid',
   *         handler: function() {
   *             formPanel.getForm().markInvalid([{
   *                 field: 'name',
   *                 message: 'Name invalid message'
   *             }, {
   *                 field: 'email',
   *                 message: ['First invalid message', 'Second message']
   *             }]);
   *         }
   *     }]
   * });
   * </pre>
   * <p><b>Note</b>: this method does not cause the Field's
   * →<code>ext.form.field.Field.validate()</code> or →<code>ext.form.field.BaseField.isValid()</code>
   * methods to return <code>false</code> if the value does <i>pass</i> validation. So simply marking
   * a Field as invalid will not prevent submission of forms submitted with the
   * →<code>ext.form.action.SubmitAction.clientValidation</code> option set.</p>
   * <p>For additional information on how the fields are marked invalid see field's
   * →<code>ext.form.field.BaseField.markInvalid()</code> method.</p>
   * @param errors The errors param may be in one of two forms: Object[] or Object
   * <ul>
   * <li><b>Array:</b> An array of Objects with the following keys:
   * <ul>
   * <li><i>field</i> (→<code>String</code>): The →<code>ext.form.field.BaseField.name</code> or
   * →<code>ext.form.field.BaseField.id</code> of the form field to receive the error message</li>
   * <li><i>message</i> (→<code>String</code>/→<code>String</code>[]): The error message or an array
   * of messages</li>
   * </ul>
   * </li>
   * </ul>
   * <p>Example Array syntax:</p>
   * <pre>
   * form.markInvalid([{
   *     field: 'email', // the field name
   *     message: 'Error message'
   * }]);
   * </pre>
   * <ul>
   * <li><b>Object:</b> An Object hash with key/value pairs where the key is the field name
   * or field ID and the value is the message or array of messages to display.</li>
   * </ul>
   * <p>Example Object syntax:</p>
   * <pre>
   * form.markInvalid({
   *     name: 'Err. message',
   *     emailId: ['Error1', 'Error 2']
   * });
   * </pre>
   * @return basicForm The Ext.form.Basic instance
   * @see ext.form.field.Field#validate()
   * @see ext.form.field.BaseField#isValid()
   * @see ext.form.action.SubmitAction#clientValidation
   * @see ext.form.field.BaseField#markInvalid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-markInvalid Original Ext JS documentation of 'markInvalid'
   * @see String
   * @see ext.form.field.BaseField#name
   * @see ext.form.field.BaseField#id
   */
  public native function markInvalid(errors:*):BasicForm;

  /**
   * Resets all fields in this form. By default, any record bound by →<code>loadRecord()</code>
   * will be retained.
   * @param resetRecord True to unbind any record set
   * by →<code>loadRecord()</code>
   * @default false
   * @return this
   * @see #loadRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-reset Original Ext JS documentation of 'reset'
   */
  public native function reset(resetRecord:Boolean = false):BasicForm;

  /**
   * Set values for fields in this form in bulk.
   * @param values Either an array in the form:
   * <pre>
   * [{id:'clientName', value:'Fred. Olsen Lines'},
   *  {id:'portOfLoading', value:'FXT'},
   *  {id:'portOfDischarge', value:'OSL'} ]
   * </pre>
   * <p>or an object hash of the form:</p>
   * <pre>
   * {
   *     clientName: 'Fred. Olsen Lines',
   *     portOfLoading: 'FXT',
   *     portOfDischarge: 'OSL'
   * }
   * </pre>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-setValues Original Ext JS documentation of 'setValues'
   */
  public native function setValues(values:*):BasicForm;

  /**
   * Shortcut to <i>do</i> (→<code>doAction()</code>) a <i>submit action</i> (→<code>ext.form.action.SubmitAction</code>). This will
   * use the <i>AJAX submit action</i> (→<code>ext.form.action.SubmitAction</code>) by default. If the
   * →<code>standardSubmit</code> config is enabled it will use a standard form element to submit,
   * or if the →<code>api</code> config is present it will use the
   * <i>Ext.direct.Direct submit action</i> (→<code>ext.form.action.DirectLoadAction</code>).
   * <p>The following code:</p>
   * <pre>
   * myFormPanel.getForm().submit({
   *     clientValidation: true,
   *     url: 'updateConsignment.php',
   *     params: {
   *         newStatus: 'delivered'
   *     },
   *     success: function(form, action) {
   *        Ext.Msg.alert('Success', action.result.msg);
   *     },
   *     failure: function(form, action) {
   *         switch (action.failureType) {
   *             case Ext.form.action.Action.CLIENT_INVALID:
   *                 Ext.Msg.alert(
   *                     'Failure',
   *                     'Form fields may not be submitted with invalid values'
   *                 );
   *                 break;
   *             case Ext.form.action.Action.CONNECT_FAILURE:
   *                 Ext.Msg.alert('Failure', 'Ajax communication failed');
   *                 break;
   *             case Ext.form.action.Action.SERVER_INVALID:
   *                Ext.Msg.alert('Failure', action.result.msg);
   *        }
   *     }
   * });
   * </pre>
   * <p>would process the following server response for a successful submission:</p>
   * <pre>
   * {
   *     "success":true, // note this is Boolean, not string
   *     "msg":"Consignment updated"
   * }
   * </pre>
   * <p>and the following server response for a failed submission:</p>
   * <pre>
   * {
   *     "success":false, // note this is Boolean, not string
   *     "msg":"You do not have permission to perform this operation"
   * }
   * </pre>
   * @param options The options to pass to the action (see →<code>doAction()</code>
   * for details).
   * @return this
   * @see #doAction()
   * @see ext.form.action.SubmitAction
   * @see #standardSubmit
   * @see #api
   * @see ext.form.action.DirectLoadAction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-submit Original Ext JS documentation of 'submit'
   */
  public native function submit(options:Object):BasicForm;

  /**
   * Persists the values in this form into the passed →<code>ext.data.Model</code> object
   * in a beginEdit/endEdit block. If the record is not specified, it will attempt to update
   * (if it exists) the record provided to loadRecord.
   * @param record The record to edit
   * @return this
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Basic.html#method-updateRecord Original Ext JS documentation of 'updateRecord'
   */
  public native function updateRecord(record:Model = null):BasicForm;
}
}