package ext.form {
import ext.Component;
import ext.form.field.IField;

import js.HTMLElement;

[Native("Ext.form.CheckboxGroup", require)]
/**
 * @see ext.form.events.CheckboxGroup_newValue_oldValueEvent.CHANGE
 * @eventType ext.form.events.CheckboxGroup_newValue_oldValueEvent.CHANGE
 */
[Event(name='onChange', type='ext.form.events.CheckboxGroup_newValue_oldValueEvent')]
/**
 * @see ext.form.events.CheckboxGroup_isDirtyEvent.DIRTY_CHANGE
 * @eventType ext.form.events.CheckboxGroup_isDirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.form.events.CheckboxGroup_isDirtyEvent')]
/**
 * @see ext.form.events.CheckboxGroup_isValidEvent.VALIDITY_CHANGE
 * @eventType ext.form.events.CheckboxGroup_isValidEvent.VALIDITY_CHANGE
 */
[Event(name='onValidityChange', type='ext.form.events.CheckboxGroup_isValidEvent')]
/**
 * A <i>field container</i> (→<code>ext.form.FieldContainer</code>) which has a specialized layout for arranging
 * →<code>ext.form.field.Checkbox</code> controls into columns, and provides convenience
 * →<code>ext.form.field.Field</code> methods for <i>getting</i> (→<code>getValue()</code>), <i>setting</i> (→<code>setValue()</code>),
 * and <i>validating</i> (→<code>validate()</code>) the group of checkboxes as a whole.
 * <p><b>Validation</b></p>
 * <p>Individual checkbox fields themselves have no default validation behavior, but
 * sometimes you want to require a user to select at least one of a group of checkboxes.
 * CheckboxGroup allows this by setting the config <code>→allowBlank:false</code>; when the user
 * does not check at least one of the checkboxes, the entire group will be highlighted as invalid
 * and the <i>error message</i> (→<code>blankText</code>) will be displayed according to the →<code>msgTarget</code>
 * config.</p>
 * <p><b>Layout</b></p>
 * <p>The default layout for CheckboxGroup makes it easy to arrange the checkboxes into
 * columns; see the →<code>columns</code> and →<code>vertical</code> config documentation for details.
 * You may also use a completely different layout by setting the →<code>layout</code> to one of the
 * other supported layout types; for instance you may wish to use a custom arrangement
 * of hbox and vbox containers. In that case the checkbox components at any depth will
 * still be managed by the CheckboxGroup's validation.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Checkbox Group',
 *     width: 300,
 *     height: 125,
 *     bodyPadding: 10,
 *     renderTo: Ext.getBody(),
 *     items:[{
 *         xtype: 'checkboxgroup',
 *         fieldLabel: 'Two Columns',
 *         // Arrange checkboxes into two columns, distributed vertically
 *         columns: 2,
 *         vertical: true,
 *         items: [
 *             { boxLabel: 'Item 1', name: 'rb', inputValue: '1' },
 *             { boxLabel: 'Item 2', name: 'rb', inputValue: '2', checked: true },
 *             { boxLabel: 'Item 3', name: 'rb', inputValue: '3' },
 *             { boxLabel: 'Item 4', name: 'rb', inputValue: '4' },
 *             { boxLabel: 'Item 5', name: 'rb', inputValue: '5' },
 *             { boxLabel: 'Item 6', name: 'rb', inputValue: '6' }
 *         ]
 *     }]
 * });
 * </pre>
 * @see ext.form.FieldContainer
 * @see ext.form.field.Checkbox
 * @see ext.form.field.Field
 * @see #getValue()
 * @see #setValue()
 * @see #validate()
 * @see #allowBlank
 * @see #blankText
 * @see #msgTarget
 * @see #columns
 * @see #vertical
 * @see #layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html Original Ext JS documentation of 'Ext.form.CheckboxGroup'
 */
public class CheckboxGroup extends FieldContainer implements IField {
  /**
   * @param config @inheritDoc
   */
  public function CheckboxGroup(config:CheckboxGroup = null) {
    super();
  }

  [ExtConfig]
  /**
   * False to validate that at least one item in the group is checked. If no items are selected at
   * validation time, →<code>blankText</code> will be used as the error text.
   * @default true
   * @see #blankText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#cfg-allowBlank Original Ext JS documentation of 'allowBlank'
   */
  public native function get allowBlank():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowBlank(value:Boolean):void;

  [ExtConfig]
  /**
   * Error text to display if the →<code>allowBlank</code> validation fails
   * @default "You must select at least one item in this group"
   * @see #allowBlank
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#cfg-blankText Original Ext JS documentation of 'blankText'
   */
  public native function get blankText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set blankText(value:String):void;

  [ExtConfig]
  /**
   * Specifies the number of columns to use when displaying grouped checkbox/radio controls using
   * automatic layout. This config can take several types of values:
   * <ul>
   * <li>'auto' - The controls will be rendered one per column on one row and the width of each
   * column will be evenly distributed based on the width of the overall field container.
   * This is the default.</li>
   * <li>Number - If you specific a number (e.g., 3) that number of columns will be created
   * and the contained controls will be automatically distributed based on the value
   * of →<code>vertical</code>.</li>
   * <li>Array - You can also specify an array of column widths, mixing integer (fixed width)
   * and float (percentage width) values as needed (e.g., [100, .25, .75]). Any integer values
   * will be rendered first, then any float values will be calculated as a percentage
   * of the remaining space. Float values do not have to add up to 1 (100%)
   * although if you want the controls to take up the entire field container you should do so.</li>
   * </ul>
   * @default 'auto'
   * @see #vertical
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#cfg-columns Original Ext JS documentation of 'columns'
   */
  public native function get columns():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columns(value:*):void;

  [ExtConfig]
  /**
   * True to disable the field. Disabled Fields will not be
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>).
   * @default false
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  override public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set disabled(value:Boolean):void;

  /**
   * The value <code>true</code> to identify an object as an instance of this or derived class.
   * @default true
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#property-isCheckboxGroup Original Ext JS documentation of 'isCheckboxGroup'
   */
  public native function get isCheckboxGroup():Boolean;

  /**
   * @inheritDoc
   */
  public native function get isFormField():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isFormField(value:Boolean):void;

  [ExtConfig]
  /**
   * An Array of →<code>ext.form.field.Checkbox</code>es or Checkbox config objects to arrange
   * in the group.
   * @see ext.form.field.Checkbox
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#cfg-items Original Ext JS documentation of 'items'
   */
  override public native function get items():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set items(value:Array):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The name of the field. By default this is used as the parameter name when including the
   * <i>field value</i> (→<code>getSubmitData()</code>) in a <i>form submit()</i> (→<code>ext.form.BasicForm.submit()</code>).
   * To prevent the field from being included in the form submit, set →<code>submitValue</code>
   * to false.
   * @see #getSubmitData()
   * @see ext.form.BasicForm#submit()
   * @see #submitValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-name Original Ext JS documentation of 'name'
   * @see #getName()
   */
  public native function get name():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get originalValue():*;

  /**
   * @inheritDoc
   */
  public native function set originalValue(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default 'value'
   * @see #reference
   * @see #publishState
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Setting this to false will prevent the field from being
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>) even when it is not disabled.
   * @default true
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-submitValue Original Ext JS documentation of 'submitValue'
   */
  public native function get submitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitValue(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether this field should be validated immediately whenever a change in its value
   * is detected. If the validation results in a change in the field's validity, a
   * →<code>event:onValidityChange</code> event will be fired. This allows the field to show feedback
   * about the validity of its contents immediately as the user is typing.
   * <p>When set to false, feedback will not be immediate. However the form will still be validated
   * before submitting if the clientValidation option to →<code>ext.form.BasicForm.doAction()</code>
   * is enabled, or if the field or form are validated manually.</p>
   * <p>See also →<code>ext.form.field.BaseField.checkChangeEvents</code> for controlling how changes
   * to the field's value are detected.</p>
   * @default true
   * @see #event:onValidityChange
   * @see ext.form.BasicForm#doAction()
   * @see ext.form.field.BaseField#checkChangeEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validateOnChange Original Ext JS documentation of 'validateOnChange'
   */
  public native function get validateOnChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set validateOnChange(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This property, when a <code>→String</code>, contributes its value to the error state of this
   * instance as reported by <code>→getErrors()</code>.
   * @default null
   * @see String
   * @see #getErrors()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validation Original Ext JS documentation of 'validation'
   * @see #getValidation()
   * @see #setValidation()
   */
  public native function get validation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set validation(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A value to initialize this field with.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set value(value:Object):void;

  [ExtConfig]
  /**
   * The event name(s) to use to publish the →<code>value</code>
   * →<code>ext.form.field.BaseField.bind</code> for this field.
   * @default 'change'
   * @since 5.0.1
   * @see #value
   * @see ext.form.field.BaseField#bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-valuePublishEvent Original Ext JS documentation of 'valuePublishEvent'
   */
  public native function get valuePublishEvent():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valuePublishEvent(value:*):void;

  [ExtConfig]
  /**
   * True to distribute contained controls across columns, completely filling each column top
   * to bottom before starting on the next column. The number of controls in each column will be
   * automatically calculated to keep columns as even as possible. The default value is false,
   * so that controls will be added to columns one at a time, completely filling each row
   * left to right before starting on the next row.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#cfg-vertical Original Ext JS documentation of 'vertical'
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function batchChanges(fn:Function):void;

  /**
   * Template method before a field is reset.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-beforeReset Original Ext JS documentation of 'beforeReset'
   */
  protected native function beforeReset():void;

  /**
   * @inheritDoc
   */
  public native function checkChange():void;

  /**
   * @inheritDoc
   */
  public native function checkDirty():void;

  /**
   * @inheritDoc
   */
  public native function cleanupField():void;

  /**
   * @inheritDoc
   */
  public native function clearInvalid():void;

  /**
   * @inheritDoc
   */
  public native function extractFileInput():HTMLElement;

  [ArrayElementType("ext.form.field.Checkbox")]
  /**
   * Returns an Array of all checkboxes in the container which are currently checked
   * @return Array of Ext.form.field.Checkbox components
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-getChecked Original Ext JS documentation of 'getChecked'
   */
  public native function getChecked():Array;

  [ArrayElementType("String")]
  /**
   * Runs CheckboxGroup's validations and returns an array of any errors. The only error
   * by default is if allowBlank is set to false and no items are checked.
   * @param value The value to get errors for (defaults to the current field value)
   * @return Array of all validation errors
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-getErrors Original Ext JS documentation of 'getErrors'
   */
  public native function getErrors(value:*):Array;

  /**
   * @inheritDoc
   */
  public native function getModelData(includeEmptyText:Boolean):Object;

  /**
   * @inheritDoc
   */
  public native function getName():String;

  /**
   * @inheritDoc
   */
  public native function getSubmitData():Object;

  /**
   * Returns the value of <code>validation</code>.
   * @see #validation
   */
  public native function getValidation():*;

  /**
   * Returns an object containing the values of all checked checkboxes within the group.
   * Each key-value pair in the object corresponds to a checkbox
   * →<code>ext.form.field.Checkbox.name</code>. If there is only one checked checkbox
   * with a particular name, the value of that pair will be the String
   * →<code>ext.form.field.Checkbox.inputValue</code> of that checkbox. If there are
   * multiple checked checkboxes with that name, the value of that pair will be an Array
   * of the selected inputValues.
   * <p>The object format returned from this method can also be passed directly to the
   * →<code>setValue()</code> method.</p>
   * <p>NOTE: In Ext 3, this method returned an array of Checkbox components; this was changed
   * to make it more consistent with other field components and with the →<code>setValue()</code>
   * argument signature. If you need the old behavior in Ext 4+, use the →<code>getChecked()</code>
   * method instead.</p>
   * @see ext.form.field.Checkbox#name
   * @see ext.form.field.Checkbox#inputValue
   * @see #setValue()
   * @see #getChecked()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():*;

  /**
   * @inheritDoc
   */
  public native function initField():void;

  /**
   * Initializes the field's value based on the initial config. If the →<code>value</code> config
   * is specified then we use that to set the value; otherwise we initialize the originalValue
   * by querying the values of all sub-checkboxes after they have been initialized.
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-initValue Original Ext JS documentation of 'initValue'
   */
  public native function initValue():void;

  /**
   * @inheritDoc
   */
  public native function isDirty():Boolean;

  /**
   * @inheritDoc
   */
  public native function isEqual(value1:Object, value2:Object):Boolean;

  /**
   * @inheritDoc
   */
  public native function isFileUpload():Boolean;

  /**
   * @inheritDoc
   */
  public native function isValid():Boolean;

  /**
   * @inheritDoc
   */
  public native function markInvalid(errors:*):void;

  /**
   * When a checkbox is added to the group, monitor it for changes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-onAdd Original Ext JS documentation of 'onAdd'
   */
  override protected native function onAdd(component:Component, position:Number):void;

  /**
   * Resets the checked state of all <i>checkboxes</i> (→<code>ext.form.field.Checkbox</code>) in the group
   * to their originally loaded values and clears any validation messages.
   * See →<code>ext.form.BasicForm</code>.→<code>ext.form.BasicForm.trackResetOnLoad</code>
   * @see ext.form.field.Checkbox
   * @see ext.form.BasicForm
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-reset Original Ext JS documentation of 'reset'
   */
  public native function reset():void;

  /**
   * @inheritDoc
   */
  public native function resetOriginalValue():void;

  /**
   * Sets the value of <code>validation</code>.
   * @param validation The new value.
   * @see #validation
   */
  public native function setValidation(validation:*):void;

  /**
   * Sets the value(s) of all checkboxes in the group. The expected format is an Object
   * of name-value pairs corresponding to the names of the checkboxes in the group. Each pair
   * can have either a single or multiple values:
   * <ul>
   * <li>A single Boolean or String value will be passed to the <code>→setValue()</code> method of the checkbox
   * with that name. See the rules in →<code>ext.form.field.Checkbox.setValue()</code>
   * for accepted values.</li>
   * <li>An Array of String values will be matched against the
   * →<code>ext.form.field.Checkbox.inputValue</code> of checkboxes in the group
   * with that name; those checkboxes whose inputValue exists in the array will be
   * checked and others will be unchecked.</li>
   * </ul>
   * <p>If a checkbox's name is not in the mapping at all, it will be unchecked.</p>
   * <p>An example:</p>
   * <pre>
   * var myCheckboxGroup = new Ext.form.CheckboxGroup({
   *     columns: 3,
   *     items: [{
   *         name: 'cb1',
   *         boxLabel: 'Single 1'
   *     }, {
   *         name: 'cb2',
   *         boxLabel: 'Single 2'
   *     }, {
   *         name: 'cb3',
   *         boxLabel: 'Single 3'
   *     }, {
   *         name: 'cbGroup',
   *         boxLabel: 'Grouped 1'
   *         inputValue: 'value1'
   *     }, {
   *         name: 'cbGroup',
   *         boxLabel: 'Grouped 2'
   *         inputValue: 'value2'
   *     }, {
   *         name: 'cbGroup',
   *         boxLabel: 'Grouped 3'
   *         inputValue: 'value3'
   *     }]
   * });
   *
   * myCheckboxGroup.setValue({
   *     cb1: true,
   *     cb3: false,
   *     cbGroup: ['value1', 'value3']
   * });
   * </pre>
   * <p>The above code will cause the checkbox named 'cb1' to be checked, as well as the first
   * and third checkboxes named 'cbGroup'. The other three checkboxes will be unchecked.</p>
   * @param value The value to set
   * @return this
   * @see #setValue()
   * @see ext.form.field.Checkbox#setValue()
   * @see ext.form.field.Checkbox#inputValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.CheckboxGroup.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  public native function setValue(value:*):IField;

  /**
   * @inheritDoc
   */
  public native function validate():Boolean;
}
}