package ext.form {
import ext.Mixin;
import ext.form.field.Field;

[Native("Ext.form.FieldAncestor", require)]
[ExtConfig]
/**
 * @see ext.form.events.FieldAncestor_field_errorEvent.FIELD_ERROR_CHANGE
 * @eventType ext.form.events.FieldAncestor_field_errorEvent.FIELD_ERROR_CHANGE
 */
[Event(name='onFieldErrorChange', type='ext.form.events.FieldAncestor_field_errorEvent')]
/**
 * @see ext.form.events.FieldAncestor_field_isValidEvent.FIELD_VALIDITY_CHANGE
 * @eventType ext.form.events.FieldAncestor_field_isValidEvent.FIELD_VALIDITY_CHANGE
 */
[Event(name='onFieldValidityChange', type='ext.form.events.FieldAncestor_field_isValidEvent')]
/**
 * A mixin for →<code>ext.container.Container</code> components that are likely to have form fields
 * in their items subtree. Adds the following capabilities:
 * <ul>
 * <li>Methods for handling the addition and removal of →<code>ext.form.Labelable</code> and
 * →<code>ext.form.field.Field</code> instances at any depth within the container.</li>
 * <li>Events (→<code>event:onFieldValidityChange</code> and →<code>event:onFieldErrorChange</code>) for handling changes
 * to the state of individual fields at the container level.</li>
 * <li>Automatic application of →<code>fieldDefaults</code> config properties to each field added
 * within the container, to facilitate uniform configuration of all fields.</li>
 * </ul>
 * <p>This mixin is primarily for internal use by →<code>ext.form.FormPanel</code> and
 * →<code>ext.form.FieldContainer</code>, and should not normally need to be used directly.</p>
 * @see ext.container.Container
 * @see ext.form.Labelable
 * @see ext.form.field.Field
 * @see #event:onFieldValidityChange
 * @see #event:onFieldErrorChange
 * @see #fieldDefaults
 * @see ext.form.FormPanel
 * @see ext.form.FieldContainer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html Original Ext JS documentation of 'Ext.form.FieldAncestor'
 */
public class FieldAncestor extends Mixin implements IFieldAncestor {
  /**
   * @param config @inheritDoc
   */
  public function FieldAncestor(config:FieldAncestor = null) {
    super();
  }

  [ExtConfig]
  /**
   * If specified, the properties in this object are used as default config values for each
   * →<code>ext.form.Labelable</code> instance (e.g. →<code>ext.form.field.BaseField</code> or
   * →<code>ext.form.FieldContainer</code>) that is added as a descendant of this container.
   * Corresponding values specified in an individual field's own configuration, or from the
   * <i>defaults config</i> (→<code>ext.container.Container.defaults</code>) of its parent container,
   * will take precedence. See the documentation for →<code>ext.form.Labelable</code> to see
   * what config options may be specified in the fieldDefaults.
   * <p>Example:</p>
   * <pre>
   * new Ext.form.Panel({
   *     fieldDefaults: {
   *         labelAlign: 'left',
   *         labelWidth: 100
   *     },
   *     items: [{
   *         xtype: 'fieldset',
   *         defaults: {
   *             labelAlign: 'top'
   *         },
   *         items: [{
   *             name: 'field1'
   *         }, {
   *             name: 'field2'
   *         }]
   *     }, {
   *         xtype: 'fieldset',
   *         items: [{
   *             name: 'field3',
   *             labelWidth: 150
   *         }, {
   *             name: 'field4'
   *         }]
   *     }]
   * });
   * </pre>
   * <p>In this example, field1 and field2 will get labelAlign: 'top' (from the fieldset's defaults)
   * and labelWidth: 100 (from fieldDefaults), field3 and field4 will both get labelAlign: 'left'
   * (from fieldDefaults and field3 will use the labelWidth: 150 from its own config.</p>
   * @see ext.form.Labelable
   * @see ext.form.field.BaseField
   * @see ext.form.FieldContainer
   * @see ext.container.Container#defaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#cfg-fieldDefaults Original Ext JS documentation of 'fieldDefaults'
   */
  public native function get fieldDefaults():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldDefaults(value:Object):void;

  /**
   * Initializes the FieldAncestor's state; this must be called from the initComponent method
   * of any components importing this mixin.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-initFieldAncestor Original Ext JS documentation of 'initFieldAncestor'
   */
  protected native function initFieldAncestor():void;

  /**
   * Fired when the error message of any field within the container changes.
   * @param field The sub-field whose active error changed
   * @param error The new active error message
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldErrorChange Original Ext JS documentation of 'onFieldErrorChange'
   */
  protected native function onFieldErrorChange(field:Labelable, error:String):void;

  /**
   * Fired when the validity of any field within the container changes.
   * @param field The sub-field whose validity changed
   * @param valid The new validity state
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldValidityChange Original Ext JS documentation of 'onFieldValidityChange'
   */
  protected native function onFieldValidityChange(field:Field, valid:Boolean):void;
}
}