package ext.form {
import ext.container.Container;
import ext.dom.Element;
import ext.form.field.Field;

[Native("Ext.form.FieldContainer", require)]
/**
 * @see ext.form.events.FieldContainer_errorEvent.ERROR_CHANGE
 * @eventType ext.form.events.FieldContainer_errorEvent.ERROR_CHANGE
 */
[Event(name='onErrorChange', type='ext.form.events.FieldContainer_errorEvent')]
/**
 * @see ext.form.events.FieldContainer_field_errorEvent.FIELD_ERROR_CHANGE
 * @eventType ext.form.events.FieldContainer_field_errorEvent.FIELD_ERROR_CHANGE
 */
[Event(name='onFieldErrorChange', type='ext.form.events.FieldContainer_field_errorEvent')]
/**
 * @see ext.form.events.FieldContainer_field_isValidEvent.FIELD_VALIDITY_CHANGE
 * @eventType ext.form.events.FieldContainer_field_isValidEvent.FIELD_VALIDITY_CHANGE
 */
[Event(name='onFieldValidityChange', type='ext.form.events.FieldContainer_field_isValidEvent')]
/**
 * FieldContainer is a derivation of →<code>ext.container.Container</code> that implements the
 * →<code>ext.form.Labelable</code> mixin. This allows it to be configured so that it is
 * rendered with a <i>field label</i> (→<code>fieldLabel</code>) and optional <i>error message</i> (→<code>msgTarget</code>)
 * around its sub-items. This is useful for arranging a group of fields within a single item
 * in a form, so that it lines up nicely with other fields. A common use is for grouping a set
 * of related fields under a single label in a form.
 * <p>The container's configured →<code>items</code> will be layed out within the field body area
 * according to the configured →<code>layout</code> type. The default layout is <code>'autocontainer'</code>.</p>
 * <p>Like regular fields, FieldContainer can inherit its decoration configuration from the
 * →<code>ext.form.FormPanel.fieldDefaults</code> of an enclosing FormPanel. In addition,
 * FieldContainer itself can pass →<code>fieldDefaults</code> to any <i>fields</i> (→<code>ext.form.Labelable</code>)
 * it may itself contain.</p>
 * <p>If you are grouping a set of →<code>ext.form.field.Checkbox</code> or
 * →<code>ext.form.field.Radio</code> fields in a single labeled container, consider using
 * a →<code>ext.form.CheckboxGroup</code> or →<code>ext.form.RadioGroup</code> instead as they are specialized
 * for handling those types.</p>
 * <p><b>Example</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'FieldContainer Example',
 *     width: 550,
 *     bodyPadding: 10,
 *
 *     items: [{
 *         xtype: 'fieldcontainer',
 *         fieldLabel: 'Last Three Jobs',
 *         labelWidth: 100,
 *
 *         // The body area will contain three text fields, arranged
 *         // horizontally, separated by draggable splitters.
 *         layout: 'hbox',
 *         items: [{
 *             xtype: 'textfield',
 *             flex: 1
 *         }, {
 *             xtype: 'splitter'
 *         }, {
 *             xtype: 'textfield',
 *             flex: 1
 *         }, {
 *             xtype: 'splitter'
 *         }, {
 *             xtype: 'textfield',
 *             flex: 1
 *         }]
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p><b>Usage of fieldDefaults</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'FieldContainer Example',
 *     width: 350,
 *     bodyPadding: 10,
 *
 *     items: [{
 *         xtype: 'fieldcontainer',
 *         fieldLabel: 'Your Name',
 *         labelWidth: 75,
 *         defaultType: 'textfield',
 *
 *         // Arrange fields vertically, stretched to full width
 *         layout: 'anchor',
 *         defaults: {
 *             layout: '100%'
 *         },
 *
 *         // These config values will be applied to both sub-fields, except
 *         // for Last Name which will use its own msgTarget.
 *         fieldDefaults: {
 *             msgTarget: 'under',
 *             labelAlign: 'top'
 *         },
 *
 *         items: [{
 *             fieldLabel: 'First Name',
 *             name: 'firstName'
 *         }, {
 *             fieldLabel: 'Last Name',
 *             name: 'lastName',
 *             msgTarget: 'under'
 *         }]
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.container.Container
 * @see ext.form.Labelable
 * @see #fieldLabel
 * @see #msgTarget
 * @see #items
 * @see #layout
 * @see ext.form.FormPanel#fieldDefaults
 * @see #fieldDefaults
 * @see ext.form.field.Checkbox
 * @see ext.form.field.Radio
 * @see ext.form.CheckboxGroup
 * @see ext.form.RadioGroup
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldContainer.html Original Ext JS documentation of 'Ext.form.FieldContainer'
 */
public class FieldContainer extends Container implements ILabelable, IFieldAncestor {
  /**
   * @param config @inheritDoc
   */
  public function FieldContainer(config:FieldContainer = null) {
    super();
  }

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * If specified, then the component will be displayed with this value as its active error
   * when first rendered. Use →<code>setActiveError()</code> or →<code>unsetActiveError()</code> to change it
   * after component creation.
   * @see #setActiveError()
   * @see #unsetActiveError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-activeError Original Ext JS documentation of 'activeError'
   * @see #getActiveError()
   */
  public native function get activeError():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set activeError(value:String):void;

  [ExtConfig]
  /**
   * The template used to format the Array of error messages passed to →<code>setActiveErrors()</code>
   * into a single HTML string. if the →<code>msgTarget</code> is title, it defaults to a list
   * separated by new lines. Otherwise, it renders each message as an item in an unordered list.
   * @see #setActiveErrors()
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-activeErrorsTpl Original Ext JS documentation of 'activeErrorsTpl'
   */
  public native function get activeErrorsTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeErrorsTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * at the end of the input containing element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterBodyEl Original Ext JS documentation of 'afterBodyEl'
   */
  public native function get afterBodyEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterBodyEl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the label text. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterLabelTextTpl Original Ext JS documentation of 'afterLabelTextTpl'
   */
  public native function get afterLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the label element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterLabelTpl Original Ext JS documentation of 'afterLabelTpl'
   */
  public native function get afterLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the <i>subTpl markup</i> (→<code>getSubTplMarkup()</code>). If an <code>XTemplate</code> is used, the
   * component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see #getSubTplMarkup()
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterSubTpl Original Ext JS documentation of 'afterSubTpl'
   */
  public native function get afterSubTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterSubTpl(value:*):void;

  [ExtConfig]
  /**
   * Localized announcement text for validation errors. This text
   * will be used by Assistive Technologies such as screen readers to alert the users when
   * field validation fails.
   * <p>This config is used with →<code>ext.StringUtil.format()</code>. '{0}' will be replaced with the actual
   * error message(s), '{1}' will be replaced with field label.</p>
   * @default 'Input error. {0}.'
   * @see ext.SStringUtil#format() ext.StringUtil.format()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-ariaErrorText Original Ext JS documentation of 'ariaErrorText'
   */
  public native function get ariaErrorText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaErrorText(value:String):void;

  [ExtConfig]
  /**
   * Optional text description for this object. This text will be
   * announced to Assistive Technology users when the object is focused.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-ariaHelp Original Ext JS documentation of 'ariaHelp'
   */
  public native function get ariaHelp():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaHelp(value:String):void;

  [ExtConfig]
  /**
   * Whether to adjust the component's body width to make room for 'side'
   * <i>error messages</i> (→<code>msgTarget</code>).
   * @default true
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-autoFitErrors Original Ext JS documentation of 'autoFitErrors'
   */
  public native function get autoFitErrors():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoFitErrors(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the body content element.
   * @default Ext.baseCSSPrefix + 'form-item-body'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-baseBodyCls Original Ext JS documentation of 'baseBodyCls'
   */
  public native function get baseBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseBodyCls(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * at the beginning of the input containing element. If an <code>XTemplate</code> is used,
   * the component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeBodyEl Original Ext JS documentation of 'beforeBodyEl'
   */
  public native function get beforeBodyEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeBodyEl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the label text. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeLabelTextTpl Original Ext JS documentation of 'beforeLabelTextTpl'
   */
  public native function get beforeLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the label element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeLabelTpl Original Ext JS documentation of 'beforeLabelTpl'
   */
  public native function get beforeLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the <i>subTpl markup</i> (→<code>getSubTplMarkup()</code>). If an <code>XTemplate</code> is used, the
   * component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see #getSubTplMarkup()
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeSubTpl Original Ext JS documentation of 'beforeSubTpl'
   */
  public native function get beforeSubTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeSubTpl(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get bodyEl():Element;

  /**
   * @inheritDoc
   */
  public native function set bodyEl(value:Element):void;

  [ExtConfig]
  /**
   * If set to true, the field container will automatically combine and display the validation
   * errors from all the fields it contains as a single error on the container, according to the
   * configured →<code>msgTarget</code>. Defaults to false.
   * @default false
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldContainer.html#cfg-combineErrors Original Ext JS documentation of 'combineErrors'
   */
  public native function get combineErrors():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set combineErrors(value:Boolean):void;

  [ExtConfig]
  /**
   * If set to true, and there is no defined →<code>fieldLabel</code>, the field container will
   * automatically generate its label by combining the labels of all the fields it contains.
   * Defaults to false.
   * @default false
   * @see #fieldLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldContainer.html#cfg-combineLabels Original Ext JS documentation of 'combineLabels'
   */
  public native function get combineLabels():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set combineLabels(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get errorEl():Element;

  /**
   * @inheritDoc
   */
  public native function set errorEl(value:Element):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the error message element.
   * @default Ext.baseCSSPrefix + 'form-error-msg'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-errorMsgCls Original Ext JS documentation of 'errorMsgCls'
   */
  public native function get errorMsgCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set errorMsgCls(value:String):void;

  [ExtConfig]
  /**
   * An extra CSS class to be applied to the body content element in addition to
   * →<code>baseBodyCls</code>.
   * @default ''
   * @see #baseBodyCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-fieldBodyCls Original Ext JS documentation of 'fieldBodyCls'
   */
  public native function get fieldBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldBodyCls(value:String):void;

  [ExtConfig]
  /**
   * If specified, the properties in this object are used as default config values for each
   * →<code>ext.form.Labelable</code> instance (e.g. →<code>ext.form.field.BaseField</code> or
   * →<code>ext.form.FieldContainer</code>) that is added as a descendant of this container.
   * Corresponding values specified in an individual field's own configuration, or from the
   * <i>defaults config</i> (→<code>ext.container.Container.defaults</code>) of its parent container,
   * will take precedence. See the documentation for →<code>ext.form.Labelable</code> to see
   * what config options may be specified in the fieldDefaults.
   * <p>Example:</p>
   * <pre>
   * new Ext.form.Panel({
   *     fieldDefaults: {
   *         labelAlign: 'left',
   *         labelWidth: 100
   *     },
   *     items: [{
   *         xtype: 'fieldset',
   *         defaults: {
   *             labelAlign: 'top'
   *         },
   *         items: [{
   *             name: 'field1'
   *         }, {
   *             name: 'field2'
   *         }]
   *     }, {
   *         xtype: 'fieldset',
   *         items: [{
   *             name: 'field3',
   *             labelWidth: 150
   *         }, {
   *             name: 'field4'
   *         }]
   *     }]
   * });
   * </pre>
   * <p>In this example, field1 and field2 will get labelAlign: 'top' (from the fieldset's defaults)
   * and labelWidth: 100 (from fieldDefaults), field3 and field4 will both get labelAlign: 'left'
   * (from fieldDefaults and field3 will use the labelWidth: 150 from its own config.</p>
   * @see ext.form.Labelable
   * @see ext.form.field.BaseField
   * @see ext.form.FieldContainer
   * @see ext.container.Container#defaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#cfg-fieldDefaults Original Ext JS documentation of 'fieldDefaults'
   * @see #setFieldDefaults()
   */
  public native function get fieldDefaults():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set fieldDefaults(value:Object):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The label for the field. It gets appended with the →<code>labelSeparator</code>, and its position
   * and sizing is determined by the →<code>labelAlign</code> and →<code>labelWidth</code> configs.
   * @default undefined
   * @see #labelSeparator
   * @see #labelAlign
   * @see #labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-fieldLabel Original Ext JS documentation of 'fieldLabel'
   * @see #getFieldLabel()
   * @see #setFieldLabel()
   */
  public native function get fieldLabel():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set fieldLabel(value:String):void;

  [ExtConfig]
  /**
   * A CSS class to be applied to the outermost element to denote that it is participating
   * in the form field layout.
   * @default Ext.baseCSSPrefix + 'form-item'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-formItemCls Original Ext JS documentation of 'formItemCls'
   */
  public native function get formItemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formItemCls(value:String):void;

  [ExtConfig]
  /**
   * When set to true, the label element (→<code>fieldLabel</code> and →<code>labelSeparator</code>)
   * will be automatically hidden if the →<code>fieldLabel</code> is empty. Setting this to false
   * will cause the empty label element to be rendered and space to be reserved for it;
   * this is useful if you want a field without a label to line up with other labeled fields
   * in the same form.
   * <p>If you wish to unconditionall hide the label even if a non-empty fieldLabel is configured,
   * then set the →<code>hideLabel</code> config to true.</p>
   * @default true
   * @see #fieldLabel
   * @see #labelSeparator
   * @see #hideLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-hideEmptyLabel Original Ext JS documentation of 'hideEmptyLabel'
   */
  public native function get hideEmptyLabel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideEmptyLabel(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to true to completely hide the label element (→<code>fieldLabel</code> and
   * →<code>labelSeparator</code>). Also see →<code>hideEmptyLabel</code>, which controls whether space
   * will be reserved for an empty fieldLabel.
   * @default false
   * @see #fieldLabel
   * @see #labelSeparator
   * @see #hideEmptyLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-hideLabel Original Ext JS documentation of 'hideLabel'
   */
  public native function get hideLabel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideLabel(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class to use when marking the component invalid.
   * @default Ext.baseCSSPrefix + 'form-invalid'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-invalidCls Original Ext JS documentation of 'invalidCls'
   */
  public native function get invalidCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set invalidCls(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get isFieldLabelable():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isFieldLabelable(value:Boolean):void;

  [ExtConfig]
  /**
   * Controls the position and alignment of the →<code>fieldLabel</code>. Valid values are:
   * <ul>
   * <li>"left" (the default) - The label is positioned to the left of the field, with its text
   * aligned to the left. Its width is determined by the →<code>labelWidth</code> config.</li>
   * <li>"top" - The label is positioned above the field.</li>
   * <li>"right" - The label is positioned to the left of the field, with its text aligned
   * to the right. Its width is determined by the →<code>labelWidth</code> config.</li>
   * </ul>
   * @default 'left'
   * @see #fieldLabel
   * @see #labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelAlign Original Ext JS documentation of 'labelAlign'
   */
  public native function get labelAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelAlign(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * inside the label element (as attributes). If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelAttrTpl Original Ext JS documentation of 'labelAttrTpl'
   */
  public native function get labelAttrTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelAttrTpl(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the label element. This (single) CSS class is used
   * to formulate the renderSelector and drives the field layout where it is concatenated
   * with a hyphen ('-') and →<code>labelAlign</code>. To add additional classes, use
   * →<code>labelClsExtra</code>.
   * @default Ext.baseCSSPrefix + 'form-item-label'
   * @see #labelAlign
   * @see #labelClsExtra
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelCls Original Ext JS documentation of 'labelCls'
   */
  public native function get labelCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelCls(value:String):void;

  [ExtConfig]
  /**
   * An optional string of one or more additional CSS classes to add to the label element.
   * Defaults to empty.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelClsExtra Original Ext JS documentation of 'labelClsExtra'
   */
  public native function get labelClsExtra():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelClsExtra(value:String):void;

  [ExtConfig]
  /**
   * The string to use when joining the labels of individual sub-fields, when
   * →<code>combineLabels</code> is set to true. Defaults to ', '.
   * @default ', '
   * @see #combineLabels
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldContainer.html#cfg-labelConnector Original Ext JS documentation of 'labelConnector'
   */
  public native function get labelConnector():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelConnector(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get labelEl():Element;

  /**
   * @inheritDoc
   */
  public native function set labelEl(value:Element):void;

  [ExtConfig]
  /**
   * The amount of space in pixels between the →<code>fieldLabel</code> and the field body.
   * This defaults to <code>5</code> for compatibility with Ext JS 4, however, as of Ext JS 5
   * the space between the label and the body can optionally be determined by the theme
   * using the →<code>style:$form-label-horizontal-spacing</code> (for side-aligned labels) and
   * →<code>style:$form-label-vertical-spacing</code> (for top-aligned labels) SASS variables.
   * In order for the stylesheet values as to take effect, you must use a labelPad value
   * of <code>null</code>.
   * @default 5
   * @see #fieldLabel
   * @see #style:$form-label-horizontal-spacing
   * @see #style:$form-label-vertical-spacing
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelPad Original Ext JS documentation of 'labelPad'
   */
  public native function get labelPad():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelPad(value:Number):void;

  [ExtConfig]
  /**
   * Character(s) to be inserted at the end of the <i>label text</i> (→<code>fieldLabel</code>).
   * <p>Set to empty string to hide the separator completely.</p>
   * @default ':'
   * @see #fieldLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelSeparator Original Ext JS documentation of 'labelSeparator'
   */
  public native function get labelSeparator():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelSeparator(value:String):void;

  [ExtConfig]
  /**
   * A CSS style specification string to apply directly to this field's label.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelStyle Original Ext JS documentation of 'labelStyle'
   */
  public native function get labelStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelStyle(value:String):void;

  [ExtConfig]
  /**
   * The width of the →<code>fieldLabel</code> in pixels. Only applicable if →<code>labelAlign</code>
   * is set to "left" or "right".
   * @default 100
   * @see #fieldLabel
   * @see #labelAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelWidth Original Ext JS documentation of 'labelWidth'
   */
  public native function get labelWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelWidth(value:Number):void;

  [ExtConfig]
  /**
   * The location where the error message text should display. Must be one of the following
   * values:
   * <ul>
   * <li>
   * <p><code>qtip</code> Display a quick tip containing the message when the user hovers over the field.
   * This is the default.</p>
   * <p><b>→<code>ext.tip.QuickTipManager.init()</code> must have been called for this setting to work.</b></p>
   * </li>
   * <li>
   * <p><code>title</code> Display the message in a default browser title attribute popup.</p>
   * </li>
   * <li>
   * <p><code>under</code> Add a block div beneath the field containing the error message.</p>
   * </li>
   * <li>
   * <p><code>side</code> Add an error icon to the right of the field, displaying the message in a popup
   * on hover.</p>
   * </li>
   * <li>
   * <p><code>none</code> Don't display any error message. This might be useful if you are implementing
   * custom error display.</p>
   * </li>
   * <li>
   * <p><code>[element id]</code> Add the error message directly to the innerHTML of the specified element.</p>
   * </li>
   * </ul>
   * @default 'qtip'
   * @see ext.tip.SQuickTipManager#init() ext.tip.QuickTipManager.init()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-msgTarget Original Ext JS documentation of 'msgTarget'
   */
  public native function get msgTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set msgTarget(value:String):void;

  [ExtConfig]
  /**
   * true to disable displaying any <i>error message</i> (→<code>setActiveError()</code>) set on this object.
   * @default false
   * @see #setActiveError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-preventMark Original Ext JS documentation of 'preventMark'
   */
  public native function get preventMark():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventMark(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function getActiveError():String;

  /**
   * @inheritDoc
   */
  public native function getActiveErrors():Array;

  [ArrayElementType("String")]
  /**
   * Takes an Array of invalid →<code>ext.form.field.Field</code> objects and builds a combined list
   * of error messages from them. Defaults to prepending each message by the field name
   * and a colon. This can be overridden to provide custom combined error message handling,
   * for instance changing the format of each message or sorting the array (it is sorted
   * in order of appearance by default).
   * @param invalidFields An Array of the sub-fields which are currently
   * invalid.
   * @return The combined list of error messages
   * @see ext.form.field.Field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldContainer.html#method-getCombinedErrors Original Ext JS documentation of 'getCombinedErrors'
   */
  public native function getCombinedErrors(invalidFields:Array):Array;

  /**
   * Returns the combined field label if →<code>combineLabels</code> is set to true and if there is no
   * set →<code>fieldLabel</code>. Otherwise returns the fieldLabel like normal. You can also override
   * this method to provide a custom generated label.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @return The label, or empty string if none.
   * @see #combineLabels
   * @see #fieldLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldContainer.html#method-getFieldLabel Original Ext JS documentation of 'getFieldLabel'
   */
  public native function getFieldLabel():String;

  /**
   * @inheritDoc
   */
  public native function getInputId():String;

  /**
   * Generates the arguments for the field decorations <i>rendering template</i> (→<code>labelableRenderTpl</code>).
   * @param data optional object to use as the base data object. If provided,
   * this method will add properties to the base object instead of creating a new one.
   * @return The template arguments
   * @see #labelableRenderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getLabelableRenderData Original Ext JS documentation of 'getLabelableRenderData'
   */
  protected native function getLabelableRenderData(data:Object):Object;

  /**
   * Gets the markup to be inserted into the outer template's bodyEl. Defaults to empty string,
   * should be implemented by classes including this mixin as needed.
   * @return The markup to be inserted
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getSubTplMarkup Original Ext JS documentation of 'getSubTplMarkup'
   */
  protected native function getSubTplMarkup():String;

  /**
   * @inheritDoc
   */
  public native function hasActiveError():Boolean;

  /**
   * @inheritDoc
   */
  public native function hasVisibleLabel():Boolean;

  /**
   * Initializes the FieldAncestor's state; this must be called from the initComponent method
   * of any components importing this mixin.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-initFieldAncestor Original Ext JS documentation of 'initFieldAncestor'
   */
  protected native function initFieldAncestor():void;

  /**
   * @inheritDoc
   */
  public native function initLabelable():void;

  /**
   * Fired when the error message of any field within the container changes.
   * @param field The sub-field whose active error changed
   * @param error The new active error message
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldErrorChange Original Ext JS documentation of 'onFieldErrorChange'
   */
  protected native function onFieldErrorChange(field:Labelable, error:String):void;

  /**
   * Fired when the validity of any field within the container changes.
   * @param field The sub-field whose validity changed
   * @param valid The new validity state
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldValidityChange Original Ext JS documentation of 'onFieldValidityChange'
   */
  protected native function onFieldValidityChange(field:Field, valid:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function setActiveError(msg:String):void;

  /**
   * @inheritDoc
   */
  public native function setActiveErrors(errors:Array):void;

  /**
   * @inheritDoc
   */
  public native function setFieldDefaults(defaults:Object):void;

  /**
   * @inheritDoc
   */
  public native function setFieldLabel(label:String):void;

  /**
   * @inheritDoc
   */
  public native function trimLabelSeparator():String;

  /**
   * @inheritDoc
   */
  public native function unsetActiveError():void;
}
}