package ext.form {
import ext.Component;
import ext.container.Container;
import ext.form.field.Checkbox;
import ext.form.field.Field;
import ext.panel.Tool;

[Native("Ext.form.FieldSet", require)]
/**
 * @see ext.form.events.FieldSet_field_errorEvent.FIELD_ERROR_CHANGE
 * @eventType ext.form.events.FieldSet_field_errorEvent.FIELD_ERROR_CHANGE
 */
[Event(name='onFieldErrorChange', type='ext.form.events.FieldSet_field_errorEvent')]
/**
 * @see ext.form.events.FieldSet_field_isValidEvent.FIELD_VALIDITY_CHANGE
 * @eventType ext.form.events.FieldSet_field_isValidEvent.FIELD_VALIDITY_CHANGE
 */
[Event(name='onFieldValidityChange', type='ext.form.events.FieldSet_field_isValidEvent')]
/**
 * @see ext.form.events.FieldSetEvent.BEFORE_COLLAPSE
 * @eventType ext.form.events.FieldSetEvent.BEFORE_COLLAPSE
 */
[Event(name='onBeforeCollapse', type='ext.form.events.FieldSetEvent')]
/**
 * @see ext.form.events.FieldSetEvent.BEFORE_EXPAND
 * @eventType ext.form.events.FieldSetEvent.BEFORE_EXPAND
 */
[Event(name='onBeforeExpand', type='ext.form.events.FieldSetEvent')]
/**
 * @see ext.form.events.FieldSetEvent.COLLAPSE
 * @eventType ext.form.events.FieldSetEvent.COLLAPSE
 */
[Event(name='onCollapse', type='ext.form.events.FieldSetEvent')]
/**
 * @see ext.form.events.FieldSetEvent.EXPAND
 * @eventType ext.form.events.FieldSetEvent.EXPAND
 */
[Event(name='onExpand', type='ext.form.events.FieldSetEvent')]
/**
 * A container for grouping sets of fields, rendered as a HTML <code>fieldset</code> element.
 * The →<code>title</code> config will be rendered as the fieldset's <code>→legend</code>.
 * <p>While FieldSets commonly contain simple groups of fields, they are general
 * <i>Containers</i> (→<code>ext.container.Container</code>) and may therefore contain any type of components
 * in their →<code>items</code>, including other nested containers. The default →<code>layout</code>
 * for the FieldSet's items is <code>'anchor'</code>, but it can be configured to use any other layout type.</p>
 * <p>FieldSets may also be collapsed if configured to do so; this can be done in two ways:</p>
 * <ol>
 * <li>Set the →<code>collapsible</code> config to true; this will result in a collapse button being
 * rendered next to the <i>legend title</i> (→<code>title</code>), or:</li>
 * <li>Set the →<code>checkboxToggle</code> config to true; this is similar to using →<code>collapsible</code>
 * but renders a <i>checkbox</i> (→<code>ext.form.field.Checkbox</code>) in place of the toggle button.
 * The fieldset will be expanded when the checkbox is checked and collapsed when it is unchecked.
 * The checkbox will also be included in the <i>form submit parameters</i> (→<code>ext.form.BasicForm.submit()</code>)
 * using →<code>checkbox</code>.</li>
 * </ol>
 * <p><b>Example usage</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Simple Form with FieldSets',
 *     labelWidth: 75, // label settings here cascade unless overridden
 *     url: 'save-form.php',
 *     frame: true,
 *     bodyStyle: 'padding:5px 5px 0',
 *     width: 550,
 *     renderTo: Ext.getBody(),
 *     layout: 'column', // arrange fieldsets side by side
 *     items: [{
 *         // Fieldset in Column 1 - collapsible via toggle button
 *         xtype:'fieldset',
 *         columnWidth: 0.5,
 *         title: 'Fieldset 1',
 *         collapsible: true,
 *         defaultType: 'textfield',
 *         defaults: {anchor: '100%'},
 *         layout: 'anchor',
 *         items :[{
 *             fieldLabel: 'Field 1',
 *             name: 'field1'
 *         }, {
 *             fieldLabel: 'Field 2',
 *             name: 'field2'
 *         }]
 *     }, {
 *         // Fieldset in Column 2 - collapsible via checkbox, collapsed by default,
 *         // contains a panel
 *         xtype:'fieldset',
 *         title: 'Show Panel', // title or checkboxToggle creates fieldset header
 *         columnWidth: 0.5,
 *         checkboxToggle: true,
 *         collapsed: true, // fieldset initially collapsed
 *         layout:'anchor',
 *         items :[{
 *             xtype: 'panel',
 *             anchor: '100%',
 *             title: 'Panel inside a fieldset',
 *             frame: true,
 *             height: 52
 *         }]
 *     }]
 * });
 * </pre>
 * @see #title
 * @see #legend
 * @see ext.container.Container
 * @see #items
 * @see #layout
 * @see #collapsible
 * @see #checkboxToggle
 * @see ext.form.field.Checkbox
 * @see ext.form.BasicForm#submit()
 * @see #checkbox
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html Original Ext JS documentation of 'Ext.form.FieldSet'
 */
public class FieldSet extends Container implements IFieldAncestor {
  /**
   * @param config @inheritDoc
   */
  public function FieldSet(config:FieldSet = null) {
    super();
  }

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'group'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  override public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @default 'fieldset'
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  override public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class applied to the fieldset.
   * @default Ext.baseCSSPrefix + 'fieldset'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * A configuration for the generated checkbox that is adjacent to the →<code>title</code>
   * in the header. This config is only effective when →<code>checkboxToggle</code> is true
   * @since 6.2.0
   * @see #title
   * @see #checkboxToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-checkbox Original Ext JS documentation of 'checkbox'
   */
  public native function get checkbox():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkbox(value:Object):void;

  /**
   * Refers to the →<code>ext.form.field.Checkbox</code> component that is added next to the title
   * in the legend. Only populated if the fieldset is configured with
   * →<code>checkboxToggle</code>: true.
   * @see ext.form.field.Checkbox
   * @see #checkboxToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#property-checkboxCmp Original Ext JS documentation of 'checkboxCmp'
   */
  public native function get checkboxCmp():Checkbox;

  /**
   * @private
   */
  public native function set checkboxCmp(value:Checkbox):void;

  [Deprecated(replacement="checkbox", since="6.2.0")]
  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-checkboxName Original Ext JS documentation of 'checkboxName'
   */
  public native function get checkboxName():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkboxName(value:String):void;

  [ExtConfig]
  /**
   * Set to true to render a checkbox into the fieldset frame just in front of the legend
   * to expand/collapse the fieldset when the checkbox is toggled. This checkbox will be included
   * in form submits using the →<code>checkbox</code> configuration.
   * @default false
   * @see #checkbox
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-checkboxToggle Original Ext JS documentation of 'checkboxToggle'
   */
  public native function get checkboxToggle():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkboxToggle(value:Boolean):void;

  [ExtConfig]
  /**
   * The ui to use for the fieldset's checkbox.
   * @default 'default'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-checkboxUI Original Ext JS documentation of 'checkboxUI'
   */
  public native function get checkboxUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkboxUI(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'body'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * Set to true to render the fieldset as collapsed by default. If →<code>checkboxToggle</code>
   * is specified, the checkbox will also be unchecked by default.
   * @default false
   * @see #checkboxToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-collapsed Original Ext JS documentation of 'collapsed'
   * @see #setCollapsed()
   */
  public native function get collapsed():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set collapsed(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to true to make the fieldset collapsible and have the expand/collapse toggle button
   * automatically rendered into the legend element, false to keep the fieldset statically sized
   * with no collapse button. Another option is to configure →<code>checkboxToggle</code>.
   * Use the →<code>collapsed</code> config to collapse the fieldset by default.
   * @default false
   * @see #checkboxToggle
   * @see #collapsed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-collapsible Original Ext JS documentation of 'collapsible'
   */
  public native function get collapsible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapsible(value:Boolean):void;

  [ExtConfig]
  /**
   * Fieldset description to be announced by screen readers.
   * @default '{0} field set'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-descriptionText Original Ext JS documentation of 'descriptionText'
   */
  public native function get descriptionText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set descriptionText(value:String):void;

  [ExtConfig]
  /**
   * Text to be announced by screen readers when toggle tool
   * or checkbox is focused.
   * @default 'Expand field set'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-expandText Original Ext JS documentation of 'expandText'
   */
  public native function get expandText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandText(value:String):void;

  [ExtConfig]
  /**
   * If specified, the properties in this object are used as default config values for each
   * →<code>ext.form.Labelable</code> instance (e.g. →<code>ext.form.field.BaseField</code> or
   * →<code>ext.form.FieldContainer</code>) that is added as a descendant of this container.
   * Corresponding values specified in an individual field's own configuration, or from the
   * <i>defaults config</i> (→<code>ext.container.Container.defaults</code>) of its parent container,
   * will take precedence. See the documentation for →<code>ext.form.Labelable</code> to see
   * what config options may be specified in the fieldDefaults.
   * <p>Example:</p>
   * <pre>
   * new Ext.form.Panel({
   *     fieldDefaults: {
   *         labelAlign: 'left',
   *         labelWidth: 100
   *     },
   *     items: [{
   *         xtype: 'fieldset',
   *         defaults: {
   *             labelAlign: 'top'
   *         },
   *         items: [{
   *             name: 'field1'
   *         }, {
   *             name: 'field2'
   *         }]
   *     }, {
   *         xtype: 'fieldset',
   *         items: [{
   *             name: 'field3',
   *             labelWidth: 150
   *         }, {
   *             name: 'field4'
   *         }]
   *     }]
   * });
   * </pre>
   * <p>In this example, field1 and field2 will get labelAlign: 'top' (from the fieldset's defaults)
   * and labelWidth: 100 (from fieldDefaults), field3 and field4 will both get labelAlign: 'left'
   * (from fieldDefaults and field3 will use the labelWidth: 150 from its own config.</p>
   * @see ext.form.Labelable
   * @see ext.form.field.BaseField
   * @see ext.form.FieldContainer
   * @see ext.container.Container#defaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#cfg-fieldDefaults Original Ext JS documentation of 'fieldDefaults'
   */
  public native function get fieldDefaults():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldDefaults(value:Object):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default false
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.container.Container.layout</code> for the fieldset's immediate child items.
   * @default 'anchor'
   * @see ext.container.Container#layout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  /**
   * The component for the fieldset's legend. Will only be defined if the configuration requires
   * a legend to be created, by setting the →<code>title</code> or →<code>checkboxToggle</code> options.
   * @see #title
   * @see #checkboxToggle
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#property-legend Original Ext JS documentation of 'legend'
   */
  public native function get legend():Component;

  /**
   * @private
   */
  public native function set legend(value:Component):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code> used to create the internal structure inside
   * this Component's encapsulating <i>Element</i> (→<code>getEl()</code>).
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b><code>null</code></b> which means that they will be
   * initially rendered with no internal structure; they render their <i>Element</i> (→<code>getEl()</code>)
   * empty. The more specialized classes with complex DOM structures provide their own template
   * definitions.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * with customized internal structure.</p>
   * <p>Upon rendering, any created child elements may be automatically imported into object
   * properties using the →<code>renderSelectors</code> and →<code>childEls</code> options.</p>
   * @default [
   *     '{%this.renderLegend(out,values);%}',
   *     '<div id="{id}-body" data-ref="body" class="{baseCls}-body {baseCls}-body-{ui} {bodyTargetCls}" ',
   *     'role="presentation"<tpl if="bodyStyle"> style="{bodyStyle}"</tpl>>',
   *     '{%this.renderContainer(out,values);%}',
   *     '</div>'
   * ]
   * @see ext.XTemplate
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderSelectors
   * @see #childEls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-renderTpl Original Ext JS documentation of 'renderTpl'
   */
  override public native function get renderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set renderTpl(value:*):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.
   * By default the following stateEvents are added:</p>
   * <ul>
   * <li>→<code>event:onResize</code> - <i>(added by Ext.Component)</i></li>
   * <li>→<code>event:onCollapse</code></li>
   * <li>→<code>event:onExpand</code></li>
   * </ul>
   * @default [
   *     'collapse',
   *     'expand'
   * ]
   * @see #stateEvents
   * @see #stateful
   * @see #event:onResize
   * @see #event:onCollapse
   * @see #event:onExpand
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  override public native function get stateEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set stateEvents(value:Array):void;

  [ExtConfig]
  /**
   * A title to be displayed in the fieldset's legend. May contain HTML markup.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-title Original Ext JS documentation of 'title'
   * @see #setTitle()
   */
  public native function get title():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set title(value:String):void;

  /**
   * Refers to the →<code>ext.panel.Tool</code> component that is added as the collapse/expand button
   * next to the title in the legend. Only populated if the fieldset is configured with
   * →<code>collapsible</code>: true.
   * @see ext.panel.Tool
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#property-toggleCmp Original Ext JS documentation of 'toggleCmp'
   */
  public native function get toggleCmp():Tool;

  /**
   * @private
   */
  public native function set toggleCmp(value:Tool):void;

  [ExtConfig]
  /**
   * Set to true will add a listener to the titleCmp property for the click event which
   * will execute the →<code>toggle()</code> method. This option is only used when the
   * →<code>collapsible</code> property is set to true.
   * @default true
   * @see #toggle()
   * @see #collapsible
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#cfg-toggleOnTitleClick Original Ext JS documentation of 'toggleOnTitleClick'
   */
  public native function get toggleOnTitleClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set toggleOnTitleClick(value:Boolean):void;

  /**
   * Collapses the fieldset.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-collapse Original Ext JS documentation of 'collapse'
   */
  public native function collapse():FieldSet;

  /**
   * Creates the checkbox component. This is only called internally, but could be overridden
   * in subclasses to customize the checkbox's configuration or even return an entirely different
   * component type.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-createCheckboxCmp Original Ext JS documentation of 'createCheckboxCmp'
   */
  protected native function createCheckboxCmp():Component;

  /**
   * Creates the legend title component. This is only called internally, but could be overridden
   * in subclasses to customize the title component. If →<code>toggleOnTitleClick</code> is set
   * to true, a listener for the click event will toggle the collapsed state of the FieldSet.
   * @see #toggleOnTitleClick
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-createTitleCmp Original Ext JS documentation of 'createTitleCmp'
   */
  protected native function createTitleCmp():Component;

  /**
   * Creates the toggle button component. This is only called internally, but could be overridden
   * in subclasses to customize the toggle component.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-createToggleCmp Original Ext JS documentation of 'createToggleCmp'
   */
  protected native function createToggleCmp():Component;

  /**
   * Expands the fieldset.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-expand Original Ext JS documentation of 'expand'
   */
  public native function expand():FieldSet;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Initializes the FieldAncestor's state; this must be called from the initComponent method
   * of any components importing this mixin.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-initFieldAncestor Original Ext JS documentation of 'initFieldAncestor'
   */
  protected native function initFieldAncestor():void;

  /**
   * Fired when the error message of any field within the container changes.
   * @param field The sub-field whose active error changed
   * @param error The new active error message
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldErrorChange Original Ext JS documentation of 'onFieldErrorChange'
   */
  protected native function onFieldErrorChange(field:Labelable, error:String):void;

  /**
   * Fired when the validity of any field within the container changes.
   * @param field The sub-field whose validity changed
   * @param valid The new validity state
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldValidityChange Original Ext JS documentation of 'onFieldValidityChange'
   */
  protected native function onFieldValidityChange(field:Field, valid:Boolean):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Set the collapsed state of the fieldset.
   * @since 6.2.0
   * @param collapsed The collapsed state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-setCollapsed Original Ext JS documentation of 'setCollapsed'
   */
  public native function setCollapsed(collapsed:Boolean):void;

  /**
   * Sets the title of this fieldset.
   * @param title The new title.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-setTitle Original Ext JS documentation of 'setTitle'
   */
  public native function setTitle(title:String):FieldSet;

  /**
   * Toggle the fieldset's collapsed state to the opposite of what it is currently.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldSet.html#method-toggle Original Ext JS documentation of 'toggle'
   */
  public native function toggle():void;
}
}