package ext.form {
import ext.data.Model;
import ext.form.field.Field;
import ext.panel.Panel;

[Native("Ext.form.Panel", require)]
/**
 * @see ext.form.events.FormPanel_field_errorEvent.FIELD_ERROR_CHANGE
 * @eventType ext.form.events.FormPanel_field_errorEvent.FIELD_ERROR_CHANGE
 */
[Event(name='onFieldErrorChange', type='ext.form.events.FormPanel_field_errorEvent')]
/**
 * @see ext.form.events.FormPanel_field_isValidEvent.FIELD_VALIDITY_CHANGE
 * @eventType ext.form.events.FormPanel_field_isValidEvent.FIELD_VALIDITY_CHANGE
 */
[Event(name='onFieldValidityChange', type='ext.form.events.FormPanel_field_isValidEvent')]
/**
 * @see ext.form.events.FormPanel_actionEvent.ACTION_COMPLETE
 * @eventType ext.form.events.FormPanel_actionEvent.ACTION_COMPLETE
 */
[Event(name='onActionComplete', type='ext.form.events.FormPanel_actionEvent')]
/**
 * @see ext.form.events.FormPanel_actionEvent.ACTION_FAILED
 * @eventType ext.form.events.FormPanel_actionEvent.ACTION_FAILED
 */
[Event(name='onActionFailed', type='ext.form.events.FormPanel_actionEvent')]
/**
 * @see ext.form.events.FormPanel_actionEvent.BEFORE_ACTION
 * @eventType ext.form.events.FormPanel_actionEvent.BEFORE_ACTION
 */
[Event(name='onBeforeAction', type='ext.form.events.FormPanel_actionEvent')]
/**
 * @see ext.form.events.FormPanel_dirtyEvent.DIRTY_CHANGE
 * @eventType ext.form.events.FormPanel_dirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.form.events.FormPanel_dirtyEvent')]
/**
 * @see ext.form.events.FormPanel_validEvent.VALIDITY_CHANGE
 * @eventType ext.form.events.FormPanel_validEvent.VALIDITY_CHANGE
 */
[Event(name='onValidityChange', type='ext.form.events.FormPanel_validEvent')]
/**
 * FormPanel provides a standard container for forms. It is essentially a standard
 * →<code>ext.panel.Panel</code> which automatically creates a →<code>ext.form.BasicForm</code>
 * for managing any →<code>ext.form.field.Field</code> objects that are added as descendants of the panel.
 * It also includes conveniences for configuring and working with the BasicForm and the collection
 * of Fields.
 * <p><b>Layout</b></p>
 * <p>By default, FormPanel is configured with <code>layout:'anchor' (→ext.layout.container.AnchorLayout)</code>
 * for the layout of its immediate child items. This can be changed to any of the supported
 * container layouts. The layout of sub-containers is configured in
 * <i>the standard way</i> (→<code>ext.container.Container.layout</code>).</p>
 * <p><b>BasicForm</b></p>
 * <p>FormPanel class accepts all
 * of the config options supported by the →<code>ext.form.BasicForm</code> class, and will pass them along to
 * the internal BasicForm when it is created.</p>
 * <p>The following events fired by the BasicForm will be re-fired by the FormPanel and can therefore
 * be listened for on the FormPanel itself:</p>
 * <ul>
 * <li>→<code>ext.form.BasicForm.event:onBeforeAction</code></li>
 * <li>→<code>ext.form.BasicForm.event:onActionFailed</code></li>
 * <li>→<code>ext.form.BasicForm.event:onActionComplete</code></li>
 * <li>→<code>ext.form.BasicForm.event:onValidityChange</code></li>
 * <li>→<code>ext.form.BasicForm.event:onDirtyChange</code></li>
 * </ul>
 * <p><b>Field Defaults</b></p>
 * <p>The →<code>fieldDefaults</code> config option conveniently allows centralized configuration of default
 * values for all fields added as descendants of the FormPanel. Any config option recognized
 * by implementations of →<code>ext.form.Labelable</code> may be included in this object. See the
 * →<code>fieldDefaults</code> documentation for details of how the defaults are applied.</p>
 * <p><b>Form Validation</b></p>
 * <p>With the default configuration, form fields are validated on-the-fly while the user edits
 * their values. This can be controlled on a per-field basis (or via the →<code>fieldDefaults</code>
 * config) with the field config properties →<code>ext.form.field.Field.validateOnChange</code> and
 * →<code>ext.form.field.BaseField.checkChangeEvents</code>, and the FormPanel's config properties
 * →<code>pollForChanges</code> and →<code>pollInterval</code>.</p>
 * <p>Any component within the FormPanel can be configured with <code>formBind: true</code>. This will cause that
 * component to be automatically disabled when the form is invalid, and enabled when it is valid.
 * This is most commonly used for Button components to prevent submitting the form in an invalid
 * state, but can be used on any component type.</p>
 * <p>For more information on form validation see the following:</p>
 * <ul>
 * <li>→<code>ext.form.field.Field.validateOnChange</code></li>
 * <li>→<code>pollForChanges</code> and →<code>pollInterval</code></li>
 * <li>→<code>ext.form.field.VTypes</code></li>
 * <li><i>BasicForm.doAction clientValidation notes</i> (→<code>ext.form.BasicForm.doAction()</code>)</li>
 * </ul>
 * <p><b>Form Submission</b></p>
 * <p>By default, Ext Forms are submitted through Ajax, using →<code>ext.form.action.Action</code>.
 * See the documentation for →<code>ext.form.BasicForm</code> for details.</p>
 * <p><b>Example usage</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Simple Form',
 *     bodyPadding: 5,
 *     width: 350,
 *
 *     // The form will submit an AJAX request to this URL when submitted
 *     url: 'save-form.php',
 *
 *     // Fields will be arranged vertically, stretched to full width
 *     layout: 'anchor',
 *     defaults: {
 *         anchor: '100%'
 *     },
 *
 *     // The fields
 *     defaultType: 'textfield',
 *     items: [{
 *         fieldLabel: 'First Name',
 *         name: 'first',
 *         allowBlank: false
 *     },{
 *         fieldLabel: 'Last Name',
 *         name: 'last',
 *         allowBlank: false
 *     }],
 *
 *     // Reset and Submit buttons
 *     buttons: [{
 *         text: 'Reset',
 *         handler: function() {
 *             this.up('form').getForm().reset();
 *         }
 *     }, {
 *         text: 'Submit',
 *         formBind: true, //only enabled once the form is valid
 *         disabled: true,
 *         handler: function() {
 *             var form = this.up('form').getForm();
 *             if (form.isValid()) {
 *                 form.submit({
 *                     success: function(form, action) {
 *                        Ext.Msg.alert('Success', action.result.msg);
 *                     },
 *                     failure: function(form, action) {
 *                         Ext.Msg.alert('Failed', action.result.msg);
 *                     }
 *                 });
 *             }
 *         }
 *     }],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.panel.Panel
 * @see ext.form.BasicForm
 * @see ext.form.field.Field
 * @see ext.layout.container.AnchorLayout
 * @see ext.container.Container#layout
 * @see ext.form.BasicForm#event:onBeforeAction
 * @see ext.form.BasicForm#event:onActionFailed
 * @see ext.form.BasicForm#event:onActionComplete
 * @see ext.form.BasicForm#event:onValidityChange
 * @see ext.form.BasicForm#event:onDirtyChange
 * @see #fieldDefaults
 * @see ext.form.Labelable
 * @see ext.form.field.Field#validateOnChange
 * @see ext.form.field.BaseField#checkChangeEvents
 * @see #pollForChanges
 * @see #pollInterval
 * @see ext.form.field.#VTypes ext.form.field.VTypes
 * @see ext.form.BasicForm#doAction()
 * @see ext.form.action.Action
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html Original Ext JS documentation of 'Ext.form.Panel'
 */
public class FormPanel extends Panel implements IFieldAncestor {
  /**
   * @param config @inheritDoc
   */
  public function FormPanel(config:FormPanel = null) {
    super();
  }

  [ExtConfig]
  /**
   * If specified, load and submit actions will be handled with
   * →<code>ext.form.action.DirectLoadAction</code> and
   * →<code>ext.form.action.DirectSubmitAction</code>. Methods which have been imported by
   * →<code>ext.direct.DirectManager</code> can be specified here to load and submit forms. API methods
   * may also be specified as strings. See →<code>ext.data.proxy.DirectProxy.directFn</code>.
   * Such as the following:
   * <pre>
   * api: {
   *     load: App.ss.MyProfile.load,
   *     submit: App.ss.MyProfile.submit
   * }
   * </pre>
   * <p>Load actions can use →<code>paramOrder</code> or →<code>paramsAsHash</code> to customize how the load
   * method is invoked. Submit actions will always use a standard form submit. The <code>formHandler</code>
   * configuration (see Ext.direct.RemotingProvider#action) must be set on the associated
   * server-side method which has been imported by →<code>ext.direct.DirectManager</code>.</p>
   * @see ext.form.action.DirectLoadAction
   * @see ext.form.action.DirectSubmitAction
   * @see ext.direct.#DirectManager ext.direct.DirectManager
   * @see ext.data.proxy.DirectProxy#directFn
   * @see #paramOrder
   * @see #paramsAsHash
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-api Original Ext JS documentation of 'api'
   */
  public native function get api():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set api(value:Object):void;

  [ExtConfig]
  /**
   * Parameters to pass with all requests. e.g. baseParams: <code>{id: '123', foo: 'bar'}</code>.
   * <p>Parameters are encoded as standard HTTP parameters using →<code>ext.ObjectUtil.toQueryString()</code>.</p>
   * @see ext.SObjectUtil#toQueryString() ext.ObjectUtil.toQueryString()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-baseParams Original Ext JS documentation of 'baseParams'
   */
  public native function get baseParams():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseParams(value:Object):void;

  [ExtConfig]
  /**
   * An Ext.data.reader.Reader (e.g. →<code>ext.data.reader.XmlReader</code>) instance or
   * configuration to be used to read field error messages returned from 'submit' actions.
   * This is optional as there is built-in support for processing JSON responses.
   * <p>The Records which provide messages for the invalid Fields must use the
   * Field name (or id) as the Record ID, and must contain a field called 'msg'
   * which contains the error message.</p>
   * <p>The errorReader does not have to be a full-blown implementation of a
   * Reader. It simply needs to implement a <code>read(xhr)</code> function
   * which returns an Array of Records in an object with the following
   * structure:</p>
   * <pre>
   * {
   *     records: recordArray
   * }
   * </pre>
   * @see ext.data.reader.XmlReader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-errorReader Original Ext JS documentation of 'errorReader'
   */
  public native function get errorReader():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set errorReader(value:*):void;

  [ExtConfig]
  /**
   * If specified, the properties in this object are used as default config values for each
   * →<code>ext.form.Labelable</code> instance (e.g. →<code>ext.form.field.BaseField</code> or
   * →<code>ext.form.FieldContainer</code>) that is added as a descendant of this container.
   * Corresponding values specified in an individual field's own configuration, or from the
   * <i>defaults config</i> (→<code>ext.container.Container.defaults</code>) of its parent container,
   * will take precedence. See the documentation for →<code>ext.form.Labelable</code> to see
   * what config options may be specified in the fieldDefaults.
   * <p>Example:</p>
   * <pre>
   * new Ext.form.Panel({
   *     fieldDefaults: {
   *         labelAlign: 'left',
   *         labelWidth: 100
   *     },
   *     items: [{
   *         xtype: 'fieldset',
   *         defaults: {
   *             labelAlign: 'top'
   *         },
   *         items: [{
   *             name: 'field1'
   *         }, {
   *             name: 'field2'
   *         }]
   *     }, {
   *         xtype: 'fieldset',
   *         items: [{
   *             name: 'field3',
   *             labelWidth: 150
   *         }, {
   *             name: 'field4'
   *         }]
   *     }]
   * });
   * </pre>
   * <p>In this example, field1 and field2 will get labelAlign: 'top' (from the fieldset's defaults)
   * and labelWidth: 100 (from fieldDefaults), field3 and field4 will both get labelAlign: 'left'
   * (from fieldDefaults and field3 will use the labelWidth: 150 from its own config.</p>
   * @see ext.form.Labelable
   * @see ext.form.field.BaseField
   * @see ext.form.FieldContainer
   * @see ext.container.Container#defaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#cfg-fieldDefaults Original Ext JS documentation of 'fieldDefaults'
   */
  public native function get fieldDefaults():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldDefaults(value:Object):void;

  [ExtConfig]
  /**
   * If set to true, the field values are sent as JSON in the request body.
   * All of the field values, plus any additional params configured via →<code>baseParams</code>
   * and/or the <code>options</code> to →<code>submit()</code>, will be included in the values POSTed in the body
   * of the request.
   * @see #baseParams
   * @see #submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-jsonSubmit Original Ext JS documentation of 'jsonSubmit'
   */
  public native function get jsonSubmit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set jsonSubmit(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.container.Container.layout</code> for the form panel's immediate child items.
   * @default 'anchor'
   * @see ext.container.Container#layout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-layout Original Ext JS documentation of 'layout'
   * @see #setLayout()
   */
  override public native function get layout():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set layout(value:*):void;

  [ExtConfig]
  /**
   * The request method to use (GET or POST) for form actions if one isn't supplied
   * in the action options.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-method Original Ext JS documentation of 'method'
   */
  public native function get method():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set method(value:String):void;

  [ExtConfig]
  /**
   * A list of params to be executed server side. Only used for the →<code>api</code> <code>→load()</code>
   * configuration.
   * <p>Specify the params in the order in which they must be executed on the
   * server-side as either (1) an Array of String values, or (2) a String of params
   * delimited by either whitespace, comma, or pipe. For example,
   * any of the following would be acceptable:</p>
   * <pre>
   * paramOrder: ['param1','param2','param3']
   * paramOrder: 'param1 param2 param3'
   * paramOrder: 'param1,param2,param3'
   * paramOrder: 'param1|param2|param'
   * </pre>
   * @see #api
   * @see #load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-paramOrder Original Ext JS documentation of 'paramOrder'
   */
  public native function get paramOrder():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set paramOrder(value:*):void;

  [ExtConfig]
  /**
   * Only used for the →<code>api</code> <code>→load()</code> configuration. If true, parameters will be sent as a
   * single hash collection of named arguments. Providing a →<code>paramOrder</code> nullifies this
   * configuration.
   * @default false
   * @see #api
   * @see #load()
   * @see #paramOrder
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-paramsAsHash Original Ext JS documentation of 'paramsAsHash'
   */
  public native function get paramsAsHash():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set paramsAsHash(value:Boolean):void;

  [ExtConfig]
  /**
   * If set to <code>true</code>, sets up an interval task (using the →<code>pollInterval</code>) in which the
   * panel's fields are repeatedly checked for changes in their values. This is in addition
   * to the normal detection each field does on its own input element, and is not needed
   * in most cases. It does, however, provide a means to absolutely guarantee detection
   * of all changes including some edge cases in some browsers which do not fire native events.
   * Defaults to <code>false</code>.
   * @see #pollInterval
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-pollForChanges Original Ext JS documentation of 'pollForChanges'
   */
  public native function get pollForChanges():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pollForChanges(value:Boolean):void;

  [ExtConfig]
  /**
   * Interval in milliseconds at which the form's fields are checked for value changes. Only used
   * if the →<code>pollForChanges</code> option is set to <code>true</code>. Defaults to 500 milliseconds.
   * @see #pollForChanges
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-pollInterval Original Ext JS documentation of 'pollInterval'
   */
  public native function get pollInterval():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pollInterval(value:Number):void;

  [ExtConfig]
  /**
   * An Ext.data.reader.Reader (e.g. →<code>ext.data.reader.XmlReader</code>) instance or
   * configuration to be used to read data when executing 'load' actions. This
   * is optional as there is built-in support for processing JSON responses.
   * @see ext.data.reader.XmlReader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-reader Original Ext JS documentation of 'reader'
   */
  public native function get reader():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reader(value:*):void;

  [ExtConfig]
  /**
   * If set to true, a standard HTML form submit is used instead of a XHR (Ajax) style form
   * submission. All of the field values, plus any additional params configured via
   * →<code>baseParams</code> and/or the <code>options</code> to →<code>submit()</code>, will be included in the values
   * submitted in the form.
   * @see #baseParams
   * @see #submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-standardSubmit Original Ext JS documentation of 'standardSubmit'
   */
  public native function get standardSubmit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set standardSubmit(value:Boolean):void;

  [ExtConfig]
  /**
   * Timeout for form actions in seconds.
   * @default 30
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-timeout Original Ext JS documentation of 'timeout'
   */
  public native function get timeout():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  [ExtConfig]
  /**
   * If set to true, →<code>reset()</code>() resets to the last loaded or
   * →<code>ext.form.BasicForm.setValues()</code>() data instead of when the form was first
   * created.
   * @default false
   * @see #reset()
   * @see ext.form.BasicForm#setValues()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-trackResetOnLoad Original Ext JS documentation of 'trackResetOnLoad'
   */
  public native function get trackResetOnLoad():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trackResetOnLoad(value:Boolean):void;

  [ExtConfig]
  /**
   * The URL to use for form actions if one isn't supplied in the
   * →<code>ext.form.BasicForm.doAction()</code> options.
   * @see ext.form.BasicForm#doAction()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:String):void;

  [ExtConfig]
  /**
   * By default wait messages are displayed with Ext.MessageBox.wait. You can target a specific
   * element by passing it or its id or mask the form itself by passing in true.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-waitMsgTarget Original Ext JS documentation of 'waitMsgTarget'
   */
  public native function get waitMsgTarget():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitMsgTarget(value:*):void;

  [ExtConfig]
  /**
   * The default title to show for the waiting message box
   * @default 'Please Wait...'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#cfg-waitTitle Original Ext JS documentation of 'waitTitle'
   */
  public native function get waitTitle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitTitle(value:String):void;

  /**
   * Forces each field within the form panel to
   * <i>check if its value has changed</i> (→<code>ext.form.field.Field.checkChange()</code>).
   * @see ext.form.field.Field#checkChange()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-checkChange Original Ext JS documentation of 'checkChange'
   */
  public native function checkChange():void;

  /**
   * Provides access to the <i>Form</i> (→<code>ext.form.BasicForm</code>) which this Panel contains.
   * @return The <i>Form</i> (→<code>ext.form.BasicForm</code>) which this Panel contains.
   * @see ext.form.BasicForm
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-getForm Original Ext JS documentation of 'getForm'
   */
  public native function getForm():BasicForm;

  /**
   * Returns the currently loaded Ext.data.Model instance if one was loaded via
   * →<code>loadRecord()</code>.
   * @return The loaded instance
   * @see #loadRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-getRecord Original Ext JS documentation of 'getRecord'
   */
  public native function getRecord():Model;

  /**
   * Convenience function for fetching the current value of each field in the form.
   * This is the same as calling <i>this.getForm().getValues()</i> (→<code>ext.form.BasicForm.getValues()</code>).
   * Retrieves the fields in the form as a set of key/value pairs, using their
   * →<code>ext.form.field.Field.getSubmitData()</code> method to collect the values.
   * If multiple fields return values under the same name those values will be combined
   * into an Array. This is similar to →<code>ext.form.BasicForm.getFieldValues()</code>
   * except that this method collects only String values for submission, while getFieldValues
   * collects type-specific data values (e.g. Date objects for date fields.)
   * @param asString If true, will return the key/value collection as a single
   * URL-encoded param string.
   * @default false
   * @see ext.form.BasicForm#getValues()
   * @see ext.form.field.Field#getSubmitData()
   * @see ext.form.BasicForm#getFieldValues()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-getValues Original Ext JS documentation of 'getValues'
   */
  public native function getValues(asString:Boolean = false, dirtyOnly:* = undefined, includeEmptyText:* = undefined, useDataValues:* = undefined):*;

  /**
   * Convenience function to check if the form has any invalid fields. This is the same as calling
   * <i>this.getForm().hasInvalidField()</i> (→<code>ext.form.BasicForm.hasInvalidField()</code>).
   * Returns true if the form contains any invalid fields. No fields will be marked as invalid
   * as a result of calling this; to trigger marking of fields use →<code>isValid()</code> instead.
   * @see ext.form.BasicForm#hasInvalidField()
   * @see #isValid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-hasInvalidField Original Ext JS documentation of 'hasInvalidField'
   */
  public native function hasInvalidField():void;

  /**
   * Initializes the FieldAncestor's state; this must be called from the initComponent method
   * of any components importing this mixin.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-initFieldAncestor Original Ext JS documentation of 'initFieldAncestor'
   */
  protected native function initFieldAncestor():void;

  /**
   * Convenience function to check if the form has any dirty fields. This is the same as calling
   * <i>this.getForm().isDirty()</i> (→<code>ext.form.BasicForm.isDirty()</code>).
   * Returns <code>true</code> if any fields in this form have changed from their original values.
   * <p>Note that if this BasicForm was configured with →<code>ext.form.BasicForm.trackResetOnLoad</code> then the Fields' <i>original values</i> are updated when the values are
   * loaded by →<code>ext.form.BasicForm.setValues()</code> or →<code>loadRecord()</code>. This means
   * that:</p>
   * <ul>
   * <li>→<code>trackResetOnLoad</code>: <code>false</code> -&gt; Will return <code>true</code> after calling this method.</li>
   * <li>→<code>trackResetOnLoad</code>: <code>true</code> -&gt; Will return <code>false</code> after calling this method.</li>
   * </ul>
   * @see ext.form.BasicForm#isDirty()
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see ext.form.BasicForm#setValues()
   * @see #loadRecord()
   * @see #trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-isDirty Original Ext JS documentation of 'isDirty'
   */
  public native function isDirty():Boolean;

  /**
   * Convenience function to check if the form has all valid fields. This is the same as calling
   * <i>this.getForm().isValid()</i> (→<code>ext.form.BasicForm.isValid()</code>).
   * Returns true if client-side validation on the form is successful. Any invalid fields will be
   * marked as invalid. If you only want to determine overall form validity without marking
   * anything, use →<code>hasInvalidField()</code> instead.
   * @see ext.form.BasicForm#isValid()
   * @see #hasInvalidField()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-isValid Original Ext JS documentation of 'isValid'
   */
  public native function isValid():Boolean;

  /**
   * This is a proxy for the underlying BasicForm's →<code>ext.form.BasicForm.load()</code> call.
   * @param options The options to pass to the action (see →<code>ext.form.BasicForm.load()</code>
   * and →<code>ext.form.BasicForm.doAction()</code> for details)
   * @see ext.form.BasicForm#load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-load Original Ext JS documentation of 'load'
   * @see ext.form.BasicForm#doAction()
   */
  public native function load(options:*):Panel;

  /**
   * Loads an →<code>ext.data.Model</code> into this form (internally just calls
   * →<code>ext.form.BasicForm.loadRecord()</code>).
   * See also →<code>ext.form.BasicForm.trackResetOnLoad</code>. The fields in the model
   * are mapped to fields in the form by matching either the →<code>ext.form.field.BaseField.name</code>
   * or →<code>ext.Component.itemId</code>.
   * @param record The record to load
   * @return The Ext.form.Basic attached to this FormPanel
   * @see ext.data.Model
   * @see ext.form.BasicForm#loadRecord()
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see ext.form.field.BaseField#name
   * @see ext.Component#itemId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-loadRecord Original Ext JS documentation of 'loadRecord'
   */
  public native function loadRecord(record:Model):BasicForm;

  /**
   * Fired when the error message of any field within the container changes.
   * @param field The sub-field whose active error changed
   * @param error The new active error message
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldErrorChange Original Ext JS documentation of 'onFieldErrorChange'
   */
  protected native function onFieldErrorChange(field:Labelable, error:String):void;

  /**
   * Fired when the validity of any field within the container changes.
   * @param field The sub-field whose validity changed
   * @param valid The new validity state
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#method-onFieldValidityChange Original Ext JS documentation of 'onFieldValidityChange'
   */
  protected native function onFieldValidityChange(field:Field, valid:Boolean):void;

  /**
   * Convenience function reset the form. This is the same as calling
   * <i>this.getForm().reset()</i> (→<code>ext.form.BasicForm.reset()</code>).
   * Resets all fields in this form. By default, any record bound by →<code>loadRecord()</code>
   * will be retained.
   * @param resetRecord True to unbind any record set
   * by →<code>loadRecord()</code>
   * @default false
   * @return this
   * @see ext.form.BasicForm#reset()
   * @see #loadRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-reset Original Ext JS documentation of 'reset'
   */
  public native function reset(resetRecord:Boolean = false):BasicForm;

  /**
   * Start an interval task to continuously poll all the fields in the form for changes in their
   * values. This is normally started automatically by setting the →<code>pollForChanges</code> config.
   * @param interval The interval in milliseconds at which the check should run.
   * @see #pollForChanges
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-startPolling Original Ext JS documentation of 'startPolling'
   */
  public native function startPolling(interval:Number):void;

  /**
   * Stop a running interval task that was started by →<code>startPolling()</code>.
   * @see #startPolling()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-stopPolling Original Ext JS documentation of 'stopPolling'
   */
  public native function stopPolling():void;

  /**
   * This is a proxy for the underlying BasicForm's →<code>ext.form.BasicForm.submit()</code> call.
   * @param options The options to pass to the action (see →<code>ext.form.BasicForm.submit()</code>
   * and →<code>ext.form.BasicForm.doAction()</code> for details)
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-submit Original Ext JS documentation of 'submit'
   * @see ext.form.BasicForm#doAction()
   */
  public native function submit(options:Object):void;

  /**
   * Persists the values in this form into the passed →<code>ext.data.Model</code> object
   * in a beginEdit/endEdit block. If the record is not specified, it will attempt to update
   * (if it exists) the record provided to →<code>loadRecord()</code>.
   * @param record The record to edit
   * @return The Ext.form.Basic attached to this FormPanel
   * @see ext.data.Model
   * @see #loadRecord()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#method-updateRecord Original Ext JS documentation of 'updateRecord'
   */
  public native function updateRecord(record:Model = null):BasicForm;
}
}