package ext.form {
import ext.Component;

[Native("Ext.form.Label", require)]
/**
 * Produces a standalone <code>&lt;label /&gt;</code> element which can be inserted into a form and be associated
 * with a field in that form using the →<code>forId</code> property.
 * <p><b>NOTE:</b> in most cases it will be more appropriate to use the
 * →<code>ext.form.Labelable.fieldLabel</code> and associated config properties
 * (→<code>ext.form.Labelable.labelAlign</code>, →<code>ext.form.Labelable.labelWidth</code>, etc.)
 * in field components themselves, as that allows labels to be uniformly sized throughout the form.
 * Ext.form.Label should only be used when your layout can not be achieved with the standard
 * <i>field layout</i> (→<code>ext.form.Labelable</code>).</p>
 * <p>You will likely be associating the label with a field component that extends
 * →<code>ext.form.field.BaseField</code>, so you should make sure the →<code>forId</code> is set to the same value
 * as the →<code>ext.form.field.BaseField.inputId</code> of that field.</p>
 * <p>The label's text can be set using either the →<code>text</code> or →<code>html</code> configuration
 * properties; the difference between the two is that the former will automatically escape HTML
 * characters when rendering, while the latter will not.</p>
 * <p><b>Example</b></p>
 * <p>This example creates a Label after its associated Text field, an arrangement that cannot
 * currently be achieved using the standard Field layout's labelAlign.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Field with Label',
 *     width: 400,
 *     bodyPadding: 10,
 *     renderTo: Ext.getBody(),
 *     layout: {
 *         type: 'hbox',
 *         align: 'middle'
 *     },
 *     items: [{
 *         xtype: 'textfield',
 *         hideLabel: true,
 *         flex: 1
 *     }, {
 *         xtype: 'label',
 *         forId: 'myFieldId',
 *         text: 'My Awesome Field',
 *         margin: '0 0 0 10'
 *     }]
 * });
 * </pre>
 * @see #forId
 * @see ext.form.Labelable#fieldLabel
 * @see ext.form.Labelable#labelAlign
 * @see ext.form.Labelable#labelWidth
 * @see ext.form.Labelable
 * @see ext.form.field.BaseField
 * @see ext.form.field.BaseField#inputId
 * @see #text
 * @see #html
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Label.html Original Ext JS documentation of 'Ext.form.Label'
 */
public class Label extends Component {
  /**
   * @param config @inheritDoc
   */
  public function Label(config:Label = null) {
    super();
  }

  [ExtConfig]
  /**
   * The id of the input element to which this label will be bound via the standard HTML 'for'
   * attribute. If not specified, the attribute will not be added to the label. In most cases
   * you will be associating the label with a →<code>ext.form.field.BaseField</code> component,
   * so you should make sure this matches the →<code>ext.form.field.BaseField.inputId</code>
   * of that field.
   * @see ext.form.field.BaseField
   * @see ext.form.field.BaseField#inputId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Label.html#cfg-forId Original Ext JS documentation of 'forId'
   */
  public native function get forId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set forId(value:String):void;

  [ExtConfig]
  /**
   * An HTML fragment that will be used as the label's innerHTML.
   * Note that if →<code>text</code> is specified it will take precedence and this value
   * will be ignored.
   * @default ''
   * @see #text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Label.html#cfg-html Original Ext JS documentation of 'html'
   * @see #setHtml()
   */
  override public native function get html():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set html(value:*):void;

  [ExtConfig]
  /**
   * The plain text to display within the label. If you need to include HTML
   * tags within the label's innerHTML, use the →<code>html</code> config instead.
   * @default ''
   * @see #html
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Label.html#cfg-text Original Ext JS documentation of 'text'
   * @see #setText()
   */
  public native function get text():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set text(value:String):void;

  /**
   * Updates the label's innerHTML with the specified string.
   * @param text The new label text
   * @param encode False to skip HTML-encoding the text when rendering it
   * to the label. This might be useful if you want to include tags in the label's innerHTML
   * rather than rendering them as string literals per the default logic.
   * @default true
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Label.html#method-setText Original Ext JS documentation of 'setText'
   */
  public native function setText(text:String, encode:Boolean = true):Label;
}
}