package ext.form {
import ext.Mixin;
import ext.dom.Element;

[Native("Ext.form.Labelable", require)]
[ExtConfig]
/**
 * @see ext.form.events.Labelable_errorEvent.ERROR_CHANGE
 * @eventType ext.form.events.Labelable_errorEvent.ERROR_CHANGE
 */
[Event(name='onErrorChange', type='ext.form.events.Labelable_errorEvent')]
/**
 * A mixin which allows a component to be configured and decorated with a label and/or error message
 * as is common for form fields. This is used by e.g. Ext.form.field.Base and
 * Ext.form.FieldContainer to let them be managed by the Field layout.
 * <p>NOTE: This mixin is mainly for internal library use and most users should not need to use it
 * directly. It is more likely you will want to use one of the component classes that import
 * this mixin, such as Ext.form.field.Base or Ext.form.FieldContainer.</p>
 * <p>Use of this mixin does not make a component a field in the logical sense, meaning it does not
 * provide any logic or state related to values or validation; that is handled by the related
 * Ext.form.field.Field mixin. These two mixins may be used separately
 * (for example Ext.form.FieldContainer is Labelable but not a Field), or in combination
 * (for example Ext.form.field.Base implements both and has logic for connecting the two.)</p>
 * <p>Component classes which use this mixin should use the Field layout
 * or a derivation thereof to properly size and position the label and message according to the
 * component config. They must also call the →<code>initLabelable()</code> method during component
 * initialization to ensure the mixin gets set up correctly.</p>
 * @see #initLabelable()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html Original Ext JS documentation of 'Ext.form.Labelable'
 */
public class Labelable extends Mixin implements ILabelable {
  /**
   * @param config @inheritDoc
   */
  public function Labelable(config:Labelable = null) {
    super();
  }

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * If specified, then the component will be displayed with this value as its active error
   * when first rendered. Use →<code>setActiveError()</code> or →<code>unsetActiveError()</code> to change it
   * after component creation.
   * @see #setActiveError()
   * @see #unsetActiveError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-activeError Original Ext JS documentation of 'activeError'
   * @see #getActiveError()
   */
  public native function get activeError():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set activeError(value:String):void;

  [ExtConfig]
  /**
   * The template used to format the Array of error messages passed to →<code>setActiveErrors()</code>
   * into a single HTML string. if the →<code>msgTarget</code> is title, it defaults to a list
   * separated by new lines. Otherwise, it renders each message as an item in an unordered list.
   * @see #setActiveErrors()
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-activeErrorsTpl Original Ext JS documentation of 'activeErrorsTpl'
   */
  public native function get activeErrorsTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeErrorsTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * at the end of the input containing element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterBodyEl Original Ext JS documentation of 'afterBodyEl'
   */
  public native function get afterBodyEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterBodyEl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the label text. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterLabelTextTpl Original Ext JS documentation of 'afterLabelTextTpl'
   */
  public native function get afterLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the label element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterLabelTpl Original Ext JS documentation of 'afterLabelTpl'
   */
  public native function get afterLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the <i>subTpl markup</i> (→<code>getSubTplMarkup()</code>). If an <code>XTemplate</code> is used, the
   * component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see #getSubTplMarkup()
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterSubTpl Original Ext JS documentation of 'afterSubTpl'
   */
  public native function get afterSubTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterSubTpl(value:*):void;

  [ExtConfig]
  /**
   * Localized announcement text for validation errors. This text
   * will be used by Assistive Technologies such as screen readers to alert the users when
   * field validation fails.
   * <p>This config is used with →<code>ext.StringUtil.format()</code>. '{0}' will be replaced with the actual
   * error message(s), '{1}' will be replaced with field label.</p>
   * @default 'Input error. {0}.'
   * @see ext.SStringUtil#format() ext.StringUtil.format()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-ariaErrorText Original Ext JS documentation of 'ariaErrorText'
   */
  public native function get ariaErrorText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaErrorText(value:String):void;

  [ExtConfig]
  /**
   * Optional text description for this object. This text will be
   * announced to Assistive Technology users when the object is focused.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-ariaHelp Original Ext JS documentation of 'ariaHelp'
   */
  public native function get ariaHelp():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaHelp(value:String):void;

  [ExtConfig]
  /**
   * Whether to adjust the component's body width to make room for 'side'
   * <i>error messages</i> (→<code>msgTarget</code>).
   * @default true
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-autoFitErrors Original Ext JS documentation of 'autoFitErrors'
   */
  public native function get autoFitErrors():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoFitErrors(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the body content element.
   * @default Ext.baseCSSPrefix + 'form-item-body'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-baseBodyCls Original Ext JS documentation of 'baseBodyCls'
   */
  public native function get baseBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseBodyCls(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * at the beginning of the input containing element. If an <code>XTemplate</code> is used,
   * the component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeBodyEl Original Ext JS documentation of 'beforeBodyEl'
   */
  public native function get beforeBodyEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeBodyEl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the label text. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeLabelTextTpl Original Ext JS documentation of 'beforeLabelTextTpl'
   */
  public native function get beforeLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the label element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeLabelTpl Original Ext JS documentation of 'beforeLabelTpl'
   */
  public native function get beforeLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the <i>subTpl markup</i> (→<code>getSubTplMarkup()</code>). If an <code>XTemplate</code> is used, the
   * component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see #getSubTplMarkup()
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeSubTpl Original Ext JS documentation of 'beforeSubTpl'
   */
  public native function get beforeSubTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeSubTpl(value:*):void;

  /**
   * The div Element wrapping the component's contents. Only available after
   * the component has been rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#property-bodyEl Original Ext JS documentation of 'bodyEl'
   */
  public native function get bodyEl():Element;

  /**
   * @private
   */
  public native function set bodyEl(value:Element):void;

  /**
   * The div Element that will contain the component's error message(s). Note that
   * depending on the configured →<code>msgTarget</code>, this element may be hidden
   * in favor of some other form of presentation, but will always be present in the DOM
   * for use by assistive technologies.
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#property-errorEl Original Ext JS documentation of 'errorEl'
   */
  public native function get errorEl():Element;

  /**
   * @private
   */
  public native function set errorEl(value:Element):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the error message element.
   * @default Ext.baseCSSPrefix + 'form-error-msg'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-errorMsgCls Original Ext JS documentation of 'errorMsgCls'
   */
  public native function get errorMsgCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set errorMsgCls(value:String):void;

  [ExtConfig]
  /**
   * An extra CSS class to be applied to the body content element in addition to
   * →<code>baseBodyCls</code>.
   * @default ''
   * @see #baseBodyCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-fieldBodyCls Original Ext JS documentation of 'fieldBodyCls'
   */
  public native function get fieldBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldBodyCls(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The label for the field. It gets appended with the →<code>labelSeparator</code>, and its position
   * and sizing is determined by the →<code>labelAlign</code> and →<code>labelWidth</code> configs.
   * @default undefined
   * @see #labelSeparator
   * @see #labelAlign
   * @see #labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-fieldLabel Original Ext JS documentation of 'fieldLabel'
   * @see #getFieldLabel()
   * @see #setFieldLabel()
   */
  public native function get fieldLabel():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set fieldLabel(value:String):void;

  [ExtConfig]
  /**
   * A CSS class to be applied to the outermost element to denote that it is participating
   * in the form field layout.
   * @default Ext.baseCSSPrefix + 'form-item'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-formItemCls Original Ext JS documentation of 'formItemCls'
   */
  public native function get formItemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formItemCls(value:String):void;

  [ExtConfig]
  /**
   * When set to true, the label element (→<code>fieldLabel</code> and →<code>labelSeparator</code>)
   * will be automatically hidden if the →<code>fieldLabel</code> is empty. Setting this to false
   * will cause the empty label element to be rendered and space to be reserved for it;
   * this is useful if you want a field without a label to line up with other labeled fields
   * in the same form.
   * <p>If you wish to unconditionall hide the label even if a non-empty fieldLabel is configured,
   * then set the →<code>hideLabel</code> config to true.</p>
   * @default true
   * @see #fieldLabel
   * @see #labelSeparator
   * @see #hideLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-hideEmptyLabel Original Ext JS documentation of 'hideEmptyLabel'
   */
  public native function get hideEmptyLabel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideEmptyLabel(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to true to completely hide the label element (→<code>fieldLabel</code> and
   * →<code>labelSeparator</code>). Also see →<code>hideEmptyLabel</code>, which controls whether space
   * will be reserved for an empty fieldLabel.
   * @default false
   * @see #fieldLabel
   * @see #labelSeparator
   * @see #hideEmptyLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-hideLabel Original Ext JS documentation of 'hideLabel'
   */
  public native function get hideLabel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideLabel(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class to use when marking the component invalid.
   * @default Ext.baseCSSPrefix + 'form-invalid'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-invalidCls Original Ext JS documentation of 'invalidCls'
   */
  public native function get invalidCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set invalidCls(value:String):void;

  /**
   * Flag denoting that this object is labelable as a field. Always true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#property-isFieldLabelable Original Ext JS documentation of 'isFieldLabelable'
   */
  public native function get isFieldLabelable():Boolean;

  /**
   * @private
   */
  public native function set isFieldLabelable(value:Boolean):void;

  [ExtConfig]
  /**
   * Controls the position and alignment of the →<code>fieldLabel</code>. Valid values are:
   * <ul>
   * <li>"left" (the default) - The label is positioned to the left of the field, with its text
   * aligned to the left. Its width is determined by the →<code>labelWidth</code> config.</li>
   * <li>"top" - The label is positioned above the field.</li>
   * <li>"right" - The label is positioned to the left of the field, with its text aligned
   * to the right. Its width is determined by the →<code>labelWidth</code> config.</li>
   * </ul>
   * @default 'left'
   * @see #fieldLabel
   * @see #labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelAlign Original Ext JS documentation of 'labelAlign'
   */
  public native function get labelAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelAlign(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * inside the label element (as attributes). If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelAttrTpl Original Ext JS documentation of 'labelAttrTpl'
   */
  public native function get labelAttrTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelAttrTpl(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the label element. This (single) CSS class is used
   * to formulate the renderSelector and drives the field layout where it is concatenated
   * with a hyphen ('-') and →<code>labelAlign</code>. To add additional classes, use
   * →<code>labelClsExtra</code>.
   * @default Ext.baseCSSPrefix + 'form-item-label'
   * @see #labelAlign
   * @see #labelClsExtra
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelCls Original Ext JS documentation of 'labelCls'
   */
  public native function get labelCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelCls(value:String):void;

  [ExtConfig]
  /**
   * An optional string of one or more additional CSS classes to add to the label element.
   * Defaults to empty.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelClsExtra Original Ext JS documentation of 'labelClsExtra'
   */
  public native function get labelClsExtra():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelClsExtra(value:String):void;

  /**
   * The label Element for this component. Only available after the component
   * has been rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#property-labelEl Original Ext JS documentation of 'labelEl'
   */
  public native function get labelEl():Element;

  /**
   * @private
   */
  public native function set labelEl(value:Element):void;

  [ExtConfig]
  /**
   * The amount of space in pixels between the →<code>fieldLabel</code> and the field body.
   * This defaults to <code>5</code> for compatibility with Ext JS 4, however, as of Ext JS 5
   * the space between the label and the body can optionally be determined by the theme
   * using the →<code>style:$form-label-horizontal-spacing</code> (for side-aligned labels) and
   * →<code>style:$form-label-vertical-spacing</code> (for top-aligned labels) SASS variables.
   * In order for the stylesheet values as to take effect, you must use a labelPad value
   * of <code>null</code>.
   * @default 5
   * @see #fieldLabel
   * @see #style:$form-label-horizontal-spacing
   * @see #style:$form-label-vertical-spacing
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelPad Original Ext JS documentation of 'labelPad'
   */
  public native function get labelPad():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelPad(value:Number):void;

  [ExtConfig]
  /**
   * Character(s) to be inserted at the end of the <i>label text</i> (→<code>fieldLabel</code>).
   * <p>Set to empty string to hide the separator completely.</p>
   * @default ':'
   * @see #fieldLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelSeparator Original Ext JS documentation of 'labelSeparator'
   */
  public native function get labelSeparator():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelSeparator(value:String):void;

  [ExtConfig]
  /**
   * A CSS style specification string to apply directly to this field's label.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelStyle Original Ext JS documentation of 'labelStyle'
   */
  public native function get labelStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelStyle(value:String):void;

  [ExtConfig]
  /**
   * The width of the →<code>fieldLabel</code> in pixels. Only applicable if →<code>labelAlign</code>
   * is set to "left" or "right".
   * @default 100
   * @see #fieldLabel
   * @see #labelAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelWidth Original Ext JS documentation of 'labelWidth'
   */
  public native function get labelWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelWidth(value:Number):void;

  [ExtConfig]
  /**
   * The location where the error message text should display. Must be one of the following
   * values:
   * <ul>
   * <li>
   * <p><code>qtip</code> Display a quick tip containing the message when the user hovers over the field.
   * This is the default.</p>
   * <p><b>→<code>ext.tip.QuickTipManager.init()</code> must have been called for this setting to work.</b></p>
   * </li>
   * <li>
   * <p><code>title</code> Display the message in a default browser title attribute popup.</p>
   * </li>
   * <li>
   * <p><code>under</code> Add a block div beneath the field containing the error message.</p>
   * </li>
   * <li>
   * <p><code>side</code> Add an error icon to the right of the field, displaying the message in a popup
   * on hover.</p>
   * </li>
   * <li>
   * <p><code>none</code> Don't display any error message. This might be useful if you are implementing
   * custom error display.</p>
   * </li>
   * <li>
   * <p><code>[element id]</code> Add the error message directly to the innerHTML of the specified element.</p>
   * </li>
   * </ul>
   * @default 'qtip'
   * @see ext.tip.SQuickTipManager#init() ext.tip.QuickTipManager.init()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-msgTarget Original Ext JS documentation of 'msgTarget'
   */
  public native function get msgTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set msgTarget(value:String):void;

  [ExtConfig]
  /**
   * true to disable displaying any <i>error message</i> (→<code>setActiveError()</code>) set on this object.
   * @default false
   * @see #setActiveError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-preventMark Original Ext JS documentation of 'preventMark'
   */
  public native function get preventMark():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventMark(value:Boolean):void;

  /**
   * Gets the active error message for this component, if any. This does not trigger validation
   * on its own, it merely returns any message that the component may already hold.
   * @return The active error message on the component; if there is no error,
   * an empty string is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getActiveError Original Ext JS documentation of 'getActiveError'
   */
  public native function getActiveError():String;

  [ArrayElementType("String")]
  /**
   * Gets an Array of any active error messages currently applied to the field. This does not
   * trigger validation on its own, it merely returns any messages that the component
   * may already hold.
   * @return The active error messages on the component; if there are no errors,
   * an empty Array is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getActiveErrors Original Ext JS documentation of 'getActiveErrors'
   */
  public native function getActiveErrors():Array;

  /**
   * Returns the label for the field. Defaults to simply returning the →<code>fieldLabel</code> config.
   * Can be overridden to provide a custom generated label.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @return The configured field label, or empty string if not defined
   * @see #fieldLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getFieldLabel Original Ext JS documentation of 'getFieldLabel'
   */
  public native function getFieldLabel():String;

  /**
   * Get the input id, if any, for this component. This is used as the "for" attribute on the
   * label element. Implementing subclasses may also use this as e.g. the id for their own
   * input element.
   * @return The input id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getInputId Original Ext JS documentation of 'getInputId'
   */
  public native function getInputId():String;

  /**
   * Generates the arguments for the field decorations <i>rendering template</i> (→<code>labelableRenderTpl</code>).
   * @param data optional object to use as the base data object. If provided,
   * this method will add properties to the base object instead of creating a new one.
   * @return The template arguments
   * @see #labelableRenderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getLabelableRenderData Original Ext JS documentation of 'getLabelableRenderData'
   */
  protected native function getLabelableRenderData(data:Object):Object;

  /**
   * Gets the markup to be inserted into the outer template's bodyEl. Defaults to empty string,
   * should be implemented by classes including this mixin as needed.
   * @return The markup to be inserted
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getSubTplMarkup Original Ext JS documentation of 'getSubTplMarkup'
   */
  protected native function getSubTplMarkup():String;

  /**
   * Tells whether the field currently has an active error message. This does not trigger
   * validation on its own, it merely looks for any message that the component may already hold.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-hasActiveError Original Ext JS documentation of 'hasActiveError'
   */
  public native function hasActiveError():Boolean;

  /**
   * Checks if the field has a visible label
   * @return True if the field has a visible label
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-hasVisibleLabel Original Ext JS documentation of 'hasVisibleLabel'
   */
  public native function hasVisibleLabel():Boolean;

  /**
   * Performs initialization of this mixin. Component classes using this mixin should call
   * this method during their own initialization.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-initLabelable Original Ext JS documentation of 'initLabelable'
   */
  public native function initLabelable():void;

  /**
   * Sets the active error message to the given string. This replaces the entire error message
   * contents with the given string. Also see →<code>setActiveErrors()</code> which accepts an Array
   * of messages and formats them according to the →<code>activeErrorsTpl</code>. Note that this only
   * updates the error message element's text and attributes, you'll have to call
   * doComponentLayout to actually update the field's layout to match. If the field extends
   * →<code>ext.form.field.BaseField</code> you should call
   * →<code>ext.form.field.BaseField.markInvalid()</code> instead.
   * @param msg The error message
   * @see #setActiveErrors()
   * @see #activeErrorsTpl
   * @see ext.form.field.BaseField
   * @see ext.form.field.BaseField#markInvalid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-setActiveError Original Ext JS documentation of 'setActiveError'
   */
  public native function setActiveError(msg:String):void;

  /**
   * Set the active error message to an Array of error messages. The messages are formatted
   * into a single message string using the →<code>activeErrorsTpl</code>. Also see
   * →<code>setActiveError()</code> which allows setting the entire error contents with a single string.
   * Note that this only updates the error message element's text and attributes, you'll have to
   * call doComponentLayout to actually update the field's layout to match. If the field extends
   * →<code>ext.form.field.BaseField</code> you should call
   * →<code>ext.form.field.BaseField.markInvalid()</code> instead.
   * @param errors The error messages
   * @see #activeErrorsTpl
   * @see #setActiveError()
   * @see ext.form.field.BaseField
   * @see ext.form.field.BaseField#markInvalid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-setActiveErrors Original Ext JS documentation of 'setActiveErrors'
   */
  public native function setActiveErrors(errors:Array):void;

  /**
   * Applies a set of default configuration values to this Labelable instance. For each
   * of the properties in the given object, check if this component hasOwnProperty that config;
   * if not then it's inheriting a default value from its prototype and we should apply
   * the default value.
   * @param defaults The defaults to apply to the object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-setFieldDefaults Original Ext JS documentation of 'setFieldDefaults'
   */
  public native function setFieldDefaults(defaults:Object):void;

  /**
   * Set the label of this field.
   * @param label The new label. The →<code>labelSeparator</code> will be automatically
   * appended to the label string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-setFieldLabel Original Ext JS documentation of 'setFieldLabel'
   * @see #labelSeparator
   */
  public native function setFieldLabel(label:String):void;

  /**
   * Returns the trimmed label by slicing off the label separator character. Can be overridden.
   * @return The trimmed field label, or empty string if not defined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-trimLabelSeparator Original Ext JS documentation of 'trimLabelSeparator'
   */
  public native function trimLabelSeparator():String;

  /**
   * Clears the active error message(s). Note that this only clears the error message element's
   * text and attributes, you'll have to call doComponentLayout to actually update the field's
   * layout to match. If the field extends →<code>ext.form.field.BaseField</code> you should call
   * →<code>ext.form.field.BaseField.clearInvalid()</code> instead.
   * @see ext.form.field.BaseField
   * @see ext.form.field.BaseField#clearInvalid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-unsetActiveError Original Ext JS documentation of 'unsetActiveError'
   */
  public native function unsetActiveError():void;
}
}