package ext.form {
import ext.form.field.IField;

[Native("Ext.form.RadioGroup", require)]
/**
 * A <i>field container</i> (→<code>ext.form.FieldContainer</code>) which has a specialized layout for arranging
 * →<code>ext.form.field.Radio</code> controls into columns, and provides convenience
 * →<code>ext.form.field.Field</code> methods for <i>getting</i> (→<code>getValue()</code>), <i>setting</i> (→<code>setValue()</code>),
 * and <i>validating</i> (→<code>validate()</code>) the group of radio buttons as a whole.
 * <p><b><i>Validation</i></b></p>
 * <p>Individual radio buttons themselves have no default validation behavior, but
 * sometimes you want to require a user to select one of a group of radios. RadioGroup
 * allows this by setting the config <code>→allowBlank:false</code>; when the user does not check at
 * one of the radio buttons, the entire group will be highlighted as invalid and the
 * <i>error message</i> (→<code>blankText</code>) will be displayed according to the →<code>msgTarget</code> config.</p>
 * <p><b><i>Layout</i></b></p>
 * <p>The default layout for RadioGroup makes it easy to arrange the radio buttons into
 * columns; see the →<code>columns</code> and →<code>vertical</code> config documentation for details.
 * You may also use a completely different layout by setting the →<code>layout</code> to one of the
 * other supported layout types; for instance you may wish to use a custom arrangement
 * of hbox and vbox containers. In that case the Radio components at any depth will
 * still be managed by the RadioGroup's validation.</p>
 * <p><b><i>Example usage</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'RadioGroup Example',
 *     width: 300,
 *     bodyPadding: 10,
 *     renderTo: Ext.getBody(),
 *     items:[{
 *         xtype: 'radiogroup',
 *         fieldLabel: 'Two Columns',
 *         // Arrange radio buttons into two columns, distributed vertically
 *         columns: 2,
 *         vertical: true,
 *         items: [
 *             { boxLabel: 'Item 1', name: 'rb', inputValue: '1' },
 *             { boxLabel: 'Item 2', name: 'rb', inputValue: '2', checked: true},
 *             { boxLabel: 'Item 3', name: 'rb', inputValue: '3' },
 *             { boxLabel: 'Item 4', name: 'rb', inputValue: '4' },
 *             { boxLabel: 'Item 5', name: 'rb', inputValue: '5' },
 *             { boxLabel: 'Item 6', name: 'rb', inputValue: '6' }
 *         ]
 *     }]
 * });
 * </pre>
 * <p><b><i>Example with value binding to the RadioGroup. In the below example, "Item 2" will</i></b></p>
 * <p>initially be checked using <code>myValue: '2'</code> from the ViewModel.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('MyApp.main.view.Main', {
 *     extend: 'Ext.app.ViewModel',
 *     alias: 'viewmodel.main',
 *     data: {
 *         myValue: '2'
 *     }
 * });
 *
 * Ext.create('Ext.form.Panel', {
 *     title: 'RadioGroup Example',
 *     viewModel: {
 *         type: 'main'
 *     },
 *     width: 300,
 *     bodyPadding: 10,
 *     renderTo: Ext.getBody(),
 *     items:[{
 *         xtype: 'radiogroup',
 *         fieldLabel: 'Two Columns',
 *         // Arrange radio buttons into two columns, distributed vertically
 *         columns: 2,
 *         vertical: true,
 *         simpleValue: true,  // set simpleValue to true to enable value binding
 *         bind: '{myValue}',
 *         items: [
 *             { boxLabel: 'Item 1', name: 'rb', inputValue: '1' },
 *             { boxLabel: 'Item 2', name: 'rb', inputValue: '2' },
 *             { boxLabel: 'Item 3', name: 'rb', inputValue: '3' },
 *             { boxLabel: 'Item 4', name: 'rb', inputValue: '4' },
 *             { boxLabel: 'Item 5', name: 'rb', inputValue: '5' },
 *             { boxLabel: 'Item 6', name: 'rb', inputValue: '6' }
 *         ]
 *     }]
 * });
 * </pre>
 * @see ext.form.FieldContainer
 * @see ext.form.field.Radio
 * @see ext.form.field.Field
 * @see #getValue()
 * @see #setValue()
 * @see #validate()
 * @see #allowBlank
 * @see #blankText
 * @see #msgTarget
 * @see #columns
 * @see #vertical
 * @see #layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html Original Ext JS documentation of 'Ext.form.RadioGroup'
 */
public class RadioGroup extends CheckboxGroup {
  /**
   * @param config @inheritDoc
   */
  public function RadioGroup(config:RadioGroup = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to allow every item in the group to be blank.
   * If allowBlank = false and no items are selected at validation time,
   * →<code>blankText</code> will be used as the error text.
   * @default true
   * @see #blankText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#cfg-allowBlank Original Ext JS documentation of 'allowBlank'
   */
  override public native function get allowBlank():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set allowBlank(value:Boolean):void;

  [ExtConfig]
  /**
   * Error text to display if the →<code>allowBlank</code> validation fails
   * @default 'You must select one item in this group'
   * @see #allowBlank
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#cfg-blankText Original Ext JS documentation of 'blankText'
   */
  override public native function get blankText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set blankText(value:String):void;

  /**
   * The value <code>true</code> to identify an object as an instance of this or derived class.
   * @default true
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#property-isRadioGroup Original Ext JS documentation of 'isRadioGroup'
   */
  public native function get isRadioGroup():Boolean;

  [ExtConfig]
  /**
   * An Array of →<code>ext.form.field.Radio</code>s or Radio config objects to arrange
   * in the group.
   * @see ext.form.field.Radio
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#cfg-items Original Ext JS documentation of 'items'
   */
  override public native function get items():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set items(value:Array):void;

  [ExtConfig]
  /**
   * By default, child <i>radio</i> (→<code>ext.form.field.Radio</code>) <code>→name</code>s are scoped to the
   * encapsulating <i>form panel</i> (→<code>ext.form.FormPanel</code>) if any, of the document.
   * <p>If you are using multiple <code>RadioGroup</code>s each of which uses the same <code>→name</code>
   * configuration in child <i>radio</i> (→<code>ext.form.field.Radio</code>)s, configure this as
   * <code>true</code> to scope the names to within this <code>RadioGroup</code></p>
   * @default false
   * @see ext.form.field.Radio
   * @see #name
   * @see ext.form.FormPanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#cfg-local Original Ext JS documentation of 'local'
   */
  public native function get local():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set local(value:Boolean):void;

  [ExtConfig]
  /**
   * When set to <code>true</code> the <code>→value</code> of this group of <code>radiofield</code> components will be
   * mapped to the <code>inputValue</code> of the checked item. This is, the <code>→getValue()</code> method
   * will return the <code>inputValue</code> of the checked item while <code>→setValue()</code> will check the
   * <code>radiofield</code> whose <code>inputValue</code> matches the given value.
   * <p>This field allows the <code>radiogroup</code> to participate in binding an entire group of
   * radio buttons to a single value.</p>
   * <p>In the below example, "Item 2" will initially be checked using <code>myValue: '2'</code> from
   * the ViewModel.</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.define('MyApp.main.view.Main', {
   *     extend: 'Ext.app.ViewModel',
   *     alias: 'viewmodel.main',
   *     data: {
   *         myValue: '2'
   *     }
   * });
   *
   * Ext.create('Ext.form.Panel', {
   *     title: 'RadioGroup Example',
   *     viewModel: {
   *         type: 'main'
   *     },
   *     width: 300,
   *     bodyPadding: 10,
   *     renderTo: Ext.getBody(),
   *     items:[{
   *         xtype: 'radiogroup',
   *         fieldLabel: 'Two Columns',
   *         // Arrange radio buttons into two columns, distributed vertically
   *         columns: 2,
   *         vertical: true,
   *         simpleValue: true,  // set simpleValue to true to enable value binding
   *         bind: '{myValue}',
   *         items: [
   *             { boxLabel: 'Item 1', name: 'rb', inputValue: '1' },
   *             { boxLabel: 'Item 2', name: 'rb', inputValue: '2' },
   *             { boxLabel: 'Item 3', name: 'rb', inputValue: '3' },
   *             { boxLabel: 'Item 4', name: 'rb', inputValue: '4' },
   *             { boxLabel: 'Item 5', name: 'rb', inputValue: '5' },
   *             { boxLabel: 'Item 6', name: 'rb', inputValue: '6' }
   *         ]
   *     }]
   * });
   * </pre>
   * @default false
   * @since 6.2.0
   * @see #value
   * @see #getValue()
   * @see #setValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#cfg-simpleValue Original Ext JS documentation of 'simpleValue'
   */
  public native function get simpleValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set simpleValue(value:Boolean):void;

  /**
   * Sets the value of the radio group. The radio with corresponding name and value will be set.
   * This method is simpler than →<code>ext.form.CheckboxGroup.setValue()</code> because only 1 value
   * is allowed for each name. You can use the setValue method as:
   * <pre>
   * var form = Ext.create('Ext.form.Panel', {
   *     title       : 'RadioGroup Example',
   *     width       : 300,
   *     bodyPadding : 10,
   *     renderTo    : Ext.getBody(),
   *     items       : [
   *         {
   *             xtype      : 'radiogroup',
   *             fieldLabel : 'Group',
   *             items      : [
   *                 { boxLabel : 'Item 1', name : 'rb', inputValue : 1 },
   *                 { boxLabel : 'Item 2', name : 'rb', inputValue : 2 }
   *             ]
   *         }
   *     ],
   *     tbar        : [
   *         {
   *             text    : 'setValue on RadioGroup',
   *             handler : function() {
   *                 form.child('radiogroup').setValue({
   *                     rb : 2
   *                 });
   *             }
   *         }
   *     ]
   * });
   * </pre>
   * @param value The value to set
   * @return this
   * @see ext.form.CheckboxGroup#setValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.RadioGroup.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;
}
}