package ext.form.action {
import ext.Base;
import ext.form.BasicForm;

[Native("Ext.form.action.Action", require)]
/**
 * The subclasses of this class provide actions to perform upon <i>Form</i> (→<code>ext.form.BasicForm</code>)s.
 * <p>Instances of this class are only created by a <i>Form</i> (→<code>ext.form.BasicForm</code>) when the Form needs
 * to perform an action such as submit or load. The Configuration options listed for this class
 * are set through the Form's action methods: →<code>ext.form.BasicForm.submit()</code>,
 * →<code>ext.form.BasicForm.load()</code> and →<code>ext.form.BasicForm.doAction()</code></p>
 * <p>The instance of Action which performed the action is passed to the success and failure callbacks
 * of the Form's action methods (→<code>ext.form.BasicForm.submit()</code>,
 * →<code>ext.form.BasicForm.load()</code> and →<code>ext.form.BasicForm.doAction()</code>), and to the
 * →<code>ext.form.BasicForm.event:onActionComplete</code> and
 * →<code>ext.form.BasicForm.event:onActionFailed</code> event handlers.</p>
 * @see ext.form.BasicForm
 * @see ext.form.BasicForm#submit()
 * @see ext.form.BasicForm#load()
 * @see ext.form.BasicForm#doAction()
 * @see ext.form.BasicForm#event:onActionComplete
 * @see ext.form.BasicForm#event:onActionFailed
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html Original Ext JS documentation of 'Ext.form.action.Action'
 */
public class Action extends Base {
  /**
   * Failure type returned when client side validation of the Form fails thus aborting
   * a submit action. Client side validation is performed unless
   * →<code>ext.form.action.SubmitAction.clientValidation</code> is explicitly set to false.
   * @default 'client'
   * @see ext.form.action.SubmitAction#clientValidation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#static-property-CLIENT_INVALID Original Ext JS documentation of 'CLIENT_INVALID'
   */
  public static native function get CLIENT_INVALID():String;

  /**
   * Failure type returned when a communication error happens when attempting to send
   * a request to the remote server. The →<code>response</code> may be examined to provide
   * further information.
   * @default 'connect'
   * @see #response
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#static-property-CONNECT_FAILURE Original Ext JS documentation of 'CONNECT_FAILURE'
   */
  public static native function get CONNECT_FAILURE():String;

  /**
   * Failure type returned when the response's <code>→success</code> property is set to false,
   * or no field values are returned in the response's data property.
   * @default 'load'
   * @see #success
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#static-property-LOAD_FAILURE Original Ext JS documentation of 'LOAD_FAILURE'
   */
  public static native function get LOAD_FAILURE():String;

  /**
   * Failure type returned when server side processing fails and the →<code>result</code>'s
   * <code>→success</code> property is set to false.
   * <p>In the case of a form submission, field-specific error messages may be returned
   * in the →<code>result</code>'s errors property.</p>
   * @default 'server'
   * @see #result
   * @see #success
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#static-property-SERVER_INVALID Original Ext JS documentation of 'SERVER_INVALID'
   */
  public static native function get SERVER_INVALID():String;

  /**
   * Creates new Action.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Action(config:Action = null) {
    super();
  }

  [ExtConfig]
  /**
   * The function to call when a failure packet was received, or when an error
   * occurred in the Ajax communication.
   * <ul>
   * <li><code>form:ext.form.BasicForm</code> (optional) —
   * The form that requested the action
   * </li>
   * <li><code>action:ext.form.action.Action</code> (optional) —
   * The Action class. If an Ajax error
   * occurred, the failure type will be in →<code>failureType</code>. The →<code>result</code>
   * property of this object may be examined to perform custom post-processing.
   * </li>
   * </ul>
   * @see #failureType
   * @see #result
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-failure Original Ext JS documentation of 'failure'
   */
  public native function get failure():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set failure(value:*):void;

  /**
   * The type of failure detected will be one of these:
   * →<code>CLIENT_INVALID</code>, →<code>SERVER_INVALID</code>, →<code>CONNECT_FAILURE</code>, or →<code>LOAD_FAILURE</code>.
   * <p>Usage:</p>
   * <pre>
   * var fp = new Ext.form.Panel({
   * ...
   * buttons: [{
   *     text: 'Save',
   *     formBind: true,
   *     handler: function(){
   *         if(fp.getForm().isValid()){
   *             fp.getForm().submit({
   *                 url: 'form-submit.php',
   *                 waitMsg: 'Submitting your data...',
   *                 success: function(form, action){
   *                     // server responded with success = true
   *                     var result = action.result;
   *                 },
   *                 failure: function(form, action){
   *                     if (action.→<code>failureType</code> === Ext.form.action.Action.CONNECT_FAILURE) {
   *                         Ext.Msg.alert('Error',
   *                             'Status:'+action.response.status+': '+
   *                             action.response.statusText);
   *                     }
   *                     if (action.failureType === Ext.form.action.Action.SERVER_INVALID){
   *                         // server responded with success = false
   *                         Ext.Msg.alert('Invalid', action.result.errormsg);
   *                     }
   *                 }
   *             });
   *         }
   *     }
   * },{
   *     text: 'Reset',
   *     handler: function(){
   *         fp.getForm().reset();
   *     }
   * }]
   * </pre>
   * @see #CLIENT_INVALID
   * @see #SERVER_INVALID
   * @see #CONNECT_FAILURE
   * @see #LOAD_FAILURE
   * @see #failureType
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#property-failureType Original Ext JS documentation of 'failureType'
   */
  public native function get failureType():String;

  /**
   * @private
   */
  public native function set failureType(value:String):void;

  [ExtConfig]
  /**
   * The →<code>ext.form.BasicForm</code> instance that is invoking this Action. Required.
   * @see ext.form.BasicForm
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-form Original Ext JS documentation of 'form'
   */
  public native function get form():BasicForm;

  [ExtConfig]
  /**
   * @private
   */
  public native function set form(value:BasicForm):void;

  [ExtConfig]
  /**
   * Extra headers to be sent in the AJAX request for submit and load actions.
   * See →<code>ext.data.proxy.AjaxProxy.headers</code>.
   * <p><b>Note:</b> Headers are not sent during file upload.</p>
   * @see ext.data.proxy.AjaxProxy#headers
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-headers Original Ext JS documentation of 'headers'
   */
  public native function get headers():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set headers(value:Object):void;

  [ExtConfig]
  /**
   * The HTTP method to use to access the requested URL.
   * Defaults to the <i>BasicForm's method</i> (→<code>ext.form.BasicForm.method</code>), or 'POST' if not specified.
   * @see ext.form.BasicForm#method
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-method Original Ext JS documentation of 'method'
   */
  public native function get method():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set method(value:String):void;

  [ExtConfig]
  /**
   * Extra parameter values to pass. These are added to the Form's
   * →<code>ext.form.BasicForm.baseParams</code> and passed to the specified URL along with the Form's
   * input fields.
   * <p>Parameters are encoded as standard HTTP parameters using
   * <i>Ext.Object.toQueryString</i> (→<code>ext.Ext.urlEncode()</code>).</p>
   * @see ext.form.BasicForm#baseParams
   * @see ext.SExt#urlEncode() ext.Ext.urlEncode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-params Original Ext JS documentation of 'params'
   */
  public native function get params():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set params(value:*):void;

  [ExtConfig]
  /**
   * When set to <b>true</b>, causes the Form to be →<code>ext.form.BasicForm.reset()</code> on Action
   * success. If specified, this happens before the →<code>success</code> callback is called and before
   * the Form's →<code>ext.form.BasicForm.event:onActionComplete</code> event fires.
   * @see ext.form.BasicForm#reset()
   * @see #success
   * @see ext.form.BasicForm#event:onActionComplete
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-reset Original Ext JS documentation of 'reset'
   */
  public native function get reset():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reset(value:Boolean):void;

  /**
   * The raw XMLHttpRequest object used to perform the action.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#property-response Original Ext JS documentation of 'response'
   */
  public native function get response():Object;

  /**
   * @private
   */
  public native function set response(value:Object):void;

  /**
   * The decoded response object containing a boolean <code>→success</code> property and other,
   * action-specific properties.
   * @see #success
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#property-result Original Ext JS documentation of 'result'
   */
  public native function get result():Object;

  /**
   * @private
   */
  public native function set result(value:Object):void;

  [ExtConfig]
  /**
   * The scope in which to call the configured #success and #failure callback functions
   * (the <code>this</code> reference for the callback functions).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * If set to true, the emptyText value will be sent with the form when it is submitted.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-submitEmptyText Original Ext JS documentation of 'submitEmptyText'
   */
  public native function get submitEmptyText():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitEmptyText(value:Boolean):void;

  [ExtConfig]
  /**
   * The function to call when a valid success return packet is received.
   * <ul>
   * <li><code>form:ext.form.BasicForm</code> (optional) —
   * The form that requested the action
   * </li>
   * <li><code>action:ext.form.action.Action</code> (optional) —
   * The Action class. The →<code>result</code> property
   * of this object may be examined to perform custom post-processing.
   * </li>
   * </ul>
   * @see #result
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-success Original Ext JS documentation of 'success'
   */
  public native function get success():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set success(value:*):void;

  [ExtConfig]
  /**
   * The number of seconds to wait for a server response before failing with the
   * →<code>failureType</code> as →<code>ext.form.action.Action.CONNECT_FAILURE</code>. If not specified,
   * defaults to the configured →<code>ext.form.BasicForm.timeout</code> of the →<code>form</code>.
   * @see #failureType
   * @see ext.form.action.Action#CONNECT_FAILURE
   * @see ext.form.BasicForm#timeout
   * @see #form
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-timeout Original Ext JS documentation of 'timeout'
   */
  public native function get timeout():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set timeout(value:Number):void;

  /**
   * The type of action this Action instance performs. Currently only "submit" and "load"
   * are supported.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#property-type Original Ext JS documentation of 'type'
   */
  public native function get type():String;

  /**
   * @private
   */
  public native function set type(value:String):void;

  [ExtConfig]
  /**
   * The URL that the Action is to invoke. Will default to the →<code>ext.form.BasicForm.url</code>
   * configured on the →<code>form</code>.
   * @see ext.form.BasicForm#url
   * @see #form
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-url Original Ext JS documentation of 'url'
   */
  public native function get url():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set url(value:String):void;

  [ExtConfig]
  /**
   * The message to be displayed by a call to →<code>ext.window.MessageBoxWindow.wait()</code> during the time
   * the action is being processed.
   * @see ext.window.MessageBoxWindow#wait()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-waitMsg Original Ext JS documentation of 'waitMsg'
   */
  public native function get waitMsg():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitMsg(value:String):void;

  [ExtConfig]
  /**
   * The title to be displayed by a call to →<code>ext.window.MessageBoxWindow.wait()</code> during the time
   * the action is being processed.
   * @see ext.window.MessageBoxWindow#wait()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#cfg-waitTitle Original Ext JS documentation of 'waitTitle'
   */
  public native function get waitTitle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set waitTitle(value:String):void;

  /**
   * Invokes this action using the current configuration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Action.html#method-run Original Ext JS documentation of 'run'
   */
  public native function run():void;
}
}