package ext.form.action {

[Native("Ext.form.action.DirectSubmit", require)]
/**
 * Provides Ext Direct support for submitting form data.
 * <p>This example illustrates usage of Ext Direct to submit a form.</p>
 * <pre>
 * var myFormPanel = new Ext.form.Panel({
 *     // configs for FormPanel
 *     title: 'Basic Information',
 *     renderTo: document.body,
 *     width: 300, height: 160,
 *     padding: 10,
 *     buttons:[{
 *         text: 'Submit',
 *         handler: function(){
 *             myFormPanel.getForm().submit({
 *                 params: {
 *                     foo: 'bar',
 *                     uid: 34
 *                 }
 *             });
 *         }
 *     }],
 *
 *     // configs apply to child items
 *     defaults: {anchor: '100%'},
 *     defaultType: 'textfield',
 *     items: [{
 *         fieldLabel: 'Name',
 *         name: 'name'
 *     },{
 *         fieldLabel: 'Email',
 *         name: 'email'
 *     },{
 *         fieldLabel: 'Company',
 *         name: 'company'
 *     }],
 *
 *     // configs for BasicForm
 *     api: {
 *         // The server-side method to call for load() requests
 *         load: 'Profile.getBasicInfo',
 *         // The server-side must mark the submit handler as a 'formHandler'
 *         submit: 'Profile.updateBasicInfo'
 *     },
 *     // specify the order for the passed params
 *     paramOrder: ['uid', 'foo']
 * });
 * </pre>
 * <p>Before using DirectLoad action, make sure you set up Ext Direct remoting provider.
 * See →<code>ext.direct.DirectManager</code> for more information.</p>
 * <p>For corresponding load action, see →<code>ext.form.action.DirectLoadAction</code>.</p>
 * @see ext.direct.#DirectManager ext.direct.DirectManager
 * @see ext.form.action.DirectLoadAction
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.DirectSubmit.html Original Ext JS documentation of 'Ext.form.action.DirectSubmit'
 */
public class DirectSubmitAction extends SubmitAction implements IDirectAction {
  /**
   * @param config @inheritDoc
   */
  public function DirectSubmitAction(config:DirectSubmitAction = null) {
    super();
  }
}
}