package ext.form.action {

[Native("Ext.form.action.Load", require)]
/**
 * A class which handles loading of data from a server into the Fields of an →<code>ext.form.BasicForm</code>.
 * <p>Instances of this class are only created by a <i>Form</i> (→<code>ext.form.BasicForm</code>) when
 * →<code>ext.form.BasicForm.load()</code>ing.</p>
 * <p><b><i>Response Packet Criteria</i></b></p>
 * <p>A response packet <b>must</b> contain:</p>
 * <ul>
 * <li><b><code>→success</code></b> property : Boolean</li>
 * <li><b><code>data</code></b> property : Object</li>
 * </ul>
 * <p>The <code>data</code> property contains the values of Fields to load. The individual value object
 * for each Field is passed to the Field's →<code>ext.form.field.Field.setValue()</code> method.</p>
 * <p><b><i>JSON Packets</i></b></p>
 * <p>By default, response packets are assumed to be JSON, so for the following form load call:</p>
 * <pre>
 * var myFormPanel = new Ext.form.Panel({
 *     title: 'Client and routing info',
 *     renderTo: Ext.getBody(),
 *     defaults: {
 *         xtype: 'textfield'
 *     },
 *     items: [{
 *         fieldLabel: 'Client',
 *         name: 'clientName'
 *     }, {
 *         fieldLabel: 'Port of loading',
 *         name: 'portOfLoading'
 *     }, {
 *         fieldLabel: 'Port of discharge',
 *         name: 'portOfDischarge'
 *     }]
 * });
 * myFormPanel.getForm().load({
 *     url: '/getRoutingInfo.php',
 *     params: {
 *         consignmentRef: myConsignmentRef
 *     },
 *     failure: function(form, action) {
 *         Ext.Msg.alert("Load failed", action.result.errorMessage);
 *     }
 * });
 * </pre>
 * <p>a <b>success response</b> packet may look like this:</p>
 * <pre>
 * {
 *     success: true,
 *     data: {
 *         clientName: "Fred. Olsen Lines",
 *         portOfLoading: "FXT",
 *         portOfDischarge: "OSL"
 *     }
 * }
 * </pre>
 * <p>while a <b>failure response</b> packet may look like this:</p>
 * <pre>
 * {
 *     success: false,
 *     errorMessage: "Consignment reference not found"
 * }
 * </pre>
 * <p>Other data may be placed into the response for processing the <i>Form</i> (→<code>ext.form.BasicForm</code>)'s
 * callback or event handler methods. The object decoded from this JSON is available in the
 * →<code>ext.form.action.Action.result</code> property.</p>
 * @see ext.form.BasicForm
 * @see ext.form.BasicForm#load()
 * @see #success
 * @see ext.form.field.Field#setValue()
 * @see ext.form.action.Action#result
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Load.html Original Ext JS documentation of 'Ext.form.action.Load'
 */
public class LoadAction extends Action {
  /**
   * @param config @inheritDoc
   */
  public function LoadAction(config:LoadAction = null) {
    super();
  }
}
}