package ext.form.action {

[Native("Ext.form.action.StandardSubmit", require)]
/**
 * A class which handles submission of data from <i>Form</i> (→<code>ext.form.BasicForm</code>)s using a standard
 * <code>&lt;form&gt;</code> element submit. It does not handle the response from the submit.
 * <p>If validation of the form fields fails, the Form's afterAction method will be called.
 * Otherwise, afterAction will not be called.</p>
 * <p>Instances of this class are only created by a <i>Form</i> (→<code>ext.form.BasicForm</code>) when
 * →<code>ext.form.BasicForm.submit()</code>ting, when the form's →<code>ext.form.BasicForm.standardSubmit</code>
 * config option is true.</p>
 * @see ext.form.BasicForm
 * @see ext.form.BasicForm#submit()
 * @see ext.form.BasicForm#standardSubmit
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.StandardSubmit.html Original Ext JS documentation of 'Ext.form.action.StandardSubmit'
 */
public class StandardSubmitAction extends SubmitAction {
  /**
   * @param config @inheritDoc
   */
  public function StandardSubmitAction(config:StandardSubmitAction = null) {
    super();
  }

  [ExtConfig]
  /**
   * Optional target attribute to be used for the form when submitting.
   * <p>Defaults to the current window/frame.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.StandardSubmit.html#cfg-target Original Ext JS documentation of 'target'
   */
  public native function get target():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:String):void;
}
}