package ext.form.action {

[Native("Ext.form.action.Submit", require)]
/**
 * A class which handles submission of data from <i>Form</i> (→<code>ext.form.BasicForm</code>)s and processes
 * the returned response.
 * <p>Instances of this class are only created by a <i>Form</i> (→<code>ext.form.BasicForm</code>) when
 * →<code>ext.form.BasicForm.submit()</code>ting.</p>
 * <p><b>Response Packet Criteria</b></p>
 * <p>A response packet may contain:</p>
 * <ul>
 * <li>
 * <p><b><code>→success</code></b> property : Boolean - required.</p>
 * </li>
 * <li>
 * <p><b><code>errors</code></b> property : Object - optional, contains error messages for invalid fields.</p>
 * </li>
 * </ul>
 * <p><b>JSON Packets</b></p>
 * <p>By default, response packets are assumed to be JSON, so a typical response packet may look
 * like this:</p>
 * <pre>
 * {
 *     success: false,
 *     errors: {
 *         clientCode: "Client not found",
 *         portOfLoading: "This field must not be null"
 *     }
 * }
 * </pre>
 * <p>Other data may be placed into the response for processing by the →<code>ext.form.BasicForm</code>'s
 * callback or event handler methods. The object decoded from this JSON is available in the
 * →<code>ext.form.action.Action.result</code> property.</p>
 * <p>Alternatively, if an →<code>ext.form.BasicForm.errorReader</code> is specified as an
 * →<code>ext.data.reader.XmlReader</code>:</p>
 * <pre>
 * errorReader: new Ext.data.reader.Xml({
 *         record : 'field',
 *         success: '&#64;success'
 *     }, [
 *         'id', 'msg'
 *     ]
 * )
 * </pre>
 * <p>then the results may be sent back in XML format:</p>
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;
 * &lt;message success="false"&gt;
 * &lt;errors&gt;
 *     &lt;field&gt;
 *         &lt;id&gt;clientCode&lt;/id&gt;
 *         &lt;msg&gt;
 *             &lt;![CDATA[
 *                 Code not found. &lt;br /&gt;
 *                 &lt;i&gt;This is a test validation message from the server &lt;/i&gt;
 *             ]]&gt;
 *         &lt;/msg&gt;
 *     &lt;/field&gt;
 *     &lt;field&gt;
 *         &lt;id&gt;portOfLoading&lt;/id&gt;
 *         &lt;msg&gt;
 *             &lt;![CDATA[
 *                 Port not found. &lt;br /&gt;
 *                 &lt;i&gt;This is a test validation message from the server &lt;/i&gt;
 *             ]]&gt;
 *         &lt;/msg&gt;
 *     &lt;/field&gt;
 * &lt;/errors&gt;
 * &lt;/message&gt;
 * </pre>
 * <p>Other elements may be placed into the response XML for processing by the →<code>ext.form.BasicForm</code>'s
 * callback or event handler methods. The XML document is available in the
 * →<code>ext.form.BasicForm.errorReader</code>'s →<code>ext.data.reader.XmlReader.xmlData</code>
 * property.</p>
 * @see ext.form.BasicForm
 * @see ext.form.BasicForm#submit()
 * @see #success
 * @see ext.form.action.Action#result
 * @see ext.form.BasicForm#errorReader
 * @see ext.data.reader.XmlReader
 * @see ext.data.reader.XmlReader#xmlData
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Submit.html Original Ext JS documentation of 'Ext.form.action.Submit'
 */
public class SubmitAction extends Action {
  /**
   * @param config @inheritDoc
   */
  public function SubmitAction(config:SubmitAction = null) {
    super();
  }

  [ExtConfig]
  /**
   * Determines whether a Form's fields are validated in a final call
   * to →<code>ext.form.BasicForm.isValid()</code> prior to submission. Pass false in the Form's
   * submit options to prevent this.
   * @default true
   * @see ext.form.BasicForm#isValid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.action.Submit.html#cfg-clientValidation Original Ext JS documentation of 'clientValidation'
   */
  public native function get clientValidation():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clientValidation(value:Boolean):void;
}
}