package ext.form.events {
import ext.form.field.Field;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.events.CheckboxGroup_isDirtyEvent")]
public class CheckboxGroup_isDirtyEvent extends FlExtEvent {
  /**
   * Fires when a change in the field's →<code>isDirty()</code> state is detected.
   * @see ext.form.CheckboxGroup#isDirty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#event-dirtychange Original Ext JS documentation of 'dirtychange'
   * @see ext.form.CheckboxGroup
   * @eventType onDirtyChange
   */
  public static const DIRTY_CHANGE:String = "onDirtyChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "isDirty", "eOpts"];

  public function CheckboxGroup_isDirtyEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Whether or not the field is now dirty
   */
  public native function get isDirty():Boolean;

  public native function get source():Field;
}
}