package ext.form.events {
import ext.form.field.Field;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.events.CheckboxGroup_isValidEvent")]
public class CheckboxGroup_isValidEvent extends FlExtEvent {
  /**
   * Fires when a change in the field's validity is detected.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#event-validitychange Original Ext JS documentation of 'validitychange'
   * @see ext.form.CheckboxGroup
   * @eventType onValidityChange
   */
  public static const VALIDITY_CHANGE:String = "onValidityChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "isValid", "eOpts"];

  public function CheckboxGroup_isValidEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Whether or not the field is now valid
   */
  public native function get isValid():Boolean;

  public native function get source():Field;
}
}