package ext.form.events {
import ext.form.FieldAncestor;
import ext.form.Labelable;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.events.FieldSet_field_isValidEvent")]
public class FieldSet_field_isValidEvent extends FlExtEvent {
  /**
   * Fires when the validity state of any one of the →<code>ext.form.field.Field</code> instances
   * within this container changes.
   * @see ext.form.field.Field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.FieldAncestor.html#event-fieldvaliditychange Original Ext JS documentation of 'fieldvaliditychange'
   * @see ext.form.FieldSet
   * @eventType onFieldValidityChange
   */
  public static const FIELD_VALIDITY_CHANGE:String = "onFieldValidityChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "field", "isValid", "eOpts"];

  public function FieldSet_field_isValidEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The Field instance whose validity changed
   */
  public native function get field():Labelable;

  /**
   * The field's new validity state
   */
  public native function get isValid():String;

  public native function get source():FieldAncestor;
}
}