package ext.form.events {
import ext.form.BasicForm;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.events.FormPanel_validEvent")]
public class FormPanel_validEvent extends FlExtEvent {
  /**
   * Fires when the validity of the entire form changes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Panel.html#event-validitychange Original Ext JS documentation of 'validitychange'
   * @see ext.form.FormPanel
   * @eventType onValidityChange
   */
  public static const VALIDITY_CHANGE:String = "onValidityChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "valid", "eOpts"];

  public function FormPanel_validEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():BasicForm;

  /**
   * <code>true</code> if the form is now valid, <code>false</code> if it is now invalid.
   */
  public native function get valid():Boolean;
}
}