package ext.form.field {
import ext.Component;
import ext.dom.Element;
import ext.form.ILabelable;

import js.HTMLElement;

[Native("Ext.form.field.Base", require)]
/**
 * @see ext.form.field.events.BaseField_errorEvent.ERROR_CHANGE
 * @eventType ext.form.field.events.BaseField_errorEvent.ERROR_CHANGE
 */
[Event(name='onErrorChange', type='ext.form.field.events.BaseField_errorEvent')]
/**
 * @see ext.form.field.events.BaseField_newValue_oldValueEvent.CHANGE
 * @eventType ext.form.field.events.BaseField_newValue_oldValueEvent.CHANGE
 */
[Event(name='onChange', type='ext.form.field.events.BaseField_newValue_oldValueEvent')]
/**
 * @see ext.form.field.events.BaseField_isDirtyEvent.DIRTY_CHANGE
 * @eventType ext.form.field.events.BaseField_isDirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.form.field.events.BaseField_isDirtyEvent')]
/**
 * @see ext.form.field.events.BaseField_isValidEvent.VALIDITY_CHANGE
 * @eventType ext.form.field.events.BaseField_isValidEvent.VALIDITY_CHANGE
 */
[Event(name='onValidityChange', type='ext.form.field.events.BaseField_isValidEvent')]
/**
 * @see ext.form.field.events.BaseField_eEvent.SPECIAL_KEY
 * @eventType ext.form.field.events.BaseField_eEvent.SPECIAL_KEY
 */
[Event(name='onSpecialKey', type='ext.form.field.events.BaseField_eEvent')]
/**
 * @see ext.form.field.events.BaseField_ReadEvent.WRITEABLE_CHANGE
 * @eventType ext.form.field.events.BaseField_ReadEvent.WRITEABLE_CHANGE
 */
[Event(name='onWriteableChange', type='ext.form.field.events.BaseField_ReadEvent')]
/**
 * Base class for form fields that provides default event handling, rendering, and other common
 * functionality needed by all form field types. Utilizes the →<code>ext.form.field.Field</code> mixin
 * for value handling and validation, and the →<code>ext.form.Labelable</code> mixin to provide label
 * and error message display.
 * <p>In most cases you will want to use a subclass, such as →<code>ext.form.field.TextField</code> or
 * →<code>ext.form.field.Checkbox</code>, rather than creating instances of this class directly. However
 * if you are implementing a custom form field, using this as the parent class is recommended.</p>
 * <p><b>Values and Conversions</b></p>
 * <p>Because Base implements the Field mixin, it has a main value that can be initialized with the
 * →<code>value</code> config and manipulated via the →<code>getValue()</code> and →<code>setValue()</code> methods.
 * This main value can be one of many data types appropriate to the current field, for instance a
 * →<code>ext.form.field.DateField</code> field would use a JavaScript Date object as its value type.
 * However, because the field is rendered as a HTML input, this value data type can not always
 * be directly used in the rendered field.</p>
 * <p>Therefore Base introduces the concept of a "raw value". This is the value of the rendered HTML
 * input field, and is normally a String. The →<code>getRawValue()</code> and →<code>setRawValue()</code> methods
 * can be used to directly work with the raw value, though it is recommended to use getValue
 * and setValue in most cases.</p>
 * <p>Conversion back and forth between the main value and the raw value is handled by the
 * →<code>valueToRaw()</code> and →<code>rawToValue()</code> methods. If you are implementing a subclass
 * that uses a non-String value data type, you should override these methods to handle
 * the conversion.</p>
 * <p><b>Rendering</b></p>
 * <p>The content of the field body is defined by the →<code>fieldSubTpl</code> XTemplate, with its argument
 * data created by the →<code>getSubTplData()</code> method. Override this template and/or method to create
 * custom field renderings.</p>
 * @see ext.form.field.Field
 * @see ext.form.Labelable
 * @see ext.form.field.TextField
 * @see ext.form.field.Checkbox
 * @see #value
 * @see #getValue()
 * @see #setValue()
 * @see ext.form.field.DateField
 * @see #getRawValue()
 * @see #setRawValue()
 * @see #valueToRaw()
 * @see #rawToValue()
 * @see #fieldSubTpl
 * @see #getSubTplData()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html Original Ext JS documentation of 'Ext.form.field.Base'
 */
public class BaseField extends Component implements ILabelable, IField {
  /**
   * @param config @inheritDoc
   */
  public function BaseField(config:BaseField = null) {
    super();
  }

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * If specified, then the component will be displayed with this value as its active error
   * when first rendered. Use →<code>setActiveError()</code> or →<code>unsetActiveError()</code> to change it
   * after component creation.
   * @see #setActiveError()
   * @see #unsetActiveError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-activeError Original Ext JS documentation of 'activeError'
   * @see #getActiveError()
   */
  public native function get activeError():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set activeError(value:String):void;

  [ExtConfig]
  /**
   * The template used to format the Array of error messages passed to →<code>setActiveErrors()</code>
   * into a single HTML string. if the →<code>msgTarget</code> is title, it defaults to a list
   * separated by new lines. Otherwise, it renders each message as an item in an unordered list.
   * @see #setActiveErrors()
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-activeErrorsTpl Original Ext JS documentation of 'activeErrorsTpl'
   */
  public native function get activeErrorsTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set activeErrorsTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * at the end of the input containing element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterBodyEl Original Ext JS documentation of 'afterBodyEl'
   */
  public native function get afterBodyEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterBodyEl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the label text. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterLabelTextTpl Original Ext JS documentation of 'afterLabelTextTpl'
   */
  public native function get afterLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the label element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterLabelTpl Original Ext JS documentation of 'afterLabelTpl'
   */
  public native function get afterLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the <i>subTpl markup</i> (→<code>getSubTplMarkup()</code>). If an <code>XTemplate</code> is used, the
   * component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see #getSubTplMarkup()
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-afterSubTpl Original Ext JS documentation of 'afterSubTpl'
   */
  public native function get afterSubTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterSubTpl(value:*):void;

  /**
   * The name of the Component property that holds
   * a reference to the Element that serves as that Component's ARIA element.
   * This property will be replaced with the actual Element reference after rendering.
   * <p>Most of the simple Components will have their main element as ariaEl.</p>
   * @default 'inputEl'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#property-ariaEl Original Ext JS documentation of 'ariaEl'
   */
  public native function get ariaEl():String;

  /**
   * @private
   */
  public native function set ariaEl(value:String):void;

  [ExtConfig]
  /**
   * Localized announcement text for validation errors. This text
   * will be used by Assistive Technologies such as screen readers to alert the users when
   * field validation fails.
   * <p>This config is used with →<code>ext.StringUtil.format()</code>. '{0}' will be replaced with the actual
   * error message(s), '{1}' will be replaced with field label.</p>
   * @default 'Input error. {0}.'
   * @see ext.SStringUtil#format() ext.StringUtil.format()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-ariaErrorText Original Ext JS documentation of 'ariaErrorText'
   */
  public native function get ariaErrorText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaErrorText(value:String):void;

  [ExtConfig]
  /**
   * Optional text description for this object. This text will be
   * announced to Assistive Technology users when the object is focused.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-ariaHelp Original Ext JS documentation of 'ariaHelp'
   */
  public native function get ariaHelp():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaHelp(value:String):void;

  [ExtConfig]
  /**
   * A tag name or →<code>ext.dom.DomHelper</code> spec used to create the <i>Element</i> (→<code>getEl()</code>)
   * which will encapsulate this Component.
   * <p>You do not normally need to specify this. For the base classes →<code>ext.Component</code> and
   * →<code>ext.container.Container</code>, this defaults to <b>'div'</b>. The more complex Sencha classes
   * use a more complex DOM structure specified by their own →<code>renderTpl</code>s.</p>
   * <p>This is intended to allow the developer to create application-specific utility Components
   * encapsulated by different DOM elements. Example usage:</p>
   * <pre>
   * {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'img',
   *         src: 'http://www.example.com/example.jpg'
   *     }
   * }, {
   *     xtype: 'component',
   *     autoEl: {
   *         tag: 'blockquote',
   *         html: 'autoEl is cool!'
   *     }
   * }, {
   *     xtype: 'container',
   *     autoEl: 'ul',
   *     cls: 'ux-unordered-list',
   *     items: {
   *         xtype: 'component',
   *         autoEl: 'li',
   *         html: 'First list item'
   *     }
   * }
   * </pre>
   * @default {
   *     role: 'presentation'
   * }
   * @see ext.dom.#DomHelper ext.dom.DomHelper
   * @see #getEl()
   * @see ext.Component
   * @see ext.container.Container
   * @see #renderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-autoEl Original Ext JS documentation of 'autoEl'
   */
  override public native function get autoEl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoEl(value:*):void;

  [ExtConfig]
  /**
   * Whether to adjust the component's body width to make room for 'side'
   * <i>error messages</i> (→<code>msgTarget</code>).
   * @default true
   * @see #msgTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-autoFitErrors Original Ext JS documentation of 'autoFitErrors'
   */
  public native function get autoFitErrors():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoFitErrors(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the body content element.
   * @default Ext.baseCSSPrefix + 'form-item-body'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-baseBodyCls Original Ext JS documentation of 'baseBodyCls'
   */
  public native function get baseBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set baseBodyCls(value:String):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this component's element. This will also be prepended
   * to elements within this component like Panel's body will get a class <code>x-panel-body</code>.
   * This means that if you create a subclass of Panel, and you want it to get all the Panels
   * styling for the element and the body, you leave the <code>→baseCls</code> <code>x-panel</code> and use
   * <code>→componentCls</code> to add specific styling for this component.
   * @default Ext.baseCSSPrefix + 'field'
   * @see #baseCls
   * @see #componentCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * at the beginning of the input containing element. If an <code>XTemplate</code> is used,
   * the component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeBodyEl Original Ext JS documentation of 'beforeBodyEl'
   */
  public native function get beforeBodyEl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeBodyEl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the label text. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeLabelTextTpl Original Ext JS documentation of 'beforeLabelTextTpl'
   */
  public native function get beforeLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the label element. If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeLabelTpl Original Ext JS documentation of 'beforeLabelTpl'
   */
  public native function get beforeLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the <i>subTpl markup</i> (→<code>getSubTplMarkup()</code>). If an <code>XTemplate</code> is used, the
   * component's <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see #getSubTplMarkup()
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-beforeSubTpl Original Ext JS documentation of 'beforeSubTpl'
   */
  public native function get beforeSubTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeSubTpl(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get bodyEl():Element;

  /**
   * @inheritDoc
   */
  public native function set bodyEl(value:Element):void;

  [ExtConfig]
  /**
   * Defines a timeout in milliseconds for buffering →<code>checkChangeEvents</code> that fire
   * in rapid succession.
   * Defaults to 50 milliseconds.
   * @default 50
   * @see #checkChangeEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-checkChangeBuffer Original Ext JS documentation of 'checkChangeBuffer'
   */
  public native function get checkChangeBuffer():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkChangeBuffer(value:Number):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * A list of event names that will be listened for on the field's
   * <i>input element</i> (→<code>inputEl</code>), which will cause the field's value to be checked for changes.
   * If a change is detected, the <i>change event</i> (→<code>event:onChange</code>) will be fired, followed by
   * validation if the →<code>validateOnChange</code> option is enabled.
   * <p>Defaults to ['change', 'propertychange', 'keyup'] in Internet Explorer, and
   * ['change', 'input', 'textInput', 'keyup', 'dragdrop'] in other browsers.
   * This catches all the ways that field values can be changed in most supported browsers;
   * the only known exceptions at the time of writing are:</p>
   * <ul>
   * <li>Safari 3.2 and older: cut/paste in textareas via the context menu, and dragging text
   * into textareas</li>
   * <li>Opera 10 and 11: dragging text into text fields and textareas, and cut via the context
   * menu in text fields and textareas</li>
   * <li>Opera 9: Same as Opera 10 and 11, plus paste from context menu in text fields
   * and textareas</li>
   * </ul>
   * <p>If you need to guarantee on-the-fly change notifications including these edge cases, you can
   * call the →<code>checkChange()</code> method on a repeating interval, e.g. using
   * →<code>ext.util.TaskManager</code>, or if the field is within a →<code>ext.form.FormPanel</code>, you can use
   * the FormPanel's →<code>ext.form.FormPanel.pollForChanges</code> configuration to set up
   * such a task automatically.</p>
   * @default Ext.isIE && (!document.documentMode || document.documentMode <= 9) ? [
   *     'change',
   *     'propertychange',
   *     'keyup'
   * ] : [
   *     'change',
   *     'input',
   *     'textInput',
   *     'keyup',
   *     'dragdrop'
   * ]
   * @see #inputEl
   * @see #event:onChange
   * @see #validateOnChange
   * @see #checkChange()
   * @see ext.util.#TaskManager ext.util.TaskManager
   * @see ext.form.FormPanel
   * @see ext.form.FormPanel#pollForChanges
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-checkChangeEvents Original Ext JS documentation of 'checkChangeEvents'
   */
  public native function get checkChangeEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkChangeEvents(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     /&#42;&#42;
   *          &#42; @property {Ext.dom.Element} inputEl
   *          &#42; The input Element for this Field. Only available after the field has been rendered.
   *          &#42;/
   *     'inputEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  /**
   * This property is used to determine the property of a <code>→bind</code> config that is just
   * the value. For example, if <code>defaultBindProperty="value"</code>, then this shorthand
   * <code>→bind</code> config:
   * <pre>
   *  bind: '{name}'
   * </pre>
   * <p>Is equivalent to this object form:</p>
   * <pre>
   *  bind: {
   *      value: '{name}'
   *  }
   * </pre>
   * <p>The <code>→defaultBindProperty</code> is set to "value" for form fields and to "store" for
   * grids and trees.</p>
   * @default 'value'
   * @see #bind
   * @see #defaultBindProperty
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#property-defaultBindProperty Original Ext JS documentation of 'defaultBindProperty'
   */
  override public native function get defaultBindProperty():String;

  /**
   * @private
   */
  override public native function set defaultBindProperty(value:String):void;

  [ExtConfig]
  /**
   * The CSS class to use when the field value <i>is dirty</i> (→<code>isDirty()</code>).
   * @default Ext.baseCSSPrefix + 'form-dirty'
   * @see #isDirty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-dirtyCls Original Ext JS documentation of 'dirtyCls'
   */
  public native function get dirtyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dirtyCls(value:String):void;

  [ExtConfig]
  /**
   * True to disable the field. Disabled Fields will not be
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>).
   * @default false
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  override public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set disabled(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get errorEl():Element;

  /**
   * @inheritDoc
   */
  public native function set errorEl(value:Element):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the error message element.
   * @default Ext.baseCSSPrefix + 'form-error-msg'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-errorMsgCls Original Ext JS documentation of 'errorMsgCls'
   */
  public native function get errorMsgCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set errorMsgCls(value:String):void;

  [ExtConfig]
  /**
   * An extra CSS class to be applied to the body content element in addition to
   * →<code>baseBodyCls</code>.
   * @default ''
   * @see #baseBodyCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-fieldBodyCls Original Ext JS documentation of 'fieldBodyCls'
   */
  public native function get fieldBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldBodyCls(value:String):void;

  [ExtConfig]
  /**
   * The default CSS class for the field input
   * @default Ext.baseCSSPrefix + 'form-field'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-fieldCls Original Ext JS documentation of 'fieldCls'
   */
  public native function get fieldCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldCls(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The label for the field. It gets appended with the →<code>labelSeparator</code>, and its position
   * and sizing is determined by the →<code>labelAlign</code> and →<code>labelWidth</code> configs.
   * @default undefined
   * @see #labelSeparator
   * @see #labelAlign
   * @see #labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-fieldLabel Original Ext JS documentation of 'fieldLabel'
   * @see #getFieldLabel()
   * @see #setFieldLabel()
   */
  public native function get fieldLabel():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set fieldLabel(value:String):void;

  [ExtConfig]
  /**
   * Optional CSS style(s) to be applied to the <i>field input element</i> (→<code>inputEl</code>).
   * Should be a valid argument to →<code>ext.dom.Element.applyStyles()</code>. Defaults to undefined.
   * See also the →<code>setFieldStyle()</code> method for changing the style after initialization.
   * @see #inputEl
   * @see ext.dom.Element#applyStyles()
   * @see #setFieldStyle()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-fieldStyle Original Ext JS documentation of 'fieldStyle'
   */
  public native function get fieldStyle():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set fieldStyle(value:String):void;

  [ExtConfig]
  /**
   * The CSS class to use when the field receives focus
   * @default 'form-focus'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  override public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusCls(value:String):void;

  /**
   * The element that will be focused
   * when →<code>focus()</code> method is called on this component. Usually this is
   * the same element that receives focus via mouse clicks, taps, and pressing
   * Tab key.
   * @default 'inputEl'
   * @see #focus()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#property-focusEl Original Ext JS documentation of 'focusEl'
   */
  override public native function get focusEl():Element;

  /**
   * @private
   */
  override public native function set focusEl(value:Element):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class to be applied to the outermost element to denote that it is participating
   * in the form field layout.
   * @default Ext.baseCSSPrefix + 'form-item'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-formItemCls Original Ext JS documentation of 'formItemCls'
   */
  public native function get formItemCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formItemCls(value:String):void;

  [Deprecated(message="This config is deprecated.\n", since="6.2.0")]
  [ExtConfig]
  /**
   * Helpful text describing acceptable format for field values. This text will be
   * announced by Assistive Technologies such as screen readers when the field is
   * focused.
   * <p>This option is superseded by →<code>ariaHelp</code>.</p>
   * @see #ariaHelp
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-formatText Original Ext JS documentation of 'formatText'
   */
  public native function get formatText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set formatText(value:String):void;

  [ExtConfig]
  /**
   * When set to true, the label element (→<code>fieldLabel</code> and →<code>labelSeparator</code>)
   * will be automatically hidden if the →<code>fieldLabel</code> is empty. Setting this to false
   * will cause the empty label element to be rendered and space to be reserved for it;
   * this is useful if you want a field without a label to line up with other labeled fields
   * in the same form.
   * <p>If you wish to unconditionall hide the label even if a non-empty fieldLabel is configured,
   * then set the →<code>hideLabel</code> config to true.</p>
   * @default true
   * @see #fieldLabel
   * @see #labelSeparator
   * @see #hideLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-hideEmptyLabel Original Ext JS documentation of 'hideEmptyLabel'
   */
  public native function get hideEmptyLabel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideEmptyLabel(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to true to completely hide the label element (→<code>fieldLabel</code> and
   * →<code>labelSeparator</code>). Also see →<code>hideEmptyLabel</code>, which controls whether space
   * will be reserved for an empty fieldLabel.
   * @default false
   * @see #fieldLabel
   * @see #labelSeparator
   * @see #hideEmptyLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-hideLabel Original Ext JS documentation of 'hideLabel'
   */
  public native function get hideLabel():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideLabel(value:Boolean):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * inside the input element (as attributes). If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>getSubTplData()</code>) serves as the context.
   * @see #getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-inputAttrTpl Original Ext JS documentation of 'inputAttrTpl'
   */
  public native function get inputAttrTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inputAttrTpl(value:*):void;

  /**
   * The input Element for this Field. Only available after the field has been rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#property-inputEl Original Ext JS documentation of 'inputEl'
   */
  public native function get inputEl():Element;

  /**
   * @private
   */
  public native function set inputEl(value:Element):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The id that will be given to the generated input DOM element. Defaults to an automatically
   * generated id. If you configure this manually, you must make sure it is unique
   * in the document.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-inputId Original Ext JS documentation of 'inputId'
   * @see #getInputId()
   */
  public native function get inputId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inputId(value:String):void;

  [ExtConfig]
  /**
   * The type attribute for input fields -- e.g. radio, text, password, file. The extended types
   * supported by HTML5 inputs (url, email, etc.) may also be used, though using them will cause
   * older browsers to fall back to 'text'.
   * <p>The type 'password' must be used to render that field type currently -- there is no separate
   * Ext component for that. You can use →<code>ext.form.field.FileUploadField</code> which creates
   * a custom-rendered file upload field, but if you want a plain unstyled file input you can use
   * a Base with inputType:'file'.</p>
   * @default 'text'
   * @see ext.form.field.FileUploadField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-inputType Original Ext JS documentation of 'inputType'
   */
  public native function get inputType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inputType(value:String):void;

  [ExtConfig]
  /**
   * The CSS class to use when marking the component invalid.
   * @default Ext.baseCSSPrefix + 'form-invalid'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-invalidCls Original Ext JS documentation of 'invalidCls'
   */
  public native function get invalidCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set invalidCls(value:String):void;

  [ExtConfig]
  /**
   * The error text to use when marking a field invalid and no message is provided
   * @default 'The value in this field is invalid'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-invalidText Original Ext JS documentation of 'invalidText'
   */
  public native function get invalidText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set invalidText(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get isFieldLabelable():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isFieldLabelable(value:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function get isFormField():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isFormField(value:Boolean):void;

  [ExtConfig]
  /**
   * Controls the position and alignment of the →<code>fieldLabel</code>. Valid values are:
   * <ul>
   * <li>"left" (the default) - The label is positioned to the left of the field, with its text
   * aligned to the left. Its width is determined by the →<code>labelWidth</code> config.</li>
   * <li>"top" - The label is positioned above the field.</li>
   * <li>"right" - The label is positioned to the left of the field, with its text aligned
   * to the right. Its width is determined by the →<code>labelWidth</code> config.</li>
   * </ul>
   * @default 'left'
   * @see #fieldLabel
   * @see #labelWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelAlign Original Ext JS documentation of 'labelAlign'
   */
  public native function get labelAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelAlign(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * inside the label element (as attributes). If an <code>XTemplate</code> is used, the component's
   * <i>render data</i> (→<code>ext.Component.renderData</code>) serves as the context.
   * @see ext.Component#renderData
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelAttrTpl Original Ext JS documentation of 'labelAttrTpl'
   */
  public native function get labelAttrTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelAttrTpl(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the label element. This (single) CSS class is used
   * to formulate the renderSelector and drives the field layout where it is concatenated
   * with a hyphen ('-') and →<code>labelAlign</code>. To add additional classes, use
   * →<code>labelClsExtra</code>.
   * @default Ext.baseCSSPrefix + 'form-item-label'
   * @see #labelAlign
   * @see #labelClsExtra
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelCls Original Ext JS documentation of 'labelCls'
   */
  public native function get labelCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelCls(value:String):void;

  [ExtConfig]
  /**
   * An optional string of one or more additional CSS classes to add to the label element.
   * Defaults to empty.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelClsExtra Original Ext JS documentation of 'labelClsExtra'
   */
  public native function get labelClsExtra():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelClsExtra(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get labelEl():Element;

  /**
   * @inheritDoc
   */
  public native function set labelEl(value:Element):void;

  [ExtConfig]
  /**
   * The amount of space in pixels between the →<code>fieldLabel</code> and the field body.
   * This defaults to <code>5</code> for compatibility with Ext JS 4, however, as of Ext JS 5
   * the space between the label and the body can optionally be determined by the theme
   * using the →<code>style:$form-label-horizontal-spacing</code> (for side-aligned labels) and
   * →<code>style:$form-label-vertical-spacing</code> (for top-aligned labels) SASS variables.
   * In order for the stylesheet values as to take effect, you must use a labelPad value
   * of <code>null</code>.
   * @default 5
   * @see #fieldLabel
   * @see #style:$form-label-horizontal-spacing
   * @see #style:$form-label-vertical-spacing
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelPad Original Ext JS documentation of 'labelPad'
   */
  public native function get labelPad():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelPad(value:Number):void;

  [ExtConfig]
  /**
   * Character(s) to be inserted at the end of the <i>label text</i> (→<code>fieldLabel</code>).
   * <p>Set to empty string to hide the separator completely.</p>
   * @default ':'
   * @see #fieldLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelSeparator Original Ext JS documentation of 'labelSeparator'
   */
  public native function get labelSeparator():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelSeparator(value:String):void;

  [ExtConfig]
  /**
   * A CSS style specification string to apply directly to this field's label.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelStyle Original Ext JS documentation of 'labelStyle'
   */
  public native function get labelStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelStyle(value:String):void;

  [ExtConfig]
  /**
   * The width of the →<code>fieldLabel</code> in pixels. Only applicable if →<code>labelAlign</code>
   * is set to "left" or "right".
   * @default 100
   * @see #fieldLabel
   * @see #labelAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-labelWidth Original Ext JS documentation of 'labelWidth'
   */
  public native function get labelWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelWidth(value:Number):void;

  [ExtConfig]
  /**
   * Components that achieve their internal layout results using solely CSS with no JS
   * intervention must set this to true. This allows the component to opt out of the
   * layout run when used inside certain container layouts such as →<code>ext.layout.container.FormLayout</code> and →<code>ext.layout.container.AutoLayout</code>
   * resulting in a performance gain. The following components currently use liquid
   * layout (<code>liquidLayout: true</code>):
   * <ul>
   * <li>All Form Fields (subclasses of →<code>ext.form.field.BaseField</code>)</li>
   * <li>→<code>ext.button.Button</code></li>
   * </ul>
   * <p>It is important to keep in mind that components using liquidLayout do not fire
   * the following events:</p>
   * <ul>
   * <li>→<code>event:onResize</code></li>
   * <li>→<code>event:onBoxReady</code></li>
   * </ul>
   * <p>In addition, liquidLayout components do not call the following template methods:</p>
   * <ul>
   * <li>→<code>afterComponentLayout()</code></li>
   * <li>→<code>onBoxReady()</code></li>
   * <li>→<code>onResize()</code></li>
   * </ul>
   * <p>Any component that needs to fire these events or to have these methods called during
   * its life cycle needs to set <code>→liquidLayout</code> to <code>false</code>. The following example
   * demonstrates how to enable the resize event for a
   * <i>TextArea Field</i> (→<code>ext.form.field.TextArea</code>):</p>
   * <p><b>Example:</b></p>
   * <pre>
   * var win = Ext.create({
   *         xtype: 'window',
   *         title: 'Resize This Window!',
   *         height: 100,
   *         width: 200,
   *         layout: 'anchor',
   *         items: [{
   *             xtype: 'textarea',
   *             anchor: '0 0',
   *             liquidLayout: false // allows the textarea to fire "resize"
   *         }]
   *     }),
   *     textfield = win.items.getAt(0);
   *
   * win.show();
   *
   * textfield.on('resize', function(textfield, width, height) {
   *     Ext.Msg.alert('Text Field Resized', 'width: ' + width + ', height: ' + height);
   * });
   * </pre>
   * <p>Use caution when setting <code>→liquidLayout</code> to <code>false</code> as it carries a performance penalty
   * since it means the layout system must perform expensive DOM reads to determine the
   * Component's size.</p>
   * @default true
   * @see ext.layout.container.FormLayout
   * @see ext.layout.container.AutoLayout
   * @see ext.form.field.BaseField
   * @see ext.button.Button
   * @see #event:onResize
   * @see #event:onBoxReady
   * @see #afterComponentLayout()
   * @see #onBoxReady()
   * @see #onResize()
   * @see #liquidLayout
   * @see ext.form.field.TextArea
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-liquidLayout Original Ext JS documentation of 'liquidLayout'
   */
  override public native function get liquidLayout():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set liquidLayout(value:Boolean):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  /**
   * The location where the error message text should display. Must be one of the following
   * values:
   * <ul>
   * <li>
   * <p><code>qtip</code> Display a quick tip containing the message when the user hovers over the field.
   * This is the default.</p>
   * <p><b>→<code>ext.tip.QuickTipManager.init()</code> must have been called for this setting to work.</b></p>
   * </li>
   * <li>
   * <p><code>title</code> Display the message in a default browser title attribute popup.</p>
   * </li>
   * <li>
   * <p><code>under</code> Add a block div beneath the field containing the error message.</p>
   * </li>
   * <li>
   * <p><code>side</code> Add an error icon to the right of the field, displaying the message in a popup
   * on hover.</p>
   * </li>
   * <li>
   * <p><code>none</code> Don't display any error message. This might be useful if you are implementing
   * custom error display.</p>
   * </li>
   * <li>
   * <p><code>[element id]</code> Add the error message directly to the innerHTML of the specified element.</p>
   * </li>
   * </ul>
   * @default 'qtip'
   * @see ext.tip.SQuickTipManager#init() ext.tip.QuickTipManager.init()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-msgTarget Original Ext JS documentation of 'msgTarget'
   */
  public native function get msgTarget():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set msgTarget(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The name of the field. By default this is used as the parameter name when including the
   * <i>field value</i> (→<code>getSubmitData()</code>) in a <i>form submit()</i> (→<code>ext.form.BasicForm.submit()</code>).
   * To prevent the field from being included in the form submit, set →<code>submitValue</code>
   * to false.
   * @see #getSubmitData()
   * @see ext.form.BasicForm#submit()
   * @see #submitValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-name Original Ext JS documentation of 'name'
   * @see #getName()
   */
  public native function get name():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get originalValue():*;

  /**
   * @inheritDoc
   */
  public native function set originalValue(value:*):void;

  [ExtConfig]
  /**
   * true to disable displaying any <i>error message</i> (→<code>setActiveError()</code>) set on this object.
   * @default false
   * @see #setActiveError()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#cfg-preventMark Original Ext JS documentation of 'preventMark'
   */
  public native function get preventMark():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventMark(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default 'value'
   * @see #reference
   * @see #publishState
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * true to mark the field as readOnly in HTML.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-readOnly Original Ext JS documentation of 'readOnly'
   * @see #setReadOnly()
   */
  public native function get readOnly():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set readOnly(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class applied to the component's main element when it is →<code>readOnly</code>.
   * @default Ext.baseCSSPrefix + 'form-readonly'
   * @see #readOnly
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-readOnlyCls Original Ext JS documentation of 'readOnlyCls'
   */
  public native function get readOnlyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set readOnlyCls(value:String):void;

  [ExtConfig]
  /**
   * The possible values for shrinkWrap are...
   * <ul>
   * <li>0 (or <code>false</code>): Neither width nor height depend on content.</li>
   * <li>1: Width depends on content (shrink wraps), but height does not.</li>
   * <li>2: Height depends on content (shrink wraps), but width does not.</li>
   * <li>3 (or <code>true</code>): Both width and height depend on content (shrink wrap).</li>
   * </ul>
   * <p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed
   * to a block-level element.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-shrinkWrap Original Ext JS documentation of 'shrinkWrap'
   */
  override public native function get shrinkWrap():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shrinkWrap(value:*):void;

  [ExtConfig]
  /**
   * Setting this to false will prevent the field from being
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>) even when it is not disabled.
   * @default true
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-submitValue Original Ext JS documentation of 'submitValue'
   */
  public native function get submitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitValue(value:Boolean):void;

  [ExtConfig]
  /**
   * Sets a DOM tabIndex for this field. tabIndex may be set to <code>-1</code> in order to remove
   * the field from the tab rotation.
   * <p><b>Note:</b> tabIndex only applies to fields that are rendered. It does not effect
   * fields built via applyTo</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  [ExtConfig]
  /**
   * Whether the field should validate when it loses focus. This will cause fields to be validated
   * as the user steps through the fields in the form regardless of whether they are making
   * changes to those fields along the way. See also →<code>validateOnChange</code>.
   * @default true
   * @see #validateOnChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-validateOnBlur Original Ext JS documentation of 'validateOnBlur'
   */
  public native function get validateOnBlur():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set validateOnBlur(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether this field should be validated immediately whenever a change in its value
   * is detected. If the validation results in a change in the field's validity, a
   * →<code>event:onValidityChange</code> event will be fired. This allows the field to show feedback
   * about the validity of its contents immediately as the user is typing.
   * <p>When set to false, feedback will not be immediate. However the form will still be validated
   * before submitting if the clientValidation option to →<code>ext.form.BasicForm.doAction()</code>
   * is enabled, or if the field or form are validated manually.</p>
   * <p>See also →<code>ext.form.field.BaseField.checkChangeEvents</code> for controlling how changes
   * to the field's value are detected.</p>
   * @default true
   * @see #event:onValidityChange
   * @see ext.form.BasicForm#doAction()
   * @see ext.form.field.BaseField#checkChangeEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validateOnChange Original Ext JS documentation of 'validateOnChange'
   */
  public native function get validateOnChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set validateOnChange(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to <code>true</code> to validate the field
   * when focus leaves the field's component hierarchy entirely.
   * <p>The difference between →<code>validateOnBlur</code> and this option is that the former
   * will happen when field's <i>input element</i> blurs. In complex fields such as ComboBox
   * or Date focus may leave the input element to the drop-down picker, which will cause
   * →<code>validateOnBlur</code> to happen prematurely.</p>
   * <p>Using this option is recommended for accessible applications. The default value
   * is <code>false</code> for backwards compatibility; this option and →<code>validateOnBlur</code>
   * are mutually exclusive.</p>
   * @default false
   * @since 6.5.3
   * @see #validateOnBlur
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#cfg-validateOnFocusLeave Original Ext JS documentation of 'validateOnFocusLeave'
   */
  public native function get validateOnFocusLeave():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set validateOnFocusLeave(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This property, when a <code>→String</code>, contributes its value to the error state of this
   * instance as reported by <code>→getErrors()</code>.
   * @default null
   * @see String
   * @see #getErrors()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validation Original Ext JS documentation of 'validation'
   * @see #getValidation()
   * @see #setValidation()
   */
  public native function get validation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set validation(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A value to initialize this field with.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set value(value:Object):void;

  [ExtConfig]
  /**
   * The event name(s) to use to publish the →<code>value</code>
   * →<code>ext.form.field.BaseField.bind</code> for this field.
   * @default 'change'
   * @since 5.0.1
   * @see #value
   * @see ext.form.field.BaseField#bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-valuePublishEvent Original Ext JS documentation of 'valuePublishEvent'
   */
  public native function get valuePublishEvent():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valuePublishEvent(value:*):void;

  /**
   * @inheritDoc
   */
  public native function batchChanges(fn:Function):void;

  /**
   * Template method before a field is reset.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-beforeReset Original Ext JS documentation of 'beforeReset'
   */
  protected native function beforeReset():void;

  /**
   * @inheritDoc
   */
  public native function checkChange():void;

  /**
   * @inheritDoc
   */
  public native function checkDirty():void;

  /**
   * @inheritDoc
   */
  public native function cleanupField():void;

  /**
   * Clear any invalid styles/messages for this field.
   * <p><b>Note</b>: this method does not cause the Field's →<code>validate()</code> or →<code>isValid()</code>
   * methods to return <code>true</code> if the value does not <i>pass</i> validation. So simply clearing
   * a field's errors will not necessarily allow submission of forms submitted with the
   * →<code>ext.form.action.SubmitAction.clientValidation</code> option set.</p>
   * @see #validate()
   * @see #isValid()
   * @see ext.form.action.SubmitAction#clientValidation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-clearInvalid Original Ext JS documentation of 'clearInvalid'
   */
  public native function clearInvalid():void;

  /**
   * Called when focus leaves this input field.
   * Used to postprocess raw values and perform conversion and validation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-completeEdit Original Ext JS documentation of 'completeEdit'
   */
  protected native function completeEdit():void;

  /**
   * @inheritDoc
   */
  public native function extractFileInput():HTMLElement;

  /**
   * @inheritDoc
   */
  public native function getActiveError():String;

  /**
   * @inheritDoc
   */
  public native function getActiveErrors():Array;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * @inheritDoc
   */
  public native function getErrors(value:*):Array;

  /**
   * @inheritDoc
   */
  public native function getFieldLabel():String;

  /**
   * Returns the input id for this field. If none was specified via the →<code>inputId</code> config,
   * then an id will be automatically generated.
   * @see #inputId
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-getInputId Original Ext JS documentation of 'getInputId'
   */
  public native function getInputId():String;

  /**
   * Generates the arguments for the field decorations <i>rendering template</i> (→<code>labelableRenderTpl</code>).
   * @param data optional object to use as the base data object. If provided,
   * this method will add properties to the base object instead of creating a new one.
   * @return The template arguments
   * @see #labelableRenderTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getLabelableRenderData Original Ext JS documentation of 'getLabelableRenderData'
   */
  protected native function getLabelableRenderData(data:Object):Object;

  /**
   * @inheritDoc
   */
  public native function getModelData(includeEmptyText:Boolean):Object;

  /**
   * @inheritDoc
   */
  public native function getName():String;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Returns the raw value of the field, without performing any normalization, conversion,
   * or validation. To get a normalized and converted value see →<code>getValue()</code>.
   * @return value The raw String value of the field
   * @see #getValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-getRawValue Original Ext JS documentation of 'getRawValue'
   */
  public native function getRawValue():String;

  /**
   * Creates and returns the data object to be used when rendering the →<code>fieldSubTpl</code>.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @return The template data
   * @see #fieldSubTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-getSubTplData Original Ext JS documentation of 'getSubTplData'
   */
  public native function getSubTplData(fieldData:*):Object;

  /**
   * Gets the markup to be inserted into the outer template's bodyEl. Defaults to empty string,
   * should be implemented by classes including this mixin as needed.
   * @return The markup to be inserted
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.Labelable.html#method-getSubTplMarkup Original Ext JS documentation of 'getSubTplMarkup'
   */
  protected native function getSubTplMarkup(fieldData:Object):String;

  /**
   * @inheritDoc
   */
  public native function getSubmitData():Object;

  /**
   * Returns the value that would be included in a standard form submit for this field.
   * This will be combined with the field's name to form a name=value pair in the
   * <i>submitted parameters</i> (→<code>getSubmitData()</code>). If an empty string is returned then just
   * the name= will be submitted; if null is returned then nothing will be submitted.
   * <p>Note that the value returned will have been <i>processed</i> (→<code>processRawValue()</code>)
   * but may or may not have been successfully <i>validated</i> (→<code>validate()</code>).</p>
   * @return The value to be submitted, or null.
   * @see #getSubmitData()
   * @see #processRawValue()
   * @see #validate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-getSubmitValue Original Ext JS documentation of 'getSubmitValue'
   */
  public native function getSubmitValue():String;

  /**
   * Returns the value of <code>validation</code>.
   * @see #validation
   */
  public native function getValidation():*;

  /**
   * Returns the current data value of the field. The type of value returned is particular
   * to the type of the particular field (e.g. a Date object for →<code>ext.form.field.DateField</code>),
   * as the result of calling →<code>rawToValue()</code> on the field's
   * <i>processed</i> (→<code>processRawValue()</code>) String value. To return the raw String value,
   * see →<code>getRawValue()</code>.
   * @return value The field value
   * @see ext.form.field.DateField
   * @see #rawToValue()
   * @see #processRawValue()
   * @see #getRawValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():*;

  /**
   * @inheritDoc
   */
  public native function hasActiveError():Boolean;

  /**
   * @inheritDoc
   */
  public native function hasVisibleLabel():Boolean;

  /**
   * @inheritDoc
   */
  public native function initField():void;

  /**
   * @inheritDoc
   */
  public native function initLabelable():void;

  /**
   * @inheritDoc
   */
  public native function initValue():void;

  /**
   * @inheritDoc
   */
  public native function isDirty():Boolean;

  /**
   * @inheritDoc
   */
  public native function isEqual(value1:Object, value2:Object):Boolean;

  /**
   * @inheritDoc
   */
  public native function isFileUpload():Boolean;

  /**
   * Returns whether or not the field value is currently valid by <i>validating</i> (→<code>getErrors()</code>)
   * the <i>processed raw value</i> (→<code>processRawValue()</code>) of the field. <b>Note</b>: →<code>disabled</code>
   * fields are always treated as valid.
   * @return True if the value is valid, else false
   * @see #getErrors()
   * @see #processRawValue()
   * @see #disabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-isValid Original Ext JS documentation of 'isValid'
   */
  public native function isValid():Boolean;

  /**
   * Display one or more error messages associated with this field, using
   * →<code>ext.form.Labelable.msgTarget</code> to determine how to display the messages and
   * applying →<code>ext.form.Labelable.invalidCls</code> to the field's UI element.
   * <pre>
   * var formPanel = Ext.create('Ext.form.Panel', {
   *     title: 'Contact Info',
   *     width: 300,
   *     bodyPadding: 10,
   *     renderTo: Ext.getBody(),
   *     items: [{
   *         xtype: 'textfield',
   *         name: 'name',
   *         id: 'nameId',
   *         fieldLabel: 'Name'
   *     }],
   *     bbar: [{
   *         text: 'Mark both fields invalid',
   *         handler: function() {
   *             var nameField = formPanel.getForm().findField('name');
   *             nameField.markInvalid('Name invalid message');
   *
   *             // multiple error string syntax
   *             // nameField.markInvalid(['First message', 'Second message']);
   *         }
   *     }]
   * });
   * </pre>
   * <p><b>Note</b>: this method does not cause the Field's →<code>validate()</code> or
   * →<code>isValid()</code> methods to return <code>false</code> if the value does <i>pass</i> validation.
   * So simply marking a Field as invalid will not prevent submission of forms
   * submitted with the →<code>ext.form.action.SubmitAction.clientValidation</code> option set.</p>
   * @param errors The validation message(s) to display.
   * @see ext.form.Labelable#msgTarget
   * @see ext.form.Labelable#invalidCls
   * @see #validate()
   * @see #isValid()
   * @see ext.form.action.SubmitAction#clientValidation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-markInvalid Original Ext JS documentation of 'markInvalid'
   */
  public native function markInvalid(errors:*):void;

  /**
   * Performs any necessary manipulation of a raw field value to prepare it for
   * <i>conversion</i> (→<code>rawToValue()</code>) and/or <i>validation</i> (→<code>validate()</code>), for instance
   * stripping out ignored characters. In the base implementation it does nothing;
   * individual subclasses may override this as needed.
   * @param value The unprocessed string value
   * @return The processed string value
   * @see #rawToValue()
   * @see #validate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-processRawValue Original Ext JS documentation of 'processRawValue'
   */
  public native function processRawValue(value:Object):Object;

  /**
   * Converts a raw input field value into a mixed-type value that is suitable for this particular
   * field type. This allows controlling the normalization and conversion of user-entered values
   * into field-type-appropriate values, e.g. a Date object for →<code>ext.form.field.DateField</code>,
   * and is invoked by →<code>getValue()</code>.
   * <p>It is up to individual implementations to decide how to handle raw values that cannot be
   * successfully converted to the desired object type.</p>
   * <p>See →<code>valueToRaw()</code> for the opposite conversion.</p>
   * <p>The base implementation does no conversion, returning the raw value untouched.</p>
   * @return The converted value.
   * @see ext.form.field.DateField
   * @see #getValue()
   * @see #valueToRaw()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-rawToValue Original Ext JS documentation of 'rawToValue'
   */
  public native function rawToValue(rawValue:Object):Object;

  /**
   * @inheritDoc
   */
  public native function reset():void;

  /**
   * @inheritDoc
   */
  public native function resetOriginalValue():void;

  /**
   * @inheritDoc
   */
  public native function setActiveError(msg:String):void;

  /**
   * @inheritDoc
   */
  public native function setActiveErrors(errors:Array):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * @inheritDoc
   */
  public native function setFieldDefaults(defaults:Object):void;

  /**
   * @inheritDoc
   */
  public native function setFieldLabel(label:String):void;

  /**
   * Set the <i>CSS style</i> (→<code>fieldStyle</code>) of the <i>field input element</i> (→<code>inputEl</code>).
   * @param style The style(s) to apply. Should be a valid argument
   * to →<code>ext.dom.Element.applyStyles()</code>.
   * @see #fieldStyle
   * @see #inputEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-setFieldStyle Original Ext JS documentation of 'setFieldStyle'
   * @see ext.dom.Element#applyStyles()
   */
  public native function setFieldStyle(style:*):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the field's raw value directly, bypassing <i>value conversion</i> (→<code>valueToRaw()</code>),
   * change detection, and validation. To set the value with these additional inspections
   * see →<code>setValue()</code>.
   * @param value The value to set
   * @return value The field value that is set
   * @see #valueToRaw()
   * @see #setValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-setRawValue Original Ext JS documentation of 'setRawValue'
   */
  public native function setRawValue(value:Object):Object;

  /**
   * Sets the read only state of this field.
   * @param readOnly Whether the field should be read only.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-setReadOnly Original Ext JS documentation of 'setReadOnly'
   */
  public native function setReadOnly(readOnly:Boolean):void;

  /**
   * Sets the value of <code>validation</code>.
   * @param validation The new value.
   * @see #validation
   */
  public native function setValidation(validation:*):void;

  /**
   * Sets a data value into the field and runs the change detection and validation.
   * To set the value directly without these inspections see →<code>setRawValue()</code>.
   * @param value The value to set
   * @return this
   * @see #setRawValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  public native function setValue(value:*):IField;

  /**
   * Transform the raw value before it is set
   * @param value The value
   * @return The value to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-transformRawValue Original Ext JS documentation of 'transformRawValue'
   */
  protected native function transformRawValue(value:Object):Object;

  /**
   * @inheritDoc
   */
  public native function trimLabelSeparator():String;

  /**
   * @inheritDoc
   */
  public native function unsetActiveError():void;

  /**
   * @inheritDoc
   */
  public native function validate():Boolean;

  /**
   * Uses →<code>getErrors()</code> to build an array of validation errors. If any errors are found,
   * they are passed to →<code>markInvalid()</code> and false is returned, otherwise true is returned.
   * <p>Previously, subclasses were invited to provide an implementation of this to process
   * validations - from 3.2 onwards →<code>getErrors()</code> should be overridden instead.</p>
   * @param value The value to validate
   * @return True if all validations passed, false if one or more failed
   * @see #getErrors()
   * @see #markInvalid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-validateValue Original Ext JS documentation of 'validateValue'
   */
  public native function validateValue(value:Object):Boolean;

  /**
   * Converts a mixed-type value to a raw representation suitable for displaying in the field.
   * This allows controlling how value objects passed to →<code>setValue()</code> are shown to the user,
   * including localization. For instance, for a →<code>ext.form.field.DateField</code>, this would control
   * how a Date object passed to →<code>setValue()</code> would be converted to a String for display
   * in the field.
   * <p>See →<code>rawToValue()</code> for the opposite conversion.</p>
   * <p>The base implementation simply does a standard toString conversion, and converts
   * <i>empty values</i> (→<code>ext.Ext.isEmpty()</code>) to an empty string.</p>
   * @param value The mixed-type value to convert to the raw representation.
   * @return The converted raw value.
   * @see #setValue()
   * @see ext.form.field.DateField
   * @see #rawToValue()
   * @see ext.SExt#isEmpty() ext.Ext.isEmpty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Base.html#method-valueToRaw Original Ext JS documentation of 'valueToRaw'
   */
  public native function valueToRaw(value:Object):Object;
}
}