package ext.form.field {
import ext.XTemplate;
import ext.dom.Element;

[Native("Ext.form.field.Checkbox", require)]
/**
 * Single checkbox field. Can be used as a direct replacement for traditional checkbox fields.
 * Also serves as a parent class for <i>radio buttons</i> (→<code>ext.form.field.Radio</code>).
 * <p><b><i>Labeling</i></b></p>
 * <p>In addition to the <i>standard field labeling options</i> (→<code>ext.form.Labelable</code>), checkboxes
 * may be given an optional →<code>boxLabel</code> which will be displayed immediately after checkbox.
 * Also see →<code>ext.form.CheckboxGroup</code> for a convenient method of grouping related checkboxes.</p>
 * <p><b>Values</b></p>
 * <p>The main value of a checkbox is a boolean, indicating whether or not the checkbox is checked.
 * The following values will check the checkbox:</p>
 * <ul>
 * <li><code>true</code></li>
 * <li><code>'true'</code></li>
 * <li><code>'1'</code></li>
 * <li><code>'on'</code></li>
 * </ul>
 * <p>Any other value will un-check the checkbox.</p>
 * <p>In addition to the main boolean value, you may also specify a separate →<code>inputValue</code>.
 * This will be sent as the parameter value when the form is
 * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>). You will want to set this value if you have multiple
 * checkboxes with the same →<code>name</code>. If not specified, the value <code>→on()</code> will be used.</p>
 * <p><b><i>Example usage</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     bodyPadding: 10,
 *     width: 300,
 *     title: 'Pizza Order',
 *     items: [
 *         {
 *             xtype: 'fieldcontainer',
 *             fieldLabel: 'Toppings',
 *             defaultType: 'checkboxfield',
 *             items: [
 *                 {
 *                     boxLabel  : 'Anchovies',
 *                     name      : 'topping',
 *                     inputValue: '1',
 *                     id        : 'checkbox1'
 *                 }, {
 *                     boxLabel  : 'Artichoke Hearts',
 *                     name      : 'topping',
 *                     inputValue: '2',
 *                     checked   : true,
 *                     id        : 'checkbox2'
 *                 }, {
 *                     boxLabel  : 'Bacon',
 *                     name      : 'topping',
 *                     inputValue: '3',
 *                     id        : 'checkbox3'
 *                 }
 *             ]
 *         }
 *     ],
 *     bbar: [
 *         {
 *             text: 'Select Bacon',
 *             handler: function() {
 *                 Ext.getCmp('checkbox3').setValue(true);
 *             }
 *         },
 *         '-',
 *         {
 *             text: 'Select All',
 *             handler: function() {
 *                 Ext.getCmp('checkbox1').setValue(true);
 *                 Ext.getCmp('checkbox2').setValue(true);
 *                 Ext.getCmp('checkbox3').setValue(true);
 *             }
 *         },
 *         {
 *             text: 'Deselect All',
 *             handler: function() {
 *                 Ext.getCmp('checkbox1').setValue(false);
 *                 Ext.getCmp('checkbox2').setValue(false);
 *                 Ext.getCmp('checkbox3').setValue(false);
 *             }
 *         }
 *     ],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.form.field.Radio
 * @see ext.form.Labelable
 * @see #boxLabel
 * @see ext.form.CheckboxGroup
 * @see #inputValue
 * @see ext.form.BasicForm#submit()
 * @see #name
 * @see #on()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html Original Ext JS documentation of 'Ext.form.field.Checkbox'
 */
public class Checkbox extends BaseField {
  /**
   * @param config @inheritDoc
   */
  public function Checkbox(config:Checkbox = null) {
    super();
  }

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the box label text. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-afterBoxLabelTextTpl Original Ext JS documentation of 'afterBoxLabelTextTpl'
   */
  public native function get afterBoxLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterBoxLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the box label element. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-afterBoxLabelTpl Original Ext JS documentation of 'afterBoxLabelTpl'
   */
  public native function get afterBoxLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterBoxLabelTpl(value:*):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'native'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the box label text. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-beforeBoxLabelTextTpl Original Ext JS documentation of 'beforeBoxLabelTextTpl'
   */
  public native function get beforeBoxLabelTextTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeBoxLabelTextTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the box label element. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-beforeBoxLabelTpl Original Ext JS documentation of 'beforeBoxLabelTpl'
   */
  public native function get beforeBoxLabelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeBoxLabelTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional text label that will appear next to the checkbox. Whether it appears before
   * or after the checkbox is determined by the →<code>boxLabelAlign</code> config.
   * @see #boxLabelAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-boxLabel Original Ext JS documentation of 'boxLabel'
   * @see #setBoxLabel()
   */
  public native function get boxLabel():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set boxLabel(value:String):void;

  [ExtConfig]
  /**
   * The position relative to the checkbox where the →<code>boxLabel</code> should appear.
   * Recognized values are 'before' and 'after'.
   * @default 'after'
   * @see #boxLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-boxLabelAlign Original Ext JS documentation of 'boxLabelAlign'
   */
  public native function get boxLabelAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set boxLabelAlign(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * inside the box label element (as attributes). If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-boxLabelAttrTpl Original Ext JS documentation of 'boxLabelAttrTpl'
   */
  public native function get boxLabelAttrTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set boxLabelAttrTpl(value:*):void;

  [ExtConfig]
  /**
   * The CSS class to be applied to the →<code>boxLabel</code> element
   * @default Ext.baseCSSPrefix + 'form-cb-label'
   * @see #boxLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-boxLabelCls Original Ext JS documentation of 'boxLabelCls'
   */
  public native function get boxLabelCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set boxLabelCls(value:String):void;

  /**
   * A reference to the label element created for the →<code>boxLabel</code>. Only present
   * if the component has been rendered and has a boxLabel configured.
   * @see #boxLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#property-boxLabelEl Original Ext JS documentation of 'boxLabelEl'
   */
  public native function get boxLabelEl():Element;

  /**
   * @private
   */
  public native function set boxLabelEl(value:Element):void;

  [ExtConfig]
  /**
   * true if the checkbox should render initially checked
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-checked Original Ext JS documentation of 'checked'
   */
  public native function get checked():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checked(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class(es) added to the component's main element when it is in the checked state.
   * You can add your own class (checkedCls='myClass x-form-cb-checked') or replace the default
   * class altogether (checkedCls='myClass').
   * @default Ext.baseCSSPrefix + 'form-cb-checked'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-checkedCls Original Ext JS documentation of 'checkedCls'
   */
  public native function get checkedCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkedCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default [
   *     'boxLabelEl',
   *     'innerWrapEl',
   *     'displayEl'
   * ]
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * The default CSS class for the checkbox
   * @default 'x-form-field'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-fieldCls Original Ext JS documentation of 'fieldCls'
   */
  override public native function get fieldCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set fieldCls(value:String):void;

  [ExtConfig]
  /**
   * The content of the field body is defined by this config option.
   * @default [
   *     '<div id="{cmpId}-innerWrapEl" data-ref="innerWrapEl" role="presentation"',
   *     ' class="{wrapInnerCls}">',
   *     '<tpl if="labelAlignedBefore">',
   *     '{beforeBoxLabelTpl}',
   *     '<label id="{cmpId}-boxLabelEl" data-ref="boxLabelEl" {boxLabelAttrTpl} class="{boxLabelCls} ',
   *     '{boxLabelCls}-{ui} {boxLabelCls}-{boxLabelAlign} {noBoxLabelCls} {childElCls}" for="{id}">',
   *     '{beforeBoxLabelTextTpl}',
   *     '{boxLabel}',
   *     '{afterBoxLabelTextTpl}',
   *     '</label>',
   *     '{afterBoxLabelTpl}',
   *     '</tpl>',
   *     '<span id="{cmpId}-displayEl" data-ref="displayEl" role="presentation" class="{fieldCls} {typeCls} ',
   *     '{typeCls}-{ui} {inputCls} {inputCls}-{ui} {fixCls} {childElCls} {afterLabelCls}">',
   *     '<input type="{inputType}" id="{id}" name="{inputName}" data-ref="inputEl" {inputAttrTpl}',
   *     '<tpl if="tabIdx != null"> tabindex="{tabIdx}"</tpl>',
   *     '<tpl if="disabled"> disabled="disabled"</tpl>',
   *     '<tpl if="checked"> checked="checked"</tpl>',
   *     '<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
   *     ' class="{checkboxCls}" autocomplete="off" hidefocus="true" ',
   *     '<tpl foreach="ariaElAttributes"> {$}="{.}"</tpl>',
   *     '<tpl foreach="inputElAriaAttributes"> {$}="{.}"</tpl>',
   *     '/>',
   *     '</span>',
   *     '<tpl if="!labelAlignedBefore">',
   *     '{beforeBoxLabelTpl}',
   *     '<label id="{cmpId}-boxLabelEl" data-ref="boxLabelEl" {boxLabelAttrTpl} class="{boxLabelCls} ',
   *     '{boxLabelCls}-{ui} {boxLabelCls}-{boxLabelAlign} {noBoxLabelCls} {childElCls}" for="{id}">',
   *     '{beforeBoxLabelTextTpl}',
   *     '{boxLabel}',
   *     '{afterBoxLabelTextTpl}',
   *     '</label>',
   *     '{afterBoxLabelTpl}',
   *     '</tpl>',
   *     '</div>',
   *     {
   *         disableFormats: true,
   *         compiled: true
   *     }
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-fieldSubTpl Original Ext JS documentation of 'fieldSubTpl'
   */
  public native function get fieldSubTpl():XTemplate;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldSubTpl(value:XTemplate):void;

  [ExtConfig]
  /**
   * The CSS class to use when the checkbox receives focus
   * @default 'form-checkbox-focus'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  override public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusCls(value:String):void;

  [ExtConfig]
  /**
   * A function called when the →<code>checked</code> value changes (can be used instead of handling
   * the <i>change event</i> (→<code>event:onChange</code>)).
   * <ul>
   * <li><code>checkbox:ext.form.field.Checkbox</code> (optional) —
   * The Checkbox being toggled.
   * </li>
   * <li><code>checked:Boolean</code> (optional) —
   * The new checked state of the checkbox.
   * </li>
   * </ul>
   * @see #checked
   * @see #event:onChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * The type attribute for input fields -- e.g. radio, text, password, file. The extended types
   * supported by HTML5 inputs (url, email, etc.) may also be used, though using them will cause
   * older browsers to fall back to 'text'.
   * <p>The type 'password' must be used to render that field type currently -- there is no separate
   * Ext component for that. You can use →<code>ext.form.field.FileUploadField</code> which creates
   * a custom-rendered file upload field, but if you want a plain unstyled file input you can use
   * a Base with inputType:'file'.</p>
   * @default 'checkbox'
   * @see ext.form.field.FileUploadField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-inputType Original Ext JS documentation of 'inputType'
   */
  override public native function get inputType():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set inputType(value:String):void;

  [ExtConfig]
  /**
   * The value that should go into the generated input element's value attribute and
   * should be used as the parameter value when submitting as part of a form.
   * @default 'on'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-inputValue Original Ext JS documentation of 'inputValue'
   */
  public native function get inputValue():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inputValue(value:*):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Checkbox, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#property-isCheckbox Original Ext JS documentation of 'isCheckbox'
   */
  public native function get isCheckbox():Boolean;

  /**
   * @private
   */
  public native function set isCheckbox(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> if this field renders as a text input.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-isTextInput Original Ext JS documentation of 'isTextInput'
   */
  public native function get isTextInput():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set isTextInput(value:Boolean):void;

  [ExtConfig]
  /**
   * The value to use for →<code>getModelData()</code> when checked.
   * @default true
   * @since 6.2.1
   * @see #getModelData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-modelValue Original Ext JS documentation of 'modelValue'
   */
  public native function get modelValue():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set modelValue(value:*):void;

  [ExtConfig]
  /**
   * The value to use for →<code>getModelData()</code> when unchecked.
   * @default false
   * @since 6.2.1
   * @see #getModelData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-modelValueUnchecked Original Ext JS documentation of 'modelValueUnchecked'
   */
  public native function get modelValueUnchecked():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set modelValueUnchecked(value:*):void;

  /**
   * The original value of the field as configured in the →<code>checked</code> configuration,
   * or as loaded by the last form load operation if the form's
   * →<code>ext.form.BasicForm.trackResetOnLoad</code> setting is <code>true</code>.
   * @default checked
   * @see #checked
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#property-originalValue Original Ext JS documentation of 'originalValue'
   */
  override public native function get originalValue():*;

  /**
   * @private
   */
  override public native function set originalValue(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default {
   *     checked: 1
   * }
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * An object to use as the scope ('this' reference) of the →<code>handler</code> function.
   * <p>Defaults to this Checkbox.</p>
   * @see #handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * If configured, this will be submitted as the checkbox's value during form submit
   * if the checkbox is unchecked. By default this is undefined, which results in
   * nothing being submitted for the checkbox field when the form is submitted
   * (the default behavior of HTML checkboxes).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#cfg-uncheckedValue Original Ext JS documentation of 'uncheckedValue'
   */
  public native function get uncheckedValue():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set uncheckedValue(value:String):void;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Returns the checked state of the checkbox.
   * @return True if checked, else false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#method-getRawValue Original Ext JS documentation of 'getRawValue'
   */
  override public native function getRawValue():String;

  /**
   * Returns the submit value for the checkbox which can be used when submitting forms.
   * @return If checked the →<code>inputValue</code> is returned; otherwise the
   * →<code>uncheckedValue</code> (or null if the latter is not configured).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#method-getSubmitValue Original Ext JS documentation of 'getSubmitValue'
   * @see #inputValue
   * @see #uncheckedValue
   */
  override public native function getSubmitValue():String;

  /**
   * Returns the checked state of the checkbox.
   * @return True if checked, else false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  override public native function getValue():*;

  /**
   * Sets the →<code>boxLabel</code> for this checkbox.
   * @param boxLabel The new label
   * @see #boxLabel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#method-setBoxLabel Original Ext JS documentation of 'setBoxLabel'
   */
  public native function setBoxLabel(boxLabel:String):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the checked state of the checkbox.
   * @param value The value to set
   * @return the new checked state of the checkbox
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#method-setRawValue Original Ext JS documentation of 'setRawValue'
   */
  override public native function setRawValue(value:Object):Object;

  /**
   * Sets the checked state of the checkbox, and invokes change detection.
   * @param value The value to set
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Checkbox.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;
}
}