package ext.form.field {
import ext.data.AbstractStore;
import ext.data.Model;
import ext.data.Store;
import ext.util.FilterCollection;
import ext.util.IStoreHolder;

[Native("Ext.form.field.ComboBox", require)]
/**
 * @see ext.form.field.events.ComboBox_record_indexEvent.BEFORE_DESELECT
 * @eventType ext.form.field.events.ComboBox_record_indexEvent.BEFORE_DESELECT
 */
[Event(name='onBeforeDeselect', type='ext.form.field.events.ComboBox_record_indexEvent')]
/**
 * @see ext.form.field.events.ComboBox_queryPlanEvent.BEFORE_QUERY
 * @eventType ext.form.field.events.ComboBox_queryPlanEvent.BEFORE_QUERY
 */
[Event(name='onBeforeQuery', type='ext.form.field.events.ComboBox_queryPlanEvent')]
/**
 * @see ext.form.field.events.ComboBox_record_indexEvent.BEFORE_SELECT
 * @eventType ext.form.field.events.ComboBox_record_indexEvent.BEFORE_SELECT
 */
[Event(name='onBeforeSelect', type='ext.form.field.events.ComboBox_record_indexEvent')]
/**
 * @see ext.form.field.events.ComboBox_recordEvent.SELECT
 * @eventType ext.form.field.events.ComboBox_recordEvent.SELECT
 */
[Event(name='onSelect', type='ext.form.field.events.ComboBox_recordEvent')]
/**
 * A combobox control with support for autocomplete, remote loading, and many other features.
 * <p>A ComboBox is like a combination of a traditional HTML text <code>&lt;input&gt;</code> field and a <code>&lt;select&gt;</code>
 * field; the user is able to type freely into the field, and/or pick values from a dropdown
 * selection list. The user can input any value by default, even if it does not appear
 * in the selection list; to prevent free-form values and restrict them to items in the list,
 * set →<code>forceSelection</code> to <code>true</code>.</p>
 * <p>The selection list's options are populated from any →<code>ext.data.Store</code>, including remote
 * stores. The data items in the store are mapped to each option's displayed text and backing value
 * via the →<code>valueField</code> and →<code>displayField</code> configurations, respectively.</p>
 * <p>If your store is not remote, i.e. it depends only on local data and is loaded up front,
 * you should be sure to set the →<code>queryMode</code> to <code>'local'</code>, as this will improve
 * responsiveness for the user.</p>
 * <p><b>Example usage:</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * // The data store containing the list of states
 * var states = Ext.create('Ext.data.Store', {
 *     fields: ['abbr', 'name'],
 *     data : [
 *         {"abbr":"AL", "name":"Alabama"},
 *         {"abbr":"AK", "name":"Alaska"},
 *         {"abbr":"AZ", "name":"Arizona"}
 *     ]
 * });
 *
 * // Create the combo box, attached to the states data store
 * Ext.create('Ext.form.ComboBox', {
 *     fieldLabel: 'Choose State',
 *     store: states,
 *     queryMode: 'local',
 *     displayField: 'name',
 *     valueField: 'abbr',
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p><b>Events</b></p>
 * <p>To do something when something in ComboBox is selected, configure the select event:</p>
 * <pre>
 * var cb = Ext.create('Ext.form.ComboBox', {
 *     // all of your config options
 *     listeners:{
 *          scope: yourScope,
 *          'select': yourFunction
 *     }
 * });
 *
 * // Alternatively, you can assign events after the object is created:
 * var cb = new Ext.form.field.ComboBox(yourOptions);
 * cb.on('select', yourFunction, yourScope);
 * </pre>
 * <p><b>Multiple Selection</b></p>
 * <p>The →<code>multiSelect</code> config is deprecated. For multiple selection use
 * →<code>ext.form.field.Tag</code> or →<code>ext.view.MultiSelectorView</code>.</p>
 * <p><b>Filtered Stores</b></p>
 * <p>If you have a local store that is already filtered, you can use the →<code>lastQuery</code>
 * config option to prevent the store from having the filter being cleared on first expand.</p>
 * <p><b><i>Customized combobox</i></b></p>
 * <p>Both the text shown in dropdown menu and text field can be easily customized:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var states = Ext.create('Ext.data.Store', {
 *     fields: ['abbr', 'name'],
 *     data : [
 *         {"abbr":"AL", "name":"Alabama"},
 *         {"abbr":"AK", "name":"Alaska"},
 *         {"abbr":"AZ", "name":"Arizona"}
 *     ]
 * });
 *
 * Ext.create('Ext.form.ComboBox', {
 *     fieldLabel: 'Choose State',
 *     store: states,
 *     queryMode: 'local',
 *     valueField: 'abbr',
 *     renderTo: Ext.getBody(),
 *     // Template for the dropdown menu.
 *     // Note the use of the "x-list-plain" and "x-boundlist-item" class,
 *     // this is required to make the items selectable.
 *     tpl: Ext.create('Ext.XTemplate',
 *         '&lt;ul class="x-list-plain"&gt;&lt;tpl for="."&gt;',
 *             '&lt;li role="option" class="x-boundlist-item"&gt;{abbr} - {name}&lt;/li&gt;',
 *         '&lt;/tpl&gt;&lt;/ul&gt;'
 *     ),
 *     // template for the content inside text field
 *     displayTpl: Ext.create('Ext.XTemplate',
 *         '&lt;tpl for="."&gt;',
 *             '{abbr} - {name}',
 *         '&lt;/tpl&gt;'
 *     )
 * });
 * </pre>
 * <p>See also the →<code>listConfig</code> option for additional configuration of the dropdown.</p>
 * @see #forceSelection
 * @see ext.data.Store
 * @see #valueField
 * @see #displayField
 * @see #queryMode
 * @see #multiSelect
 * @see ext.form.field.Tag
 * @see ext.view.MultiSelectorView
 * @see #lastQuery
 * @see #listConfig
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html Original Ext JS documentation of 'Ext.form.field.ComboBox'
 */
public class ComboBox extends Picker implements IStoreHolder {
  /**
   * @param config @inheritDoc
   */
  public function ComboBox(config:ComboBox = null) {
    super();
  }

  [ExtConfig]
  /**
   * The text query to send to the server to return all records for the list with no filtering
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-allQuery Original Ext JS documentation of 'allQuery'
   */
  public native function get allQuery():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allQuery(value:String):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to allow matching of the typed characters at any position in the
   * →<code>valueField</code>'s value.
   * @default false
   * @see #valueField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-anyMatch Original Ext JS documentation of 'anyMatch'
   */
  public native function get anyMatch():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anyMatch(value:Boolean):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'combobox'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  override public native function set ariaRole(value:String):void;

  /**
   * This property allows the object
   * to destroy bound stores that have →<code>ext.data.AbstractStore.autoDestroy</code>
   * option set to <code>true</code>.
   * @default true
   * @see ext.data.AbstractStore#autoDestroy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#property-autoDestroyBoundStore Original Ext JS documentation of 'autoDestroyBoundStore'
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @private
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  [ExtConfig]
  /**
   * This option controls whether to <i>initially</i> load the store when a value is set so that
   * the display value can be determined from the appropriate record.
   * The store will only be loaded in a limited set of circumstances:
   * <ul>
   * <li>The store is not currently loading.</li>
   * <li>The store does not have a pending →<code>ext.data.Store.autoLoad</code>.</li>
   * <li>The store has not been loaded before.</li>
   * </ul>
   * @default false
   * @see ext.data.Store#autoLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-autoLoadOnValue Original Ext JS documentation of 'autoLoadOnValue'
   */
  public native function get autoLoadOnValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoLoadOnValue(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to automatically highlight the first result gathered by the data store in the
   * dropdown list when it is opened. A false value would cause nothing in the list to be
   * highlighted automatically, so the user would have to manually highlight an item before
   * pressing the enter or <i>tab</i> (→<code>selectOnTab</code>) key to select it (unless the value of
   * (→<code>typeAhead</code>) were true), or use the mouse to select a value.
   * @default true
   * @see #selectOnTab
   * @see #typeAhead
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-autoSelect Original Ext JS documentation of 'autoSelect'
   */
  public native function get autoSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * When <code>true</code>, the last selected record in the dropdown list will be re-selected
   * upon →<code>autoSelect</code>. Set to <code>false</code> to always select the first record in the
   * drop-down list. For accessible applications it is recommended to set this option
   * to <code>false</code>.
   * @default true
   * @see #autoSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-autoSelectLast Original Ext JS documentation of 'autoSelectLast'
   */
  public native function get autoSelectLast():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoSelectLast(value:Boolean):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to make the filtering match with exact case matching
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-caseSensitive Original Ext JS documentation of 'caseSensitive'
   */
  public native function get caseSensitive():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set caseSensitive(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The canonical form of <code>→childEls</code> is an object keyed by child's property name
   * with values that are objects with the following properties.
   * <ul>
   * <li><code>→itemId</code> - The id to combine with the Component's id that is the id of the
   * child element.</li>
   * <li><code>→id</code> - The id of the child element.</li>
   * <li><code>leaf</code> - Set to <code>true</code> to ignore content when scanning for childEls. This
   * should be set on things like the generated content for an <code>→ext.view.DataView</code>.</li>
   * <li><code>select</code>: A selector that will be passed to →<code>ext.dom.Element.select()</code>.</li>
   * <li><code>selectNode</code>: A selector that will be passed to
   * →<code>ext.dom.Element.selectNode()</code>.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   *  childEls: {
   *      button: true,
   *      buttonText: 'text',
   *      buttonImage: {
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above is translated into the following complete form:</p>
   * <pre>
   *  childEls: {
   *      button: {
   *          name: 'button',
   *          itemId: 'button'
   *      },
   *      buttonText: {
   *          name: 'buttonText',
   *          itemId: 'text'
   *      },
   *      buttonImage: {
   *          name: 'buttonImage',
   *          itemId: 'image'
   *      }
   *  }
   * </pre>
   * <p>The above can be provided as an array like so:</p>
   * <pre>
   *  childEls: [
   *      'button',
   *      { name: 'buttonText', itemId: 'text' },
   *      { name: 'buttonImage', itemId: 'image' }
   *  }
   * </pre>
   * <p>For example, a Component which renders a title and body text:</p>
   * <p><b>Example:</b></p>
   * <pre>
   * Ext.create('Ext.Component', {
   *     renderTo: Ext.getBody(),
   *     renderTpl: [
   *         '&lt;h1 id="{id}-title" data-ref="title"&gt;{title}&lt;/h1&gt;',
   *         '&lt;p&gt;{msg}&lt;/p&gt;',
   *     ],
   *     renderData: {
   *         title: "Error",
   *         msg: "Something went wrong"
   *     },
   *     childEls: ["title"],
   *     listeners: {
   *         afterrender: function(cmp){
   *             // After rendering the component will have a title property
   *             cmp.title.setStyle({color: "red"});
   *         }
   *     }
   * });
   * </pre>
   * <p><b>Note:</b> <code>childEl</code>s in the →<code>ext.Component.renderTpl</code>
   * must be referenced in a <b>data-ref</b> attribute. Notice in the above example
   * that the "title" <code>childEl</code> is set in the <code>→renderTpl</code> using
   * <b>data-ref="title"</b>.</p>
   * <p>When using <code>select</code>, the property will be an instance of →<code>ext.dom.CompositeElement</code>.
   * In all other cases, the property will be an →<code>ext.dom.Element</code> or <code>null</code>
   * if not found.</p>
   * <p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements.
   * The following issues should be considered:</p>
   * <ul>
   * <li>Performance: using selectors can be 10x slower than id lookup.</li>
   * <li>Over-selecting: selectors are applied after the DOM elements for all children
   * have been rendered, so selectors can match elements from child components
   * (including nested versions of the same component) accidentally.</li>
   * </ul>
   * <p>This above issues are most important when using <code>select</code> since it returns multiple
   * elements.</p>
   * @default {
   *     'hiddenDataEl': true
   * }
   * @see #childEls
   * @see #itemId
   * @see #id
   * @see ext.view.DataView
   * @see ext.dom.Element#select()
   * @see ext.dom.Element#selectNode()
   * @see ext.Component#renderTpl
   * @see #renderTpl
   * @see ext.dom.CompositeElement
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-childEls Original Ext JS documentation of 'childEls'
   * @see #getChildEls()
   * @see #setChildEls()
   */
  override public native function get childEls():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set childEls(value:*):void;

  [ExtConfig]
  /**
   * <i>When →<code>queryMode</code> is <code>'local'</code> only</i>.
   * <p>As text is entered, the underlying store is filtered to match the value. When this option
   * is <code>true</code>, any filtering applied by this field will be cleared when focus is removed
   * &amp; reinstated on focus.
   * If <code>false</code>, the filters will be left in place.</p>
   * @default true
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-clearFilterOnBlur Original Ext JS documentation of 'clearFilterOnBlur'
   */
  public native function get clearFilterOnBlur():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clearFilterOnBlur(value:Boolean):void;

  [Deprecated(replacement="ext.form.field.Tag", since="5.1.0")]
  [ExtConfig]
  /**
   * Has no effect if →<code>multiSelect</code> is <code>false</code>.
   * <p>Configure as true to automatically collapse the pick list after a selection is made.</p>
   * @default false
   * @see #multiSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-collapseOnSelect Original Ext JS documentation of 'collapseOnSelect'
   */
  public native function get collapseOnSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseOnSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * Set of options that will be used as defaults for the user-configured →<code>listConfig</code>
   * object.
   * @default {
   *     loadingHeight: 70,
   *     minWidth: 70,
   *     maxHeight: 300,
   *     shadow: 'sides'
   * }
   * @see #listConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-defaultListConfig Original Ext JS documentation of 'defaultListConfig'
   */
  public native function get defaultListConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultListConfig(value:Object):void;

  [Deprecated(replacement="ext.form.field.Tag", since="5.1.0")]
  [ExtConfig]
  [Bindable]
  /**
   * The character(s) used to separate the <i>display values</i> (→<code>displayField</code>) of multiple
   * selected items when <code>→multiSelect = true</code>.
   * @default ', '
   * @see #displayField
   * @see #multiSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-delimiter Original Ext JS documentation of 'delimiter'
   * @see #getDelimiter()
   * @see #setDelimiter()
   */
  public native function get delimiter():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set delimiter(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The underlying <i>data field name</i> (→<code>ext.data.field.DataField.name</code>) to bind to this ComboBox.
   * <p>See also <code>→valueField</code>.</p>
   * @default 'text'
   * @see ext.data.field.DataField#name
   * @see #valueField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-displayField Original Ext JS documentation of 'displayField'
   * @see #getDisplayField()
   * @see #setDisplayField()
   */
  public native function get displayField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set displayField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The template to be used to display selected records inside the text field. An array
   * of the selected records' data will be passed to the template. Defaults to:
   * <pre>
   * '&lt;tpl for="."&gt;' +
   *     '{[typeof values === "string" ? values : values["' + me.displayField + '"]]}' +
   *     '&lt;tpl if="xindex &lt; xcount"&gt;' + me.delimiter + '&lt;/tpl&gt;' +
   * '&lt;/tpl&gt;'
   * </pre>
   * <p>By default only the immediate data of the record is passed (no associated data).
   * The →<code>getRecordDisplayData()</code> can be overridden to extend this.</p>
   * @default null
   * @see #getRecordDisplayData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-displayTpl Original Ext JS documentation of 'displayTpl'
   * @see #getDisplayTpl()
   * @see #setDisplayTpl()
   */
  public native function get displayTpl():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set displayTpl(value:*):void;

  [ExtConfig]
  /**
   * <i>When →<code>queryMode</code> is <code>'local'</code> only</i>.
   * <p>Set to <code>true</code> to have the ComboBox use the typed value as a RegExp source to filter the store
   * to get possible matches. Invalid regex values will be ignored.</p>
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-enableRegEx Original Ext JS documentation of 'enableRegEx'
   */
  public native function get enableRegEx():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableRegEx(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to restrict the selected value to one of the values in the list, <code>false</code> to allow
   * the user to set arbitrary text into the field.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-forceSelection Original Ext JS documentation of 'forceSelection'
   */
  public native function get forceSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set forceSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>false</code> to not allow the component to resize itself when its data changes
   * (and its →<code>grow</code> property is <code>true</code>)
   * @default true
   * @see #grow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-growToLongestValue Original Ext JS documentation of 'growToLongestValue'
   */
  public native function get growToLongestValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set growToLongestValue(value:Boolean):void;

  [ExtConfig]
  /**
   * The name of an underlying hidden field which will be synchronized with the underlying value
   * of the combo. This option is useful if the combo is part of a form element doing a regular
   * form post. The hidden field will not be created unless a hiddenName is specified.
   * @default ""
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-hiddenName Original Ext JS documentation of 'hiddenName'
   */
  public native function get hiddenName():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hiddenName(value:String):void;

  /**
   * The value of the match string used to filter the store. Delete this property to force
   * a requery. Example use:
   * <pre>
   * var combo = new Ext.form.field.ComboBox({
   *     ...
   *     queryMode: 'remote',
   *     listeners: {
   *         // delete the previous query in the beforequery event or set
   *         // combo.lastQuery = null (this will reload the store the next time it expands)
   *         beforequery: function(qe){
   *             delete qe.combo.lastQuery;
   *         }
   *     }
   * });
   * </pre>
   * <p>To make sure the filter in the store is not cleared the first time the ComboBox trigger
   * is used configure the combo with <code>lastQuery=''</code>. Example use:</p>
   * <pre>
   * var combo = new Ext.form.field.ComboBox({
   *     ...
   *     queryMode: 'local',
   *     triggerAction: 'all',
   *     lastQuery: ''
   * });
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#property-lastQuery Original Ext JS documentation of 'lastQuery'
   */
  public native function get lastQuery():String;

  /**
   * @private
   */
  public native function set lastQuery(value:String):void;

  [ExtConfig]
  /**
   * An optional set of configuration properties that will be passed to the
   * →<code>ext.view.BoundListView</code>'s constructor. Any configuration that is valid for BoundList
   * can be included. Some of the more useful ones are:
   * <ul>
   * <li>
   * <p>→<code>ext.view.BoundListView.cls</code> - defaults to empty</p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.emptyText</code> - defaults to empty string</p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.itemSelector</code> - defaults to the value defined
   * in BoundList</p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.loadingText</code> - defaults to <code>'Loading...'</code></p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.minWidth</code> - defaults to <code>70</code></p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.maxWidth</code> - defaults to <code>undefined</code></p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.maxHeight</code> - defaults to <code>300</code></p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.resizable</code> - defaults to <code>false</code></p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.shadow</code> - defaults to <code>'sides'</code></p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.width</code> - defaults to <code>undefined</code> (automatically set
   * to the width of the ComboBox field if →<code>matchFieldWidth</code> is true)</p>
   * </li>
   * <li>
   * <p>→<code>ext.view.BoundListView.getInnerTpl()</code> A function which returns a template
   * string which renders the ComboBox's →<code>displayField</code> value in the dropdown.
   * This defaults to just outputting the raw value, but may use any
   * →<code>ext.XTemplate</code> methods to produce output.</p>
   * <p>The running template is configured with some extra properties that provide some context:
   * - field →<code>ext.form.field.ComboBox</code> This combobox
   * - store →<code>ext.data.Store</code> This combobox's data store</p>
   * </li>
   * </ul>
   * @see ext.view.BoundListView
   * @see ext.view.BoundListView#cls
   * @see ext.view.BoundListView#emptyText
   * @see ext.view.BoundListView#itemSelector
   * @see ext.view.BoundListView#loadingText
   * @see ext.view.BoundListView#minWidth
   * @see ext.view.BoundListView#maxWidth
   * @see ext.view.BoundListView#maxHeight
   * @see ext.view.BoundListView#resizable
   * @see ext.view.BoundListView#shadow
   * @see ext.view.BoundListView#width
   * @see #matchFieldWidth
   * @see ext.view.BoundListView#getInnerTpl()
   * @see #displayField
   * @see ext.XTemplate
   * @see ext.form.field.ComboBox
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-listConfig Original Ext JS documentation of 'listConfig'
   */
  public native function get listConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set listConfig(value:Object):void;

  [ExtConfig]
  /**
   * The minimum number of characters the user must type before autocomplete and
   * →<code>typeAhead</code> activate.
   * <p>Defaults to <code>4</code> if <code>→queryMode = 'remote'</code> or <code>0</code> if <code>→queryMode = 'local'</code>,
   * does not apply if <code>→ext.form.field.TriggerField.editable = false</code>.</p>
   * @see #typeAhead
   * @see #queryMode
   * @see ext.form.field.TriggerField#editable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-minChars Original Ext JS documentation of 'minChars'
   */
  public native function get minChars():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minChars(value:Number):void;

  [Deprecated(replacement="ext.form.field.Tag", since="5.1.0")]
  [ExtConfig]
  /**
   * If set to <code>true</code>, allows the combo field to hold more than one value at a time, and allows
   * selecting multiple items from the dropdown list. The combo's text field will show all
   * selected values separated by the →<code>delimiter</code>.
   * @default false
   * @see #delimiter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-multiSelect Original Ext JS documentation of 'multiSelect'
   */
  public native function get multiSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set multiSelect(value:Boolean):void;

  [ExtConfig]
  /**
   * If greater than <code>0</code>, a →<code>ext.toolbar.PagingToolbar</code> is displayed in the footer of the dropdown
   * list and the <i>filter queries</i> (→<code>doQuery()</code>) will execute with page start
   * and <i>limit</i> (→<code>ext.view.BoundListView.pageSize</code>) parameters.
   * Only applies when <code>→queryMode = 'remote'</code>.
   * @default 0
   * @see ext.toolbar.PagingToolbar
   * @see #doQuery()
   * @see ext.view.BoundListView#pageSize
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-pageSize Original Ext JS documentation of 'pageSize'
   */
  public native function get pageSize():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pageSize(value:Number):void;

  [Deprecated(replacement="ext.form.field.Tag", since="5.1.0")]
  [ExtConfig]
  /**
   * Has no effect if →<code>multiSelect</code> is <code>false</code>.
   * <p>Configure as <code>false</code> to automatically collapse the pick list after a selection is made.</p>
   * @default true
   * @see #multiSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-pinList Original Ext JS documentation of 'pinList'
   */
  public native function get pinList():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pinList(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>→reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState()</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default [
   *     'selection'
   * ]
   * @see #reference
   * @see #publishState()
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * When true, this prevents the combo from re-querying (either locally or remotely) when
   * the current query is the same as the previous query.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-queryCaching Original Ext JS documentation of 'queryCaching'
   */
  public native function get queryCaching():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set queryCaching(value:Boolean):void;

  [ExtConfig]
  /**
   * The length of time in milliseconds to delay between the start of typing and sending the query
   * to filter the dropdown list.
   * <p>Defaults to <code>500</code> if <code>→queryMode = 'remote'</code> or <code>10</code> if
   * <code>→queryMode = 'local'</code></p>
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-queryDelay Original Ext JS documentation of 'queryDelay'
   */
  public native function get queryDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set queryDelay(value:Number):void;

  [ExtConfig]
  /**
   * The mode in which the ComboBox uses the configured Store. Acceptable values are:
   * <ul>
   * <li>
   * <p><b><code>'remote'</code></b> :</p>
   * <p>In <code>queryMode: 'remote'</code>, the ComboBox loads its Store dynamically based upon user
   * interaction.</p>
   * <p>This is typically used for "autocomplete" type inputs, and after the user finishes
   * typing, the Store is →<code>ext.data.Store.load()</code>ed.</p>
   * <p>A parameter containing the typed string is sent in the load request. The default
   * parameter name for the input string is <code>query</code>, but this can be configured using
   * the →<code>queryParam</code> config.</p>
   * <p>In <code>queryMode: 'remote'</code>, the Store may be configured with
   * <code>→ext.data.Store.remoteFilter: true</code>, and further filters may be
   * <i>programatically</i> added to the Store which are then passed with every load
   * request which allows the server to further refine the returned dataset.</p>
   * <p>Typically, in an autocomplete situation, →<code>hideTrigger</code> is configured <code>true</code>
   * because it has no meaning for autocomplete.</p>
   * </li>
   * <li>
   * <p><b><code>'local'</code></b> :</p>
   * <p>ComboBox loads local data</p>
   * <pre>
   * var combo = new Ext.form.field.ComboBox({
   *     renderTo: document.body,
   *     queryMode: 'local',
   *     store: new Ext.data.ArrayStore({
   *         id: 0,
   *         fields: [
   *             'myId',  // numeric value is the key
   *             'displayText'
   *         ],
   *         data: [[1, 'item1'], [2, 'item2']]  // data is local
   *     }),
   *     valueField: 'myId',
   *     displayField: 'displayText',
   *     triggerAction: 'all'
   * });
   * </pre>
   * </li>
   * </ul>
   * @default 'remote'
   * @see ext.data.Store#load()
   * @see #queryParam
   * @see ext.data.Store#remoteFilter
   * @see #hideTrigger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-queryMode Original Ext JS documentation of 'queryMode'
   */
  public native function get queryMode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set queryMode(value:String):void;

  [ExtConfig]
  /**
   * Name of the parameter used by the Store to pass the typed string when the ComboBox
   * is configured with <code>→queryMode: 'remote'</code>. If explicitly set to a falsy value
   * it will not be sent.
   * @default 'query'
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-queryParam Original Ext JS documentation of 'queryParam'
   */
  public native function get queryParam():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set queryParam(value:String):void;

  [ExtConfig]
  /**
   * Whether the Tab key should select the currently highlighted item.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-selectOnTab Original Ext JS documentation of 'selectOnTab'
   */
  public native function get selectOnTab():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set selectOnTab(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The selected model. Typically used with <i>binding</i> (→<code>bind</code>).
   * @see #bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-selection Original Ext JS documentation of 'selection'
   * @see #getSelection()
   * @see #setSelection()
   */
  public native function get selection():Model;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set selection(value:Model):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * <b>This is a required setting</b>. The data source to which the combo / tagfield is bound. Acceptable values for this
   * property are:
   * <ul>
   * <li>
   * <p><b>any →<code>ext.data.Store</code> class / subclass</b></p>
   * </li>
   * <li>
   * <p><b>an <i>ID of a store</i> (→<code>ext.data.Store.storeId</code>)</b></p>
   * </li>
   * <li>
   * <p><b>an Array</b> : Arrays will be converted to a →<code>ext.data.Store</code> internally,
   * automatically generating <i>field names</i> (→<code>ext.data.field.DataField.name</code>) to work with all
   * data components.</p>
   * <ul>
   * <li>
   * <p><b>1-dimensional array</b> : (e.g., <code>['Foo','Bar']</code>)</p>
   * <p>A 1-dimensional array will automatically be expanded (each array item will be
   * used for both the combo →<code>valueField</code> and →<code>displayField</code>)</p>
   * </li>
   * <li>
   * <p><b>2-dimensional array</b> : (e.g., <code>[['f','Foo'],['b','Bar']]</code>)</p>
   * <p>For a multi-dimensional array, the value in index 0 of each item will be assumed
   * to be the combo →<code>valueField</code>, while the value at index 1 is assumed to be
   * the combo →<code>displayField</code>.</p>
   * </li>
   * </ul>
   * </li>
   * <li>
   * <p><b>a →<code>ext.data.Store</code> config object</b>. When passing a config you can
   * specify the store type by alias. Passing a config object with a store type will
   * dynamically create a new store of that type when the combo / tagfield is
   * instantiated.</p>
   * <p>Ext.define('MyApp.store.States', {
   * extend: 'Ext.data.Store',
   * alias: 'store.states',
   * fields: ['name']
   * });</p>
   * <p>Ext.create({
   * xtype: 'combobox',
   * renderTo: document.body,
   * store: {
   * type: 'states',
   * data: [{
   * name: 'California'
   * }]
   * },
   * queryMode: 'local',
   * displayField: 'name',
   * valueField: 'name'
   * });</p>
   * </li>
   * </ul>
   * <p>See also →<code>queryMode</code>.</p>
   * @see ext.data.Store
   * @see ext.data.Store#storeId
   * @see ext.data.field.DataField#name
   * @see #valueField
   * @see #displayField
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-store Original Ext JS documentation of 'store'
   * @see #getStore()
   * @see #setStore()
   */
  public native function get store():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set store(value:*):void;

  [ExtConfig]
  /**
   * The id, DOM node or →<code>ext.dom.Element</code> of an existing HTML <code>&lt;select&gt;</code> element to convert
   * into a ComboBox. The target select's options will be used to build the options
   * in the ComboBox dropdown; a configured →<code>store</code> will take precedence over this.
   * @see ext.dom.Element
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-transform Original Ext JS documentation of 'transform'
   */
  public native function get transform():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set transform(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to automatically render this combo box in place of the select element that is being
   * <i>transformed</i> (→<code>transform</code>). If <code>false</code>, this combo will be rendered using the normal
   * rendering, either as part of a layout, or using →<code>renderTo</code> or →<code>render()</code>.
   * @default true
   * @see #transform
   * @see #renderTo
   * @see #render()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-transformInPlace Original Ext JS documentation of 'transformInPlace'
   */
  public native function get transformInPlace():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set transformInPlace(value:Boolean):void;

  [ExtConfig]
  /**
   * The action to execute when the trigger is clicked.
   * <ul>
   * <li>
   * <p><b><code>'all'</code></b>: <i>run the query</i> (→<code>doQuery()</code>) specified by the <code>→allQuery</code>
   * config option</p>
   * </li>
   * <li>
   * <p><b><code>'last'</code></b>: <i>run the query</i> (→<code>doQuery()</code>) using the
   * <code>last query value (→lastQuery)</code>.</p>
   * </li>
   * <li>
   * <p><b><code>'query'</code></b>: <i>run the query</i> (→<code>doQuery()</code>) using the
   * <i>raw value</i> (→<code>ext.form.field.BaseField.getRawValue()</code>).</p>
   * </li>
   * </ul>
   * <p>See also <code>→queryParam</code>.</p>
   * @default 'all'
   * @see #doQuery()
   * @see #allQuery
   * @see #lastQuery
   * @see ext.form.field.BaseField#getRawValue()
   * @see #queryParam
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-triggerAction Original Ext JS documentation of 'triggerAction'
   */
  public native function get triggerAction():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set triggerAction(value:String):void;

  [ExtConfig]
  /**
   * An additional CSS class used to style the trigger button. The trigger will always get
   * the →<code>ext.form.trigger.Trigger.baseCls</code> by default and <code>→triggerCls</code> will be
   * <b>appended</b> if specified.
   * @default Ext.baseCSSPrefix + 'form-arrow-trigger'
   * @see ext.form.trigger.Trigger#baseCls
   * @see #triggerCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-triggerCls Original Ext JS documentation of 'triggerCls'
   */
  override public native function get triggerCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set triggerCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * This object holds a map of <code>config</code> properties that will update their binding
   * as they are modified. For example, <code>→value</code> is a key added by form fields. The
   * form of this config is the same as <code>→publishes</code>.
   * <p>This config is defined so that updaters are not created and added for all
   * bound properties since most cannot be modified by the end-user and hence are
   * not appropriate for two-way binding.</p>
   * @default [
   *     'selection'
   * ]
   * @see #value
   * @see #publishes
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-twoWayBindable Original Ext JS documentation of 'twoWayBindable'
   * @see #getTwoWayBindable()
   * @see #setTwoWayBindable()
   */
  override public native function get twoWayBindable():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set twoWayBindable(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to populate and autoselect the remainder of the text being typed after a configurable
   * delay (→<code>typeAheadDelay</code>) if it matches a known value.
   * @default false
   * @see #typeAheadDelay
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-typeAhead Original Ext JS documentation of 'typeAhead'
   */
  public native function get typeAhead():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set typeAhead(value:Boolean):void;

  [ExtConfig]
  /**
   * The length of time in milliseconds to wait until the typeahead text is displayed if
   * <code>→typeAhead = true</code>
   * @default 250
   * @see #typeAhead
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-typeAheadDelay Original Ext JS documentation of 'typeAheadDelay'
   */
  public native function get typeAheadDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set typeAheadDelay(value:Number):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. The underlying <i>data value name</i> (→<code>ext.data.field.DataField.name</code>) to bind to this ComboBox.
   * <p><b>Note</b>: use of a <code>→valueField</code> requires the user to make a selection in order for a value
   * to be mapped. See also <code>→displayField</code>.</p>
   * <p>Defaults to match the value of the →<code>displayField</code> config.</p>
   * @see ext.data.field.DataField#name
   * @see #valueField
   * @see #displayField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-valueField Original Ext JS documentation of 'valueField'
   */
  public native function get valueField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valueField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * When using a name/value combo, if the value passed to setValue is not found in the store,
   * valueNotFoundText will be displayed as the field text if defined. If this default text
   * is used, it means there is no value set and no validation will occur on this field.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#cfg-valueNotFoundText Original Ext JS documentation of 'valueNotFoundText'
   * @see #getValueNotFoundText()
   * @see #setValueNotFoundText()
   */
  public native function get valueNotFoundText():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set valueNotFoundText(value:String):void;

  /**
   * Adds a value or values to the current value of the field
   * @param value The value or values to add to the current value, see →<code>setValue()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-addValue Original Ext JS documentation of 'addValue'
   * @see #setValue()
   */
  public native function addValue(value:*):void;

  /**
   * A method called when the filtering caused by the →<code>doQuery()</code> call is complete
   * and the store has been either filtered locally (if →<code>queryMode</code> is <code>"local"</code>),
   * or has been loaded using the specified filtering.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param queryPlan An object containing details about the query was executed.
   * <ul>
   * <li><code>query:String</code> (optional) —
   * The query value to be used to match against the ComboBox's
   * →<code>valueField</code>.
   * </li>
   * <li><code>forceAll:Boolean</code> (optional) —
   * If <code>true</code>, causes the query to be executed even if
   * the minChars threshold is not met.
   * </li>
   * <li><code>cancel:Boolean</code> (optional) —
   * A boolean value which, if set to <code>true</code> upon return,
   * causes the query not to be executed.
   * </li>
   * <li><code>rawQuery:Boolean</code> (optional) —
   * If <code>true</code> indicates that the raw input field value
   * is being used, and upon store load, the input field value should <b>not</b> be overwritten.
   * </li>
   * </ul>
   * @see #doQuery()
   * @see #queryMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-afterQuery Original Ext JS documentation of 'afterQuery'
   * @see #valueField
   */
  public native function afterQuery(queryPlan:Object):void;

  /**
   * A method which may modify aspects of how the store is to be filtered (if →<code>queryMode</code>
   * is <code>"local"</code>) of loaded (if →<code>queryMode</code> is <code>"remote"</code>).
   * <p>This is called by the →<code>doQuery()</code> method, and may be overridden in subclasses to modify
   * the default behaviour.</p>
   * <p>This method is passed an object containing information about the upcoming query operation
   * which it may modify before returning.</p>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param queryPlan An object containing details about the query to be executed.
   * <ul>
   * <li><code>query:String</code> (optional) —
   * The query value to be used to match against the ComboBox's
   * →<code>valueField</code>.
   * </li>
   * <li><code>lastQuery:String</code> (optional) —
   * The query value used the last time a store query
   * was made.
   * </li>
   * <li><code>forceAll:Boolean</code> (optional) —
   * If <code>true</code>, causes the query to be executed even if
   * the minChars threshold is not met.
   * </li>
   * <li><code>cancel:Boolean</code> (optional) —
   * A boolean value which, if set to <code>true</code> upon return,
   * causes the query not to be executed.
   * </li>
   * <li><code>rawQuery:Boolean</code> (optional) —
   * If <code>true</code> indicates that the raw input field value
   * is being used, and upon store load, the input field value should <b>not</b> be overwritten.
   * </li>
   * </ul>
   * @see #queryMode
   * @see #doQuery()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-beforeQuery Original Ext JS documentation of 'beforeQuery'
   * @see #valueField
   */
  public native function beforeQuery(queryPlan:Object):void;

  /**
   * Binds a store to this instance.
   * @param store The store to bind or ID of the store.
   * When no store given (or when <code>null</code> or <code>undefined</code> passed), unbinds the existing store.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-bindStore Original Ext JS documentation of 'bindStore'
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * Clears any value currently set in the ComboBox.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-clearValue Original Ext JS documentation of 'clearValue'
   */
  public native function clearValue():void;

  /**
   * Executes a query to filter the dropdown list. Fires the →<code>event:onBeforeQuery</code> event
   * prior to performing the query allowing the query action to be canceled if needed.
   * @param queryString The string to use to filter available items by matching
   * against the configured →<code>valueField</code>.
   * @param forceAll <code>true</code> to force the query to execute even if there are
   * currently fewer characters in the field than the minimum specified by the
   * <code>→minChars</code> config option. It also clears any filter previously saved in the current
   * store.
   * @default false
   * @param rawQuery Pass as true if the raw typed value is being used
   * as the query string. This causes the resulting store load to leave the raw value
   * undisturbed.
   * @default false
   * @see #event:onBeforeQuery
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-doQuery Original Ext JS documentation of 'doQuery'
   * @see #valueField
   * @see #minChars
   */
  public native function doQuery(queryString:String, forceAll:Boolean = false, rawQuery:Boolean = false):void;

  /**
   * Finds the record by searching for a specific field/value combination.
   * @param field The name of the field to test.
   * @param value The value to match the field against.
   * @return The matched record or false.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-findRecord Original Ext JS documentation of 'findRecord'
   */
  public native function findRecord(field:String, value:Object):Model;

  /**
   * Finds the record by searching values in the →<code>displayField</code>.
   * @param value The value to match the field against.
   * @return The matched record or <code>false</code>.
   * @see #displayField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-findRecordByDisplay Original Ext JS documentation of 'findRecordByDisplay'
   */
  public native function findRecordByDisplay(value:Object):Model;

  /**
   * Finds the record by searching values in the →<code>valueField</code>.
   * @param value The value to match the field against.
   * @return The matched record or <code>false</code>.
   * @see #valueField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-findRecordByValue Original Ext JS documentation of 'findRecordByValue'
   */
  public native function findRecordByValue(value:Object):Model;

  /**
   * Returns the value of <code>childEls</code>.
   * @see #childEls
   */
  override public native function getChildEls():*;

  [Deprecated(replacement="ext.form.field.Tag", since="5.1.0")]
  /**
   * Returns the value of <code>delimiter</code>.
   * @see #delimiter
   */
  public native function getDelimiter():String;

  /**
   * Returns the value of <code>displayField</code>.
   * @see #displayField
   */
  public native function getDisplayField():String;

  /**
   * Returns the value of <code>displayTpl</code>.
   * @see #displayTpl
   */
  public native function getDisplayTpl():*;

  /**
   * Returns the <code>→ext.util.FilterCollection</code>. Unless <code>autoCreate</code> is explicitly passed
   * as <code>false</code> this collection will be automatically created if it does not yet exist.
   * @param autoCreate Pass <code>false</code> to disable auto-creation of the collection.
   * @default true
   * @return The collection of filters.
   * @see ext.util.FilterCollection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-getFilters Original Ext JS documentation of 'getFilters'
   */
  public native function getFilters(autoCreate:Boolean = true):FilterCollection;

  /**
   * Returns the value of <code>publishes</code>.
   * @see #publishes
   */
  override public native function getPublishes():*;

  /**
   * Gets data for each record to be used for constructing the display value with
   * the →<code>displayTpl</code>. This may be overridden to provide access to associated records.
   * @param record The record.
   * @return The data to be passed for each record to the →<code>displayTpl</code>.
   * @see #displayTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-getRecordDisplayData Original Ext JS documentation of 'getRecordDisplayData'
   */
  protected native function getRecordDisplayData(record:Model):Object;

  /**
   * Returns the combobox's selection.
   * @return The selected record
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-getSelection Original Ext JS documentation of 'getSelection'
   */
  public native function getSelection():Model;

  /**
   * @inheritDoc
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Returns the value of <code>twoWayBindable</code>.
   * @see #twoWayBindable
   */
  override public native function getTwoWayBindable():*;

  /**
   * Returns the value of <code>valueNotFoundText</code>.
   * @see #valueNotFoundText
   */
  public native function getValueNotFoundText():String;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Selects an item by a →<code>ext.data.Model</code>, or by a key value.
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-select Original Ext JS documentation of 'select'
   */
  public native function select(r:Object):void;

  /**
   * Sets the value of <code>childEls</code>.
   * @param childEls The new value.
   * @see #childEls
   */
  override public native function setChildEls(childEls:*):void;

  [Deprecated(replacement="ext.form.field.Tag", since="5.1.0")]
  /**
   * Sets the value of <code>delimiter</code>.
   * @param delimiter The new value.
   * @see #delimiter
   */
  public native function setDelimiter(delimiter:String):void;

  /**
   * Sets the value of <code>displayField</code>.
   * @param displayField The new value.
   * @see #displayField
   */
  public native function setDisplayField(displayField:String):void;

  /**
   * Sets the value of <code>displayTpl</code>.
   * @param displayTpl The new value.
   * @see #displayTpl
   */
  public native function setDisplayTpl(displayTpl:*):void;

  /**
   * Sets the value of <code>publishes</code>.
   * @param publishes The new value.
   * @see #publishes
   */
  override public native function setPublishes(publishes:*):void;

  /**
   * Sets the value of <code>selection</code>.
   * @param selection The new value.
   * @see #selection
   */
  public native function setSelection(selection:Model):void;

  /**
   * @inheritDoc
   */
  public native function setStore(store:Object):void;

  /**
   * Sets the value of <code>twoWayBindable</code>.
   * @param twoWayBindable The new value.
   * @see #twoWayBindable
   */
  override public native function setTwoWayBindable(twoWayBindable:*):void;

  /**
   * Sets the specified value(s) into the field. For each value, if a record is found
   * in the →<code>store</code> that matches based on the →<code>valueField</code>, then that record's
   * →<code>displayField</code> will be displayed in the field. If no match is found, and the
   * →<code>valueNotFoundText</code> config option is defined, then that will be displayed
   * as the default field text. Otherwise a blank value will be shown, although the value
   * will still be set.
   * @param value The value to set
   * @return this
   * @see #store
   * @see #valueField
   * @see #displayField
   * @see #valueNotFoundText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.ComboBox.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;

  /**
   * Sets the value of <code>valueNotFoundText</code>.
   * @param valueNotFoundText The new value.
   * @see #valueNotFoundText
   */
  public native function setValueNotFoundText(valueNotFoundText:String):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}