package ext.form.field {

[Native("Ext.form.field.Date", require)]
/**
 * @see ext.form.field.events.DateField_valueEvent.SELECT
 * @eventType ext.form.field.events.DateField_valueEvent.SELECT
 */
[Event(name='onSelect', type='ext.form.field.events.DateField_valueEvent')]
/**
 * Provides a date input field with a <i>date picker</i> (→<code>ext.picker.DatePicker</code>) dropdown and automatic
 * date validation.
 * <p>This field recognizes and uses the JavaScript Date object as its main →<code>value</code> type.
 * In addition, it recognizes string values which are parsed according to the →<code>format</code>
 * and/or →<code>altFormats</code> configs. These may be reconfigured to use date formats appropriate
 * for the user's locale.</p>
 * <p>The field may be limited to a certain range of dates by using the →<code>minValue</code>,
 * →<code>maxValue</code>, →<code>disabledDays</code>, and →<code>disabledDates</code> config parameters.
 * These configurations will be used both in the field's validation, and in the date picker
 * dropdown by preventing invalid dates from being selected.</p>
 * <p><b>Example usage</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     renderTo: Ext.getBody(),
 *     width: 300,
 *     bodyPadding: 10,
 *     title: 'Dates',
 *     items: [{
 *         xtype: 'datefield',
 *         anchor: '100%',
 *         fieldLabel: 'From',
 *         name: 'from_date',
 *         maxValue: new Date()  // limited to the current date or prior
 *     }, {
 *         xtype: 'datefield',
 *         anchor: '100%',
 *         fieldLabel: 'To',
 *         name: 'to_date',
 *         value: new Date()  // defaults to today
 *     }]
 * });
 * </pre>
 * <p><b>Date Formats Examples</b></p>
 * <p>This example shows a couple of different date format parsing scenarios. Both use custom date
 * format configurations; the first one matches the configured <code>→format</code> while the second matches
 * the <code>→altFormats</code>.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     renderTo: Ext.getBody(),
 *     width: 300,
 *     bodyPadding: 10,
 *     title: 'Dates',
 *     items: [{
 *         xtype: 'datefield',
 *         anchor: '100%',
 *         fieldLabel: 'Date',
 *         name: 'date',
 *         // The value matches the format; will be parsed and displayed using that format.
 *         format: 'm d Y',
 *         value: '02 04 1978'
 *     }, {
 *         xtype: 'datefield',
 *         anchor: '100%',
 *         fieldLabel: 'Date',
 *         name: 'date',
 *         // The value does not match the format, but does match an altFormat; will be parsed
 *         // using the altFormat and displayed using the format.
 *         format: 'm d Y',
 *         altFormats: 'm,d,Y|m.d.Y',
 *         value: '02.04.1978'
 *     }]
 * });
 * </pre>
 * @see ext.picker.DatePicker
 * @see #value
 * @see #format
 * @see #altFormats
 * @see #minValue
 * @see #maxValue
 * @see #disabledDays
 * @see #disabledDates
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html Original Ext JS documentation of 'Ext.form.field.Date'
 */
public class DateField extends Picker {
  /**
   * @param config @inheritDoc
   */
  public function DateField(config:DateField = null) {
    super();
  }

  [ExtConfig]
  /**
   * Multiple date formats separated by "|" to try when parsing a user input value and it
   * does not match the defined format.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-altFormats Original Ext JS documentation of 'altFormats'
   */
  public native function get altFormats():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set altFormats(value:String):void;

  [ExtConfig]
  /**
   * The text that Assistive Technologies such as screen readers will announce when the
   * date falls on a disabled date.
   * @default "This date cannot be selected"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-ariaDisabledDatesText Original Ext JS documentation of 'ariaDisabledDatesText'
   */
  public native function get ariaDisabledDatesText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDisabledDatesText(value:String):void;

  [ExtConfig]
  /**
   * The text that Assistive Technologies such as screen readers will announce when the
   * date falls on a disabled day of week.
   * @default "This day of week is disabled"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-ariaDisabledDaysText Original Ext JS documentation of 'ariaDisabledDaysText'
   */
  public native function get ariaDisabledDaysText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDisabledDaysText(value:String):void;

  [ExtConfig]
  /**
   * This date format will be used to format ARIA attributes in the field and its Picker,
   * to provide Assistive Technologies such as screen readers with user friendly text.
   * The format must be valid →<code>ext.DateUtil.format()</code>.
   * @default 'M j Y'
   * @see ext.SDateUtil#format() ext.DateUtil.format()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-ariaFormat Original Ext JS documentation of 'ariaFormat'
   */
  public native function get ariaFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaFormat(value:String):void;

  [ExtConfig]
  /**
   * The text that Assistive Technologies such as screen readers will announce when the
   * date in the cell is after →<code>maxValue</code>. The date substituted for {0} will be
   * formatted as per →<code>ariaFormat</code>.
   * @default "The date must be equal to or before {0}"
   * @see #maxValue
   * @see #ariaFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-ariaMaxText Original Ext JS documentation of 'ariaMaxText'
   */
  public native function get ariaMaxText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaMaxText(value:String):void;

  [ExtConfig]
  /**
   * The text that Assistive Technologies such as screen readers will announce when the
   * date in the cell is before →<code>minValue</code>. The date substituted for {0} will be
   * formatted as per →<code>ariaFormat</code>.
   * @default "The date must be equal to or after {0}"
   * @see #minValue
   * @see #ariaFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-ariaMinText Original Ext JS documentation of 'ariaMinText'
   */
  public native function get ariaMinText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaMinText(value:String):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'combobox'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  override public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * CSS Class to be added to a components root level element to give distinction to it
   * via styling.
   * @default Ext.baseCSSPrefix + 'form-field-date'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-componentCls Original Ext JS documentation of 'componentCls'
   */
  override public native function get componentCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set componentCls(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of "dates" to disable, as strings. These strings will be used to build
   * a dynamic regular expression so they are very powerful. Some examples:
   * <pre>
   * // disable these exact dates:
   * disabledDates: ["03/08/2003", "09/16/2003"]
   * // disable these days for every year:
   * disabledDates: ["03/08", "09/16"]
   * // only match the beginning (useful if you are using short years):
   * disabledDates: ["^03/08"]
   * // disable every day in March 2006:
   * disabledDates: ["03/../2006"]
   * // disable every day in every March:
   * disabledDates: ["^03"]
   * </pre>
   * <p>Note that the format of the dates included in the array should exactly match
   * the →<code>format</code> config. In order to support regular expressions, if you are using
   * a <i>date format</i> (→<code>format</code>) that has "." in it, you will have to escape the dot
   * when restricting dates. For example: <code>["03\\.08\\.03"]</code>.</p>
   * @see #format
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-disabledDates Original Ext JS documentation of 'disabledDates'
   * @see #setDisabledDates()
   */
  public native function get disabledDates():Array;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabledDates(value:Array):void;

  [ExtConfig]
  /**
   * The tooltip text to display when the date falls on a disabled date.
   * @default "Disabled"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-disabledDatesText Original Ext JS documentation of 'disabledDatesText'
   */
  public native function get disabledDatesText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledDatesText(value:String):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * An array of days to disable, 0 based. Some examples:
   * <pre>
   * // disable Sunday and Saturday:
   * disabledDays:  [0, 6]
   * // disable weekdays:
   * disabledDays: [1,2,3,4,5]
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-disabledDays Original Ext JS documentation of 'disabledDays'
   * @see #setDisabledDays()
   */
  public native function get disabledDays():Array;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set disabledDays(value:Array):void;

  [ExtConfig]
  /**
   * The tooltip to display when the date falls on a disabled day of week.
   * @default "Disabled"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-disabledDaysText Original Ext JS documentation of 'disabledDaysText'
   */
  public native function get disabledDaysText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabledDaysText(value:String):void;

  [ExtConfig]
  /**
   * The default date format string which can be overriden for localization support.
   * The format must be valid according to →<code>ext.DateUtil.parse()</code>.
   * @default "m/d/Y"
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-format Original Ext JS documentation of 'format'
   */
  public native function get format():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set format(value:String):void;

  [ExtConfig]
  /**
   * The format text to be announced by screen readers when the field is focused.
   * @default 'Expected date format {0}.'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-formatText Original Ext JS documentation of 'formatText'
   */
  override public native function get formatText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set formatText(value:String):void;

  [ExtConfig]
  /**
   * The error text to display when the date in the field is invalid.
   * @default "{0} is not a valid date - it must be in the format {1}"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-invalidText Original Ext JS documentation of 'invalidText'
   */
  override public native function get invalidText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set invalidText(value:String):void;

  [ExtConfig]
  /**
   * Whether the picker dropdown's width should be explicitly set to match the width of the field.
   * Defaults to true.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-matchFieldWidth Original Ext JS documentation of 'matchFieldWidth'
   */
  override public native function get matchFieldWidth():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set matchFieldWidth(value:Boolean):void;

  [ExtConfig]
  /**
   * The error text to display when the date in the cell is after →<code>maxValue</code>.
   * @default "The date in this field must be equal to or before {0}"
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-maxText Original Ext JS documentation of 'maxText'
   */
  public native function get maxText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxText(value:String):void;

  [ExtConfig]
  /**
   * The maximum allowed date. Can be either a Javascript date object or a string date
   * in a valid format.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-maxValue Original Ext JS documentation of 'maxValue'
   * @see #setMaxValue()
   */
  public native function get maxValue():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set maxValue(value:*):void;

  [ExtConfig]
  /**
   * The error text to display when the date in the cell is before →<code>minValue</code>.
   * @default "The date in this field must be equal to or after {0}"
   * @see #minValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-minText Original Ext JS documentation of 'minText'
   */
  public native function get minText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minText(value:String):void;

  [ExtConfig]
  /**
   * The minimum allowed date. Can be either a Javascript date object or a string date
   * in a valid format.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-minValue Original Ext JS documentation of 'minValue'
   * @see #setMinValue()
   */
  public native function get minValue():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set minValue(value:*):void;

  [ExtConfig]
  /**
   * false to hide the footer area of the Date picker containing the Today button and disable
   * the keyboard handler for spacebar that selects the current date.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-showToday Original Ext JS documentation of 'showToday'
   */
  public native function get showToday():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showToday(value:Boolean):void;

  [ExtConfig]
  /**
   * Day index at which the week should begin, 0-based.
   * <p>Defaults to <code>0</code> (Sunday).</p>
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-startDay Original Ext JS documentation of 'startDay'
   */
  public native function get startDay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startDay(value:Number):void;

  [ExtConfig]
  /**
   * The date format string which will be submitted to the server. The format must be valid
   * according to →<code>ext.DateUtil.parse()</code>.
   * <p>Defaults to →<code>format</code>.</p>
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see #format
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-submitFormat Original Ext JS documentation of 'submitFormat'
   */
  public native function get submitFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitFormat(value:String):void;

  [ExtConfig]
  /**
   * An additional CSS class used to style the trigger button. The trigger will always get
   * the class 'x-form-trigger' and triggerCls will be <b>appended</b> if specified
   * (default class displays a calendar icon).
   * @default Ext.baseCSSPrefix + 'form-date-trigger'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-triggerCls Original Ext JS documentation of 'triggerCls'
   */
  override public native function get triggerCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set triggerCls(value:String):void;

  [ExtConfig]
  /**
   * True to enforce strict date parsing to prevent the default Javascript "date rollover".
   * Defaults to the useStrict parameter set on Ext.Date
   * See →<code>ext.DateUtil.parse()</code>.
   * @default undefined
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-useStrict Original Ext JS documentation of 'useStrict'
   */
  public native function get useStrict():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useStrict(value:Boolean):void;

  [ExtConfig]
  /**
   * The event name(s) to use to publish the →<code>value</code>
   * →<code>ext.form.field.BaseField.bind</code> for this field.
   * @default [
   *     'select',
   *     'blur'
   * ]
   * @see #value
   * @see ext.form.field.BaseField#bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#cfg-valuePublishEvent Original Ext JS documentation of 'valuePublishEvent'
   */
  override public native function get valuePublishEvent():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set valuePublishEvent(value:*):void;

  /**
   * Checks whether the value of the field has changed since the last time it was checked.
   * If the value has changed, it:
   * <ol>
   * <li>Fires the <i>change event</i> (→<code>event:onChange</code>),</li>
   * <li>Performs validation if the →<code>validateOnChange</code> config is enabled, firing the
   * <i>validitychange event</i> (→<code>event:onValidityChange</code>) if the validity has changed, and</li>
   * <li>Checks the <i>dirty state</i> (→<code>isDirty()</code>) of the field and fires the
   * <i>dirtychange event</i> (→<code>event:onDirtyChange</code>) if it has changed.</li>
   * </ol>
   * @see #event:onChange
   * @see #validateOnChange
   * @see #event:onValidityChange
   * @see #isDirty()
   * @see #event:onDirtyChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-checkChange Original Ext JS documentation of 'checkChange'
   */
  override public native function checkChange():void;

  [ArrayElementType("String")]
  /**
   * Runs all of Date's validations and returns an array of any errors. Note that this first
   * runs Text's validations, so the returned array is an amalgamation of all field errors.
   * The additional validation checks are testing that the date format is valid, that the chosen
   * date is within the min and max date constraints set, that the date chosen is not in the
   * disabledDates regex and that the day chosed is not one of the disabledDays.
   * @param value The value to get errors for (defaults to the current field value)
   * @return All validation errors for this field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-getErrors Original Ext JS documentation of 'getErrors'
   */
  override public native function getErrors(value:*):Array;

  /**
   * Returns the current data value of the field. The type of value returned is particular
   * to the type of the particular field (e.g. a Date object for →<code>ext.form.field.DateField</code>),
   * as the result of calling →<code>rawToValue()</code> on the field's
   * <i>processed</i> (→<code>processRawValue()</code>) String value. To return the raw String value,
   * see →<code>getRawValue()</code>.
   * @return value The field value
   * @see ext.form.field.DateField
   * @see #rawToValue()
   * @see #processRawValue()
   * @see #getRawValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  override public native function getValue():*;

  /**
   * Attempts to parse a given string value using a given <i>date format</i> (→<code>ext.DateUtil.parse()</code>).
   * @param value The value to attempt to parse
   * @param format A valid date format (see →<code>ext.DateUtil.parse()</code>)
   * @return The parsed Date object, or null if the value could not be successfully parsed.
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-safeParse Original Ext JS documentation of 'safeParse'
   */
  public native function safeParse(value:String, format:String):Date;

  /**
   * Replaces any existing disabled dates with new values and refreshes the Date picker.
   * @param disabledDates An array of date strings (see the →<code>disabledDates</code>
   * config for details on supported values) used to disable a pattern of dates.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-setDisabledDates Original Ext JS documentation of 'setDisabledDates'
   * @see #disabledDates
   */
  public native function setDisabledDates(disabledDates:Array):void;

  /**
   * Replaces any existing disabled days (by index, 0-6) with new values and refreshes
   * the Date picker.
   * @param disabledDays An array of disabled day indexes.
   * See the →<code>disabledDays</code> config for details on supported values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-setDisabledDays Original Ext JS documentation of 'setDisabledDays'
   * @see #disabledDays
   */
  public native function setDisabledDays(disabledDays:Array):void;

  /**
   * Replaces any existing →<code>maxValue</code> with the new value and refreshes the Date picker.
   * @param value The maximum date that can be selected
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-setMaxValue Original Ext JS documentation of 'setMaxValue'
   */
  public native function setMaxValue(value:Date):void;

  /**
   * Replaces any existing →<code>minValue</code> with the new value and refreshes the Date picker.
   * @param value The minimum date that can be selected
   * @see #minValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-setMinValue Original Ext JS documentation of 'setMinValue'
   */
  public native function setMinValue(value:Date):void;

  /**
   * Sets the value of the date field. You can pass a date object or any string that can be parsed
   * into a valid date, using →<code>format</code> as the date format, according to the same rules
   * as →<code>ext.DateUtil.parse()</code> (the default format used is "m/d/Y").
   * <p>Usage:</p>
   * <pre>
   * // All of these calls set the same date value (May 4, 2006)
   *
   * // Pass a date object:
   * var dt = new Date('5/4/2006');
   * dateField.me = this,
   * setValue(dt);
   *
   * // Pass a date string (default format):
   * dateField.setValue('05/04/2006');
   *
   * // Pass a date string (custom format):
   * dateField.format = 'Y-m-d';
   * dateField.setValue('2006-05-04');
   * </pre>
   * @param value The value to set
   * @return this
   * @see #format
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Date.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;
}
}