package ext.form.field {
import ext.XTemplate;

[Native("Ext.form.field.Display", require)]
/**
 * A display-only text field which is not validated and not submitted. This is useful for when
 * you want to display a value from a form's <i>loaded data</i> (→<code>ext.form.BasicForm.load()</code>) but do not want
 * to allow the user to edit or submit that value. The value can be optionally
 * <i>HTML encoded</i> (→<code>htmlEncode</code>) if it contains HTML markup that you do not want to be rendered.
 * <p>If you have more complex content, or need to include components within the displayed content,
 * also consider using a →<code>ext.form.FieldContainer</code> instead.</p>
 * <p>Example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     renderTo: Ext.getBody(),
 *     width: 175,
 *     height: 150,
 *     bodyPadding: 10,
 *     title: 'Final Score',
 *     items: [{
 *         xtype: 'displayfield',
 *         fieldLabel: 'Home',
 *         name: 'home_score',
 *         value: '10'
 *     }, {
 *         xtype: 'displayfield',
 *         fieldLabel: 'Visitor',
 *         name: 'visitor_score',
 *         value: '11'
 *     }],
 *     buttons: [{
 *         text: 'Update'
 *     }]
 * });
 * </pre>
 * @see ext.form.BasicForm#load()
 * @see #htmlEncode
 * @see ext.form.FieldContainer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html Original Ext JS documentation of 'Ext.form.field.Display'
 */
public class DisplayField extends BaseField {
  /**
   * @param config @inheritDoc
   */
  public function DisplayField(config:DisplayField = null) {
    super();
  }

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * An extra CSS class to be applied to the body content element in addition to
   * →<code>baseBodyCls</code>.
   * @default Ext.baseCSSPrefix + 'form-display-field-body'
   * @see #baseBodyCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-fieldBodyCls Original Ext JS documentation of 'fieldBodyCls'
   */
  override public native function get fieldBodyCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set fieldBodyCls(value:String):void;

  [ExtConfig]
  /**
   * The default CSS class for the field input
   * @default Ext.baseCSSPrefix + 'form-display-field'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-fieldCls Original Ext JS documentation of 'fieldCls'
   */
  override public native function get fieldCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set fieldCls(value:String):void;

  [ExtConfig]
  /**
   * The content of the field body is defined by this config option.
   * @default [
   *     '<div id="{id}" data-ref="inputEl" role="textbox" aria-readonly="true"',
   *     ' aria-labelledby="{cmpId}-labelEl" {inputAttrTpl}',
   *     ' tabindex="<tpl if="tabIdx != null">{tabIdx}<tpl else>-1</tpl>"',
   *     '<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
   *     ' class="{fieldCls} {fieldCls}-{ui}">{value}</div>',
   *     {
   *         compiled: true,
   *         disableFormats: true
   *     }
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-fieldSubTpl Original Ext JS documentation of 'fieldSubTpl'
   */
  public native function get fieldSubTpl():XTemplate;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldSubTpl(value:XTemplate):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default false
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  override public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * True to escape HTML in text when rendering it.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-htmlEncode Original Ext JS documentation of 'htmlEncode'
   */
  public native function get htmlEncode():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set htmlEncode(value:Boolean):void;

  /**
   * Tells the layout system that the height can be measured immediately because the width
   * does not need setting.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#property-noWrap Original Ext JS documentation of 'noWrap'
   */
  public native function get noWrap():*;

  /**
   * @private
   */
  public native function set noWrap(value:*):void;

  [ExtConfig]
  /**
   * A function to transform the raw value for display in the field.
   * <pre>
   * Ext.create('Ext.form.Panel', {
   *     renderTo: document.body,
   *     width: 175,
   *     bodyPadding: 10,
   *     title: 'Final Score',
   *     items: [{
   *         xtype: 'displayfield',
   *         fieldLabel: 'Grade',
   *         name: 'final_grade',
   *         value: 68,
   *         renderer: function (value, field) {
   *             var color = (value &lt; 70) ? 'red' : 'black';
   *             return '&lt;span style="color:' + color + ';"&gt;' + value + '&lt;/span&gt;';
   *         }
   *     }]
   * });
   * </pre>
   * <ul>
   * <li><code>value:Object</code> —
   * The raw field →<code>value</code>
   * </li>
   * <li><code>field:ext.form.field.DisplayField</code> —
   * The display field
   * </li>
   * <li><code>null:String</code> —
   * displayValue The HTML string to be rendered
   * </li>
   * </ul>
   * @see #value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-renderer Original Ext JS documentation of 'renderer'
   */
  public native function get renderer():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set renderer(value:*):void;

  [ExtConfig]
  /**
   * The scope to execute the →<code>renderer</code> function. Defaults to this.
   * @see #renderer
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * Setting this to false will prevent the field from being
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>) even when it is not disabled.
   * @default false
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Display.html#cfg-submitValue Original Ext JS documentation of 'submitValue'
   */
  override public native function get submitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set submitValue(value:Boolean):void;
}
}