package ext.form.field {
import ext.Base;

import js.HTMLElement;

[Native("Ext.form.field.Field", require)]
/**
 * @see ext.form.field.events.Field_newValue_oldValueEvent.CHANGE
 * @eventType ext.form.field.events.Field_newValue_oldValueEvent.CHANGE
 */
[Event(name='onChange', type='ext.form.field.events.Field_newValue_oldValueEvent')]
/**
 * @see ext.form.field.events.Field_isDirtyEvent.DIRTY_CHANGE
 * @eventType ext.form.field.events.Field_isDirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.form.field.events.Field_isDirtyEvent')]
/**
 * @see ext.form.field.events.Field_isValidEvent.VALIDITY_CHANGE
 * @eventType ext.form.field.events.Field_isValidEvent.VALIDITY_CHANGE
 */
[Event(name='onValidityChange', type='ext.form.field.events.Field_isValidEvent')]
/**
 * This mixin provides a common interface for the logical behavior and state of form fields,
 * including...
 * <ul>
 * <li>Getter and setter methods for field values</li>
 * <li>Events and methods for tracking value and validity changes</li>
 * <li>Methods for triggering validation</li>
 * </ul>
 * <p><b>NOTE</b>: When implementing custom fields, it is most likely that you will want to extend
 * the →<code>ext.form.field.BaseField</code> component class rather than using this mixin directly,
 * as BaseField contains additional logic for generating an actual DOM complete with
 * <i>label and error message</i> (→<code>ext.form.Labelable</code>) display and a form input field,
 * plus methods that bind the Field value getters and setters to the input field's value.</p>
 * <p>If you do want to implement this mixin directly and don't want to extend
 * →<code>ext.form.field.BaseField</code>, then you will most likely want to override the following methods
 * with custom implementations: →<code>getValue()</code>, →<code>setValue()</code>, and →<code>getErrors()</code>.
 * Other methods may be overridden as needed but their base implementations should be sufficient
 * for common cases. You will also need to make sure that →<code>initField()</code> is called
 * during the component's initialization.</p>
 * @see ext.form.field.BaseField
 * @see ext.form.Labelable
 * @see #getValue()
 * @see #setValue()
 * @see #getErrors()
 * @see #initField()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html Original Ext JS documentation of 'Ext.form.field.Field'
 */
public class Field extends Base implements IField {
  /**
   * @param config @inheritDoc
   */
  public function Field(config:Field = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to disable the field. Disabled Fields will not be
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>).
   * @default false
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-disabled Original Ext JS documentation of 'disabled'
   */
  public native function get disabled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set disabled(value:Boolean):void;

  /**
   * Flag denoting that this component is a Field. Always true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#property-isFormField Original Ext JS documentation of 'isFormField'
   */
  public native function get isFormField():Boolean;

  /**
   * @private
   */
  public native function set isFormField(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The name of the field. By default this is used as the parameter name when including the
   * <i>field value</i> (→<code>getSubmitData()</code>) in a <i>form submit()</i> (→<code>ext.form.BasicForm.submit()</code>).
   * To prevent the field from being included in the form submit, set →<code>submitValue</code>
   * to false.
   * @see #getSubmitData()
   * @see ext.form.BasicForm#submit()
   * @see #submitValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-name Original Ext JS documentation of 'name'
   * @see #getName()
   */
  public native function get name():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * The original value of the field as configured in the →<code>value</code> configuration,
   * or as loaded by the last form load operation if the form's
   * →<code>ext.form.BasicForm.trackResetOnLoad</code> setting is <code>true</code>.
   * @default me.getValue()
   * @see #value
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#property-originalValue Original Ext JS documentation of 'originalValue'
   */
  public native function get originalValue():*;

  /**
   * @private
   */
  public native function set originalValue(value:*):void;

  [ExtConfig]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default 'value'
   * @see #reference
   * @see #publishState
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-publishes Original Ext JS documentation of 'publishes'
   */
  public native function get publishes():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * Setting this to false will prevent the field from being
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>) even when it is not disabled.
   * @default true
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-submitValue Original Ext JS documentation of 'submitValue'
   */
  public native function get submitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitValue(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether this field should be validated immediately whenever a change in its value
   * is detected. If the validation results in a change in the field's validity, a
   * →<code>event:onValidityChange</code> event will be fired. This allows the field to show feedback
   * about the validity of its contents immediately as the user is typing.
   * <p>When set to false, feedback will not be immediate. However the form will still be validated
   * before submitting if the clientValidation option to →<code>ext.form.BasicForm.doAction()</code>
   * is enabled, or if the field or form are validated manually.</p>
   * <p>See also →<code>ext.form.field.BaseField.checkChangeEvents</code> for controlling how changes
   * to the field's value are detected.</p>
   * @default true
   * @see #event:onValidityChange
   * @see ext.form.BasicForm#doAction()
   * @see ext.form.field.BaseField#checkChangeEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validateOnChange Original Ext JS documentation of 'validateOnChange'
   */
  public native function get validateOnChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set validateOnChange(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This property, when a <code>→String</code>, contributes its value to the error state of this
   * instance as reported by <code>→getErrors()</code>.
   * @default null
   * @see String
   * @see #getErrors()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validation Original Ext JS documentation of 'validation'
   * @see #getValidation()
   * @see #setValidation()
   */
  public native function get validation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set validation(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A value to initialize this field with.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set value(value:Object):void;

  [ExtConfig]
  /**
   * The event name(s) to use to publish the →<code>value</code>
   * →<code>ext.form.field.BaseField.bind</code> for this field.
   * @default 'change'
   * @since 5.0.1
   * @see #value
   * @see ext.form.field.BaseField#bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-valuePublishEvent Original Ext JS documentation of 'valuePublishEvent'
   */
  public native function get valuePublishEvent():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valuePublishEvent(value:*):void;

  /**
   * A utility for grouping a set of modifications which may trigger value changes into a single
   * transaction, to prevent excessive firing of →<code>event:onChange</code> events. This is useful
   * for instance if the field has sub-fields which are being updated as a group;
   * you don't want the container field to check its own changed state for each subfield change.
   * @param fn The function to call with change checks suspended.
   * @see #event:onChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-batchChanges Original Ext JS documentation of 'batchChanges'
   */
  public native function batchChanges(fn:Function):void;

  /**
   * Template method before a field is reset.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-beforeReset Original Ext JS documentation of 'beforeReset'
   */
  protected native function beforeReset():void;

  /**
   * Checks whether the value of the field has changed since the last time it was checked.
   * If the value has changed, it:
   * <ol>
   * <li>Fires the <i>change event</i> (→<code>event:onChange</code>),</li>
   * <li>Performs validation if the →<code>validateOnChange</code> config is enabled, firing the
   * <i>validitychange event</i> (→<code>event:onValidityChange</code>) if the validity has changed, and</li>
   * <li>Checks the <i>dirty state</i> (→<code>isDirty()</code>) of the field and fires the
   * <i>dirtychange event</i> (→<code>event:onDirtyChange</code>) if it has changed.</li>
   * </ol>
   * @see #event:onChange
   * @see #validateOnChange
   * @see #event:onValidityChange
   * @see #isDirty()
   * @see #event:onDirtyChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-checkChange Original Ext JS documentation of 'checkChange'
   */
  public native function checkChange():void;

  /**
   * Checks the →<code>isDirty()</code> state of the field and if it has changed since the last time
   * it was checked, fires the →<code>event:onDirtyChange</code> event.
   * @see #isDirty()
   * @see #event:onDirtyChange
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-checkDirty Original Ext JS documentation of 'checkDirty'
   */
  public native function checkDirty():void;

  /**
   * Cleans up values initialized by this Field mixin on the current instance.
   * Components using this mixin should call this method before being destroyed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-cleanupField Original Ext JS documentation of 'cleanupField'
   */
  public native function cleanupField():void;

  /**
   * Clear any invalid styles/messages for this field. Components using this mixin should
   * implement this method to update the components rendering to clear any existing messages.
   * <p><b>Note</b>: this method does not cause the Field's →<code>validate()</code> or →<code>isValid()</code>
   * methods to return <code>true</code> if the value does not <i>pass</i> validation. So simply clearing
   * a field's errors will not necessarily allow submission of forms submitted with the
   * →<code>ext.form.action.SubmitAction.clientValidation</code> option set.</p>
   * @see #validate()
   * @see #isValid()
   * @see ext.form.action.SubmitAction#clientValidation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-clearInvalid Original Ext JS documentation of 'clearInvalid'
   */
  public native function clearInvalid():void;

  /**
   * Only relevant if the instance's →<code>isFileUpload()</code> method returns true. Returns
   * a reference to the file input DOM element holding the user's selected file.
   * The input will be appended into the submission form and will not be returned, so this method
   * should also create a replacement.
   * @see #isFileUpload()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-extractFileInput Original Ext JS documentation of 'extractFileInput'
   */
  public native function extractFileInput():HTMLElement;

  [ArrayElementType("String")]
  /**
   * Runs this field's validators and returns an array of error messages for any validation
   * failures. This is called internally during validation and would not usually need to be used
   * manually.
   * <p>Each subclass should override or augment the return value to provide their own errors.</p>
   * @param value The value to get errors for (defaults to the current field value)
   * @return All error messages for this field; an empty Array if none.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-getErrors Original Ext JS documentation of 'getErrors'
   */
  public native function getErrors(value:*):Array;

  /**
   * Returns the value(s) that should be saved to the →<code>ext.data.Model</code> instance
   * for this field, when →<code>ext.form.BasicForm.updateRecord()</code> is called. Typically this will be
   * an object with a single name-value pair, the name being this field's
   * <i>name</i> (→<code>getName()</code>) and the value being its current data value. More advanced field
   * implementations may return more than one name-value pair. The returned values will be saved
   * to the corresponding field names in the Model.
   * <p>Note that the values returned from this method are not guaranteed to have been successfully
   * <i>validated</i> (→<code>validate()</code>).</p>
   * @param includeEmptyText Whether or not to include empty text
   * @return A mapping of submit parameter names to values; each value should be
   * a string, or an array of strings if that particular name has multiple values. It can also
   * return null if there are no parameters to be submitted.
   * @see ext.data.Model
   * @see ext.form.BasicForm#updateRecord()
   * @see #getName()
   * @see #validate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-getModelData Original Ext JS documentation of 'getModelData'
   */
  public native function getModelData(includeEmptyText:Boolean):Object;

  /**
   * Returns the →<code>ext.form.field.Field.name</code> attribute of the field. This is used
   * as the parameter name when including the field value in a
   * <i>form submit()</i> (→<code>ext.form.BasicForm.submit()</code>).
   * @return name The field →<code>ext.form.field.Field.name</code>
   * @see ext.form.field.Field#name
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-getName Original Ext JS documentation of 'getName'
   */
  public native function getName():String;

  /**
   * Returns the parameter(s) that would be included in a standard form submit for this field.
   * Typically this will be an object with a single name-value pair, the name being this field's
   * <i>name</i> (→<code>getName()</code>) and the value being its current stringified value.
   * More advanced field implementations may return more than one name-value pair.
   * <p>Note that the values returned from this method are not guaranteed to have been successfully
   * <i>validated</i> (→<code>validate()</code>).</p>
   * @return A mapping of submit parameter names to values; each value should be
   * a string, or an array of strings if that particular name has multiple values. It can also
   * return null if there are no parameters to be submitted.
   * @see #getName()
   * @see #validate()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-getSubmitData Original Ext JS documentation of 'getSubmitData'
   */
  public native function getSubmitData():Object;

  /**
   * Returns the value of <code>validation</code>.
   * @see #validation
   */
  public native function getValidation():*;

  /**
   * Returns the current data value of the field. The type of value returned is particular
   * to the type of the particular field (e.g. a Date object for →<code>ext.form.field.DateField</code>).
   * @return value The field value
   * @see ext.form.field.DateField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue():*;

  /**
   * Initializes this Field mixin on the current instance. Components using this mixin
   * should call this method during their own initialization process.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-initField Original Ext JS documentation of 'initField'
   */
  public native function initField():void;

  /**
   * Initializes the field's value based on the initial config.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-initValue Original Ext JS documentation of 'initValue'
   */
  public native function initValue():void;

  /**
   * Returns true if the value of this Field has been changed from its →<code>originalValue</code>.
   * Will always return false if the field is disabled.
   * <p>Note that if the owning <i>form</i> (→<code>ext.form.BasicForm</code>) was configured with
   * →<code>ext.form.BasicForm.trackResetOnLoad</code> then the →<code>originalValue</code>
   * is updated when the values are loaded by
   * →<code>ext.form.BasicForm</code>.→<code>ext.form.BasicForm.setValues()</code>.</p>
   * @return True if this field has been changed from its original value
   * (and is not disabled), false otherwise.
   * @see #originalValue
   * @see ext.form.BasicForm
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see ext.form.BasicForm#setValues()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-isDirty Original Ext JS documentation of 'isDirty'
   */
  public native function isDirty():Boolean;

  /**
   * Returns whether two field <i>values</i> (→<code>getValue()</code>) are logically equal. Field implementations
   * may override this to provide custom comparison logic appropriate for the particular field's
   * data type.
   * @param value1 The first value to compare
   * @param value2 The second value to compare
   * @return True if the values are equal, false if inequal.
   * @see #getValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-isEqual Original Ext JS documentation of 'isEqual'
   */
  public native function isEqual(value1:Object, value2:Object):Boolean;

  /**
   * Returns whether this Field is a file upload field; if it returns true, forms will use special
   * techniques for <i>submitting the form</i> (→<code>ext.form.BasicForm.submit()</code>) via AJAX.
   * See →<code>ext.form.BasicForm.hasUpload()</code> for details. If this returns true, the
   * →<code>extractFileInput()</code> method must also be implemented to return the corresponding file
   * input element.
   * @see ext.form.BasicForm#submit()
   * @see ext.form.BasicForm#hasUpload()
   * @see #extractFileInput()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-isFileUpload Original Ext JS documentation of 'isFileUpload'
   */
  public native function isFileUpload():Boolean;

  /**
   * Returns whether or not the field value is currently valid by <i>validating</i> (→<code>getErrors()</code>)
   * the field's current value. The →<code>event:onValidityChange</code> event will not be fired;
   * use →<code>validate()</code> instead if you want the event to fire.
   * <b>Note</b>: →<code>disabled</code> fields are always treated as valid.
   * <p>Implementations are encouraged to ensure that this method does not have side-effects
   * such as triggering error message display.</p>
   * @return True if the value is valid, else false
   * @see #getErrors()
   * @see #event:onValidityChange
   * @see #validate()
   * @see #disabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-isValid Original Ext JS documentation of 'isValid'
   */
  public native function isValid():Boolean;

  /**
   * Display one or more error messages associated with this field, using
   * →<code>ext.form.Labelable.msgTarget</code> to determine how to display the messages and
   * applying →<code>ext.form.Labelable.invalidCls</code> to the field's UI element.
   * <pre>
   * var formPanel = Ext.create('Ext.form.Panel', {
   *     title: 'Contact Info',
   *     width: 300,
   *     bodyPadding: 10,
   *     renderTo: Ext.getBody(),
   *     items: [{
   *         xtype: 'textfield',
   *         name: 'name',
   *         id: 'nameId',
   *         fieldLabel: 'Name'
   *     }],
   *     bbar: [{
   *         text: 'Mark both fields invalid',
   *         handler: function() {
   *             var nameField = formPanel.getForm().findField('name');
   *             nameField.markInvalid('Name invalid message');
   *
   *             // multiple error string syntax
   *             // nameField.markInvalid(['First message', 'Second message']);
   *         }
   *     }]
   * });
   * </pre>
   * <p><b>Note</b>: this method does not cause the Field's →<code>validate()</code> or
   * →<code>isValid()</code> methods to return <code>false</code> if the value does <i>pass</i> validation.
   * So simply marking a Field as invalid will not prevent submission of forms
   * submitted with the →<code>ext.form.action.SubmitAction.clientValidation</code> option set.</p>
   * @param errors The validation message(s) to display.
   * @see ext.form.Labelable#msgTarget
   * @see ext.form.Labelable#invalidCls
   * @see #validate()
   * @see #isValid()
   * @see ext.form.action.SubmitAction#clientValidation
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-markInvalid Original Ext JS documentation of 'markInvalid'
   */
  public native function markInvalid(errors:*):void;

  /**
   * Resets the current field value to the originally loaded value and clears any validation
   * messages. See →<code>ext.form.BasicForm</code>.→<code>ext.form.BasicForm.trackResetOnLoad</code>
   * @see ext.form.BasicForm
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-reset Original Ext JS documentation of 'reset'
   */
  public native function reset():void;

  /**
   * Resets the field's →<code>originalValue</code> property so it matches the current
   * <i>value</i> (→<code>getValue()</code>). This is called by
   * →<code>ext.form.BasicForm</code>.→<code>ext.form.BasicForm.setValues()</code> if the form's
   * →<code>ext.form.BasicForm.trackResetOnLoad</code> property is set to true.
   * @see #originalValue
   * @see #getValue()
   * @see ext.form.BasicForm
   * @see ext.form.BasicForm#setValues()
   * @see ext.form.BasicForm#trackResetOnLoad
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-resetOriginalValue Original Ext JS documentation of 'resetOriginalValue'
   */
  public native function resetOriginalValue():void;

  /**
   * Sets the value of <code>validation</code>.
   * @param validation The new value.
   * @see #validation
   */
  public native function setValidation(validation:*):void;

  /**
   * Sets a data value into the field and runs the change detection and validation.
   * @param value The value to set
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  public native function setValue(value:*):IField;

  /**
   * Returns whether or not the field value is currently valid by <i>validating</i> (→<code>getErrors()</code>)
   * the field's current value, and fires the →<code>event:onValidityChange</code> event if the field's
   * validity has changed since the last validation.
   * <b>Note</b>: →<code>disabled</code> fields are always treated as valid.
   * <p>Custom implementations of this method are allowed to have side-effects such as triggering
   * error message display. To validate without side-effects, use →<code>isValid()</code>.</p>
   * @return True if the value is valid, else false
   * @see #getErrors()
   * @see #event:onValidityChange
   * @see #disabled
   * @see #isValid()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-validate Original Ext JS documentation of 'validate'
   */
  public native function validate():Boolean;
}
}