package ext.form.field {
import ext.button.Button;
import ext.dom.Element;

[Native("Ext.form.field.File", require)]
/**
 * @see ext.form.field.events.FileUploadField_valueEvent.CHANGE
 * @eventType ext.form.field.events.FileUploadField_valueEvent.CHANGE
 */
[Event(name='onChange', type='ext.form.field.events.FileUploadField_valueEvent')]
/**
 * A file upload field which has custom styling and allows control over the button text and other
 * features of <i>text fields</i> (→<code>ext.form.field.TextField</code>) like
 * <i>empty text</i> (→<code>ext.form.field.TextField.emptyText</code>). It uses a hidden file input element
 * behind the scenes to allow user selection of a file and to perform the actual upload
 * during <i>form submit</i> (→<code>ext.form.BasicForm.submit()</code>).
 * <p>Because there is no secure cross-browser way to programmatically set the value of a file input,
 * the standard Field <code>→setValue()</code> method is not implemented. The <code>→getValue()</code> method
 * will return a value that is browser-dependent; some have just the file name,
 * some have a full path, some use a fake path.</p>
 * <p><b>IMPORTANT:</b> File uploads are not performed using normal 'Ajax' techniques;
 * see the description for →<code>ext.form.BasicForm.hasUpload()</code> for details.</p>
 * <p><b>Example Usage</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Upload a Photo',
 *     width: 400,
 *     bodyPadding: 10,
 *     frame: true,
 *     renderTo: Ext.getBody(),
 *     items: [{
 *         xtype: 'filefield',
 *         name: 'photo',
 *         fieldLabel: 'Photo',
 *         labelWidth: 50,
 *         msgTarget: 'side',
 *         allowBlank: false,
 *         anchor: '100%',
 *         buttonText: 'Select Photo...'
 *     }],
 *
 *     buttons: [{
 *         text: 'Upload',
 *         handler: function() {
 *             var form = this.up('form').getForm();
 *             if(form.isValid()) {
 *                 form.submit({
 *                     url: 'photo-upload.php',
 *                     waitMsg: 'Uploading your photo...',
 *                     success: function(fp, o) {
 *                         Ext.Msg.alert('Success', 'Your photo "' + o.result.file +
 *                                                  '" has been uploaded.');
 *                     }
 *                 });
 *             }
 *         }
 *     }]
 * });
 * </pre>
 * @see ext.form.field.TextField
 * @see ext.form.field.TextField#emptyText
 * @see ext.form.BasicForm#submit()
 * @see #setValue()
 * @see #getValue()
 * @see ext.form.BasicForm#hasUpload()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html Original Ext JS documentation of 'Ext.form.field.File'
 */
public class FileUploadField extends TextField {
  /**
   * @param config @inheritDoc
   */
  public function FileUploadField(config:FileUploadField = null) {
    super();
  }

  [ExtConfig]
  /**
   * An optional list of file MIME types accepted by this field.
   * This string will be rendered in to the <code>→accept</code> attribute of the file input and should
   * conform to HTML requirements: http://www.w3.org/TR/html-markup/input.file.html
   * @since 6.2.0
   * @see #accept
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-accept Original Ext JS documentation of 'accept'
   */
  public native function get accept():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set accept(value:String):void;

  /**
   * A reference to the trigger Button component created for this upload field.
   * Only populated after this component is rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#property-button Original Ext JS documentation of 'button'
   */
  public native function get button():Button;

  /**
   * @private
   */
  public native function set button(value:Button):void;

  [ExtConfig]
  /**
   * Specify optional custom button →<code>ext.button.Button</code> config (eg. iconCls, text)
   * for the upload button
   * @see ext.button.Button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-buttonConfig Original Ext JS documentation of 'buttonConfig'
   */
  public native function get buttonConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttonConfig(value:Object):void;

  [ExtConfig]
  /**
   * The number of pixels of space reserved between the button and the text field. Note that this
   * only applies if →<code>buttonOnly</code> = false.
   * @default 3
   * @see #buttonOnly
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-buttonMargin Original Ext JS documentation of 'buttonMargin'
   */
  public native function get buttonMargin():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttonMargin(value:Number):void;

  [ExtConfig]
  /**
   * True to display the file upload field as a button with no visible text field. If true, all
   * inherited Text members will still be available.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-buttonOnly Original Ext JS documentation of 'buttonOnly'
   */
  public native function get buttonOnly():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttonOnly(value:Boolean):void;

  [ExtConfig]
  /**
   * The button text to display on the upload button. Note that if you supply a value for
   * →<code>buttonConfig</code>, the buttonConfig.text value will be used instead if available.
   * @default 'Browse...'
   * @see #buttonConfig
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-buttonText Original Ext JS documentation of 'buttonText'
   */
  public native function get buttonText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttonText(value:String):void;

  [ExtConfig]
  /**
   * True to clear the selected file value when the form this field belongs to
   * is submitted to the server.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-clearOnSubmit Original Ext JS documentation of 'clearOnSubmit'
   */
  public native function get clearOnSubmit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clearOnSubmit(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * false to prevent the user from typing text directly into the field; the field can
   * only have its value set programmatically or via an action invoked by a trigger.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-editable Original Ext JS documentation of 'editable'
   * @see #getEditable()
   * @see #setEditable()
   */
  override public native function get editable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set editable(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * Overridden to undefined as →<code>emptyText</code> is not supported with
   * →<code>inputType</code>:'file' and should be avoided.
   * The default text to place into an empty field.
   * @default undefined
   * @see #emptyText
   * @see #inputType
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-emptyText Original Ext JS documentation of 'emptyText'
   * @see #getEmptyText()
   * @see #setEmptyText()
   */
  override public native function get emptyText():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set emptyText(value:String):void;

  /**
   * A reference to the invisible file input element created for this upload field.
   * Only populated after this component is rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#property-fileInputEl Original Ext JS documentation of 'fileInputEl'
   */
  public native function get fileInputEl():Element;

  /**
   * @private
   */
  public native function set fileInputEl(value:Element):void;

  [ExtConfig]
  /**
   * Unlike with other form fields, the readOnly config defaults to true in File field.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-readOnly Original Ext JS documentation of 'readOnly'
   * @see #setReadOnly()
   */
  override public native function get readOnly():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set readOnly(value:Boolean):void;

  [ExtConfig]
  /**
   * Setting this to false will prevent the field from being
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>) even when it is not disabled.
   * @default false
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-submitValue Original Ext JS documentation of 'submitValue'
   */
  override public native function get submitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set submitValue(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * <i>Triggers</i> (→<code>ext.form.trigger.Trigger</code>) to use in this field. The keys in
   * this object are unique identifiers for the triggers. The values in this object
   * are →<code>ext.form.trigger.Trigger</code> configuration objects.
   * <pre>
   * Ext.create('Ext.form.field.Text', {
   *     renderTo: document.body,
   *     fieldLabel: 'My Custom Field',
   *     triggers: {
   *         foo: {
   *             cls: 'my-foo-trigger',
   *             handler: function() {
   *                 console.log('foo trigger clicked');
   *             }
   *         },
   *         bar: {
   *             cls: 'my-bar-trigger',
   *             handler: function() {
   *                 console.log('bar trigger clicked');
   *             }
   *         }
   *     }
   * });
   * </pre>
   * <p>The weight value may be a negative value in order to position custom triggers
   * ahead of default triggers like that of ComboBox.</p>
   * <pre>
   * Ext.create('Ext.form.field.ComboBox', {
   *     renderTo: Ext.getBody(),
   *     fieldLabel: 'My Custom Field',
   *     triggers: {
   *         foo: {
   *             cls: 'my-foo-trigger',
   *             weight: -2, // negative to place before default triggers
   *             handler: function() {
   *                 console.log('foo trigger clicked');
   *             }
   *         },
   *         bar: {
   *             cls: 'my-bar-trigger',
   *             weight: -1,
   *             handler: function() {
   *                 console.log('bar trigger clicked');
   *             }
   *         }
   *     }
   * });
   * </pre>
   * @default {
   *     filebutton: {
   *         type: 'component',
   *         hideOnReadOnly: false,
   *         // Most form fields prevent the default browser action on mousedown of the trigger.
   *         // This is intended to prevent the field's input element from losing focus when
   *         // the trigger is clicked.  File fields disable this behavior because:
   *         // 1. The input element does not receive focus when the field is focused.
   *         // The button does.
   *         // 2. Preventing the default action of touchstart (translated from mousedown
   *         // on mobile browsers) prevents the browser's file dialog from opening.
   *         preventMouseDown: false
   *     }
   * }
   * @see ext.form.trigger.Trigger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#cfg-triggers Original Ext JS documentation of 'triggers'
   * @see #getTriggers()
   * @see #setTriggers()
   */
  override public native function get triggers():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set triggers(value:Object):void;

  /**
   * Returns the value of <code>editable</code>.
   * @see #editable
   */
  override public native function getEditable():Boolean;

  /**
   * Gets the markup to be inserted into the subTplMarkup.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#method-getTriggerMarkup Original Ext JS documentation of 'getTriggerMarkup'
   */
  public native function getTriggerMarkup():String;

  /**
   * Returns the value of <code>triggers</code>.
   * @see #triggers
   */
  override public native function getTriggers():Object;

  /**
   * Returns whether this Field is a file upload field; if it returns true, forms will use special
   * techniques for <i>submitting the form</i> (→<code>ext.form.BasicForm.submit()</code>) via AJAX.
   * See →<code>ext.form.BasicForm.hasUpload()</code> for details. If this returns true, the
   * →<code>extractFileInput()</code> method must also be implemented to return the corresponding file
   * input element.
   * @see ext.form.BasicForm#submit()
   * @see ext.form.BasicForm#hasUpload()
   * @see #extractFileInput()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#method-isFileUpload Original Ext JS documentation of 'isFileUpload'
   */
  override public native function isFileUpload():Boolean;

  /**
   * Sets the value of <code>editable</code>.
   * @param editable The new value.
   * @see #editable
   */
  override public native function setEditable(editable:Boolean):void;

  /**
   * @param value The →<code>emptyText</code> value for this field
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#method-setEmptyText Original Ext JS documentation of 'setEmptyText'
   * @see #emptyText
   */
  override public native function setEmptyText(value:String):TextField;

  /**
   * Sets the value of <code>triggers</code>.
   * @param triggers The new value.
   * @see #triggers
   */
  override public native function setTriggers(triggers:Object):void;

  /**
   * Overridden to do nothing
   * @param value The value to set
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;
}
}