package ext.form.field {

[Native("Ext.form.field.Hidden", require)]
/**
 * A basic hidden field for storing hidden values in forms that need to be passed in the form
 * submit.
 * <p>This creates an actual input element with type="hidden" in the DOM. While its label is
 * <i>not rendered</i> (→<code>hideLabel</code>) by default, it is still a real component and may be sized
 * according to its owner container's layout.</p>
 * <p>Because of this, in most cases it is more convenient and less problematic to simply
 * <i>pass hidden parameters</i> (→<code>ext.form.action.Action.params</code>) directly when
 * <i>submitting the form</i> (→<code>ext.form.BasicForm.submit()</code>).</p>
 * <p>Example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * new Ext.form.Panel({
 *     title: 'My Form',
 *     items: [{
 *         xtype: 'textfield',
 *         fieldLabel: 'Text Field',
 *         name: 'text_field',
 *         value: 'value from text field'
 *     }, {
 *         xtype: 'hiddenfield',
 *         name: 'hidden_field_1',
 *         value: 'value from hidden field'
 *     }],
 *
 *     buttons: [{
 *         text: 'Submit',
 *         handler: function() {
 *             this.up('form').getForm().submit({
 *                 params: {
 *                     hidden_field_2: 'value from submit call'
 *                 }
 *             });
 *         }
 *     }]
 * });
 * </pre>
 * <p>Submitting the above form will result in three values sent to the server:</p>
 * <pre>
 * text_field=value+from+text+field&amp;hidden;_field_1=value+from+hidden+field&amp;
 * hidden_field_2=value+from+submit+call
 * </pre>
 * @see #hideLabel
 * @see ext.form.action.Action#params
 * @see ext.form.BasicForm#submit()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Hidden.html Original Ext JS documentation of 'Ext.form.field.Hidden'
 */
public class Hidden extends BaseField {
  /**
   * @param config @inheritDoc
   */
  public function Hidden(config:Hidden = null) {
    super();
  }
}
}