package ext.form.field {
import ext.form.FieldContainer;
import ext.toolbar.Toolbar;

import js.HTMLElement;

[Native("Ext.form.field.HtmlEditor", require)]
/**
 * @see ext.form.field.events.HtmlEditor_newValue_oldValueEvent.CHANGE
 * @eventType ext.form.field.events.HtmlEditor_newValue_oldValueEvent.CHANGE
 */
[Event(name='onChange', type='ext.form.field.events.HtmlEditor_newValue_oldValueEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_isDirtyEvent.DIRTY_CHANGE
 * @eventType ext.form.field.events.HtmlEditor_isDirtyEvent.DIRTY_CHANGE
 */
[Event(name='onDirtyChange', type='ext.form.field.events.HtmlEditor_isDirtyEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_isValidEvent.VALIDITY_CHANGE
 * @eventType ext.form.field.events.HtmlEditor_isValidEvent.VALIDITY_CHANGE
 */
[Event(name='onValidityChange', type='ext.form.field.events.HtmlEditor_isValidEvent')]
/**
 * @see ext.form.field.events.HtmlEditorEvent.ACTIVATE
 * @eventType ext.form.field.events.HtmlEditorEvent.ACTIVATE
 */
[Event(name='onActivate', type='ext.form.field.events.HtmlEditorEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_htmlEvent.BEFORE_PUSH
 * @eventType ext.form.field.events.HtmlEditor_htmlEvent.BEFORE_PUSH
 */
[Event(name='onBeforePush', type='ext.form.field.events.HtmlEditor_htmlEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_htmlEvent.BEFORE_SYNC
 * @eventType ext.form.field.events.HtmlEditor_htmlEvent.BEFORE_SYNC
 */
[Event(name='onBeforeSync', type='ext.form.field.events.HtmlEditor_htmlEvent')]
/**
 * @see ext.form.field.events.HtmlEditorEvent.BLUR
 * @eventType ext.form.field.events.HtmlEditorEvent.BLUR
 */
[Event(name='onBlur', type='ext.form.field.events.HtmlEditorEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_sourceEditEvent.EDIT_MODE_CHANGE
 * @eventType ext.form.field.events.HtmlEditor_sourceEditEvent.EDIT_MODE_CHANGE
 */
[Event(name='onEditModeChange', type='ext.form.field.events.HtmlEditor_sourceEditEvent')]
/**
 * @see ext.form.field.events.HtmlEditorEvent.FOCUS
 * @eventType ext.form.field.events.HtmlEditorEvent.FOCUS
 */
[Event(name='onFocus', type='ext.form.field.events.HtmlEditorEvent')]
/**
 * @see ext.form.field.events.HtmlEditorEvent.INITIALIZE
 * @eventType ext.form.field.events.HtmlEditorEvent.INITIALIZE
 */
[Event(name='onInitialize', type='ext.form.field.events.HtmlEditorEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_htmlEvent.PUSH
 * @eventType ext.form.field.events.HtmlEditor_htmlEvent.PUSH
 */
[Event(name='onPush', type='ext.form.field.events.HtmlEditor_htmlEvent')]
/**
 * @see ext.form.field.events.HtmlEditorEvent.SPECIAL_KEY
 * @eventType ext.form.field.events.HtmlEditorEvent.SPECIAL_KEY
 */
[Event(name='onSpecialKey', type='ext.form.field.events.HtmlEditorEvent')]
/**
 * @see ext.form.field.events.HtmlEditor_htmlEvent.SYNC
 * @eventType ext.form.field.events.HtmlEditor_htmlEvent.SYNC
 */
[Event(name='onSync', type='ext.form.field.events.HtmlEditor_htmlEvent')]
/**
 * Provides a lightweight HTML Editor component. Some toolbar features are not supported
 * by Safari and will be automatically hidden when needed. These are noted in the config options
 * where appropriate.
 * <p>The editor's toolbar buttons have tooltips defined in the →<code>buttonTips</code> property,
 * but they are not enabled by default unless the global →<code>ext.tip.QuickTipManager</code> singleton
 * is <i>initialized</i> (→<code>ext.tip.QuickTipManager.init()</code>).</p>
 * <p>An Editor is a sensitive component that can't be used in all spots standard fields can be used.
 * Putting an Editor within any element that has display set to 'none' can cause problems in Safari
 * and Firefox due to their default iframe reloading bugs.</p>
 * <p><b>Example usage</b></p>
 * <p>Simple example rendered with default options:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.tip.QuickTipManager.init();  // enable tooltips
 * Ext.create('Ext.form.HtmlEditor', {
 *     width: 580,
 *     height: 250,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>Passed via xtype into a container and with custom options:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.tip.QuickTipManager.init();  // enable tooltips
 * new Ext.panel.Panel({
 *     title: 'HTML Editor',
 *     renderTo: Ext.getBody(),
 *     width: 550,
 *     height: 250,
 *     frame: true,
 *     layout: 'fit',
 *     items: {
 *         xtype: 'htmleditor',
 *         enableColors: false,
 *         enableAlignments: false
 *     }
 * });
 * </pre>
 * <p><b>Reflow issues</b></p>
 * <p>In some browsers, a layout reflow will cause the underlying editor iframe to be reset. This
 * is most commonly seen when using the editor in collapsed panels with animation. In these cases
 * it is best to avoid animation.
 * More information can be found here: https://bugzilla.mozilla.org/show_bug.cgi?id=90268</p>
 * @see #buttonTips
 * @see ext.tip.#QuickTipManager ext.tip.QuickTipManager
 * @see ext.tip.SQuickTipManager#init() ext.tip.QuickTipManager.init()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html Original Ext JS documentation of 'Ext.form.field.HtmlEditor'
 */
public class HtmlEditor extends FieldContainer implements IField {
  /**
   * @param config @inheritDoc
   */
  public function HtmlEditor(config:HtmlEditor = null) {
    super();
  }

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the iframe element. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-afterIFrameTpl Original Ext JS documentation of 'afterIFrameTpl'
   */
  public native function get afterIFrameTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterIFrameTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * after the textarea element. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-afterTextAreaTpl Original Ext JS documentation of 'afterTextAreaTpl'
   */
  public native function get afterTextAreaTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set afterTextAreaTpl(value:*):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-allowDomMove Original Ext JS documentation of 'allowDomMove'
   */
  public native function get allowDomMove():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set allowDomMove(value:Boolean):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-autoCreate Original Ext JS documentation of 'autoCreate'
   */
  public native function get autoCreate():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoCreate(value:String):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the iframe element. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-beforeIFrameTpl Original Ext JS documentation of 'beforeIFrameTpl'
   */
  public native function get beforeIFrameTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeIFrameTpl(value:*):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * before the textarea element. If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-beforeTextAreaTpl Original Ext JS documentation of 'beforeTextAreaTpl'
   */
  public native function get beforeTextAreaTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set beforeTextAreaTpl(value:*):void;

  [ExtConfig]
  /**
   * A config object to apply to the toolbar's <i>buttons</i> (→<code>ext.button.Button</code>) to affect
   * how they operate, eg:
   * <pre>
   * buttonDefaults: {
   *     tooltip: {
   *         align: 't-b',
   *         anchor: true
   *     }
   * }
   * </pre>
   * @since 6.2.0
   * @see ext.button.Button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-buttonDefaults Original Ext JS documentation of 'buttonDefaults'
   */
  public native function get buttonDefaults():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set buttonDefaults(value:Object):void;

  /**
   * Object collection of toolbar tooltips for the buttons in the editor.
   * The key is the command id associated with that button and the value is a valid
   * QuickTips object. For example:
   * <pre>
   * {
   *     bold: {
   *         title: 'Bold (Ctrl+B)',
   *         text: 'Make the selected text bold.',
   *         cls: 'x-html-editor-tip'
   *     },
   *     italic: {
   *         title: 'Italic (Ctrl+I)',
   *         text: 'Make the selected text italic.',
   *         cls: 'x-html-editor-tip'
   *     }
   *     // ...
   * }
   * </pre>
   * @default {
   *     bold: {
   *         title: 'Bold (Ctrl+B)',
   *         text: 'Make the selected text bold.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     italic: {
   *         title: 'Italic (Ctrl+I)',
   *         text: 'Make the selected text italic.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     underline: {
   *         title: 'Underline (Ctrl+U)',
   *         text: 'Underline the selected text.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     increasefontsize: {
   *         title: 'Grow Text',
   *         text: 'Increase the font size.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     decreasefontsize: {
   *         title: 'Shrink Text',
   *         text: 'Decrease the font size.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     backcolor: {
   *         title: 'Text Highlight Color',
   *         text: 'Change the background color of the selected text.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     forecolor: {
   *         title: 'Font Color',
   *         text: 'Change the color of the selected text.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     justifyleft: {
   *         title: 'Align Text Left',
   *         text: 'Align text to the left.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     justifycenter: {
   *         title: 'Center Text',
   *         text: 'Center text in the editor.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     justifyright: {
   *         title: 'Align Text Right',
   *         text: 'Align text to the right.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     insertunorderedlist: {
   *         title: 'Bullet List',
   *         text: 'Start a bulleted list.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     insertorderedlist: {
   *         title: 'Numbered List',
   *         text: 'Start a numbered list.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     createlink: {
   *         title: 'Hyperlink',
   *         text: 'Make the selected text a hyperlink.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     },
   *     sourceedit: {
   *         title: 'Source Edit',
   *         text: 'Switch to source editing mode.',
   *         cls: Ext.baseCSSPrefix + 'html-editor-tip'
   *     }
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#property-buttonTips Original Ext JS documentation of 'buttonTips'
   */
  public native function get buttonTips():Object;

  /**
   * @private
   */
  public native function set buttonTips(value:Object):void;

  [ExtConfig]
  /**
   * The default text for the create link prompt
   * @default 'Please enter the URL for the link:'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-createLinkText Original Ext JS documentation of 'createLinkText'
   */
  public native function get createLinkText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set createLinkText(value:String):void;

  [ExtConfig]
  /**
   * A default →<code>ext.Component.ui</code> to use for the HtmlEditor's toolbar
   * <i>buttons</i> (→<code>ext.button.Button</code>).
   * @default 'default-toolbar'
   * @see ext.Component#ui
   * @see ext.button.Button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-defaultButtonUI Original Ext JS documentation of 'defaultButtonUI'
   */
  public native function get defaultButtonUI():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultButtonUI(value:String):void;

  [ExtConfig]
  /**
   * The default value for the create link prompt
   * @default 'http://'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-defaultLinkValue Original Ext JS documentation of 'defaultLinkValue'
   */
  public native function get defaultLinkValue():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultLinkValue(value:String):void;

  [ExtConfig]
  /**
   * A default value to be put into the editor to resolve focus issues.
   * <p>Defaults to (Non-breaking space) in Opera,
   * (Zero-width space) in all other browsers.</p>
   * @default Ext.isOpera ? '&#160;' : '&#8203;'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-defaultValue Original Ext JS documentation of 'defaultValue'
   */
  public native function get defaultValue():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultValue(value:String):void;

  [ExtConfig]
  /**
   * True to disable the field. Disabled Fields will not be
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>).
   * @default false
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  override public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set disabled(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the left, center, right alignment buttons
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableAlignments Original Ext JS documentation of 'enableAlignments'
   */
  public native function get enableAlignments():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableAlignments(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the fore/highlight color buttons
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableColors Original Ext JS documentation of 'enableColors'
   */
  public native function get enableColors():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableColors(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable font selection. Not available in Safari 2.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableFont Original Ext JS documentation of 'enableFont'
   */
  public native function get enableFont():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableFont(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the increase/decrease font size buttons
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableFontSize Original Ext JS documentation of 'enableFontSize'
   */
  public native function get enableFontSize():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableFontSize(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the bold, italic and underline buttons
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableFormat Original Ext JS documentation of 'enableFormat'
   */
  public native function get enableFormat():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableFormat(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the create link button. Not available in Safari 2.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableLinks Original Ext JS documentation of 'enableLinks'
   */
  public native function get enableLinks():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableLinks(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the bullet and numbered list buttons. Not available in Safari 2.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableLists Original Ext JS documentation of 'enableLists'
   */
  public native function get enableLists():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableLists(value:Boolean):void;

  [ExtConfig]
  /**
   * Enable the switch to source edit button. Not available in Safari 2.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-enableSourceEdit Original Ext JS documentation of 'enableSourceEdit'
   */
  public native function get enableSourceEdit():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableSourceEdit(value:Boolean):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-fieldCls Original Ext JS documentation of 'fieldCls'
   */
  public native function get fieldCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fieldCls(value:String):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-focusCls Original Ext JS documentation of 'focusCls'
   */
  override public native function get focusCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set focusCls(value:String):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of available font families
   * @default [
   *     'Arial',
   *     'Courier New',
   *     'Tahoma',
   *     'Times New Roman',
   *     'Verdana'
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-fontFamilies Original Ext JS documentation of 'fontFamilies'
   */
  public native function get fontFamilies():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fontFamilies(value:Array):void;

  [ExtConfig]
  /**
   * An optional string or <code>XTemplate</code> configuration to insert in the field markup
   * inside the iframe element (as attributes). If an <code>XTemplate</code> is used, the component's
   * <i>subTpl data</i> (→<code>ext.form.field.BaseField.getSubTplData()</code>) serves as the context.
   * @see ext.form.field.BaseField#getSubTplData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-iframeAttrTpl Original Ext JS documentation of 'iframeAttrTpl'
   */
  public native function get iframeAttrTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set iframeAttrTpl(value:*):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-inputType Original Ext JS documentation of 'inputType'
   */
  public native function get inputType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set inputType(value:String):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-invalidCls Original Ext JS documentation of 'invalidCls'
   */
  override public native function get invalidCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set invalidCls(value:String):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-invalidText Original Ext JS documentation of 'invalidText'
   */
  public native function get invalidText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set invalidText(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get isFormField():Boolean;

  /**
   * @inheritDoc
   */
  public native function set isFormField(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The name of the field. By default this is used as the parameter name when including the
   * <i>field value</i> (→<code>getSubmitData()</code>) in a <i>form submit()</i> (→<code>ext.form.BasicForm.submit()</code>).
   * To prevent the field from being included in the form submit, set →<code>submitValue</code>
   * to false.
   * @see #getSubmitData()
   * @see ext.form.BasicForm#submit()
   * @see #submitValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-name Original Ext JS documentation of 'name'
   * @see #getName()
   */
  public native function get name():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set name(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get originalValue():*;

  /**
   * @inheritDoc
   */
  public native function set originalValue(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * One or more names of config properties that this component should publish
   * to its ViewModel. Generally speaking, only properties defined in a class config
   * block (including ancestor config blocks and mixins) are eligible for publishing
   * to the viewModel. Some components override this and publish their most useful
   * configs by default.
   * <p><b>Note:</b> We'll discuss publishing properties <b>not</b> found in the config block below.</p>
   * <p>Values determined to be invalid by component (often form fields and model validations)
   * will not be published to the ViewModel.</p>
   * <p>This config uses the <code>→reference</code> to determine the name of the data
   * object to place in the <code>ViewModel</code>. If <code>reference</code> is not set then this config
   * is ignored.</p>
   * <p>By using this config and <code>→reference</code> you can bind configs between
   * components. For example:</p>
   * <pre>
   *  ...
   *      items: [{
   *          xtype: 'textfield',
   *          reference: 'somefield',  // component's name in the ViewModel
   *          publishes: 'value' // value is not published by default
   *      },{
   *          ...
   *      },{
   *          xtype: 'displayfield',
   *          bind: 'You have entered "{somefield.value}"'
   *      }]
   *  ...
   * </pre>
   * <p>Classes must provide this config as an Object:</p>
   * <pre>
   *  Ext.define('App.foo.Bar', {
   *      publishes: {
   *          foo: true,
   *          bar: true
   *      }
   *  });
   * </pre>
   * <p>This is required for the config system to properly merge values from derived
   * classes.</p>
   * <p>For instances this value can be specified as a value as show above or an array
   * or object as follows:</p>
   * <pre>
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: [
   *          'value',
   *          'rawValue',
   *          'dirty'
   *      ]
   *  }
   *
   *  // This achieves the same result as the above array form.
   *  {
   *      xtype: 'textfield',
   *      reference: 'somefield',
   *      publishes: {
   *          value: true,
   *          rawValue: true,
   *          dirty: true
   *      }
   *  }
   * </pre>
   * <p>In some cases, users may want to publish a property to the viewModel that is not found
   * in a class config block. In these situations, you may utilize →<code>publishState</code>
   * if the property has a setter method. Let's use
   * →<code>ext.form.Labelable.setFieldLabel()</code> as an example:</p>
   * <pre>
   *   setFieldLabel: function(fieldLabel) {
   *       this.callParent(arguments);
   *       this.publishState('fieldLabel', fieldLabel);
   *   }
   * </pre>
   * <p>With the above chunk of code, fieldLabel may now be published to the viewModel.</p>
   * @default 'value'
   * @see #reference
   * @see #publishState
   * @see ext.form.Labelable#setFieldLabel()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-publishes Original Ext JS documentation of 'publishes'
   * @see #getPublishes()
   * @see #setPublishes()
   */
  override public native function get publishes():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set publishes(value:*):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-readOnly Original Ext JS documentation of 'readOnly'
   */
  public native function get readOnly():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set readOnly(value:String):void;

  [ExtConfig]
  /**
   * Setting this to false will prevent the field from being
   * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>) even when it is not disabled.
   * @default true
   * @see ext.form.BasicForm#submit()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-submitValue Original Ext JS documentation of 'submitValue'
   */
  public native function get submitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitValue(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#cfg-tabIndex Original Ext JS documentation of 'tabIndex'
   * @see #getTabIndex()
   * @see #setTabIndex()
   */
  override public native function get tabIndex():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set tabIndex(value:Number):void;

  [ExtConfig]
  /**
   * Specifies whether this field should be validated immediately whenever a change in its value
   * is detected. If the validation results in a change in the field's validity, a
   * →<code>event:onValidityChange</code> event will be fired. This allows the field to show feedback
   * about the validity of its contents immediately as the user is typing.
   * <p>When set to false, feedback will not be immediate. However the form will still be validated
   * before submitting if the clientValidation option to →<code>ext.form.BasicForm.doAction()</code>
   * is enabled, or if the field or form are validated manually.</p>
   * <p>See also →<code>ext.form.field.BaseField.checkChangeEvents</code> for controlling how changes
   * to the field's value are detected.</p>
   * @default true
   * @see #event:onValidityChange
   * @see ext.form.BasicForm#doAction()
   * @see ext.form.field.BaseField#checkChangeEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validateOnChange Original Ext JS documentation of 'validateOnChange'
   */
  public native function get validateOnChange():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set validateOnChange(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * This property, when a <code>→String</code>, contributes its value to the error state of this
   * instance as reported by <code>→getErrors()</code>.
   * @default null
   * @see String
   * @see #getErrors()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-validation Original Ext JS documentation of 'validation'
   * @see #getValidation()
   * @see #setValidation()
   */
  public native function get validation():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set validation(value:*):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * A value to initialize this field with.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-value Original Ext JS documentation of 'value'
   * @see #getValue()
   * @see #setValue()
   */
  public native function get value():Object;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set value(value:Object):void;

  [ExtConfig]
  /**
   * The event name(s) to use to publish the →<code>value</code>
   * →<code>ext.form.field.BaseField.bind</code> for this field.
   * @default 'change'
   * @since 5.0.1
   * @see #value
   * @see ext.form.field.BaseField#bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#cfg-valuePublishEvent Original Ext JS documentation of 'valuePublishEvent'
   */
  public native function get valuePublishEvent():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valuePublishEvent(value:*):void;

  /**
   * @inheritDoc
   */
  public native function batchChanges(fn:Function):void;

  /**
   * Template method before a field is reset.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#method-beforeReset Original Ext JS documentation of 'beforeReset'
   */
  protected native function beforeReset():void;

  /**
   * @inheritDoc
   */
  public native function checkChange():void;

  /**
   * @inheritDoc
   */
  public native function checkDirty():void;

  /**
   * If you need/want custom HTML cleanup, this is the method you should override.
   * @param html The HTML to be cleaned
   * @return The cleaned HTML
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-cleanHtml Original Ext JS documentation of 'cleanHtml'
   */
  public native function cleanHtml(html:String):String;

  /**
   * @inheritDoc
   */
  public native function cleanupField():void;

  /**
   * @inheritDoc
   */
  public native function clearInvalid():void;

  /**
   * Called when the editor creates its toolbar. Override this method if you need to
   * add custom toolbar buttons.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-createToolbar Original Ext JS documentation of 'createToolbar'
   */
  protected native function createToolbar(editor:HtmlEditor):void;

  /**
   * Executes a Midas editor command directly on the editor document. For visual commands,
   * you should use →<code>relayCmd()</code> instead.
   * <b>This should only be called after the editor is initialized.</b>
   * @param cmd The Midas command
   * @param value The value to pass to the command
   * @default null
   * @see #relayCmd()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-execCmd Original Ext JS documentation of 'execCmd'
   */
  public native function execCmd(cmd:String, value:* = null):void;

  /**
   * @inheritDoc
   */
  public native function extractFileInput():HTMLElement;

  /**
   * Called when the editor initializes the iframe with HTML contents. Override this method if you
   * want to change the initialization markup of the iframe (e.g. to add stylesheets).
   * <p><b>Note:</b> IE8-Standards has unwanted scroller behavior, so the default meta tag forces IE7
   * compatibility. Also note that forcing IE7 mode works when the page is loaded normally,
   * but if you are using IE's Web Developer Tools to manually set the document mode, that will
   * take precedence and override what this code sets by default. This can be confusing when
   * developing, but is not a user-facing issue.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-getDocMarkup Original Ext JS documentation of 'getDocMarkup'
   */
  public native function getDocMarkup():String;

  /**
   * @inheritDoc
   */
  public native function getErrors(value:*):Array;

  /**
   * @inheritDoc
   */
  public native function getModelData(includeEmptyText:Boolean):Object;

  /**
   * @inheritDoc
   */
  public native function getName():String;

  /**
   * @inheritDoc
   */
  public native function getSubmitData():Object;

  /**
   * Returns the editor's toolbar. <b>This is only available after the editor has been rendered.</b>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-getToolbar Original Ext JS documentation of 'getToolbar'
   */
  public native function getToolbar():Toolbar;

  /**
   * Returns the value of <code>validation</code>.
   * @see #validation
   */
  public native function getValidation():*;

  /**
   * @inheritDoc
   */
  public native function getValue():*;

  /**
   * @inheritDoc
   */
  public native function initField():void;

  /**
   * @inheritDoc
   */
  public native function initValue():void;

  /**
   * Inserts the passed text at the current cursor position.
   * <b>Note:</b> the editor must be initialized and activated to insert text.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-insertAtCursor Original Ext JS documentation of 'insertAtCursor'
   */
  public native function insertAtCursor(text:String):void;

  /**
   * @inheritDoc
   */
  public native function isDirty():Boolean;

  /**
   * @inheritDoc
   */
  public native function isEqual(value1:Object, value2:Object):Boolean;

  /**
   * @inheritDoc
   */
  public native function isFileUpload():Boolean;

  /**
   * @inheritDoc
   */
  public native function isValid():Boolean;

  /**
   * @inheritDoc
   */
  public native function markInvalid(errors:*):void;

  /**
   * Pushes the value of the textarea into the iframe editor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-pushValue Original Ext JS documentation of 'pushValue'
   */
  public native function pushValue():void;

  /**
   * Executes a Midas editor command on the editor document and performs necessary focus
   * and toolbar updates.
   * <b>This should only be called after the editor is initialized.</b>
   * @param cmd The Midas command
   * @param value The value to pass to the command
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-relayCmd Original Ext JS documentation of 'relayCmd'
   */
  public native function relayCmd(cmd:String, value:* = null):void;

  /**
   * @inheritDoc
   */
  public native function reset():void;

  /**
   * @inheritDoc
   */
  public native function resetOriginalValue():void;

  /**
   * Sets the read only state of this field.
   * @param readOnly Whether the field should be read only.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-setReadOnly Original Ext JS documentation of 'setReadOnly'
   */
  public native function setReadOnly(readOnly:Boolean):void;

  /**
   * Sets the value of <code>validation</code>.
   * @param validation The new value.
   * @see #validation
   */
  public native function setValidation(validation:*):void;

  /**
   * @inheritDoc
   */
  [Return("this")]
  public native function setValue(value:*):IField;

  /**
   * Syncs the contents of the editor iframe with the textarea.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-syncValue Original Ext JS documentation of 'syncValue'
   */
  public native function syncValue():void;

  /**
   * Toggles the editor between standard and source edit mode.
   * @param sourceEditMode True for source edit, false for standard
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-toggleSourceEdit Original Ext JS documentation of 'toggleSourceEdit'
   */
  public native function toggleSourceEdit(sourceEditMode:Boolean = false):void;

  /**
   * Triggers a toolbar update by reading the markup state of the current selection in the editor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-updateToolbar Original Ext JS documentation of 'updateToolbar'
   */
  public native function updateToolbar():void;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#method-validate Original Ext JS documentation of 'validate'
   */
  public native function validate():Boolean;
}
}